# Generated by default/object.tt
package Paws::NetworkFirewall::CustomAction;
  use Moose;
  has ActionDefinition => (is => 'ro', isa => 'Paws::NetworkFirewall::ActionDefinition', required => 1);
  has ActionName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::CustomAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::CustomAction object:

  $service_obj->Method(Att1 => { ActionDefinition => $value, ..., ActionName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::CustomAction object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionDefinition

=head1 DESCRIPTION

An optional, non-standard action to use for stateless packet handling.
You can define this in addition to the standard action that you must
specify.

You define and name the custom actions that you want to be able to use,
and then you reference them by name in your actions settings.

You can use custom actions in the following places:

=over

=item *

In a rule group's StatelessRulesAndCustomActions specification. The
custom actions are available for use by name inside the
C<StatelessRulesAndCustomActions> where you define them. You can use
them for your stateless rule actions to specify what to do with a
packet that matches the rule's match attributes.

=item *

In a FirewallPolicy specification, in C<StatelessCustomActions>. The
custom actions are available for use inside the policy where you define
them. You can use them for the policy's default stateless actions
settings to specify what to do with packets that don't match any of the
policy's stateless rules.

=back


=head1 ATTRIBUTES


=head2 B<REQUIRED> ActionDefinition => L<Paws::NetworkFirewall::ActionDefinition>

The custom action associated with the action name.


=head2 B<REQUIRED> ActionName => Str

The descriptive name of the custom action. You can't change the name of
a custom action after you create it.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

