# Generated by default/object.tt
package Paws::CodeGuruReviewer::S3RepositoryDetails;
  use Moose;
  has BucketName => (is => 'ro', isa => 'Str');
  has CodeArtifacts => (is => 'ro', isa => 'Paws::CodeGuruReviewer::CodeArtifacts');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::S3RepositoryDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::S3RepositoryDetails object:

  $service_obj->Method(Att1 => { BucketName => $value, ..., CodeArtifacts => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::S3RepositoryDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketName

=head1 DESCRIPTION

Specifies the name of an S3 bucket and a C<CodeArtifacts> object that
contains the S3 object keys for a source code .zip file and for a build
artifacts .zip file that contains .jar or .class files.

=head1 ATTRIBUTES


=head2 BucketName => Str

The name of the S3 bucket used for associating a new S3 repository. It
must begin with C<codeguru-reviewer->.


=head2 CodeArtifacts => L<Paws::CodeGuruReviewer::CodeArtifacts>

A C<CodeArtifacts> object. The C<CodeArtifacts> object includes the S3
object key for a source code .zip file and for a build artifacts .zip
file that contains .jar or .class files.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

