package Shipment::UPS::WSDL::TrackTypes::StatusType;
$Shipment::UPS::WSDL::TrackTypes::StatusType::VERSION = '3.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Type_of : ATTR(:get<Type>);
    my %Description_of : ATTR(:get<Description>);
    my %Code_of : ATTR(:get<Code>);

    __PACKAGE__->_factory(
        [   qw(        Type
              Description
              Code

              )
        ],
        {   'Type'        => \%Type_of,
            'Description' => \%Description_of,
            'Code'        => \%Code_of,
        },
        {   'Type'        => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Code'        => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'Type'        => 'Type',
            'Description' => 'Description',
            'Code'        => 'Code',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::StatusType

=head1 VERSION

version 3.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
StatusType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type

=item * Description

=item * Code

=back

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::StatusType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::TrackTypes::StatusType
   Type =>  $some_value, # string
   Description =>  $some_value, # string
   Code =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
