# ABSTRACT: Data::Object Method/Function Signatures for Perl 5
package Data::Object::Signatures;

use 5.14.0;

use strict;
use warnings;

use parent 'Type::Tiny::Signatures';

our @DEFAULTS = @Type::Tiny::Signatures::DEFAULTS = 'Data::Object::Library';

our $VERSION = '0.04'; # VERSION

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Object::Signatures - Data::Object Method/Function Signatures for Perl 5

=head1 VERSION

version 0.04

=head1 SYNOPSIS

    use Data::Object::Signatures;

=head1 DESCRIPTION

Data::Object::Signatures is a subclass of Type::Tiny::Signatures providing
method and function signatures supporting all the type constraints provided by
L<Data::Object::Library>. B<NOTE:> This distribution is now available as part
of the L<Data::Object> core distribution. Please be sure to depend on
Data::Object directly (version 0.50 or later).

=head1 AUTHOR

Al Newkirk <anewkirk@ana.io>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Al Newkirk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
