#!/usr/bin/perl

use strict;
use warnings;
use Test::More tests => 194;
use Quantum::ClebschGordan;

while(my $line = <DATA>){
  chomp($line);
  $line =~ s/#.*//;
  next unless $line;
  last if $line =~ /__END__/;
  my @cols = split /\t/, $line;
  my $abbrv0 = pop @cols;
  next unless length($abbrv0);
  my ($j1,$j2,$m,$m1,$m2,$j) = @cols;
  my $cg = Quantum::ClebschGordan->new( j1=>$j1, j2=>$j2, m=>$m, m1=>$m1, m2=>$m2, j=>$j );
  my $c = $cg->coeff;
  is( $c, $abbrv0, "($j1,$j2,$m,$m1,$m2,$j) abbrvs match" );
}

__DATA__

#j1	j2	m	m1	m2	j	coef
# where real coef is   sign(coef)*sqrt(abs(coef))

1/2	1/2	1	1/2	1/2	1	1
1/2	1/2	0	1/2	-1/2	1	1/2
1/2	1/2	0	1/2	-1/2	0	1/2
1/2	1/2	0	-1/2	1/2	1	1/2
1/2	1/2	0	-1/2	1/2	0	-1/2

1	1/2	3/2	1	1/2	3/2	1
1	1/2	1/2	1	-1/2	3/2	1/3
1	1/2	1/2	1	-1/2	1/2	2/3
1	1/2	1/2	0	1/2	3/2	2/3
1	1/2	1/2	0	1/2	1/2	-1/3

1	1	2	1	1	2	1
1	1	1	1	0	2	1/2
1	1	1	1	0	1	1/2
1	1	1	0	1	2	1/2
1	1	1	0	1	1	-1/2
1	1	0	1	-1	2	1/6
1	1	0	1	-1	1	1/2
1	1	0	1	-1	0	1/3
1	1	0	0	0	2	2/3
1	1	0	0	0	1	0
1	1	0	0	0	0	-1/3
1	1	0	1	-1	2	1/6
1	1	0	1	-1	1	1/2
1	1	0	1	-1	0	1/3

3/2	1/2	2	3/2	1/2	2	1
3/2	1/2	1	3/2	-1/2	2	1/4
3/2	1/2	1	3/2	-1/2	1	3/4
3/2	1/2	1	1/2	1/2	2	3/4
3/2	1/2	1	1/2	1/2	1	-1/4
3/2	1/2	0	1/2	-1/2	2	1/2
3/2	1/2	0	1/2	-1/2	1	1/2
3/2	1/2	0	-1/2	1/2	2	1/2
3/2	1/2	0	-1/2	1/2	1	-1/2

3/2	1	5/2	3/2	1	5/2	1
3/2	1	3/2	3/2	0	5/2	2/5
3/2	1	3/2	3/2	0	3/2	3/5
3/2	1	3/2	1/2	1	5/2	3/5
3/2	1	3/2	1/2	1	3/2	-2/5
3/2	1	1/2	3/2	-1	5/2	1/10
3/2	1	1/2	3/2	-1	3/2	2/5
3/2	1	1/2	3/2	-1	1/2	1/2
3/2	1	1/2	1/2	0	5/2	3/5
3/2	1	1/2	1/2	0	3/2	1/15
3/2	1	1/2	1/2	0	1/2	-1/3
3/2	1	1/2	-1/2	1	5/2	3/10
3/2	1	1/2	-1/2	1	3/2	-8/15
3/2	1	1/2	-1/2	1	1/2	1/6

3/2	3/2	3	3/2	3/2	3	1
3/2	3/2	2	3/2	1/2	3	1/2
3/2	3/2	2	3/2	1/2	2	1/2
3/2	3/2	2	1/2	3/2	3	1/2
3/2	3/2	2	1/2	3/2	2	-1/2
3/2	3/2	1	3/2	-1/2	3	1/5
3/2	3/2	1	3/2	-1/2	2	1/2
3/2	3/2	1	3/2	-1/2	1	3/10
3/2	3/2	1	1/2	1/2	3	3/5
3/2	3/2	1	1/2	1/2	2	0
3/2	3/2	1	1/2	1/2	1	-2/5
3/2	3/2	1	-1/2	3/2	3	1/5
3/2	3/2	1	-1/2	3/2	2	-1/2
3/2	3/2	1	-1/2	3/2	1	3/10
3/2	3/2	0	3/2	-3/2	3	1/20
3/2	3/2	0	3/2	-3/2	2	1/4
3/2	3/2	0	3/2	-3/2	1	9/20
3/2	3/2	0	3/2	-3/2	0	1/4
3/2	3/2	0	1/2	-1/2	3	9/20
3/2	3/2	0	1/2	-1/2	2	1/4
3/2	3/2	0	1/2	-1/2	1	-1/20
3/2	3/2	0	1/2	-1/2	0	-1/4
3/2	3/2	0	-1/2	1/2	3	9/20
3/2	3/2	0	-1/2	1/2	2	-1/4
3/2	3/2	0	-1/2	1/2	1	-1/20
3/2	3/2	0	-1/2	1/2	0	1/4
3/2	3/2	0	-3/2	3/2	3	1/20
3/2	3/2	0	-3/2	3/2	2	-1/4
3/2	3/2	0	-3/2	3/2	1	9/20
3/2	3/2	0	-3/2	3/2	0	-1/4

2	1/2	5/2	2	1/2	5/2	1
2	1/2	3/2	2	-1/2	5/2	1/5
2	1/2	3/2	2	-1/2	3/2	4/5
2	1/2	3/2	1	1/2	5/2	4/5
2	1/2	3/2	1	1/2	3/2	-1/5
2	1/2	1/2	1	-1/2	5/2	2/5
2	1/2	1/2	1	-1/2	3/2	3/5
2	1/2	1/2	0	1/2	5/2	3/5
2	1/2	1/2	0	1/2	3/2	-2/5

2	1	3	2	1	3	1
2	1	2	2	0	3	1/3
2	1	2	2	0	2	2/3
2	1	2	1	1	3	2/3
2	1	2	1	1	2	-1/3
2	1	1	2	-1	3	1/15
2	1	1	2	-1	2	1/3
2	1	1	2	-1	1	3/5
2	1	1	1	0	3	8/15
2	1	1	1	0	2	1/6
2	1	1	1	0	1	-3/10
2	1	1	0	1	3	2/5
2	1	1	0	1	2	-1/2
2	1	1	0	1	1	1/10
2	1	0	1	-1	3	1/5
2	1	0	1	-1	2	1/2
2	1	0	1	-1	1	3/10
2	1	0	0	0	3	3/5
2	1	0	0	0	2	0
2	1	0	0	0	1	-2/5
2	1	0	-1	1	3	1/5
2	1	0	-1	1	2	-1/2
2	1	0	-1	1	1	3/10

2	3/2	7/2	2	3/2	7/2	1
2	3/2	5/2	2	1/2	7/2	3/7
2	3/2	5/2	2	1/2	5/2	4/7
2	3/2	5/2	1	3/2	7/2	4/7
2	3/2	5/2	1	3/2	5/2	-3/7
2	3/2	3/2	2	-1/2	7/2	1/7
2	3/2	3/2	2	-1/2	5/2	16/35
2	3/2	3/2	2	-1/2	3/2	2/5
2	3/2	3/2	1	1/2	7/2	4/7
2	3/2	3/2	1	1/2	5/2	1/35
2	3/2	3/2	1	1/2	3/2	-2/5
2	3/2	3/2	0	3/2	7/2	2/7
2	3/2	3/2	0	3/2	5/2	-18/35
2	3/2	3/2	0	3/2	3/2	1/5
2	3/2	1/2	2	-3/2	7/2	1/35
2	3/2	1/2	2	-3/2	5/2	6/35
2	3/2	1/2	2	-3/2	3/2	2/5
2	3/2	1/2	2	-3/2	1/2	2/5
2	3/2	1/2	1	-1/2	7/2	12/35
2	3/2	1/2	1	-1/2	5/2	5/14
2	3/2	1/2	1	-1/2	3/2	0
2	3/2	1/2	1	-1/2	1/2	-3/10
2	3/2	1/2	0	1/2	7/2	18/35
2	3/2	1/2	0	1/2	5/2	-3/35
2	3/2	1/2	0	1/2	3/2	-1/5
2	3/2	1/2	0	1/2	1/2	1/5
2	3/2	1/2	-1	3/2	7/2	4/35
2	3/2	1/2	-1	3/2	5/2	-27/70
2	3/2	1/2	-1	3/2	3/2	2/5
2	3/2	1/2	-1	3/2	1/2	-1/10

2	2	4	2	2	4	1
2	2	3	2	1	4	1/2
2	2	3	2	1	3	1/2
2	2	3	1	2	4	1/2
2	2	3	1	2	3	-1/2
2	2	2	2	0	4	3/14
2	2	2	2	0	3	1/2
2	2	2	2	0	2	2/7
2	2	2	1	1	4	4/7
2	2	2	1	1	3	0
2	2	2	1	1	2	-3/7
2	2	2	0	2	4	3/14
2	2	2	0	2	3	-1/2
2	2	2	0	2	2	2/7
2	2	1	2	-1	4	1/14
2	2	1	2	-1	3	3/10
2	2	1	2	-1	2	3/7
2	2	1	2	-1	1	1/5
2	2	1	1	0	4	3/7
2	2	1	1	0	3	1/5
2	2	1	1	0	2	-1/14
2	2	1	1	0	1	-3/10
2	2	1	0	1	4	3/7
2	2	1	0	1	3	-1/5
2	2	1	0	1	2	-1/14
2	2	1	0	1	1	3/10
2	2	1	-1	2	4	1/14
2	2	1	-1	2	3	-3/10
2	2	1	-1	2	2	3/7
2	2	1	-1	2	1	-1/5
2	2	0	2	-2	4	1/70
2	2	0	2	-2	3	1/10
2	2	0	2	-2	2	2/7
2	2	0	2	-2	1	2/5
2	2	0	2	-2	0	1/5
2	2	0	1	-1	4	8/35
2	2	0	1	-1	3	2/5
2	2	0	1	-1	2	1/14
2	2	0	1	-1	1	-1/10
2	2	0	1	-1	0	-1/5
2	2	0	0	0	4	18/35
2	2	0	0	0	3	0
2	2	0	0	0	2	-2/7
2	2	0	0	0	1	0
2	2	0	0	0	0	1/5
2	2	0	-1	1	4	8/35
2	2	0	-1	1	3	-2/5
2	2	0	-1	1	2	1/14
2	2	0	-1	1	1	1/10
2	2	0	-1	1	0	-1/5
2	2	0	-2	2	4	1/70
2	2	0	-2	2	3	-1/10
2	2	0	-2	2	2	2/7
2	2	0	-2	2	1	-2/5
2	2	0	-2	2	0	1/5

#5/2	1/2	

#5/2	1

#5/2	3/2	

#5/2	2

