# Generated by default/object.tt
package Paws::ConnectContactLens::PointOfInterest;
  use Moose;
  has BeginOffsetMillis => (is => 'ro', isa => 'Int', required => 1);
  has EndOffsetMillis => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ConnectContactLens::PointOfInterest

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ConnectContactLens::PointOfInterest object:

  $service_obj->Method(Att1 => { BeginOffsetMillis => $value, ..., EndOffsetMillis => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ConnectContactLens::PointOfInterest object:

  $result = $service_obj->Method(...);
  $result->Att1->BeginOffsetMillis

=head1 DESCRIPTION

The section of the contact audio where that category rule was detected.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BeginOffsetMillis => Int

The beginning offset in milliseconds where the category rule was
detected.


=head2 B<REQUIRED> EndOffsetMillis => Int

The ending offset in milliseconds where the category rule was detected.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ConnectContactLens>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

