# Generated by default/object.tt
package Paws::FSX::CreateFileSystemLustreConfiguration;
  use Moose;
  has AutoImportPolicy => (is => 'ro', isa => 'Str');
  has AutomaticBackupRetentionDays => (is => 'ro', isa => 'Int');
  has CopyTagsToBackups => (is => 'ro', isa => 'Bool');
  has DailyAutomaticBackupStartTime => (is => 'ro', isa => 'Str');
  has DataCompressionType => (is => 'ro', isa => 'Str');
  has DeploymentType => (is => 'ro', isa => 'Str');
  has DriveCacheType => (is => 'ro', isa => 'Str');
  has ExportPath => (is => 'ro', isa => 'Str');
  has ImportedFileChunkSize => (is => 'ro', isa => 'Int');
  has ImportPath => (is => 'ro', isa => 'Str');
  has PerUnitStorageThroughput => (is => 'ro', isa => 'Int');
  has WeeklyMaintenanceStartTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::CreateFileSystemLustreConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::CreateFileSystemLustreConfiguration object:

  $service_obj->Method(Att1 => { AutoImportPolicy => $value, ..., WeeklyMaintenanceStartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::CreateFileSystemLustreConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoImportPolicy

=head1 DESCRIPTION

The Lustre configuration for the file system being created.

=head1 ATTRIBUTES


=head2 AutoImportPolicy => Str

(Optional) When you create your file system, your existing S3 objects
appear as file and directory listings. Use this property to choose how
Amazon FSx keeps your file and directory listings up to date as you add
or modify objects in your linked S3 bucket. C<AutoImportPolicy> can
have the following values:

=over

=item *

C<NONE> - (Default) AutoImport is off. Amazon FSx only updates file and
directory listings from the linked S3 bucket when the file system is
created. FSx does not update file and directory listings for any new or
changed objects after choosing this option.

=item *

C<NEW> - AutoImport is on. Amazon FSx automatically imports directory
listings of any new objects added to the linked S3 bucket that do not
currently exist in the FSx file system.

=item *

C<NEW_CHANGED> - AutoImport is on. Amazon FSx automatically imports
file and directory listings of any new objects added to the S3 bucket
and any existing objects that are changed in the S3 bucket after you
choose this option.

=back

For more information, see Automatically import updates from your S3
bucket
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html).


=head2 AutomaticBackupRetentionDays => Int




=head2 CopyTagsToBackups => Bool

(Optional) Not available to use with file systems that are linked to a
data repository. A boolean flag indicating whether tags for the file
system should be copied to backups. The default value is false. If it's
set to true, all file system tags are copied to all automatic and
user-initiated backups when the user doesn't specify any
backup-specific tags. If this value is true, and you specify one or
more backup tags, only the specified tags are copied to backups. If you
specify one or more tags when creating a user-initiated backup, no tags
are copied from the file system, regardless of this value.

For more information, see Working with backups
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).


=head2 DailyAutomaticBackupStartTime => Str




=head2 DataCompressionType => Str

Sets the data compression configuration for the file system.
C<DataCompressionType> can have the following values:

=over

=item *

C<NONE> - (Default) Data compression is turned off when the file system
is created.

=item *

C<LZ4> - Data compression is turned on with the LZ4 algorithm.

=back

For more information, see Lustre data compression
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).


=head2 DeploymentType => Str

Choose C<SCRATCH_1> and C<SCRATCH_2> deployment types when you need
temporary storage and shorter-term processing of data. The C<SCRATCH_2>
deployment type provides in-transit encryption of data and higher burst
throughput capacity than C<SCRATCH_1>.

Choose C<PERSISTENT_1> deployment type for longer-term storage and
workloads and encryption of data in transit. To learn more about
deployment types, see FSx for Lustre Deployment Options
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).

Encryption of data in-transit is automatically enabled when you access
a C<SCRATCH_2> or C<PERSISTENT_1> file system from Amazon EC2 instances
that support this feature
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-
protection.html). (Default = C<SCRATCH_1>)

Encryption of data in-transit for C<SCRATCH_2> and C<PERSISTENT_1>
deployment types is supported when accessed from supported instance
types in supported AWS Regions. To learn more, Encrypting Data in
Transit
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html).


=head2 DriveCacheType => Str

The type of drive cache used by PERSISTENT_1 file systems that are
provisioned with HDD storage devices. This parameter is required when
storage type is HDD. Set to C<READ>, improve the performance for
frequently accessed files and allows 20% of the total storage capacity
of the file system to be cached.

This parameter is required when C<StorageType> is set to HDD.


=head2 ExportPath => Str

(Optional) The path in Amazon S3 where the root of your Amazon FSx file
system is exported. The path must use the same Amazon S3 bucket as
specified in ImportPath. You can provide an optional prefix to which
new and changed data is to be exported from your Amazon FSx for Lustre
file system. If an C<ExportPath> value is not provided, Amazon FSx sets
a default export path,
C<s3://import-bucket/FSxLustre[creation-timestamp]>. The timestamp is
in UTC format, for example
C<s3://import-bucket/FSxLustre20181105T222312Z>.

The Amazon S3 export bucket must be the same as the import bucket
specified by C<ImportPath>. If you only specify a bucket name, such as
C<s3://import-bucket>, you get a 1:1 mapping of file system objects to
S3 bucket objects. This mapping means that the input data in S3 is
overwritten on export. If you provide a custom prefix in the export
path, such as C<s3://import-bucket/[custom-optional-prefix]>, Amazon
FSx exports the contents of your file system to that export prefix in
the Amazon S3 bucket.


=head2 ImportedFileChunkSize => Int

(Optional) For files imported from a data repository, this value
determines the stripe count and maximum amount of data per file (in
MiB) stored on a single physical disk. The maximum number of disks that
a single file can be striped across is limited by the total number of
disks that make up the file system.

The default chunk size is 1,024 MiB (1 GiB) and can go as high as
512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.


=head2 ImportPath => Str

(Optional) The path to the Amazon S3 bucket (including the optional
prefix) that you're using as the data repository for your Amazon FSx
for Lustre file system. The root of your FSx for Lustre file system
will be mapped to the root of the Amazon S3 bucket you select. An
example is C<s3://import-bucket/optional-prefix>. If you specify a
prefix after the Amazon S3 bucket name, only object keys with that
prefix are loaded into the file system.


=head2 PerUnitStorageThroughput => Int

Required for the C<PERSISTENT_1> deployment type, describes the amount
of read and write throughput for each 1 tebibyte of storage, in
MB/s/TiB. File system throughput capacity is calculated by multiplying
le system storage capacity (TiB) by the PerUnitStorageThroughput
(MB/s/TiB). For a 2.4 TiB le system, provisioning 50 MB/s/TiB of
PerUnitStorageThroughput yields 120 MB/s of le system throughput. You
pay for the amount of throughput that you provision.

Valid values for SSD storage: 50, 100, 200. Valid values for HDD
storage: 12, 40.


=head2 WeeklyMaintenanceStartTime => Str

(Optional) The preferred start time to perform weekly maintenance,
formatted d:HH:MM in the UTC time zone, where d is the weekday number,
from 1 through 7, beginning with Monday and ending with Sunday.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

