
package Paws::CloudWatch::StartMetricStreams;
  use Moose;
  has Names => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'StartMetricStreams');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::CloudWatch::StartMetricStreamsOutput');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'StartMetricStreamsResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatch::StartMetricStreams - Arguments for method StartMetricStreams on L<Paws::CloudWatch>

=head1 DESCRIPTION

This class represents the parameters used for calling the method StartMetricStreams on the
L<Amazon CloudWatch|Paws::CloudWatch> service. Use the attributes of this class
as arguments to method StartMetricStreams.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to StartMetricStreams.

=head1 SYNOPSIS

    my $monitoring = Paws->service('CloudWatch');
    my $StartMetricStreamsOutput = $monitoring->StartMetricStreams(
      Names => [
        'MyMetricStreamName', ...    # min: 1, max: 255
      ],

    );

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/monitoring/StartMetricStreams>

=head1 ATTRIBUTES


=head2 B<REQUIRED> Names => ArrayRef[Str|Undef]

The array of the names of metric streams to start streaming.

This is an "all or nothing" operation. If you do not have permission to
access all of the metric streams that you list here, then none of the
streams that you list in the operation will start streaming.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method StartMetricStreams in L<Paws::CloudWatch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

