######################################################################
#
# 1110_keis83_by_jipsj.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x04",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\x05",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x06",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x07",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\x08",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x09",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x0A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x0B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x14",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x15",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x16",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\x17",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x18",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x1A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x1B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x1C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x20",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\x7F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x80",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x81",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x82",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x83",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\x84",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x85",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x86",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x87",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x88",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x89",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x8A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x8B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x8C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x8D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x8E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x8F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x90",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\x91",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\x92",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x93",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\x94",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\x95",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\x96",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\x97",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x98",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\x99",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x9A",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x9B",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x9C",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x9D",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x9E",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x9F",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xE1"],
        ["\xA0",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x81"],
        ["\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x82"],
        ["\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x83"],
        ["\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x84"],
        ["\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x85"],
        ["\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x86"],
        ["\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x87"],
        ["\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x88"],
        ["\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x89"],
        ["\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x8A"],
        ["\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x8C"],
        ["\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x8D"],
        ["\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x8E"],
        ["\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x8F"],
        ["\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x90"],
        ["\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x91"],
        ["\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x92"],
        ["\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x93"],
        ["\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x94"],
        ["\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x95"],
        ["\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x96"],
        ["\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x97"],
        ["\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x98"],
        ["\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x99"],
        ["\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x9A"],
        ["\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x9D"],
        ["\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x9E"],
        ["\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\x9F"],
        ["\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA2"],
        ["\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA3"],
        ["\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA4"],
        ["\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA5"],
        ["\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA6"],
        ["\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA7"],
        ["\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA8"],
        ["\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xA9"],
        ["\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xAA"],
        ["\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xAC"],
        ["\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xAD"],
        ["\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xAE"],
        ["\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xAF"],
        ["\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xBA"],
        ["\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xBB"],
        ["\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xBC"],
        ["\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xBD"],
        ["\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xBE"],
        ["\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xBF"],
        ["\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB2"],
        ["\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xCA"],
        ["\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xCB"],
        ["\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xCC"],
        ["\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xCD"],
        ["\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xCE"],
        ["\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xCF"],
        ["\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xDA"],
        ["\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xDB"],
        ["\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xDC"],
        ["\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xDD"],
        ["\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xDE"],
        ["\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xDF"],
        ["\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xEA"],
        ["\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xEB"],
        ["\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xEC"],
        ["\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xED"],
        ["\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xEE"],
        ["\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xEF"],
        ["\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xFA"],
        ["\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xFB"],
        ["\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xFC"],
        ["\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xFD"],
        ["\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xFE"],
        ["\xFF",'keis83','jipsj',{'INPUT_LAYOUT'=>'S'},"\xFF"],
        ["\x21\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],
        ["\x21\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\x21\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\x21\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\x21\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\x21\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\x21\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\x21\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\x21\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\x21\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\x21\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\x21\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\x21\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\x21\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\x21\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\x21\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\x21\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\x21\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\x21\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\x21\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\x21\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\x21\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\x21\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\x21\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\x21\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\x21\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\x21\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\x21\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\x21\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\x21\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\x21\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\x21\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],
        ["\x21\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\x21\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],
        ["\x21\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\x21\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\x21\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\x21\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\x21\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\x21\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\x21\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\x21\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\x21\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\x21\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\x21\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\x21\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\x21\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\x21\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\x21\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\x21\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\x21\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\x21\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\x21\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\x21\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\x21\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\x21\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\x21\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\x21\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\x21\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\x21\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\x21\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],
        ["\x21\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\x21\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\x21\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\x21\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\x21\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\x21\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\x21\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\x21\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\x21\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\x21\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\x21\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\x21\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\x21\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\x21\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\x21\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\x21\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\x21\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\x21\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\x21\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\x21\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],
        ["\x21\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],
        ["\x21\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\x21\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\x21\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\x21\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\x21\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\x21\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\x21\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\x21\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\x21\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\x21\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\x21\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\x21\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\x22\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\x22\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\x22\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\x22\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\x22\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\x22\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\x22\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\x22\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\x22\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\x22\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\x22\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\x22\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\x22\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\x22\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],
        ["\xA5\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],
        ["\xA6\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],
        ["\xA6\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\xA5\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\xA5\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\x2D\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\x2D\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\xA5\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],
        ["\xA5\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],
        ["\xA6\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],
        ["\xA6\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],
        ["\xA5\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],
        ["\xA5\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],
        ["\x2D\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],
        ["\x2D\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],
        ["\xA6\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],
        ["\xA5\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],
        ["\xA6\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],
        ["\x2D\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],
        ["\x2D\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],
        ["\xA5\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],
        ["\xA5\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],
        ["\x2D\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],
        ["\xA5\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],
        ["\xA5\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],
        ["\x2D\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],
        ["\x2D\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],
        ["\xA6\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],
        ["\xA4\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],
        ["\xA4\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],
        ["\xA6\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],
        ["\xA6\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],
        ["\xA6\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],
        ["\xA5\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],
        ["\xA5\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],
        ["\xA5\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],
        ["\xA6\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],
        ["\x23\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\x23\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\x23\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\x23\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\x23\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\x23\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\x23\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\x23\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\x23\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\x23\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\x23\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\x23\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\x23\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\x23\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\x23\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\x23\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\x23\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\x23\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\x23\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\x23\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\x23\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\x23\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\x23\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\x23\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\x23\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\x23\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\x23\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\x23\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\x23\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\x23\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\x23\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\x23\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\x23\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\x23\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\x23\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\x23\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\x23\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\x23\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\x23\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\x23\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\x23\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\x23\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\x23\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\x23\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\x23\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\x23\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\x23\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\x23\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\x23\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\x23\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\x23\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\x23\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\x23\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\x23\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\x23\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\x23\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\x23\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\x23\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\x23\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\x23\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\x23\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\x23\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\x24\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\x24\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\x24\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\x24\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\x24\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\x24\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\x24\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\x24\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\x24\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\x24\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\x24\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\x24\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\x24\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\x24\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\x24\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\x24\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\x24\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\x24\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\x24\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\x24\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\x24\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\x24\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\x24\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\x24\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\x24\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\x24\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\x24\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\x24\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\x24\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\x24\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\x24\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\x24\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\x24\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\x24\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\x24\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\x24\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\x24\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\x24\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\x24\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\x24\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\x24\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\x24\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\x24\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\x24\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\x24\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\x24\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\x24\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\x24\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\x24\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\x24\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\x24\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\x24\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\x24\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\x24\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\x24\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\x24\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\x24\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\x24\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\x24\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\x24\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\x24\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\x24\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\x24\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\x24\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\x24\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\x24\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\x24\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\x24\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\x24\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\x24\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\x24\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\x24\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\x24\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\x24\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\x24\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\x24\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\x24\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\x24\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\x24\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\x24\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\x24\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\x24\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\x24\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\x25\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\x25\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\x25\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\x25\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\x25\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\x25\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\x25\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\x25\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\x25\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\x25\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\x25\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\x25\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\x25\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\x25\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\x25\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\x25\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\x25\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\x25\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\x25\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\x25\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\x25\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\x25\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\x25\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\x25\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\x25\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\x25\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\x25\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\x25\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\x25\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\x25\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\x25\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\x25\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\x25\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\x25\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\x25\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\x25\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\x25\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\x25\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\x25\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\x25\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\x25\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\x25\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\x25\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\x25\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\x25\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\x25\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\x25\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\x25\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\x25\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\x25\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\x25\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\x25\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\x25\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\x25\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\x25\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\x25\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\x25\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\x25\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\x25\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\x25\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\x25\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\x25\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\x25\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\x25\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\x25\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\x25\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\x25\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\x25\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\x25\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\x25\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\x25\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\x25\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\x25\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\x25\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\x25\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\x25\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\x25\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\x25\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\x25\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\x25\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\x25\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\x25\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\x25\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\x25\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\x25\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\x25\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\x26\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\x26\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\x26\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\x26\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\x26\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\x26\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\x26\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\x26\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\x26\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\x26\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\x26\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\x26\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\x26\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\x26\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\x26\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\x26\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\x26\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\x26\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\x26\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\x26\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\x26\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\x26\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\x26\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\x26\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\x26\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\x26\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\x26\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\x26\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\x26\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\x26\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\x26\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\x26\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\x26\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\x26\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\x26\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\x26\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\x26\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\x26\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\x26\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\x26\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\x26\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\x26\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\x26\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\x26\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\x26\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\x26\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\x26\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\x26\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\x27\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\x27\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\x27\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\x27\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\x27\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\x27\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\x27\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\x27\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\x27\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\x27\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\x27\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\x27\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\x27\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\x27\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\x27\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\x27\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\x27\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\x27\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\x27\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\x27\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\x27\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\x27\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\x27\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\x27\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\x27\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\x27\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\x27\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\x27\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\x27\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\x27\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\x27\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\x27\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\x27\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\x27\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\x27\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\x27\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\x27\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\x27\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\x27\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\x27\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\x27\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\x27\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\x27\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\x27\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\x27\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\x27\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\x27\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\x27\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\x27\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\x27\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\x27\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\x27\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\x27\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\x27\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\x27\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\x27\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\x27\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\x27\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\x27\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\x27\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\x27\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\x27\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\x27\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\x27\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\x27\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\x27\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\x2C\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],
        ["\x2C\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],
        ["\x2C\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],
        ["\x2C\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],
        ["\x2C\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],
        ["\x2C\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],
        ["\x2C\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],
        ["\x2C\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],
        ["\x2C\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],
        ["\x2C\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],
        ["\x2C\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],
        ["\x2C\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],
        ["\x2C\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],
        ["\x2C\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],
        ["\x2C\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],
        ["\x2C\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],
        ["\x2C\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],
        ["\x2C\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],
        ["\x2C\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],
        ["\x2C\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],
        ["\x2C\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],
        ["\x2C\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],
        ["\x2C\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],
        ["\x2C\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],
        ["\x2C\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],
        ["\x2C\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],
        ["\x2C\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],
        ["\x2C\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],
        ["\x2C\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],
        ["\x2C\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],
        ["\x2C\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],
        ["\x2C\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],
        ["\x2D\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB1"],
        ["\x2D\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB2"],
        ["\x2D\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB3"],
        ["\x2D\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB4"],
        ["\x2D\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB5"],
        ["\x2D\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB6"],
        ["\x2D\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB7"],
        ["\x2D\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB8"],
        ["\x2D\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB9"],
        ["\x2D\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xBA"],
        ["\x2D\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"],
        ["\x2D\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA2"],
        ["\x2D\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA3"],
        ["\x2D\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA4"],
        ["\x2D\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA5"],
        ["\x2D\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA6"],
        ["\x2D\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA7"],
        ["\x2D\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA8"],
        ["\x2D\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA9"],
        ["\x2D\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x77\xAA"],
        ["\x2D\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB1"],
        ["\x2D\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB2"],
        ["\x2D\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB3"],
        ["\x2D\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB4"],
        ["\x2D\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB5"],
        ["\x2D\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB6"],
        ["\x2D\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB7"],
        ["\x2D\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB8"],
        ["\x2D\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB9"],
        ["\x2D\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xBA"],
        ["\x2D\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"],
        ["\x2D\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],
        ["\x2D\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],
        ["\x2D\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],
        ["\x2D\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],
        ["\x2D\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],
        ["\x2D\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],
        ["\x2D\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],
        ["\x2D\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\x2D\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xDB"],
        ["\x2D\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xDC"],
        ["\x2D\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],
        ["\x2D\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"],
        ["\x2D\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],
        ["\x2D\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xDA"],
        ["\x2D\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"],
        ["\x2D\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xCC"],
        ["\x2D\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xCB"],
        ["\x2D\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xCA"],
        ["\x2D\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xDA"],
        ["\x2D\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],
        ["\x2D\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xFA"],
        ["\x2D\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],
        ["\x2D\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],
        ["\x2D\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\x2D\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\x2D\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x72\xBE"],
        ["\x2D\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x72\xB6"],
        ["\x2D\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x72\xB8"],
        ["\x2D\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xEA"],
        ["\x2D\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xEB"],
        ["\x2D\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xEC"],
        ["\x2D\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xED"],
        ["\x2D\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xEE"],
        ["\x2D\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],
        ["\x2D\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xB1"],
        ["\x2D\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x73\xBD"],
        ["\x2D\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],
        ["\x2D\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],
        ["\x2D\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],
        ["\x2D\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xB8"],
        ["\x2D\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xA2"],
        ["\x2D\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xB7"],
        ["\x2D\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xBA"],
        ["\x30\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\x30\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\x30\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\x30\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\x30\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\x30\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\x30\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\x30\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\x30\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\x30\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\x30\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\x30\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\x30\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\x30\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\x30\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\x30\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\x30\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\x30\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\x72\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],
        ["\x30\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\x30\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\x30\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\x30\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\x30\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\x30\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\x30\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\x30\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\x30\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\x30\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\x30\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\x30\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\x30\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\x30\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\x30\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\x30\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\x30\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\x30\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\x30\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\x30\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\x30\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\x30\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\x30\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\x30\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\x30\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\x30\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\x30\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\x30\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\x30\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\x30\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\x30\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\x30\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\x30\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\x30\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\x30\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\x30\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\x30\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\x30\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\x30\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\x30\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\x30\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\x30\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\x30\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\x30\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\x30\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\x30\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\x30\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\x30\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\x30\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\x30\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\x30\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\x30\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\x30\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\x30\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\x30\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\x30\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\x30\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\x30\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\x30\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\x30\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\x30\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\x30\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\x30\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\x30\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\x30\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\x30\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\x30\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\x30\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\x30\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\x30\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\x30\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\x30\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\x30\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\x30\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\x30\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\x31\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\x31\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\x31\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\x31\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\x31\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\x31\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\x31\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\x31\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\x31\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\x31\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\x31\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\x31\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\x31\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\x31\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\x31\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\x31\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\x31\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\x31\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\x31\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\x31\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\x31\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\x31\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\x31\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\x31\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\x31\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\x31\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\x31\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\x31\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\x31\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\x31\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\x31\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\x31\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\x31\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\x31\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\x31\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\x31\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\x31\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\x31\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\x31\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\x31\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\x31\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\x31\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\x31\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\x31\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\x31\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\x31\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\x31\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\x31\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\x31\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\x31\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\x31\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\x31\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\x31\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\x31\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\x31\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\x31\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\x31\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\x31\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\x31\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\x31\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\x31\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\x31\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\x31\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\x31\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\x31\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\x31\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\x31\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\x31\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\x31\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\x31\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\x31\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\x31\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\x31\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\x31\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\x31\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\x31\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\x31\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\x31\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\x31\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\x31\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\x31\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\x31\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\x31\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\x31\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\x31\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\x31\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\x31\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\x31\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\x31\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\x31\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\x31\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\x31\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\x31\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\x31\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\x32\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\x32\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\x32\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\x32\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\x32\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\x32\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\x32\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\x32\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\x72\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],
        ["\x32\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\x32\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\x32\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\x32\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\x32\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\x32\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\x32\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\x32\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\x32\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\x32\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\x32\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\x32\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\x32\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\x32\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\x32\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\x32\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\x32\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\x32\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\x32\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\x32\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\x32\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\x32\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\x32\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\x32\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\x32\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\x32\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\x32\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\x32\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\x32\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\x32\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\x32\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\x32\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\x32\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\x32\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\x32\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\x32\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\x32\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\x32\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\x32\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\x32\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\x32\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\x32\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\x32\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\x32\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\x32\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\x32\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\x32\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\x32\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\x32\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\x32\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\x32\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\x32\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\x32\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\x32\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\x32\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\x32\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\x32\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\x32\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\x32\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\x32\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\x32\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\x32\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\x32\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\x32\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\x32\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\x32\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\x32\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\x32\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\x32\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\x32\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\x32\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\x32\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\x32\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\x32\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\x32\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\x32\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\x32\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\x32\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\x32\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\x32\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\x32\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\x32\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\x32\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\x32\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\x32\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\x33\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\x33\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\x33\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\x33\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\x33\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\x33\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\x33\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\x33\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\x33\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\x33\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\x33\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\x33\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\x33\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\x33\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\x33\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\x33\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\x33\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\x33\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\x33\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\x33\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\x33\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\x33\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\x33\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\x33\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\x33\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\x33\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\x33\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\x33\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\x33\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\x33\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\x33\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\x33\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\x33\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\x69\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\x33\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\x33\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\x33\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\x33\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\x33\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\x33\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\x59\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\x33\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\x33\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\x33\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\x33\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\x33\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\x33\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\x33\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\x33\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\x33\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\x33\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\x33\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\x33\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\x33\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\x33\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\x33\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\x33\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\x33\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\x33\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\x33\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\x33\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\x33\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\x33\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\x33\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\x33\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\x33\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\x33\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\x33\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\x33\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\x33\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\x33\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\x33\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\x33\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\x33\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\x33\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\x33\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\x33\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\x33\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\x33\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\x33\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\x33\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\x33\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\x33\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\x33\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\x33\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\x63\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\x33\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\x33\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\x33\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\x33\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\x33\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\x33\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\x33\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\x33\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\x34\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\x34\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\x34\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\x34\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\x34\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\x34\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\x34\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\x34\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\x34\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\x34\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\x34\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\x34\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\x34\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\x34\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\x34\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\x34\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\x34\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\x34\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\x34\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\x34\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\x34\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\x34\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\x34\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\x34\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\x34\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\x34\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\x34\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\x34\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\x34\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\x34\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\x34\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\x34\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\x34\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\x34\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\x5E\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\x34\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\x34\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\x34\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\x34\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\x34\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\x34\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\x34\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\x34\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\x34\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\x34\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\x34\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\x34\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\x34\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\x34\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\x6B\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\x34\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\x34\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\x34\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\x34\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\x34\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\x34\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\x34\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\x34\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\x34\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\x34\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\x34\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\x34\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\x34\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\x34\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\x34\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\x34\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\x34\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\x34\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\x34\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\x34\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\x34\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\x34\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\x34\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\x34\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\x34\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\x34\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\x34\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\x34\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\x34\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\x34\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\x34\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\x34\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\x34\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\x34\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\x34\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\x34\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\x34\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\x34\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\x34\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\x34\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\x34\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\x34\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\x34\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\x34\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\x35\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\x35\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\x35\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\x35\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\x35\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\x35\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\x35\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\x35\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\x35\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\x35\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\x35\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\x35\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\x35\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\x35\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\x35\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\x35\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\x35\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\x35\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\x35\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\x35\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\x35\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\x35\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\x35\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\x35\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\x35\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\x35\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\x35\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\x35\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\x35\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\x35\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\x35\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\x35\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\x35\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\x35\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\x35\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\x35\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\x35\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\x35\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\x35\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\x35\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\x35\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\x35\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\x35\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\x35\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\x35\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\x35\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\x35\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\x35\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\x35\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\x35\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\x35\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\x35\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\x35\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\x35\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\x35\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\x35\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\x35\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\x35\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\x35\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\x35\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\x35\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\x35\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\x35\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\x35\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\x35\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\x35\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\x35\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\x35\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\x35\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\x35\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\x35\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\x35\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\x35\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\x35\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\x35\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\x35\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\x35\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\x35\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\x35\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\x35\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\x35\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\x35\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\x35\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\x35\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\x35\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\x35\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\x35\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\x35\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\x35\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\x35\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\x35\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\x35\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\x35\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\x35\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\x36\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\x36\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\x36\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\x36\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\x36\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\x36\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\x36\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\x36\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\x36\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\x36\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\x36\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\x36\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\x36\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\x36\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\x36\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\x36\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\x36\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\x36\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\x36\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\x36\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\x36\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\x36\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\x36\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\x36\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\x36\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\x36\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\x36\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\x36\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\x36\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\x36\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\x36\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\x36\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\x36\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\x36\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\x36\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\x36\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\x36\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xB6\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\x36\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\x36\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\x36\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\x36\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\x36\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\x36\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\x36\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\x36\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\x36\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\x36\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\x36\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\x36\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\x36\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\x36\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\x36\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\x36\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\x36\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\x36\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\x36\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\x36\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\x36\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\x36\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\x36\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\x36\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\x36\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\x36\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\x36\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\x36\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\x36\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\x36\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\x36\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\x36\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\x36\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\x36\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\x36\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\x36\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\x36\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\x36\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\x36\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\x36\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\x36\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\x36\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\x36\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\x36\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\x36\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\x36\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\x36\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\x36\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\x36\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\x36\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\x36\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\x36\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\x36\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\x36\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\x36\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\x36\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\x37\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\x37\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\x37\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\x37\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\x37\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\x37\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\x37\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\x37\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\x37\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\x37\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\x37\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\x37\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\x37\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\x37\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\x37\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\x37\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\x37\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\x37\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\x37\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\x37\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\x37\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\x37\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\x37\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\x37\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\x37\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\x37\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\x37\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\x37\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\x37\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\x37\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\x37\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\x37\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\x37\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\x37\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\x37\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\x37\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\x37\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\x37\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\x37\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\x37\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\x37\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\x37\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\x37\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\x37\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\x37\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\x37\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\x37\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\x37\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\x37\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\x37\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\x37\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\x37\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\x37\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\x37\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\x37\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\x37\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\x37\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\x37\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\x70\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\x37\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\x37\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\x37\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\x37\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\x37\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\x37\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\x37\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\x37\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\x37\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\x37\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\x37\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\x37\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\x37\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\x37\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\x37\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\x37\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\x37\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\x37\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\x37\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\x37\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\x37\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\x37\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\x37\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\x37\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\x37\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\x37\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\x37\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\x37\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\x37\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\x37\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\x37\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\x37\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\x37\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\x37\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\x37\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\x38\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\x38\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\x38\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\x38\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\x38\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\x38\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\x38\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\x38\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\x38\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\x38\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\x38\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\x38\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\x38\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\x38\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\x38\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\x38\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\x38\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\x38\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\x38\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\x38\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\x38\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\x38\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\x38\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\x38\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\x38\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\x38\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\x38\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\x38\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\x38\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\x38\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\x38\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\x38\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\x38\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\x38\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\x38\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\x38\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\x38\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\x38\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\x38\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\x38\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\x38\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\x38\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\x38\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\x38\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\x38\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\x38\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\x38\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\x38\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\x38\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\x38\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\x38\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\x38\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\x38\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\x38\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\x38\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\x38\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\x38\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\x38\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\x38\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\x38\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\x38\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\x38\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\x38\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\x38\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\x38\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\x38\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\x38\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\x38\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\x38\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\x38\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\x38\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\x38\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\x38\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\x38\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\x38\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\x38\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\x38\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\x38\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\x38\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\x38\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\x38\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\x38\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\x38\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\x38\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\x38\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\x38\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\x38\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\x38\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\x38\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\x38\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\x38\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\x38\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\x38\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\x38\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\x39\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\x39\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\x39\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\x39\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\x39\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\x39\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\x39\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\x39\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\x39\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\x39\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\x39\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\x39\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\x39\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\x39\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\x39\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\x39\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\x39\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\x39\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\x39\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\x39\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\x39\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\x39\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\xBD\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],
        ["\x39\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\x39\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\x39\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\x39\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\x39\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\x39\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\x39\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\x39\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\x39\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\x39\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\x39\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\x39\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\x39\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\x39\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\x39\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\x39\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\x39\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\x39\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\x39\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\x39\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\x39\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\x39\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\x39\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\x39\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\x39\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\x39\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\x39\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\x39\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\x39\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\x39\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\x39\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\x39\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\x39\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\x39\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\x39\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\x39\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\x62\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\x39\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\x39\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\x39\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\x39\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\x39\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\x39\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\x39\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\x39\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\x39\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\x39\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\x39\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\x39\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\x39\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\x39\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\x39\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\x39\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xD6\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],
        ["\x39\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\x39\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\x39\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\x39\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\x39\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\x39\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\x39\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\x39\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\x39\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\x39\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\x39\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\x39\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\x39\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\x39\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\x39\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\x39\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\x39\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\x3A\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\x3A\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\x3A\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\x3A\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\x3A\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\x3A\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\x3A\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\x3A\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\x3A\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\x3A\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\x3A\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\x3A\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\x3A\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\x3A\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\x3A\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\x3A\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\x3A\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\x3A\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\x3A\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\x3A\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\x3A\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\x3A\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\x3A\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\x3A\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\x3A\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\x3A\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\x3A\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\x3A\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\x3A\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\x3A\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\x3A\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\x3A\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\x3A\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\x3A\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\x3A\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\x3A\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\x3A\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\x3A\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\x3A\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\x3A\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\x3A\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\x3A\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\x3A\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\x3A\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\x3A\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\x3A\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\x3A\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\x3A\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\x3A\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\x3A\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\x3A\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\x3A\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\x3A\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\x3A\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\x3A\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\x3A\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\x3A\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\x3A\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\x3A\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\x3A\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\x3A\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\x3A\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\x3A\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\x3A\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\x3A\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\x3A\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\x3A\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\x3A\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\x3A\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\x3A\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\x3A\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\x3A\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\x3A\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\x3A\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\x3A\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\x3A\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\x3A\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\x3A\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\x3A\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\x3A\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\x3A\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\x3A\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\x3A\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\x3A\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\x3A\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\x3A\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\x3A\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\x3A\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\x3A\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\x3A\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\x3A\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\x3A\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\x3A\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\x3A\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\x3B\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\x3B\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\x3B\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\x3B\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\x3B\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\x3B\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\x3B\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\x3B\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\x3B\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\x3B\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\x3B\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\x3B\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\x3B\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\x3B\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\x3B\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\x3B\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\x3B\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\x3B\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\x3B\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\x3B\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\x3B\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\x3B\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\x3B\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\x3B\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\x3B\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\x3B\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\x3B\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\x3B\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\x3B\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\x3B\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\x3B\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\x3B\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\x3B\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\x3B\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\x3B\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\x3B\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\x3B\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\x3B\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\x3B\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\x3B\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\x3B\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\x3B\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\x3B\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\x3B\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\x3B\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\x3B\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\x3B\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\x3B\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\x3B\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\x3B\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\x3B\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\x3B\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\x3B\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\x3B\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\x3B\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\x3B\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\x3B\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\x3B\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\x3B\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\x3B\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\x3B\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\x3B\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\x3B\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\x3B\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\x3B\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\x3B\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\x3B\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\x3B\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\x3B\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\x3B\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\x3B\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\x3B\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\x3B\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\x3B\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\x3B\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\x3B\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\x3B\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\x3B\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\x3B\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\x3B\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\x3B\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\x3B\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\x3B\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\x3B\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\x3B\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\x3B\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\x3B\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\x3B\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\x3B\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\x3B\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\x3B\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\x3B\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\x3B\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\x3B\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\x3C\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\x3C\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\x3C\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\x3C\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\x3C\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\x3C\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\x3C\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\x3C\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\x3C\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\x3C\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\x3C\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\x3C\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\x3C\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\x3C\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\x3C\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\x3C\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\x3C\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\x3C\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\x3C\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\x3C\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\x3C\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\x3C\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\x3C\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\x3C\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\x3C\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\x3C\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\x3C\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\x3C\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\x3C\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\x3C\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\x3C\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\x3C\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\x3C\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\x3C\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\x3C\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\x3C\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\x3C\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\x3C\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\x3C\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\x3C\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\x69\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\x3C\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\x3C\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\x3C\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\x3C\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\x3C\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\x3C\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\x3C\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\x3C\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\x3C\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\x3C\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\x3C\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\x3C\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\x3C\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\x3C\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\x3C\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\x3C\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\x3C\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\x3C\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\x3C\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\x3C\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\x3C\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\x3C\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\x3C\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\x3C\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\x3C\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\x3C\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\x3C\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\x3C\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\x3C\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\x3C\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\x3C\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\x3C\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\x3C\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\x3C\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\x3C\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\x3C\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\x3C\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\x3C\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\x3C\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\x3C\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\x3C\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\x3C\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\x3C\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\x3C\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\x3C\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\x3C\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\x3C\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\x3C\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\x3C\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\x3C\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\x3C\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\x3C\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\x3C\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\x3D\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\x3D\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\x3D\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\x3D\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\x3D\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\x3D\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\x3D\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\x3D\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\x3D\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\x3D\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\x3D\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\x3D\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\x3D\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\x3D\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\x3D\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\x3D\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\x3D\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\x3D\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\x3D\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\x3D\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\x3D\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\x3D\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\x3D\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\x3D\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\x3D\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\x3D\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\x3D\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\x3D\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\x3D\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\x3D\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\x3D\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\x3D\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\x3D\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\x3D\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\x3D\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\x3D\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\x3D\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\x3D\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\x3D\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\x3D\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\x3D\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\x3D\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\x3D\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\x3D\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\x3D\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\x3D\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\x3D\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\x3D\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\x3D\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\x3D\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\x3D\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\x3D\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\x3D\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\x3D\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\x3D\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\x3D\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\x3D\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\x3D\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\x3D\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\x3D\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\x3D\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\x3D\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\x3D\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\x3D\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\x3D\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\x3D\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\x3D\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\x3D\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\x3D\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\x3D\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\x3D\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\x3D\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\x3D\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\x3D\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\x3D\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\x3D\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\x3D\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\x3D\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\x3D\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\x3D\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\x3D\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\x3D\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\x3D\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\x3D\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\x3D\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\x3D\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\x3D\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\x3D\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\x3D\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\x3D\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\x3D\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\x3D\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\x3D\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\x3D\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\x3E\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\x3E\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\x3E\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\x3E\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\x3E\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\x3E\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\x3E\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\x3E\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\x3E\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\x3E\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\x3E\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\x3E\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\x3E\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\x3E\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\x3E\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\x3E\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\x3E\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\x3E\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\x3E\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\x3E\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\x3E\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\x3E\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\x3E\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\x3E\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\x3E\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\x3E\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\x3E\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\x3E\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\x3E\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\x3E\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\x3E\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\x3E\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\x3E\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\x3E\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\x3E\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\x3E\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\x3E\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\x3E\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\x3E\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\x3E\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\x3E\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\x3E\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\x3E\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\x3E\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\x3E\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\x3E\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\x3E\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\x3E\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\x3E\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\x3E\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\x3E\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\x3E\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\x3E\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\x3E\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\x3E\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\x3E\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\x3E\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\x3E\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\x3E\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\x3E\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\x3E\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\x3E\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\x3E\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\x3E\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\x3E\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\x3E\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\x3E\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\x3E\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\x3E\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\x3E\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\x3E\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\x3E\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\x3E\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\x3E\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\x3E\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\x3E\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\x3E\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\x3E\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\x3E\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\x3E\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\x3E\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\x3E\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\x3E\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\x3E\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\x3E\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\x3E\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\x3E\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\x3E\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\x3E\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\x3E\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\x3E\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\x3E\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\x3E\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\x3E\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\x3F\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\x3F\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\x3F\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\x3F\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\x3F\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\x3F\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\x3F\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\x3F\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\x3F\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\x3F\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\x3F\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\x3F\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\x3F\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\x3F\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\x3F\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\x3F\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\x3F\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\x3F\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\x3F\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\x3F\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\x3F\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\x3F\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\x3F\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\x3F\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\x3F\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\x3F\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\x3F\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\x3F\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\x3F\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\x3F\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\x3F\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\x3F\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\x3F\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\x3F\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\x3F\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\x3F\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\x3F\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\x3F\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\x3F\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\x3F\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\x3F\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\x3F\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\x3F\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\x3F\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\x3F\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\x3F\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\x3F\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\x3F\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\x3F\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\x3F\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\x3F\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\x3F\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\x3F\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\x3F\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\x3F\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\x3F\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\x70\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],
        ["\x3F\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\x3F\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\x3F\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\x3F\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\x3F\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\x3F\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\x3F\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\x3F\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\x3F\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\x3F\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\x3F\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\x3F\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\x3F\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\x3F\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\x3F\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\x3F\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\x3F\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\x3F\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\x3F\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\x3F\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\x3F\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\x3F\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\x3F\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\x3F\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\x3F\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\x3F\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\x3F\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\x3F\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\x3F\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\x3F\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\x3F\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\x3F\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\x3F\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\x3F\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\x3F\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\x3F\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\x3F\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\x40\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\x40\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\x40\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\x40\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\x40\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\x40\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\x40\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\x40\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\x40\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\x40\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\x40\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\x40\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\x40\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\x40\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\x40\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\x40\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\x40\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\x40\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\x40\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\x40\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\x40\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\x40\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\x40\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\x40\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\x40\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\x40\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\x40\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\x40\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\x40\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\x40\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\x40\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\x40\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\x40\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\x40\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\x40\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\x40\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\x40\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\x40\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\x40\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\x40\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\x40\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\x40\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\x40\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\x40\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\x40\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\x40\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\x40\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\x40\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\x40\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\x40\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\x40\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\x40\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\x40\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\x40\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\x40\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\x40\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\x40\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\x40\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\x40\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\x40\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\x40\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\x40\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\x40\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\x40\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\x40\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\x40\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\x40\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\x40\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\x40\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\x40\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\x40\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\x40\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\x40\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\x40\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\x40\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\x40\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\x40\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\x40\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\x40\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\x40\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\x40\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\x40\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\x40\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\x40\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\x40\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\x40\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\x40\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\x40\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\x40\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\x40\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\x40\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\x40\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\x40\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\x40\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\x41\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\x41\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\x41\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\x41\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\x41\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\x41\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\x41\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\x6C\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\x41\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\x41\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\x41\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\x41\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\x41\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\x41\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\x41\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\x41\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\x41\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\x41\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\x41\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\x41\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\x41\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\x41\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\x41\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\x41\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\x41\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\x41\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\x41\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\x41\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\x41\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\x41\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\x41\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\x41\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\x41\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\x41\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\x41\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\x41\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\x41\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\x41\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\x41\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\x41\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\x41\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\x41\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\x41\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\x41\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\x41\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\x41\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\x41\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\x41\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\x41\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\x41\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\x41\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\x41\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\x41\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\x41\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\x41\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\x41\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\x41\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\x41\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\x41\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\x41\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\x41\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\x41\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\x41\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\x41\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\x41\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\x41\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\x41\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\x41\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\x41\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\x41\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\x41\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\x41\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\x41\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\x41\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\x41\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\x41\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\x41\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\x41\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\x41\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\x41\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\x41\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\x41\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\x41\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\x41\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\x41\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\x41\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\x41\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\x41\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\x41\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\x41\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\x41\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\x41\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\x41\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\x41\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\x42\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\x42\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\x42\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\x42\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\x42\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\x42\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\x42\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\x42\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\x42\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\x42\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\x42\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\x42\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\x42\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\x42\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\x42\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\x42\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\x42\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\x42\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\x42\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\x42\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\x42\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\x42\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\x42\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\x42\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\x42\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\x42\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\x42\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\x42\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\x42\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\x42\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\x42\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\x42\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\x42\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\x42\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\x42\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\x42\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\x42\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\x42\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\x42\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\x42\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\x42\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\x42\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\x42\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\x42\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\x42\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\x42\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\x42\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\x42\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\x42\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\x42\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\x42\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\x42\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\x42\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\x42\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\x42\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\x42\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\x42\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\x42\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\x42\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\x42\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\x42\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\x42\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\x42\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\x42\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\x42\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\x42\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\x42\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\x42\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\x42\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\x42\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\x42\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\x42\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\x42\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\x42\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\x42\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\x42\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\x42\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\x42\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\x42\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\x42\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\x42\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\x42\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\x42\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\x42\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\x42\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\x42\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\x42\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\x42\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\x42\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\x42\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\x42\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\x42\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\x42\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\x42\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\x43\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\x43\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\x43\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\x43\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\x43\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\x43\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\x43\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\x43\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\x43\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\x43\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\x43\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\x43\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\x43\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\x43\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\x43\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\x43\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\x43\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\x43\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\x43\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\x43\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\x43\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\x43\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\x43\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\x43\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\x43\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\x43\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\x43\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\x43\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\x43\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\x43\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\x43\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\x43\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\x43\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\x43\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\x43\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\x43\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\x43\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\x43\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\x43\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\x43\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\x43\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\x43\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\x43\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\x43\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\x43\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\x43\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\x43\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\x43\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\x43\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\x43\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\x43\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\x43\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\x43\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\x43\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\x43\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\x43\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\x43\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\x43\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\x43\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\x43\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\x43\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\x43\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\x43\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\x43\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\x43\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\x43\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\x43\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\x43\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\x43\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\x43\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\x43\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\x43\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\x43\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\x43\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\x43\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\x43\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\x43\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\x43\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\x43\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\x43\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\x43\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\x43\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\x43\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\x43\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\x43\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\x43\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\x43\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\x43\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\x43\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\x43\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\x43\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\x43\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\x43\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\x43\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\x44\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\x44\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\x44\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\x44\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\x44\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\x44\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\x44\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\x44\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\x44\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\x44\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\x44\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\x44\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\x44\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\x44\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\x44\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\x44\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\x44\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\x44\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\x44\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\x44\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\x44\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\x44\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\x44\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\x44\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\x44\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\x44\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\x44\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\x44\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\x44\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\x44\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\x44\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\x44\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\x44\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\x44\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\x44\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\x44\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\x44\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\x44\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\x44\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\x44\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\x44\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\x44\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\x44\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\x44\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\xB6\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\x44\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\x44\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\x44\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\x44\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\x44\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\x44\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\x44\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\x44\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\x44\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\x44\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\x44\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\x44\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\x44\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\x54\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\x44\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\x44\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\x44\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\x44\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\x44\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\x44\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\x44\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\x44\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\x44\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\x44\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\x44\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\x44\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\x44\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\x44\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\x44\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\x44\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\x44\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\x44\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\x44\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\x44\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\x44\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\x44\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\x44\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\x44\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\x44\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\x44\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\x44\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\x44\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\x44\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\x44\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\x44\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\x44\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\x44\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\x44\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\x44\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\x45\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\x45\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\x45\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\x45\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\x45\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\x45\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\x45\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\x45\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\x45\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\x45\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\x45\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\x45\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\x45\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\x45\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\x45\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\x45\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\x45\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\x45\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\x45\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\x45\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\x45\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xD6\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\x45\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\x45\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\x45\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\x45\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\x45\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\x45\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\x45\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\x45\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xD4\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\x45\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\x45\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\x45\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\x45\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\x45\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\x45\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\x45\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\x45\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\x45\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\x45\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\x45\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\x45\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\x45\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\x45\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\x45\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\x45\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\x45\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\x45\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\x45\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\x45\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\x45\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\x45\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\x45\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\x62\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\x45\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\x45\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\x45\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\x45\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\x45\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\x45\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\x45\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\x45\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\x45\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\x45\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\x45\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\x45\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\x45\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\x45\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\x45\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\x45\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\x45\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\x45\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\x45\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\x45\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\x45\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\x45\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\x5B\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\x45\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\x45\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\x45\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\x45\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\x5E\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\x45\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\x45\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\x45\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\x45\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\x45\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\x45\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\x45\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\x45\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\x45\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\x45\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\x45\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\x46\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\x46\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\x46\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\x46\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\x46\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\x46\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\x46\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\x46\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\x46\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\x46\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\x46\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\x46\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\x46\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\x46\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\x46\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\x46\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\x46\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\x46\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\x46\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\x46\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\x46\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\x46\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\x46\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\x46\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\x46\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\x46\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\x46\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\x46\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\x46\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\x46\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\x46\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\x46\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\x46\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\x46\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\x46\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\x46\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\x46\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\x46\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\x46\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\x46\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\x46\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\x46\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\x46\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\x46\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\x46\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\x46\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\x46\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\x46\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\x46\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\x46\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\x46\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\x46\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\x46\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\x46\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\x46\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\x46\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\x46\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\x46\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\x46\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\x46\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\x46\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\x46\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\x46\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\x46\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\x46\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\x46\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\x46\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\x46\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\x46\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\x46\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\x46\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\x46\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\x46\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\x46\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\x46\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\x46\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\x46\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\x46\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\x46\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\x46\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\x46\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\x46\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\x46\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\x46\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\x46\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\x6D\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\x46\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\x46\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\x46\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\x46\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\x46\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\x46\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\x46\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\x46\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\x47\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\x47\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\x47\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\x47\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\x47\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\x47\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\x47\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\x47\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\x47\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\x47\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\x47\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\x47\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\x47\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\x47\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\x47\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\x47\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\x47\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\x47\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\x47\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\x47\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\x47\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\x47\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\x47\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\x47\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\x47\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\x47\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\x47\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\x47\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\x47\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\x47\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\x47\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\x47\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\x47\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\x47\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\x47\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\x47\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\x47\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\x47\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\x47\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\x47\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\x47\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\x47\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\x47\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\x47\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\x47\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\x47\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\x47\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\x47\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\x47\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\x47\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\x47\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\x47\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\x47\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\x47\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\x47\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\x47\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\x47\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\x47\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\x47\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\x47\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\x47\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\x47\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\x47\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\x47\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\x47\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\x47\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\x47\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\x47\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\x47\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\x47\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\x47\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\x6A\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\x47\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\x47\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\x47\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\x47\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\x47\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\x47\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\x47\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\x47\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\x47\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\x47\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\x47\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\x47\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\x47\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\x47\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\x47\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\x47\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\x47\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\x47\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\x47\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\x47\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\x47\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\x47\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\x48\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\x48\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\x48\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\x48\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\x48\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\x48\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\x48\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\x48\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\x48\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\x48\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\x48\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\x48\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\x48\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\x48\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\x48\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\x48\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\x48\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\x48\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\x48\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\x48\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\x48\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\x48\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\x48\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\x48\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\x48\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\x48\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\x48\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\x48\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\x48\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\x48\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\x48\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\x48\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\x48\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\x48\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\x48\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\x48\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\x48\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\x48\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\x48\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\x48\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\x48\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\x48\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\x48\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\x48\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\x48\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\x48\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\x48\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\x48\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\x48\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\x48\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\x48\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\x48\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\x48\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\x48\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\x48\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\x48\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\x48\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\x48\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\x48\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\x48\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\x48\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\x48\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\x48\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\x48\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\x48\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\x48\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\x48\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\x48\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\x48\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\x48\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\x48\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\x48\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\x48\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\x48\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\x48\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\x48\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\x48\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\x48\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\x48\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\x48\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\x48\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\x48\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\x48\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\x48\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\x48\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\x48\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\x48\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\x48\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\x48\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\x48\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\x48\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\x48\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\x48\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\x48\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\x49\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\x49\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\x49\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\x49\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\x49\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\x49\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\x49\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\x49\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\x49\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\x49\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\x49\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\x49\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\x49\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\x49\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\x49\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\x5B\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\x49\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\x49\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\x49\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\x49\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\x49\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\x49\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\x49\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\x49\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\x49\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\x49\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\x49\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\x49\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\x49\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\x49\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\x49\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\x49\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\x49\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\x49\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\x49\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\x49\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\x49\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\x49\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\x49\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\x49\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\x49\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\x49\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\x49\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\x49\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\x49\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\x49\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\x49\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\x49\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\x49\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\x49\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\x49\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\x49\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\x49\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\x49\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\x49\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\x49\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\x49\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\x49\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\x49\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\x49\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\x49\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\x49\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\x49\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\x49\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\x49\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\x49\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\x49\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\x49\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\x49\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\x49\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\x49\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\x49\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\x49\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\x49\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\x49\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\x49\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\x49\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\x49\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\x49\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\x49\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\x49\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\x49\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\x49\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\x49\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\x49\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\x49\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\x49\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\x49\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\x49\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\x49\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\x49\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\x49\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\x49\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\x49\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\x4A\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\x4A\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\x4A\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\x4A\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\x4A\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\x4A\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\x4A\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\x4A\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\x4A\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\x4A\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\x4A\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\x4A\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\x4A\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\x4A\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\x4A\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\x4A\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\x4A\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\x4A\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\x4A\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\x4A\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\x4A\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\x4A\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\x4A\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\x4A\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\x4A\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\x4A\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\x4A\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\x4A\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\x4A\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\x4A\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\x4A\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\x4A\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\x4A\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\x4A\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\x4A\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\x4A\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\x4A\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\x4A\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\x4A\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\x4A\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\x4A\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\x4A\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\x4A\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\x4A\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\x4A\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\x4A\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\x4A\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\x4A\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\x4A\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\x4A\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\x4A\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\x4A\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\x4A\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\x4A\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\x4A\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\x4A\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\x4A\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\x4A\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\x4A\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\x4A\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\x4A\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\x4A\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\x4A\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\x4A\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\x4A\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\x4A\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\x4A\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\x4A\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\x4A\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\x4A\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\x4A\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\x4A\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\x4A\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\x4A\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\x4A\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\x4A\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\x4A\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\x4A\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\x4A\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\x4A\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\x4A\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\x4A\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\x4A\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\x4A\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\x4A\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\x4A\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\x4A\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\x4A\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\x4A\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\x4A\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\x4A\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\x4A\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\x4A\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\x4A\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\x4B\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\x4B\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\x4B\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\x4B\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\x4B\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\x4B\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\x4B\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\x4B\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\x4B\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\x4B\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\x4B\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\x4B\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\x4B\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\x4B\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\x4B\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\x4B\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\x4B\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\x4B\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\x4B\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\x4B\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\x4B\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\x4B\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\x4B\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\x4B\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\x4B\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\x4B\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\x4B\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\x4B\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\x4B\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\x4B\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\x4B\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\x4B\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\x4B\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\x4B\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\x4B\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\x4B\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\x4B\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\x4B\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\x4B\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\x4B\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\x4B\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\x4B\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\x4B\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\x4B\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\x4B\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\x4B\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\x4B\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\x4B\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\x4B\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\x4B\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\x4B\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\x4B\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\x4B\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\x4B\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\x4B\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\x4B\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\x4B\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\x4B\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\x4B\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\x4B\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\x4B\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\x4B\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\x4B\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\x4B\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\x4B\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\x4B\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\x4B\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\x4B\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\x4B\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\x4B\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\x4B\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\x4B\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\x4B\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xBF\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],
        ["\x4B\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\x4B\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\x4B\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\x4B\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\x4B\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\x4B\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\x4B\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\x4B\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\x4B\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\x4B\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\x4B\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\x4B\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\x4B\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\x4B\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\x50\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\x4B\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\x4B\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\x4B\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\x4B\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\x4B\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\x4C\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\x4C\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\x4C\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\x4C\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\x4C\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\x4C\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\x4C\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\x4C\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\x4C\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\x4C\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\x4C\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\x4C\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\x4C\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\x4C\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\x4C\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\x4C\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\x4C\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\x4C\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\x4C\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\x4C\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\x4C\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\x4C\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\x4C\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\x4C\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\x4C\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\x4C\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\x4C\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\x4C\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\x4C\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\x4C\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\x4C\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\x4C\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\x4C\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\x4C\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\x4C\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\x4C\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\x4C\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\x4C\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\x4C\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\x4C\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\x4C\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\x4C\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\x4C\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\x4C\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\x4C\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\x4C\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\x4C\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\x4C\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\x4C\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\x4C\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\x4C\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\x4C\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\x4C\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\x4C\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\x4C\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\x4C\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\x4C\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\x4C\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\x4C\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\x4C\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\x4C\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\x4C\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\x4C\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\x4C\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\x4C\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\x4C\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\x4C\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\x4C\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\x4C\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\x4C\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\x4C\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\x4C\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\x4C\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\x4C\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\x4C\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\x4C\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\x4C\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\x4C\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\x4C\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\x4C\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\x4C\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\x4C\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\x4C\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\x4C\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\x4C\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\x4C\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\x4C\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\x4C\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\x69\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\x4C\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\x4C\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\x4C\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\x4C\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\x4C\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\x4D\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\x4D\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\x4D\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\x4D\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\x4D\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\x4D\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\x4D\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\x4D\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\x4D\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\x4D\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\x4D\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\x4D\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\x4D\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\x4D\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\x4D\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\x4D\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\x4D\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\x4D\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\x4D\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\x4D\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\x4D\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\x4D\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\x4D\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\x4D\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\x4D\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\x4D\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\x4D\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\x4D\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\x4D\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\x4D\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\x4D\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\x4D\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\x4D\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\x4D\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\x4D\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\x4D\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\x4D\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\x4D\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\x4D\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\x4D\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\x4D\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\x4D\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\x4D\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\x4D\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\x4D\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\x4D\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\x4D\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\x4D\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\x4D\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\x4D\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\x4D\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\x4D\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\x4D\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\x4D\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\x4D\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\x4D\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\x4D\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xD0\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\x4D\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\x4D\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\x4D\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\x4D\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\x4D\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\x4D\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\x4D\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\x4D\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\x4D\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\x4D\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\x4D\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\x4D\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\x4D\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\x4D\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\x4D\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\x4D\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\x4D\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\x4D\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\x4D\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\x4D\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\x4D\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\x4D\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\x4D\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\x4D\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\x4D\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\x4D\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\x4D\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\x4D\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\x4D\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\x4D\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\x4D\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\x4D\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\x4D\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\x4D\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\x4D\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\x4D\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\x4E\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\x4E\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\x4E\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\x4E\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\x4E\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\x4E\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\x4E\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\x4E\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\x4E\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\x4E\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\x4E\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\x4E\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\x4E\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\x4E\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\x4E\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\x4E\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\x4E\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\x4E\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\x4E\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\x4E\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\x4E\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\x4E\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\x4E\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\x4E\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\x4E\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\x4E\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\x4E\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\x4E\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\x4E\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\x4E\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\x4E\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\x4E\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\x4E\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\x4E\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\x4E\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\x4E\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\x4E\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\x4E\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\x4E\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\x4E\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\x4E\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\x4E\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\x4E\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\x4E\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\x4E\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\x4E\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\x4E\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\x4E\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\x4E\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\x4E\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\x4E\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\x4E\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\x4E\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\x4E\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\x4E\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\x4E\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\x4E\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\x4E\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\x4E\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\x4E\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\x4E\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\x4E\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\x4E\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\x4E\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\x4E\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\x4E\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\x4E\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\x4E\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\x4E\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\x4E\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\x4E\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\x4E\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\x4E\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\x4E\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\x4E\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\x4E\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\x4E\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\x4E\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\x4E\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\x4E\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\x4E\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\x4E\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\x4E\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\x4E\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\x4E\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\x4E\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\x4E\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\x4E\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\x4E\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\x4E\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\x4E\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\x4E\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\x4E\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\x4E\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\x4F\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\x4F\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\x4F\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\x4F\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\x4F\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\x4F\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\x4F\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\x4F\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\x4F\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\x4F\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\x4F\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\x4F\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\x4F\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\x4F\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\x4F\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\x4F\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\x4F\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\x4F\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\x4F\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\x4F\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\x4F\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\x64\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\x4F\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\x4F\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\x4F\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\x4F\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\x4F\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\x4F\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\x4F\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\x4F\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\x4F\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\x4F\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\x4F\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\x4F\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\x4F\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\x4F\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\x4F\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\x4F\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\x4F\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\x4F\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\x4F\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\x4F\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\x4F\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\x4F\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\x4F\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\x4F\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\x4F\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\x4F\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\x4F\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\x4F\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\x4F\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\x50\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\x50\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\x50\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\x50\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\x50\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\x50\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\x50\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\x50\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\x50\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\x50\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\x50\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\x50\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\x50\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\x50\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\x50\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\x50\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\x50\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\x50\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\x50\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\x50\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\x50\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\x50\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\x50\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\x50\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\x50\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\x50\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\x50\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\x50\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\x50\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\x50\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\x50\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\x50\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\x50\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\x50\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\x50\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\x50\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\x50\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\x50\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\x50\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\x50\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\x50\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\x50\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\x50\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\x50\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\x50\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\x50\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\x50\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\x50\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\x50\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\x50\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\x50\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\x50\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\x50\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\x4B\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\x50\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\x50\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\x50\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\x50\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\x50\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\x50\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\x50\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\x50\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\x50\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\x50\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\x50\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\x50\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\x50\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\x50\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\x50\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\x50\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\x50\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\x50\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\x50\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\x50\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\x50\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\x50\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\x50\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\x50\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\x50\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\x50\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\x50\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\x50\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\x50\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\x50\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\x50\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\x50\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\x50\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\x50\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\x50\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\x50\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\x50\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\x50\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\x50\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\x50\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\x51\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\x51\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\x51\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\x51\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\x51\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\x51\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\x51\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\x51\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\x51\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\x51\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\x51\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\x51\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\x51\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\x51\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\x51\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\x51\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\x51\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\x51\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\x51\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\x51\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\x51\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\x51\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\x51\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\x51\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\x51\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\x51\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\x51\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\x51\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\x51\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\x51\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\x51\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\x51\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\x51\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\x51\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\x51\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\x51\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\x51\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\x51\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\x51\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\x51\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\x51\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\x51\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\x51\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\x51\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\x51\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\x51\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\x51\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\x51\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\x51\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\x51\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\x51\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\x51\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\x51\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\x51\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\x51\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\x51\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\x51\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\x51\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\x51\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\x51\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\x51\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\x51\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\x51\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\x51\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\x51\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\x51\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\x51\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\x51\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\x51\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\x51\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\x51\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\x51\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\x51\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\x51\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\x51\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\x51\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\x51\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\x51\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\x51\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\x51\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\x51\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\x51\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\x51\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\x51\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\x51\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\x51\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\x51\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\x51\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\x51\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\x51\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\x51\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\x51\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\x51\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\x51\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\x52\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\x52\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\x52\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\x52\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\x52\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\x52\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\x52\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\x52\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\x52\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\x52\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\x52\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\x52\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\x52\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\x52\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\x52\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\x52\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\x52\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\x52\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\x52\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\x52\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\x52\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\x52\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\x52\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\x52\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\x52\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\x52\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\x52\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\x52\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\x52\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\x52\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\x52\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\x52\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\x52\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\x52\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\x52\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\x52\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\x52\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\x52\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\x52\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\x52\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\x52\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\x52\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\x52\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\x52\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\x52\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\x52\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\x52\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\x52\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\x52\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\x52\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\x52\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\x52\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\x52\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\x52\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\x52\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\x52\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\x52\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\x52\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\x52\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\x52\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\x52\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\x52\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\x52\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\x52\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\x52\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\x52\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\x52\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\x52\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\x52\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\x52\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\x52\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\x52\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\x52\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\x52\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\x52\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\x52\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\x52\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\x52\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\x52\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\x52\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\x52\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\x52\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\x52\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\x52\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\x52\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\x52\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\x52\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\x52\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\x52\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\x52\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\x52\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\x52\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\x52\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\x52\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\x53\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\x53\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\x53\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\x53\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\x53\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\x53\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\x53\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\x53\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\x53\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\x53\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\x53\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\x53\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\x53\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\x53\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\x53\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\x53\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\x53\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\x53\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\x53\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\x53\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\x53\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\x53\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\x53\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\x53\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\x53\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\x53\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\x53\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\x53\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\x53\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\x53\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\x53\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\x53\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\x53\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\x53\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\x53\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\x53\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\x53\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\x53\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\x53\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\x53\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\x53\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\x53\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\x53\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\x53\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\x53\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\x53\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\x53\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\x53\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\x53\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\x53\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\x53\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\x53\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\x53\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\x53\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\x53\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\x53\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\x53\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\x53\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\x53\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\x53\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\x53\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\x53\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\x53\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\x53\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\x53\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\x53\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\x53\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\x53\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\x53\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\x53\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\x53\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\x53\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\x53\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\x53\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\x53\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\x53\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\x53\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\x53\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\x53\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\x53\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\x53\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\x53\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\x53\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\x53\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\x53\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\x53\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\x53\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\x53\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\x53\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\x53\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\x53\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\x53\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\x53\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\x53\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\x54\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\x54\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\x54\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\x54\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\x54\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\x54\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\x54\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\x54\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\x54\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\x54\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\x54\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\x54\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\x54\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\x54\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\x54\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\x54\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\x54\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\x54\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\x54\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\x54\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\x54\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\x54\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\x54\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\x54\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\x54\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\x54\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\x54\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\x54\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\x54\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\x54\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\x54\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\x54\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\x54\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\x54\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\x54\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\x54\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\x54\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\x54\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\x54\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\x54\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\x54\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\x54\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\x54\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\x54\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\x54\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\x54\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\x54\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\x54\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\x54\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\x54\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\x54\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\x54\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\x54\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\x54\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\x54\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\x54\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\x54\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\x54\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\x54\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\x54\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\x54\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\x54\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\x54\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\x54\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\x54\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\x54\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\x54\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\x44\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\x54\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\x54\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\x54\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\x54\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\x54\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\x54\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\x54\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\x54\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\x54\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\x54\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\x54\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\x54\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\x54\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\x54\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\x54\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\x54\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\x54\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\x54\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\x54\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\x54\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\x54\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\x54\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\x54\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\x54\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\x54\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\x54\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\x55\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\x55\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\x55\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\x55\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\x55\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\x55\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\x55\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\x55\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\x55\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\x55\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\x55\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\x55\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\x55\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\x55\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\x55\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\x55\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\x55\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\x55\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\x55\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\x55\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\x55\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\x55\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\x55\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\x55\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\x55\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\x55\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\x55\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\x55\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\x55\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\x55\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\x55\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\x55\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\x55\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\x55\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\x55\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\x55\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\x55\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\x55\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\x55\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\x55\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\x55\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\x55\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\x55\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\x55\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\x55\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\x55\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\x55\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\x55\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\x55\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\x55\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\x55\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\x55\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\x55\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\x55\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\x55\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\x55\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\x55\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\x55\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\x55\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\x55\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\x55\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\x55\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\x55\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\x55\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\x55\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\x55\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\x55\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\x55\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\x55\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\x55\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\x55\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\x55\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\x55\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\x55\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\x55\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\x55\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\x55\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\x55\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\x55\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\x55\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\x55\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\x55\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\x55\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\x55\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\x55\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\x55\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\x55\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\x55\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\x55\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\x55\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\x55\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\x55\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\x55\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\x55\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\x56\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\x56\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\x56\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\x56\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\x56\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\x56\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\x56\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\x56\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\x56\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\x56\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\x56\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\x56\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\x56\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\x56\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\x56\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\x56\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\x56\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\x56\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\x56\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\x56\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\x56\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\x56\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\x56\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\x56\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\x56\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\x56\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\x56\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\x56\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\x56\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\x56\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\x56\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\x56\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\x56\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\x56\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\x56\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\x56\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\x56\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\x56\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\x56\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\x56\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\x56\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\x56\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\x56\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\x56\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\x56\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\x56\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\x56\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\x56\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\x56\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\x56\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\x56\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\x56\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\x56\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\x56\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\x56\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\x56\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\x56\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\x56\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\x56\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\x56\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\x56\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\x56\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\x56\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\x56\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\x56\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\x56\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\x56\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\x56\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\x56\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\x56\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\x56\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\x56\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\x56\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\x56\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\x56\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\x56\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\x56\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\x56\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\x56\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\x56\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\x56\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\x56\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\x56\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\x56\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\x56\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\x56\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\x56\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\x56\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\x56\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\x56\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\x56\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\x56\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\x56\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\x56\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\x57\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\x57\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\x57\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\x57\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\x57\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\x57\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\x57\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\x57\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\x57\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\x57\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\x57\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\x57\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\x57\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\x57\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\x57\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\x57\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\x57\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\x57\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\x57\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\x57\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\x57\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\x57\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\x57\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\x57\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\x57\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\x57\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\x57\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\x57\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\x57\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\x57\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\x57\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\x57\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\x57\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\x57\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\x57\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\x57\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\x57\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\x57\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\x57\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\x57\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\x57\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\x57\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\x57\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\x57\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\x57\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\x57\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\x57\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\x57\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\x57\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\x57\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\x57\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\x57\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\x57\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\x57\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\x57\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\x57\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\x57\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\x57\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\x57\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\x57\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\x57\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\x57\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\x57\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\x57\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\x57\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\x57\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\x57\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\x57\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\x57\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\x57\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\x57\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\x57\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\x57\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\x57\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\x57\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\x57\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\x57\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\x57\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\x57\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\x57\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\x57\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\x57\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\x57\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\x57\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\x57\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\x57\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\x57\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\x57\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\x57\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\x57\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\x57\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\x57\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\x57\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\x58\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\x58\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\x58\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\x58\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\x58\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\x58\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\x58\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\x58\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\x58\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\x58\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\x58\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\x58\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\x58\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\x58\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\x58\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\x58\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\x58\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\x58\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\x58\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\x58\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\x58\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\x58\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\x58\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\x58\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\x58\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\x58\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\x58\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\x58\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\x58\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\x58\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\x58\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\x58\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\x58\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\x58\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\x58\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\x58\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\x58\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\x58\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\x58\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\x58\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\x58\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\x58\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\x58\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\x58\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\x58\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\x58\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\x58\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\x58\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\x58\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\x58\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\x58\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\x58\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\x58\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\x58\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\x58\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\x58\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\x58\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\x58\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\x58\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\x58\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\x58\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\x58\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\x58\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\x58\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\x58\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\x58\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\x58\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\x58\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\x58\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\x58\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\x58\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\x58\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\x58\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\x58\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\x58\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\x58\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\x58\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\x58\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\x58\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\x58\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\x58\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\x58\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\x58\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\x58\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\x58\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\x58\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\x58\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\x58\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\x58\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\x58\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\x58\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\x58\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\x58\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\x58\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\x59\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\x59\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\x59\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\x59\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\x59\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\x59\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\x59\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\x59\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\x59\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\x59\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\x59\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\x59\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\x59\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\x59\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\x59\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\x59\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\x59\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\x59\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\x59\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\x59\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\x59\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\x59\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\x59\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\x59\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\x59\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\x59\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\x59\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\x59\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\x59\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\x59\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\x59\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\x59\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\x59\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\x59\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\x59\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\x59\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\x59\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\x59\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\x59\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\x59\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\x59\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\x59\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\x59\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\x59\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\x59\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\x59\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\x59\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\x59\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\x59\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\x59\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\x59\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\x59\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\x59\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\x59\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\x59\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\x59\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\x59\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\x59\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\x59\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\x59\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\x59\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\x59\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\x59\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\x59\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\x59\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\x59\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\x59\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\x59\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\x59\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\x59\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\x59\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\x59\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\x59\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\x59\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\x59\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\x59\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\x59\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\x59\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\x59\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\x59\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\x59\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\x59\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\x59\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\x59\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\x59\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\x59\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\x59\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\x33\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\x59\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\x59\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\x59\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\x59\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\x59\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\x59\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\x5A\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\x5A\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\x5A\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\x5A\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\x5A\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\x5A\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\x5A\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\x5A\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\x5A\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\x5A\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\x5A\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\x5A\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\x5A\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\x5A\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\x5A\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\x5A\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\x5A\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\x5A\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\x5A\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\x5A\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\x5A\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\x5A\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\x5A\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\x5A\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\x5A\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\x5A\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\x5A\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\x5A\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\x5A\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\x5A\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\x5A\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\x5A\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\x5A\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\x5A\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\x5A\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\x5A\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\x5A\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\x5A\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\x5A\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\x5A\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\x5A\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\x5A\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\x5A\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\x5A\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\x5A\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\x5A\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\x5A\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\x5A\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\x5A\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\x5A\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\x5A\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\x5A\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\x5A\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\x5A\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\x5A\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\x5A\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\x5A\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\x5A\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\x5A\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\x5A\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\x5A\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\x5A\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\x5A\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\x5A\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\x5A\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\x5A\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\x5A\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\x5A\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\x5A\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\x5A\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\x5A\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\x5A\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\x5A\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\x5A\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\x5A\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\x5A\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\x5A\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\x5A\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\x5A\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\x5A\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\x5A\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\x5A\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\x5A\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\x5A\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\x5A\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\x5A\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\x5A\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\x5A\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\x5A\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\x5A\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\x5A\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\x5A\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\x5A\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\x5A\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\x5B\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\x5B\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\x5B\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\x5B\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\x5B\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\x5B\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\x5B\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\x5B\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\x5B\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\x5B\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\x5B\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\x5B\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\x5B\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\x5B\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\x5B\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\x5B\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\x5B\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\x5B\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\x5B\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\x5B\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\x5B\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\x5B\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\x5B\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\x5B\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\x5B\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\x5B\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\x5B\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\x5B\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\x5B\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\x5B\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\x5B\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\x5B\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\x5B\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\x5B\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\x5B\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\x5B\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\x5B\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\x5B\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\x5B\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\x5B\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\x5B\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\x5B\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\x5B\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\x5B\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\x5B\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\x5B\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\x5B\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\x5B\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\x5B\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\x5B\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\x5B\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\x5B\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\x5B\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\x5B\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\x5B\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\x49\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\x5B\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\x5B\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\x5B\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\x5B\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\x5B\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\x5B\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\x5B\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\x5B\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\x5B\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\x5B\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\x5B\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\x5B\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\x5B\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\x5B\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\x5B\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\x5B\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\x5B\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\x5B\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\x5B\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\x5B\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\x45\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\x5B\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\x5B\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\x5B\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\x5B\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\x5B\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\x5B\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\x5B\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\x5B\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\x5B\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\x5B\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\x5B\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\x5B\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\x5B\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\x5B\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\x5B\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\x5B\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\x5B\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\x5C\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\x5C\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\x5C\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\x5C\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\x5C\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\x5C\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\x5C\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\x5C\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\x5C\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\x5C\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\x5C\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\x5C\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\x5C\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\x5C\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\x5C\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\x5C\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\x5C\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\x5C\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\x5C\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\x5C\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\x5C\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\x5C\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\x5C\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\x5C\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\x5C\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\x5C\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\x5C\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\x5C\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\x5C\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\x5C\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\x5C\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\x5C\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\x5C\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\x5C\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\x5C\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\x5C\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\x5C\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\x5C\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\x5C\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\x5C\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\x5C\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\x5C\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\x5C\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\x5C\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\x5C\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\x5C\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\x5C\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\x5C\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\x5C\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\x5C\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\x5C\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\x5C\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\x5C\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\x5C\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\x5C\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\x5C\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\x5C\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\x5C\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\x5C\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\x5C\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\x5C\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\x5C\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\x5C\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\x5C\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\x5C\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\x5C\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\x5C\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\x5C\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\x5C\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\x5C\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\x5C\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\x5C\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\x5C\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\x5C\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\x5C\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\x5C\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\x5C\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\x5C\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\x5C\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\x5C\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\x5C\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\x5C\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\x5C\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\x5C\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\x5C\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\x5C\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\x5C\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\x5C\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\x5C\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\x5C\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\x5C\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\x5C\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\x5C\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\x5C\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\x5D\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\x5D\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\x5D\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\x5D\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\x5D\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\x5D\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\x5D\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\x5D\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\x5D\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\x5D\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\x5D\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\x5D\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\x5D\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\x5D\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\x5D\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\x5D\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\x5D\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\x5D\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\x5D\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\x5D\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\x5D\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\x5D\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\x5D\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\x5D\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\x5D\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\x5D\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\x5D\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\x5D\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\x5D\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\x5D\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\x5D\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\x5D\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\x5D\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\x5D\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\x5D\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\x5D\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\x5D\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\x5D\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\x5D\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\x5D\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\x5D\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\x5D\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\x5D\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\x5D\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\x5D\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\x5D\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\x5D\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\x5D\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\x5D\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\x5D\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\x5D\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\x5D\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\x5D\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\x5D\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\x5D\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\x5D\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\x5D\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\x5D\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\x5D\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\x5D\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\x5D\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\x5D\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\x5D\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\x5D\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\x5D\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\x5D\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\x5D\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\x5D\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\x5D\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\x5D\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\x5D\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\x5D\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\x5D\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\x5D\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\x5D\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\x5D\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\x5D\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\x5D\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\x5D\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\x5D\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\x5D\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\x5D\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\x5D\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\x5D\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\x5D\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\x5D\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\x5D\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\x5D\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\x5D\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\x5D\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\x5D\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\x5D\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\x5D\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\x5D\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\x5E\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\x5E\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\x5E\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\x5E\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\x5E\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\x5E\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\x5E\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\x5E\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\x5E\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\x5E\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\x5E\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\x5E\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\x5E\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\x5E\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\x5E\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\x5E\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\x5E\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\x5E\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\x5E\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\x5E\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\x5E\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\x5E\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\x5E\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\x5E\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\x45\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\x5E\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\x5E\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\x5E\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\x5E\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\x5E\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\x5E\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\x5E\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\x5E\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\x5E\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\x5E\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\x5E\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\x5E\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\x5E\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\x5E\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\x5E\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\x5E\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\x5E\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\x5E\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\x5E\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\x5E\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\x5E\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\x5E\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\x5E\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\x5E\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\x5E\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\x5E\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\x5E\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\x5E\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\x5E\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\x5E\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\x5E\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\x5E\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\x5E\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\x5E\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\x5E\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\x5E\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\x5E\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\x5E\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\x5E\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\x5E\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\x5E\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\x5E\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\x5E\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\x5E\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\x5E\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\x5E\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\x5E\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\x5E\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\x5E\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\x5E\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\x5E\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\x5E\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\x5E\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\x5E\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\x5E\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\x5E\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\x5E\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\x5E\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\x5E\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\x34\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\x5E\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\x5E\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\x5E\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\x5E\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\x5E\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\x5E\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\x5E\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\x5E\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\x5E\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\x5F\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\x5F\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\x5F\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\x5F\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\x5F\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\x5F\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\x5F\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\x5F\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\x5F\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\x5F\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\x5F\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\x5F\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\x5F\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\x5F\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\x5F\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\x5F\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\x5F\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\x5F\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\x5F\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\x5F\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\x5F\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\x5F\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\x5F\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\x5F\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\x5F\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\x5F\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\x5F\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\x5F\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\x5F\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\x5F\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\x5F\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\x5F\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\x5F\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\x5F\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\x5F\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\x5F\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\x5F\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\x5F\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\x5F\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\x5F\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\x5F\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\x5F\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\x5F\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\x5F\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\x5F\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\x5F\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\x5F\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\x5F\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\x5F\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\x5F\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\x5F\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\x5F\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\x5F\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\x5F\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\x5F\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\x5F\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\x5F\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\x5F\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\x5F\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\x5F\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\x5F\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\x5F\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\x5F\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\x5F\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\x5F\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\x5F\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\x5F\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\x5F\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\x5F\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\x5F\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\x5F\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\x5F\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\x5F\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\x5F\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\x5F\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\x5F\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\x5F\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\x5F\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\x5F\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\x5F\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\x5F\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\x5F\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\x5F\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\x5F\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\x5F\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\x5F\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\x5F\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\x5F\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\x5F\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\x5F\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\x5F\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\x5F\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\x5F\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\x5F\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\x60\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\x60\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\x60\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\x60\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\x60\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\x60\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\x60\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\x60\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\x60\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\x60\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\x60\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\x60\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\x60\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\x60\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\x60\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\x60\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\x60\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\x60\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\x60\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\x60\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\x60\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\x60\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\x60\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\x60\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\x60\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\x60\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\x60\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\x60\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\x60\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\x60\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\x60\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\x60\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\x60\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\x60\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\x60\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\x60\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\x60\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\x60\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\x60\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\x60\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\x60\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\x60\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\x60\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\x60\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\x60\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\x60\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\x60\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\x60\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\x60\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\x60\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\x60\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\x60\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\x60\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\x60\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\x60\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\x60\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\x60\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\x60\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\x60\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\x60\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\x60\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\x60\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\x60\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\x60\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\x60\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\x60\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\x60\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\x60\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\x60\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\x60\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\x60\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\x60\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\x60\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\x60\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\x60\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\x60\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\x60\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\x60\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\x60\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\x60\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\x60\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\x60\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\x60\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\x60\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\x60\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xC4\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\x60\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\x60\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\x60\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\x60\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\x60\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\x60\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\x60\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\x60\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\x61\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\x61\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\x61\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\x61\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\x61\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\x61\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\x61\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\x61\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\x61\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\x61\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\x61\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\x61\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\x61\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\x61\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\x61\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\x61\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\x61\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\x61\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\x61\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\x61\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\x61\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\x61\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\x61\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\x61\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\x61\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\x61\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\x61\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\x61\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\x61\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\x61\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\x61\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\x61\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\x61\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\x61\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\x61\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\x61\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\x61\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\x61\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\x61\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\x61\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\x61\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\x61\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\x61\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\x61\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\x61\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\x61\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\x61\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\x61\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\x61\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\x61\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\x61\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\x61\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\x61\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\x61\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\x61\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\x61\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\x61\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\x61\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\x61\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\x61\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\x61\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\x61\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\x61\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\x61\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\x61\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\x61\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\x61\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\x61\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\x61\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\x61\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\x61\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\x61\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\x61\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\x61\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\x61\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\x61\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\x61\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\x61\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\x61\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\x61\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\x61\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\x61\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\x61\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\x61\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\x61\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\x61\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\x61\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\x61\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\x61\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\x61\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\x61\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\x61\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\x61\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\x61\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\x62\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\x62\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\x62\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\x62\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\x62\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\x62\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\x62\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\x62\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\x62\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\x62\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\x62\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\x62\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\x62\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\x62\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\x62\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\x62\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\x62\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\x62\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\x62\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\x62\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\x62\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\x62\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\x62\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\x62\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\x62\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\x62\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\x62\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\x62\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\x62\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\x62\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\x62\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\x62\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\x62\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\x62\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\x62\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\x62\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\x62\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\x62\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\x62\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\x62\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\x62\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\x62\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\x62\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\x62\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\x62\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\x62\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\x62\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\x62\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\x62\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\x62\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\x62\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\x62\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\x62\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\x62\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\x62\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\x62\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\x62\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\x62\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\x62\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\x62\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\x62\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\x62\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\x62\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\x62\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\x62\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\x62\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\x62\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\x62\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\x62\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\x62\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\x62\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\x39\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\x62\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\x45\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\x62\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\x62\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\x62\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\x62\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\x62\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\x62\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\x62\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\x62\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\x62\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\x62\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\x62\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\x62\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\x62\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\x62\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\x62\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\x62\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\x62\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\x62\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\x62\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\x62\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\x63\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\x63\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\x63\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\x63\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\x63\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\x63\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\x63\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\x63\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\x63\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\x63\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\x63\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\x63\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\x63\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\x63\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\x63\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\x63\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\x63\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\x63\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\x63\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\x63\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\x63\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\x63\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\x63\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\x63\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\x63\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\x63\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\x63\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\x63\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\x63\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\x63\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\x63\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\x63\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\x63\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\x63\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\x63\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\x63\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\x63\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\x63\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\x63\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\x63\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\x63\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\x63\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\x63\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\x63\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\x63\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\x63\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\x63\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\x63\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\x63\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\x63\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\x63\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\x63\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\x63\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\x63\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\x63\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\x63\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\x63\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\x63\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\x63\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\x63\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\x63\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\x33\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\x63\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\x63\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\x63\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\x63\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\x63\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\x63\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\x63\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\x63\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\x63\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\x63\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\x63\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\x63\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\x63\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\x63\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\x63\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\x63\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\x63\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\x63\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\x63\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\x63\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\x63\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\x63\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\x63\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\x63\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\x63\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\x63\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\x63\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\x63\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\x63\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\x63\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\x63\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\x63\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\x64\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\x64\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\x64\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\x64\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\x64\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\x64\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\x64\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\x64\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\x64\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\x64\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\x64\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\x64\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\x64\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\x64\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\x64\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\x64\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\x64\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\x64\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\x64\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\x64\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\x64\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\x64\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\x64\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\x64\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\x64\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\x64\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\x64\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\x64\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\x64\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\x64\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\x64\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\x64\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\x64\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\x64\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\x64\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\x64\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\x64\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\x4F\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\x64\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\x64\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\x64\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\x64\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\x64\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\x64\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\x64\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\x64\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\x64\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\x64\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\x64\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\x64\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\x64\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\x64\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\x64\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\x64\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\x64\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\x64\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\x64\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\x64\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\x64\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\x64\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\x64\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\x64\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\x64\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\x64\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\x64\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\x64\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\x64\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\x64\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\x64\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\x64\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\x64\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\x64\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\x64\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\x64\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\x64\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\x64\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\x64\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\x64\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\x64\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\x64\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\x64\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\x64\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\x64\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\x64\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\x64\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\x64\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\x64\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\x64\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\x64\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\x64\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\x64\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\x64\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\x64\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\x64\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\x65\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\x65\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\x65\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\x65\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\x65\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\x65\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\x65\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\x65\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\x65\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\x65\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\x65\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\x65\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\x65\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\x65\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\x65\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\x65\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\x65\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\x65\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\x65\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\x65\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\x65\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\x65\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\x65\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\x65\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\x65\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\x65\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\x65\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\x65\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\x65\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\x65\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\x65\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\x65\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\x65\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\x65\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\x65\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\x65\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\x65\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\x65\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\x65\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\x65\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\x65\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\x65\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\x65\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\x65\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\x65\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\x65\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\x65\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\x65\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\x65\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\x65\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\x65\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\x65\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\x65\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\x65\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\x65\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\x65\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\x65\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\x65\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\x65\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\x65\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\x65\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\x65\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\x65\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\x65\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\x65\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\x65\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\x65\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\x65\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\x65\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\x65\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\x65\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\x65\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\x65\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\x65\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\x65\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\x65\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\x65\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\x65\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\x65\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\x65\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\x65\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\x65\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\x65\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\x65\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\x65\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\x65\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\x65\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\x65\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\x65\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\x65\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\x65\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\x65\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\x65\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\x65\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\x66\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\x66\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\x66\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\x66\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\x66\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\x66\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\x66\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\x66\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\x66\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\x66\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\x66\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\x66\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\x66\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\x66\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\x66\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\x66\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\x66\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\x66\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\x66\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\x66\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\x66\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\x66\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\x66\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\x66\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\x66\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\x66\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\x66\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\x66\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\x66\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\x66\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\x66\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\x66\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\x66\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\x66\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\x66\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\x66\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\x66\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\x66\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\x66\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\x66\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\x66\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\x66\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\x66\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\x66\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\x66\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\x66\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\x66\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\x66\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\x66\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\x66\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\x66\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\x66\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\x66\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\x66\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\x66\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\x66\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\x66\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\x66\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\x66\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\x66\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\x66\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\x66\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\x66\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\x66\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\x66\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\x66\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\x66\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\x66\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\x66\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\x66\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\x66\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\x66\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\x66\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\x66\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\x66\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\x66\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\x66\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\x66\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\x66\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\x66\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\x66\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\x66\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\x66\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\x66\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\x66\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\x66\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\x66\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\x66\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\x66\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\x66\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\x66\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\x66\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\x66\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\x66\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\x67\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\x67\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\x67\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\x67\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\x67\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\x67\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\x67\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\x67\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\x67\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\x67\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\x67\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\x67\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\x67\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\x67\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\x67\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\x67\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\x67\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\x67\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\x67\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\x67\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\x67\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\x67\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\x67\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\x67\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\x67\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\x67\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\x67\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\x67\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\x67\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\x67\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\x67\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\x67\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\x67\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\x67\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\x67\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\x67\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\x67\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\x67\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\x67\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\x67\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\x67\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\x67\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\x67\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\x67\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\x67\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\x67\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\x67\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\x67\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\x67\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\x67\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\x67\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\x67\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\x67\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\x67\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\x67\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\x67\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\x67\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\x67\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\x67\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\x67\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\x67\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\x67\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\x67\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\x67\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\x67\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\x67\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\x67\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\x67\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\x67\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\x67\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\x67\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\x67\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\x67\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\x67\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\x67\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\x67\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\x67\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\x67\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\x67\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\x67\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\x67\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\x67\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\x67\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\x67\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\x67\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\x67\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\x67\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\x67\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\x67\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\x67\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\x67\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\x67\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\x67\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\x67\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\x68\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\x68\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\x68\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\x68\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\x68\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\x68\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\x68\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\x68\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\x68\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\x68\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\x68\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\x68\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\x68\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\x68\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\x68\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\x68\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\x68\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\x68\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\x68\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\x68\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\x68\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\x68\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\x68\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\x68\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\x68\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\x68\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\x68\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\x68\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\x68\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\x68\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\x68\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\x68\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\x68\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\x68\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\x68\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\x68\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\x68\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\x68\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\x68\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\x68\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\x68\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\x68\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\x68\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\x68\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\x68\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\x68\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\x68\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\x68\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\x68\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\x68\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\x68\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\x68\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\x68\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\x68\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\x68\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\x68\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\x68\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\x68\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\x68\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\x68\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\x68\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\x68\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\x68\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\x68\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\x68\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\x68\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\x68\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\x68\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\x68\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\x68\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\x68\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\x68\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\x68\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\x68\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\x68\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\x68\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\x68\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\x68\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\x68\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\x68\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\x68\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\x68\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\x68\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\x68\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\x68\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\x68\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\x68\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\x68\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\x68\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\x68\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\x68\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\x68\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\x68\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\x68\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\x69\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\x3C\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\x69\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\x69\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\x69\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\x69\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\x69\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\x69\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\x69\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\x69\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\x69\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\x69\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\x69\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\x4C\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\x69\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\x69\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\x69\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\x69\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\x69\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\x69\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\x69\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\x69\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\x69\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\x69\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\x69\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\x69\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\x69\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\x69\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\x69\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\x69\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\x69\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\x69\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\x69\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\x69\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\x69\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\x69\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\x69\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\x69\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\x69\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\x69\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\x69\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\x69\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\x69\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\x69\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\x69\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\x69\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\x69\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\x69\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\x69\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\x69\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\x69\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\x69\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\x69\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\x69\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\x69\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\x69\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\x69\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\x33\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\x69\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\x69\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\x69\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\x69\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\x69\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\x69\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\x69\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\x69\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\x69\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\x69\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\x69\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\x69\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\x69\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\x69\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\x69\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\x69\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\x69\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\x69\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\x69\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\x69\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\x69\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\x69\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\x69\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\x69\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\x69\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\x69\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\x69\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\x69\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\x69\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\x69\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\x69\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\x69\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\x69\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\x69\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\x69\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\x69\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\x6A\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\x6A\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\x6A\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\x47\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\x6A\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\x6A\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\x6A\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\x6A\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\x6A\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\x6A\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\x6A\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\x6A\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\x6A\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\x6A\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\x6A\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\x6A\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\x6A\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\x6A\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\x6A\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\x6A\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\x6A\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\x6A\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\x6A\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\x6A\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\x6A\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\x6A\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\x6A\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\x6A\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\x6A\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\x6A\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\x6A\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\x6A\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\x6A\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\x6A\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\x6A\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\x6A\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\x6A\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\x6A\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\x6A\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\x6A\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\x6A\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\x6A\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\x6A\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\x6A\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\x6A\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\x6A\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\x6A\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\x6A\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\x6A\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\x6A\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\x6A\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\x6A\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\x6A\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\x6A\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\x6A\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\x6A\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\x6A\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\x6A\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\x6A\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\x6A\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\x6A\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\x6A\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\x6A\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\x6A\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\x6A\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\x6A\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\x6A\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\x6A\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\x6A\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\x6A\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\x6A\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\x6A\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\x6A\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\x6A\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\x6A\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\x6A\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\x6A\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\x6A\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\x6A\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\x6A\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\x6A\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\x6A\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\x6A\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\x6A\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\x6A\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\x6A\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\x6A\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\x6A\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\x6A\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\x6A\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\x6A\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\x6A\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\x6A\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\x6A\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\x6B\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\x6B\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\x6B\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\x6B\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\x6B\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\x6B\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\x6B\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\x6B\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\x6B\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\x6B\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\x6B\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\x6B\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\x6B\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\x6B\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\x6B\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\x6B\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\x6B\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\x6B\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\x6B\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\x6B\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\x6B\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\x6B\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\x6B\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\x6B\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\x6B\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\x6B\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\x6B\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\x6B\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\x6B\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\x6B\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\x6B\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\x6B\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\x6B\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\x6B\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\x6B\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\x6B\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\x6B\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\x6B\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\x6B\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\x6B\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\x6B\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\x6B\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\x6B\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\x6B\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\x6B\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\x6B\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\x6B\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\x6B\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\x6B\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\x6B\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\x6B\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\x6B\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\x6B\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\x6B\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\x6B\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\x6B\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\x6B\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\x6B\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\x6B\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\x6B\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\x34\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\x6B\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\x6B\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\x6B\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\x6B\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\x6B\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\x6B\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\x6B\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\x6B\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\x6B\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\x6B\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\x6B\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\x6B\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\x6B\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\x6B\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\x6B\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\x6B\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\x6B\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\x6B\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\x6B\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\x6B\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\x6B\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\x6B\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\x6B\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\x6B\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\x6B\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\x6B\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\x6B\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\x6B\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\x6B\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\x6B\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\x6B\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\x6B\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\x6B\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\x6C\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\x6C\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\x6C\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\x6C\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\x6C\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\x6C\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\x6C\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\x6C\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\x6C\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\x6C\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\x6C\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\x6C\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\x6C\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\x6C\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\x6C\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\x6C\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\x6C\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\x6C\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\x6C\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\x6C\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\x6C\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\x6C\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\x6C\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\x6C\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\x6C\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\x6C\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\x6C\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\x6C\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\x6C\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\x6C\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\x6C\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\x6C\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\x6C\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\x6C\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\x6C\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\x6C\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\x6C\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\x6C\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\x6C\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\x6C\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\x6C\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\x6C\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\x6C\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\x6C\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\x41\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\x6C\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\x6C\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\x6C\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\x6C\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\x6C\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\x6C\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\x6C\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\x6C\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\x6C\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\x6C\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\x6C\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\x6C\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\x6C\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\x6C\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\x6C\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\x6C\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\x6C\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\x6C\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\x6C\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\x6C\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\x6C\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\x6C\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\x6C\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\x6C\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\x6C\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\x6C\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\x6C\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\x6C\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\x6C\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\x6C\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\x6C\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\x6C\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\x6C\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\x6C\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\x6C\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\x6C\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\x6C\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\x6C\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\x6C\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\x6C\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\x6C\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\x6C\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\x6C\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\x6C\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\x6C\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\x6C\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\x6C\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\x6C\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\x6C\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\x6D\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\x6D\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\x6D\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\x6D\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\x6D\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\x6D\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\x6D\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\x6D\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\x6D\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\x6D\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\x6D\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\x6D\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\x6D\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\x6D\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\x6D\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\x6D\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\x6D\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\x6D\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\x6D\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\x6D\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\x6D\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\x6D\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\x6D\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\x6D\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\x6D\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\x6D\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\x6D\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\x6D\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\x6D\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\x6D\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\x6D\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\x6D\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\x6D\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\x6D\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\x6D\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\x6D\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\x6D\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\x6D\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\x6D\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\x6D\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\x6D\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\x6D\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\x6D\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\x6D\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\x6D\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\x6D\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\x6D\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\x6D\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\x6D\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\x6D\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\x6D\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\x6D\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\x6D\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\x6D\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\x6D\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\x6D\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\x6D\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\x6D\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\x6D\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\x6D\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\x6D\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\x6D\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\x6D\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\x6D\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\x6D\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\x6D\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\x6D\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\x6D\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\x6D\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\x6D\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\x6D\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\x6D\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\x6D\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\x6D\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\x6D\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\x6D\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\x6D\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\x46\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\x6D\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\x6D\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\x6D\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\x6D\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\x6D\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\x6D\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\x6D\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\x6D\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\x6D\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\x6D\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\x6D\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\x6D\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\x6D\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\x6D\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\x6D\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],
        ["\x6D\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],
        ["\x6E\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\x6E\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\x6E\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\x6E\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\x6E\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\x6E\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\x6E\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\x6E\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\x6E\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\x6E\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\x6E\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\x6E\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\x6E\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\x6E\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\x6E\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\x6E\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\x6E\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\x6E\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\x6E\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\x6E\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\x6E\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\x6E\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\x6E\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\x6E\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\x6E\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\x6E\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\x6E\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\x6E\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\x6E\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\x6E\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\x6E\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\x6E\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\x6E\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\x6E\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\x6E\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\x6E\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\x6E\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\x6E\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\x6E\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\x6E\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\x6E\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\x6E\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\x6E\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\x6E\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\x6E\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\x6E\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\x6E\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\x6E\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\x6E\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\x6E\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\x6E\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\x6E\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\x6E\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\x6E\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\x6E\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\x6E\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\x6E\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\x6E\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\x6E\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\x6E\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\x6E\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\x6E\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\x6E\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\x6E\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\x6E\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\x6E\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\x6E\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\x6E\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\x6E\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\x6E\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\x6E\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\x6E\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\x6E\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\x6E\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\x6E\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\x6E\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\x6E\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\x6E\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\x6E\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\x6E\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\x6E\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\x6E\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\x6E\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\x6E\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\x6E\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\x6E\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\x6E\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\x6E\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\x6E\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\x6E\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\x6E\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\x6E\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\x6E\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],
        ["\x6E\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],
        ["\x6F\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\x6F\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\x6F\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\x6F\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\x6F\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\x6F\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\x6F\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\x6F\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\x6F\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\x6F\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\x6F\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\x6F\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\x6F\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\x6F\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\x6F\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\x6F\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\x6F\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\x6F\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\x6F\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\x6F\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\x6F\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\x6F\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\x6F\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\x6F\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\x6F\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\x6F\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\x6F\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\x6F\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\x6F\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\x6F\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\x6F\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\x6F\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\x6F\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\x6F\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\x6F\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\x6F\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\x6F\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\x6F\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\x6F\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\x6F\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\x6F\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\x6F\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\x6F\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\x6F\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\x6F\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\x6F\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\x6F\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\x6F\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\x6F\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\x6F\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\x6F\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\x6F\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\x6F\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\x6F\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\x6F\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\x6F\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\x6F\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\x6F\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\x6F\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\x6F\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\x6F\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\x6F\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\x6F\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\x6F\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\x6F\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\x6F\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\x6F\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\x6F\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\x6F\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\x6F\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\x6F\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\x6F\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\x6F\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\x6F\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\x6F\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\x6F\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\x6F\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\x6F\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\x6F\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\x6F\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\x6F\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\x6F\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\x6F\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\x6F\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\x6F\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\x6F\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\x6F\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\x6F\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\x6F\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\x6F\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\x6F\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\x6F\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\x6F\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],
        ["\x6F\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],
        ["\x70\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\x70\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\x70\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\x70\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\x70\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\x70\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\x70\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\x70\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\x70\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\x70\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\x70\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\x70\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\x70\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\x70\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\x70\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\x70\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\x70\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\x70\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\x70\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\x70\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\x70\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\x70\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\x70\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\x70\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\x70\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\x70\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\x70\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\x70\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\x70\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\x70\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\x70\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\x70\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\x70\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\x70\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\x70\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\x70\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\x70\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\x70\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\x70\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\x70\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\x70\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\x70\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\x70\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\x70\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\x70\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\x70\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\x70\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\x70\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\x70\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\x70\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\x70\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\x70\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\x70\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\x70\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\x3F\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\x70\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\x70\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\x70\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\x70\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\x70\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\x70\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\x70\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\x70\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\x70\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\x70\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\x70\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\x70\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\x70\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\x70\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\x70\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\x70\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\x70\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\x70\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\x70\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\x70\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\x70\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\x70\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\x70\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\x70\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\x70\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\x70\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\x70\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\x70\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\x37\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\x70\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\x70\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\x70\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\x70\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\x70\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\x70\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\x70\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\x70\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\x70\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],
        ["\x70\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],
        ["\x71\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\x71\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\x71\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\x71\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\x71\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\x71\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\x71\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\x71\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\x71\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\x71\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\x71\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\x71\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\x71\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\x71\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\x71\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\x71\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\x71\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\x71\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\x71\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\x71\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\x71\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\x71\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\x71\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\x71\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\x71\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\x71\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\x71\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\x71\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\x71\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\x71\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\x71\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\x71\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\x71\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\x71\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\x71\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\x71\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\x71\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\x71\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\x71\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\x71\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\x71\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\x71\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\x71\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\x71\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\x71\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\x71\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\x71\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\x71\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\x71\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\x71\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\x71\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\x71\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\x71\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\x71\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\x71\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\x71\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\x71\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\x71\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\x71\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\x71\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\x71\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\x71\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\x71\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\x71\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\x71\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\x71\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\x71\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\x71\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\x71\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\x71\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\x71\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\x71\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\x71\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\x71\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\x71\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\x71\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\x71\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\x71\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\x71\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\x71\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\x71\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\x71\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\x71\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\x71\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\x71\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\x71\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\x71\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\x71\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\x71\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\x71\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\x71\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\x71\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\x71\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],
        ["\x71\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],
        ["\x72\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\x72\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\x72\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\x72\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\x72\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\x72\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\x72\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\x72\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\x72\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\x72\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\x72\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\x72\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\x72\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\x72\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\x72\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\x72\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\x72\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\x72\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\x72\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\x72\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\x72\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\x72\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\x72\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\x72\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\x72\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\x72\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\x72\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\x72\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\x72\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\x72\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\x72\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\x72\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\x72\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\x72\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\x72\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\x72\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\x72\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\x72\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\x72\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\x72\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\x72\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\x72\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\x72\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\x72\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\x30\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\x72\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\x72\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\x72\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\x72\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\x72\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\x72\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\x72\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\x72\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\x72\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\x72\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\x72\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\x72\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\x72\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\x72\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\x72\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\x72\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\x72\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\x72\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\x72\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\x72\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\x72\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\x72\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\x72\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\x72\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\x72\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\x72\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\x72\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\x72\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\x72\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\x72\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\x72\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\x72\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\x72\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\x72\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\x72\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\x72\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\x72\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\x72\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\x32\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\x72\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\x72\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\x72\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\x72\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\x72\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\x72\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\x72\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\x72\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\x72\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],
        ["\x72\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],
        ["\x73\x21",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\x73\x22",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\x73\x23",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\x73\x24",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\x73\x25",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\x73\x26",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\x73\x27",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\x73\x28",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\x73\x29",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\x73\x2A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\x73\x2B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\x73\x2C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\x73\x2D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\x73\x2E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\x73\x2F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\x73\x30",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\x73\x31",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\x73\x32",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\x73\x33",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\x73\x34",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\x73\x35",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\x73\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\x73\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\x73\x38",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\x73\x39",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\x73\x3A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\x73\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\x73\x3C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\x73\x3D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\x73\x3E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\x73\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\x73\x40",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\x73\x41",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\x73\x42",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\x73\x43",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\x73\x44",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\x73\x45",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\x73\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\x73\x47",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\x73\x48",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\x73\x49",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\x73\x4A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\x73\x4B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\x73\x4C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\x73\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\x73\x4E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\x73\x4F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\x73\x50",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\x73\x51",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\x73\x52",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\x73\x53",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\x73\x54",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\x73\x55",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\x73\x56",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\x73\x57",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\x73\x58",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\x73\x59",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\x73\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\x73\x5B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\x73\x5C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\x73\x5D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\x73\x5E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\x73\x5F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\x73\x60",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\x73\x61",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\x73\x62",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\x73\x63",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\x73\x64",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\x73\x65",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\x73\x66",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\x73\x67",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\x73\x68",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\x73\x69",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\x73\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\x73\x6B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\x73\x6C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\x73\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\x73\x6E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\x73\x6F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\x73\x70",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\x73\x71",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\x73\x72",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\x73\x73",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\x73\x74",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\x73\x75",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\x73\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\x73\x77",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\x73\x78",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\x73\x79",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\x73\x7A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\x73\x7B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\x73\x7C",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\x73\x7D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],
        ["\x73\x7E",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],
        ["\x36\x46",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\x4B\x6A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],
        ["\x4D\x5A",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],
        ["\x60\x76",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],
        ["\xB4\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"],
        ["\xA2\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC1"],
        ["\xA2\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC2"],
        ["\xA2\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC3"],
        ["\xA2\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC4"],
        ["\xA2\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC5"],
        ["\xA2\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC6"],
        ["\xA2\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC7"],
        ["\xA2\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC8"],
        ["\xA2\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC9"],
        ["\xA2\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xCA"],
        ["\xA5\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xFE"],
        ["\xCE\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"],
        ["\xD2\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC7"],
        ["\xD1\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xA3"],
        ["\xCC\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xAE"],
        ["\xB2\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\xC2\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"],
        ["\xBD\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\xBF\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"],
        ["\xD2\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xBB"],
        ["\xBD\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\xBA\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\xB2\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"],
        ["\xB2\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\xB2\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\xB2\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\xB2\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\xB2\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"],
        ["\xB2\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xCB"],
        ["\xB2\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\xB2\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\xBA\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\xB2\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\xB2\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\xB3\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\xB3\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\xB3\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\xB3\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\xB3\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\xB3\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\xB3\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\xB3\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\xB3\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"],
        ["\xB3\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\xB3\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"],
        ["\xB3\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\xB3\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\xB4\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\xD4\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC3"],
        ["\xB4\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\xB4\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\xB4\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\xB4\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\xB4\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],
        ["\xB4\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\xB4\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],
        ["\xB4\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xAF"],
        ["\xB5\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"],
        ["\xB5\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\xB5\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\xB5\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\xB5\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\xB5\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\xB5\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"],
        ["\xB5\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\xB5\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],
        ["\xB5\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"],
        ["\xB6\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\xB6\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"],
        ["\xB6\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xB9"],
        ["\xB6\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\xB6\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\xB6\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"],
        ["\x44\x4D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xC7"],
        ["\xB7\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"],
        ["\xB7\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\xB7\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"],
        ["\xB7\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\xB7\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\xB7\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\xB7\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"],
        ["\xB7\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\xB7\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\xB8\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"],
        ["\xB8\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"],
        ["\xB8\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\xB8\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"],
        ["\xB8\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"],
        ["\xB8\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"],
        ["\xB8\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"],
        ["\xB8\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\xB9\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"],
        ["\xB9\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"],
        ["\xC6\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"],
        ["\xB9\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\xB9\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\xB9\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\xB9\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\xB9\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"],
        ["\xB9\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xA7"],
        ["\xBA\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\xBA\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\xBA\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\xBA\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\xBA\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\xBB\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\xBB\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\xB5\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\xBB\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"],
        ["\xBB\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\xBB\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xAA"],
        ["\xBB\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\xBB\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"],
        ["\xBB\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\xBB\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xB3"],
        ["\xB6\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\xBB\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\xBC\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\xBC\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\xBC\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"],
        ["\xBC\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\xBC\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\xBC\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\xBD\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"],
        ["\xBD\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"],
        ["\x39\x37",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"],
        ["\xBD\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"],
        ["\xBD\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"],
        ["\xBD\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],
        ["\xBD\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"],
        ["\xBD\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\xBD\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\xBD\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\xBD\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"],
        ["\xBD\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE1"],
        ["\xBD\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"],
        ["\xC5\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"],
        ["\xBE\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"],
        ["\xBE\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"],
        ["\xBD\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\xBE\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"],
        ["\xBE\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\xBE\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"],
        ["\xBE\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\xBE\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\xBE\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\xBE\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\xBE\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\xBF\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"],
        ["\xBF\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"],
        ["\xBF\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\xBF\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xF8"],
        ["\xC6\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\xBF\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\xBF\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\xBF\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"],
        ["\xBF\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\xBF\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\xBF\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\xC0\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xB9"],
        ["\xC0\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\xC0\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\xC0\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\xC0\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\xC0\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\xC0\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\xC0\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],
        ["\xC1\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\xC1\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\xC1\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\xC1\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\xC1\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"],
        ["\xC1\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"],
        ["\xC1\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"],
        ["\xC1\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"],
        ["\xC1\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"],
        ["\xC1\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"],
        ["\xC1\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"],
        ["\xC1\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"],
        ["\xC1\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"],
        ["\xC2\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\xC2\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\xC2\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"],
        ["\xC2\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\xC2\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\xC2\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\xC2\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\xC2\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\xC2\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"],
        ["\xC3\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\xC3\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"],
        ["\xC3\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\xC3\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\xC3\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\xC3\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"],
        ["\xC3\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"],
        ["\xC3\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\xC3\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"],
        ["\xC3\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\xC3\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\xC3\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"],
        ["\xC4\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\xC4\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"],
        ["\xC4\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"],
        ["\xC4\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\xC4\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\xC4\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\xC4\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\xC4\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\xC4\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\xC4\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\xC4\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"],
        ["\xC4\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\xC4\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xA8"],
        ["\xC4\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"],
        ["\xC4\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"],
        ["\xC5\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xB9"],
        ["\xC5\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],
        ["\xC5\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"],
        ["\xC5\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xCE"],
        ["\xC5\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"],
        ["\xC5\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\xC5\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\xC5\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],
        ["\xC5\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\xB4\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],
        ["\xC6\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\xC6\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\xC6\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\xC6\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xA5"],
        ["\xC6\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xAE"],
        ["\xC6\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\xC6\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xBB"],
        ["\xC6\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\xC7\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\xC7\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\xC7\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\xC7\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xFE"],
        ["\xC7\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xA2"],
        ["\xC7\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xA6"],
        ["\xC7\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xA4"],
        ["\xC8\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xB7"],
        ["\xC8\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xCC"],
        ["\xC9\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xDD"],
        ["\xC9\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE1"],
        ["\xC9\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xEC"],
        ["\xC9\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xEB"],
        ["\xC9\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],
        ["\xC9\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xFB"],
        ["\xBF\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xA5"],
        ["\xC9\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xAE"],
        ["\xC9\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xB2"],
        ["\xCB\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xDA"],
        ["\xCB\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xDD"],
        ["\xCB\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF2"],
        ["\xCC\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xFC"],
        ["\xCB\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF8"],
        ["\xCC\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xA3"],
        ["\xCC\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xAF"],
        ["\xCC\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xBE"],
        ["\xCC\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xBF"],
        ["\xCC\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xBA"],
        ["\xCC\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"],
        ["\xCD\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC9"],
        ["\xCD\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"],
        ["\xCD\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD7"],
        ["\xCD\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xDA"],
        ["\xCE\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE6"],
        ["\xCE\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xFE"],
        ["\xCE\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xA5"],
        ["\xCE\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xAA"],
        ["\xCE\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xAB"],
        ["\xCE\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xAD"],
        ["\xCE\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xB3"],
        ["\xCE\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xB2"],
        ["\xCE\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xB4"],
        ["\xCE\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xBE"],
        ["\xCE\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xC3"],
        ["\xCF\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xD0"],
        ["\xCF\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xCF"],
        ["\xCF\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xD5"],
        ["\xCF\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xD8"],
        ["\xCF\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xD9"],
        ["\xCF\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xE1"],
        ["\xCF\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xEB"],
        ["\xD0\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xFA"],
        ["\xD0\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xA3"],
        ["\xD0\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"],
        ["\xD0\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xCA"],
        ["\xD0\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xCD"],
        ["\xD0\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xD1"],
        ["\xD1\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xD9"],
        ["\xD1\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xD8"],
        ["\xD1\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xDA"],
        ["\xD1\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xDC"],
        ["\xD1\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE1"],
        ["\xD1\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE0"],
        ["\xD1\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xDF"],
        ["\xD1\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE5"],
        ["\xD1\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE9"],
        ["\xD1\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE7"],
        ["\xD1\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF2"],
        ["\xD1\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xEE"],
        ["\xD1\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF3"],
        ["\xD1\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xEF"],
        ["\xD1\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF1"],
        ["\xD1\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xEC"],
        ["\xD1\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xED"],
        ["\xD1\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF6"],
        ["\xD1\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xA6"],
        ["\xD1\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xA8"],
        ["\xD1\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xA5"],
        ["\xD1\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xB1"],
        ["\xD1\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xAC"],
        ["\xD1\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xB8"],
        ["\xD2\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xB3"],
        ["\xD2\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xB7"],
        ["\xD2\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xB5"],
        ["\xD1\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xB0"],
        ["\xD1\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\xD2\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"],
        ["\xD2\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xBE"],
        ["\xD2\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xCD"],
        ["\xD2\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC2"],
        ["\xD2\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xBF"],
        ["\xD2\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"],
        ["\xD2\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC4"],
        ["\xD2\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC5"],
        ["\xD2\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xCA"],
        ["\xD2\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xCC"],
        ["\xD2\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD8"],
        ["\xD2\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"],
        ["\xD2\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xDF"],
        ["\xD2\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE6"],
        ["\xD2\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xEF"],
        ["\xD2\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF0"],
        ["\xD2\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"],
        ["\xD2\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF8"],
        ["\xD3\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA2"],
        ["\xD3\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA4"],
        ["\xD3\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA5"],
        ["\xD3\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA6"],
        ["\xD3\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\xD3\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\xD3\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xAE"],
        ["\xD3\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xB0"],
        ["\xD3\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xD3\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xB1"],
        ["\xD3\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xB2"],
        ["\xD4\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC1"],
        ["\xD4\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC2"],
        ["\xD4\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC5"],
        ["\xD4\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC6"],
        ["\xD4\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC8"],
        ["\xD4\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC9"],
        ["\xD4\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xCC"],
        ["\xD4\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD9"],
        ["\xD4\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD4"],
        ["\xD4\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xDC"],
        ["\xD4\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\xD4\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE0"],
        ["\xD4\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE2"],
        ["\xD4\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE5"],
        ["\xD5\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE7"],
        ["\xD5\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\xD3\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\xD5\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"],
        ["\xD5\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"],
        ["\xD5\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xAC"],
        ["\xD5\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xA1"],
        ["\xA5\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x71\xB4"],
        ["\xA5\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x71\xB5"],
        ["\xA5\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x71\xB3"],
        ["\xA5\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xAF"],
        ["\xA5\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xB2"],
        ["\xA3\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xEA"],
        ["\xA3\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xFB"],
        ["\xA3\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xFD"],
        ["\xA3\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xFA"],
        ["\xA3\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xFC"],
        ["\xA3\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xED"],
        ["\xA3\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xEE"],
        ["\xA3\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xEF"],
        ["\xA3\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xEC"],
        ["\xA3\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"],
        ["\xA5\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xB1"],
        ["\xA4\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xA7"],
        ["\xA5\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF8"],
        ["\xA5\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"],
        ["\xA5\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF7"],
        ["\xA5\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF6"],
        ["\xA2\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA2\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA5\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA3\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA2\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xCB"],
        ["\xA2\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xCC"],
        ["\xA1\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"],
        ["\xA1\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],
        ["\xA1\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],
        ["\xA1\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],
        ["\xA1\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],
        ["\xA1\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],
        ["\xA1\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],
        ["\xA1\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE8"],
        ["\xA1\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],
        ["\xA1\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xEA"],
        ["\xA1\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"],
        ["\xA4\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xEC"],
        ["\xA4\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xED"],
        ["\xA4\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xEE"],
        ["\xA4\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xEF"],
        ["\xA4\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF0"],
        ["\xA4\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF1"],
        ["\xA4\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF2"],
        ["\xA4\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF3"],
        ["\xA4\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],
        ["\xA4\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF5"],
        ["\xA4\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],
        ["\xA4\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF7"],
        ["\xA4\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF8"],
        ["\xA4\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF9"],
        ["\xA4\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"],
        ["\xA1\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA1"],
        ["\xA1\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA2"],
        ["\xA1\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA3"],
        ["\xA2\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA4"],
        ["\xA2\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA5"],
        ["\xA2\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA6"],
        ["\xA2\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA7"],
        ["\xA2\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA8"],
        ["\xA2\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA9"],
        ["\xA2\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xAA"],
        ["\xA1\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xB1"],
        ["\xA1\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xB4"],
        ["\xA1\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xCB"],
        ["\xA1\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xBA"],
        ["\xA1\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xB6"],
        ["\xA1\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xBE"],
        ["\xA1\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x79\xBD"],
        ["\xA2\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xBB"],
        ["\xA2\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x74\xBC"],
        ["\xB2\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\xB2\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\xB2\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\xB2\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\xB3\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\xB2\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\xB3\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\xB3\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xBC"],
        ["\xB3\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xEA"],
        ["\xB4\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\xB5\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\xB5\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xDF"],
        ["\xB5\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\xB6\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xFD"],
        ["\xB6\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xFE"],
        ["\xB6\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xA4"],
        ["\xB6\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xB0"],
        ["\xB6\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xBF"],
        ["\xC1\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xC1"],
        ["\x45\x36",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC9"],
        ["\xB6\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\xB7\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\xB7\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xED"],
        ["\xB7\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF6"],
        ["\xB7\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF9"],
        ["\xB7\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\xB7\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\xB8\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xD8"],
        ["\xB8\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xE7"],
        ["\xB9\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\xB9\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],
        ["\x57\x3B",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBB"],
        ["\xB9\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\xB9\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\xBA\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xCC"],
        ["\xBA\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\xBA\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\xBA\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xEC"],
        ["\xBB\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xED"],
        ["\xBB\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\xBB\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\xBB\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xCD"],
        ["\xBC\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\xBC\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],
        ["\xBC\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\xBC\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xBF"],
        ["\xBD\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB8"],
        ["\xBD\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xCB"],
        ["\xBD\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xDC"],
        ["\xBD\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\xBE\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\xBE\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xA4"],
        ["\xBE\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xB0"],
        ["\xBE\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\xBE\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xB7"],
        ["\xBE\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xCA"],
        ["\xBE\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xBA"],
        ["\xBE\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\xBF\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xE7"],
        ["\xBF\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xE5"],
        ["\xBF\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\xBF\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xBF\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\xBF\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\xC0\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\xC0\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\xC0\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\xC0\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\xC0\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xDD"],
        ["\xC0\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\xC1\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\xC1\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xED"],
        ["\xC1\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\xC1\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xBA"],
        ["\xC2\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\xC2\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\xC2\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\xC2\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\xC2\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xDE"],
        ["\xC2\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\xC2\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xFC"],
        ["\xC2\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA2"],
        ["\xC3\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\xC3\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB2"],
        ["\xC3\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB3"],
        ["\xC3\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\xC3\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xDC"],
        ["\xC4\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\xC4\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\xC4\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\xC4\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\xC4\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xFB"],
        ["\xC4\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xA6"],
        ["\xC4\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xA4"],
        ["\xC4\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xAD"],
        ["\xC4\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xB5"],
        ["\xC5\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\xC5\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\xC5\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC6"],
        ["\xC5\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],
        ["\xC5\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\xC5\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\xC5\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xFC"],
        ["\xC6\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"],
        ["\xC7\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xDA"],
        ["\xC8\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xEC"],
        ["\xC7\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\xC5\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xFB"],
        ["\xC7\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],
        ["\xC8\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xB2"],
        ["\xC8\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xBB"],
        ["\xC8\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],
        ["\xC5\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\xC8\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\xC8\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\xC8\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\xC8\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],
        ["\xC8\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],
        ["\xC9\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],
        ["\xC9\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\xC9\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xBB"],
        ["\xCA\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xFB"],
        ["\xCA\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\xCB\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xA2"],
        ["\xCB\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"],
        ["\xCD\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xCD"],
        ["\xCD\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xFA"],
        ["\xCE\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xFD"],
        ["\xCE\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xA2"],
        ["\xCE\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xA6"],
        ["\xCE\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xA3"],
        ["\xCE\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xBB"],
        ["\xCE\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xBF"],
        ["\xCE\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xE5"],
        ["\xB4\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA7"],
        ["\xCF\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xF0"],
        ["\xD0\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xEF"],
        ["\xD0\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC4"],
        ["\xD0\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD1\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD1\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD1\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xDD"],
        ["\xD1\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD1\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xFB"],
        ["\xD1\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD1\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xBC"],
        ["\xD2\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xCF"],
        ["\xD2\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xD2\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xDE"],
        ["\xD2\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xEE"],
        ["\xD2\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF5"],
        ["\xD2\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"],
        ["\xCD\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xAA"],
        ["\xD3\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xBC"],
        ["\xD3\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xF6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\x45\x3F",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x80\xED"],
        ["\xD4\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD8"],
        ["\xD4\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\xD4\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\xD5\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\xD5\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\xD5\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\x39\x6D",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x80\xF7"],
        ["\xD5\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xAB"],
        ["\xB6\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xEE"],
        ["\xB2\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\xB2\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xBF"],
        ["\xB2\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\xB2\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\xB2\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\xB2\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xEC"],
        ["\xB2\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\xB2\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\xB3\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\xB3\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\xB3\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\xB3\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xDF"],
        ["\xB9\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\xB9\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xEA"],
        ["\xB9\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\xB9\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xFB"],
        ["\xB9\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\xB9\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\xB4\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xFA"],
        ["\xB4\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xA4"],
        ["\xB4\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xB1"],
        ["\xB5\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xBB"],
        ["\xB5\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\xB5\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\xB5\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB5\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xFA"],
        ["\xB6\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xA6"],
        ["\xB6\xC1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\xB6\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB6\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\xB6\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xDB"],
        ["\xB7\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF0"],
        ["\xB7\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\xB7\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF5"],
        ["\xB7\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\xB7\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xF8"],
        ["\xB7\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB7\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5D\xA7"],
        ["\xB8\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB8\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xCF"],
        ["\xBA\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\xBA\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\xBA\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xFE"],
        ["\xBB\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xA4"],
        ["\xBB\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\xBB\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\xBB\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\xBB\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBB\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xCE"],
        ["\xBC\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBA\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\xBC\xD5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xAC"],
        ["\xBD\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\xBD\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\xBD\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xCC"],
        ["\xBD\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],
        ["\xBD\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\xBD\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\xBD\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE8"],
        ["\xBD\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\xBE\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBE\xED",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB4\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\xBE\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xE6"],
        ["\xBF\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB9\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x61\xF3"],
        ["\xBF\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xA5"],
        ["\xBF\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBF\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\xC0\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD1\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBC\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\xC0\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC0\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\xC0\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\xC0\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xDF"],
        ["\xC1\xA2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\xC1\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xA9"],
        ["\xC1\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\xC1\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xAA"],
        ["\xC1\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xB1"],
        ["\xC1\xEA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xB2"],
        ["\xC1\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\xC1\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC1\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xC3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\xC2\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\xC2\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB3\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA3"],
        ["\xC3\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\xC3\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xAA"],
        ["\xC3\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xBD\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\xC3\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xEF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xF3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\xC4\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\xC4\xB2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\xC4\xBB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xDD"],
        ["\xC4\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\xC4\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xEE"],
        ["\xC4\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\xC4\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],
        ["\xC4\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\xC4\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\xC5\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\xC5\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xE0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\xC5\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xED"],
        ["\xC5\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xFD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\xC6\xA7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xB2\xF0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xAC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xC5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xA7"],
        ["\xC6\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xCC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD2\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xAC"],
        ["\xC6\xD0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\xC6\xDC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\xFA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xB3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xDC"],
        ["\xC7\xC4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xCA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE5"],
        ["\xC7\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\xC7\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\xC7\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xA4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xB3"],
        ["\xC8\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xAF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],
        ["\xC8\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xCD"],
        ["\xC8\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xBA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC8\xF7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],
        ["\xC8\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],
        ["\xC9\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xDE"],
        ["\xC9\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x67\xDA"],
        ["\xC9\xAA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xAE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xC6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xDE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xA6"],
        ["\xC9\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xE8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xF4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xFE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xBD"],
        ["\xCA\xAB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xC0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC5"],
        ["\xBE\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xDB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xDF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x68\xCF"],
        ["\xCB\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xF9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xA4"],
        ["\xCC\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\xCC\xC9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x69\xB5"],
        ["\xCC\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xE9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xCD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xCE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xD9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xE3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\xCD\xE6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xE7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xD4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xEC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xF8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xBF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xA1"],
        ["\xCE\xD7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xD3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xE4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xAE"],
        ["\xCE\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCE\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xA3",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xA5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xA6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xC5"],
        ["\xCF\xB5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xB9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xC8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCF\xFB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD0\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xFE"],
        ["\xD1\xE2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xFD"],
        ["\xD1\xEB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xA9"],
        ["\xD3\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xB6\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xB8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA1"],
        ["\xD3\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB0",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xDA",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xE1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xE5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xEE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD4\xFC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xA1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xAD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xA9",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xB1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xB4",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xB6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xB7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xBC",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xBD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xBE",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xC2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xEE"],
        ["\xD5\xC7",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xCF",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\xD5\xD1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xD2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xD6",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD3\xCB",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xD8",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xDD",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF1",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF2",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xD5\xF5",'keis83','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
