/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* boolean.c
**/

#include <string.h>

#include "pfile.h"


static void *String2Bool (char *value, bool * copy);
static void *Real2Bool (real * value, bool * copy);
static void *Int2Bool (int *value, bool * copy);

static Converter Converters[] = {
  {StringType, BooleanType, (ConverterType) String2Bool},
  {RealType, BooleanType, (ConverterType) Real2Bool},
  {IntegerType, BooleanType, (ConverterType) Int2Bool},
  {0, 0, 0}
};


vtype booleanRec = {
  "b",
  Converters,

  VXSize,
  VXAcce,
  NULL
};

static void *
String2Bool (value, copy)
     char *value;
     bool *copy;
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  if (!strcmp (value, "n"))
    *copy = 0;
  else if (!strcmp (value, "no"))
    *copy = 0;
  else if (!strcmp (value, "y"))
    *copy = 1;
  else if (!strcmp (value, "ye"))
    *copy = 1;
  else if (!strcmp (value, "yes"))
    *copy = 1;
  else
    {
      parerr = PARCANTCONVERT;
      return NULL;
    }

  return copy;
}


static void *
Int2Bool (value, copy)
     int *value;
     bool *copy;
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = *value != 0;

  return copy;
}

static void *
Real2Bool (value, copy)
     real *value;
     bool *copy;
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = *value != 0;

  return copy;
}
