# Generated by default/object.tt
package Paws::IoTEvents::DynamoDBv2Action;
  use Moose;
  has Payload => (is => 'ro', isa => 'Paws::IoTEvents::Payload', request_name => 'payload', traits => ['NameInRequest']);
  has TableName => (is => 'ro', isa => 'Str', request_name => 'tableName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::DynamoDBv2Action

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::DynamoDBv2Action object:

  $service_obj->Method(Att1 => { Payload => $value, ..., TableName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::DynamoDBv2Action object:

  $result = $service_obj->Method(...);
  $result->Att1->Payload

=head1 DESCRIPTION

Defines an action to write to the Amazon DynamoDB table that you
created. The default action payload contains all the information about
the detector model instance and the event that triggered the action.
You can customize the payload
(https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html).
A separate column of the DynamoDB table receives one attribute-value
pair in the payload that you specify.

You must use expressions for all parameters in C<DynamoDBv2Action>. The
expressions accept literals, operators, functions, references, and
substitution templates.

B<Examples>

=over

=item *

For literal values, the expressions must contain single quotes. For
example, the value for the C<tableName> parameter can be
C<'GreenhouseTemperatureTable'>.

=item *

For references, you must specify either variables or input values. For
example, the value for the C<tableName> parameter can be
C<$variable.ddbtableName>.

=item *

For a substitution template, you must use C<${}>, and the template must
be in single quotes. A substitution template can also contain a
combination of literals, operators, functions, references, and
substitution templates.

In the following example, the value for the C<contentExpression>
parameter in C<Payload> uses a substitution template.

C<'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\",
\"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 +
32}\"}'>

=item *

For a string concatenation, you must use C<+>. A string concatenation
can also contain a combination of literals, operators, functions,
references, and substitution templates.

In the following example, the value for the C<tableName> parameter uses
a string concatenation.

C<'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date>

=back

For more information, see Expressions
(https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html)
in the I<AWS IoT Events Developer Guide>.

The value for the C<type> parameter in C<Payload> must be C<JSON>.

=head1 ATTRIBUTES


=head2 Payload => L<Paws::IoTEvents::Payload>




=head2 B<REQUIRED> TableName => Str

The name of the DynamoDB table.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

