## Terminal::ANSI

This is a library of ANSI escape sequences.

### Example

    use Terminal::ANSI;

    save-screen;
    clear-screen;
    home;

    hide-cursor;

    sub scroll($row,$col = 1, $height = 7) {
      print-at $row,$col, "━" x 20;
      print-at $row + $height,$col, "━" x 20;
      my $on = $row;
      for 20000, 19999 ... 0 {
        atomically {
          set-scroll-region($row + 1,$row + $height - 1);
          scroll-up if $on >= $row + $height - 1;
          print-at ++$on min $row + $height - 1, $col, "counting down..$_";
        }
      }
    }

    my $p1 = start scroll(2);
    my $p2 = start scroll(12,10,10);
    my $p3 = start scroll(24);
    await Promise.allof($p1,$p2,$p3);
    sleep 1;

    reset-scroll-region;
    show-cursor;
    restore-screen;

See the [eg/](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/eg) directory for more examples.

## Description

The functions in this module print ANSI escape sequences to stdout.
There are functions for cursor movement, scroll regions, colors, and
other screen functionality.  There aren't functions for any of the
esoteric escape codes.

The `atomically` function suppresses printing, and instead concatenates
the output and emits the entire line at the end.  This is helpful for
multi-threaded situations, where the output of several functions needs
to be in one piece.

There is also an OO interface (see the examples).

## Functions

[atomically(&callable)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L185) Combine a series of outputs into one.

[bold()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L167) Bold (increased intensity)

[clear-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L28) Clear the screen.

[cursor-down($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L102) Move cursor down.

[cursor-left($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L117) Move cursor left.

[cursor-off()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L92) Turn off cursor (civis).

[cursor-on()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L97) Turn on cursor (cnorm).

[cursor-right($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L112) Move cursor right.

[cursor-up($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L107) Move cursor up.

[erase-to-end-of-line()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L152) Erase to end of line.

[faint()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L172) Faint (lower intensity)

[hide-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L72) Hide the cursor.

[home()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L38) Move to home (0,0).

[move-to($l, $c = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L33) Move the cursor to line, column.

[normal-video()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L162) Normal video

[print-at($r, $c, $str)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L122) Atomic move + print.

[reset-scroll-region()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L53) Reset the scroll region.

[restore-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L142) restore the cursor position.

[restore-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L87) Restore screen (rmcup).

[reverse-video()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L157) Reverse video

[save-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L137) Save the cursor position.

[save-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L82) Save screen state (smcup).

[scroll-down()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L60) Scroll down 1.

[scroll-up()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L66) Scroll up 1.

[set-bg-color($n)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L132) Set bg color to $n.

[set-fg-color($n)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L127) Set fg color to $n.

[set-scroll-region($top, $bottom)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L46) Set scroll region to top, bottom.

[show-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L77) Show the cursor.

[start-of-line()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L147) Move to start of line.

[tget(&callable)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/master/lib/Terminal/ANSI.rakumod#L177) Get strings instead of printing them.


## Author

Brian Duggan
