/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess;

import gnu.getopt.Getopt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import opennlp.common.preprocess.SentenceDetector;
import opennlp.grok.preprocess.sentdetect.EnglishSentenceDetectorME;

class SentDetectServer
extends Thread {
    private Socket socket;
    private SentenceDetector sentdetector = new EnglishSentenceDetectorME();
    private int responseCode = 621;
    static boolean verbose = false;

    public SentDetectServer(Socket s, int c) {
        super("SentenceDetectorThread");
        this.responseCode = c;
        this.socket = s;
    }

    public static String getMessage(DataInputStream in) {
        int inLen = 0;
        boolean totalAmtRead = false;
        boolean RC = true;
        try {
            inLen = in.readInt();
            byte[] input = new byte[inLen];
            if (inLen < 100000) {
                in.readFully(input, 0, inLen);
                String answer = new String(input);
                return answer;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
            DataOutputStream binaryOut = new DataOutputStream(this.socket.getOutputStream());
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            try {
                try {
                    String doc;
                    block6: while ((doc = SentDetectServer.getMessage(in)) != null) {
                        void var4_5;
                        if (var4_5.length() == 0) continue;
                        doc = var4_5.substring(4);
                        int[] sentPositions = this.sentdetector.sentPosDetect(doc);
                        StringBuffer message = new StringBuffer();
                        int i = 0;
                        while (true) {
                            if (i >= sentPositions.length) {
                                if (verbose) {
                                    System.out.println(doc.substring(sentPositions[sentPositions.length - 1]));
                                }
                                String messageStr = this.responseCode + " " + message.length() + "\u0000" + message.toString();
                                binaryOut.writeInt(messageStr.length());
                                out.print(messageStr);
                                out.flush();
                                continue block6;
                            }
                            if (verbose && i > 0) {
                                System.out.println(doc.substring(sentPositions[i - 1], sentPositions[i]));
                            }
                            message.append(sentPositions[i] + "\u0000");
                            ++i;
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Error: " + E);
                    E.printStackTrace();
                    Object var10_12 = null;
                    System.out.println("Closing connection");
                    out.close();
                    in.close();
                    this.socket.close();
                    return;
                }
                Object var10_11 = null;
                System.out.println("Closing connection");
                out.close();
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                System.out.println("Closing connection");
                out.close();
                in.close();
                this.socket.close();
                throw throwable;
            }
            in.close();
            this.socket.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        int c;
        ServerSocket serverSocket = null;
        boolean listening = true;
        int port = 1060;
        int code = 619;
        Getopt g = new Getopt("SentDetectClient", args, "p:c:v");
        while ((c = g.getopt()) != -1) {
            void var6_6;
            switch (var6_6) {
                case 112: {
                    port = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 99: {
                    code = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 118: {
                    verbose = true;
                }
            }
        }
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + port);
            System.exit(-1);
        }
        while (listening) {
            System.out.println("Waiting for Connection");
            new SentDetectServer(serverSocket.accept(), code).start();
        }
        serverSocket.close();
    }
}

