package ContactUs;

use strict;

use base 'Gantry';
use Gantry::Utils::HTML qw( :form :table :style );
use Mail::Sendmail;

sub do_main {
    my $self = shift;

    return join '',
        ht_form_js( "$self->{uri}/contactus" ),
            ht_table(),
                ht_tr(),
                    ht_td(), "Your Email Address:", ht_utd(),
                    ht_td(), ht_input( 'email',   'text' ), ht_utd(),
                ht_utr(),
                ht_tr(),
                    ht_td(), "What We Need to Know:", ht_utd(),
                    ht_td(),
                        ht_input( 'message', 'textarea', '',
                                  'rows="12" cols="75"' ),
                    ht_utd(),
                ht_utr(),
            ht_utable(),
            ht_submit( 'Submit', 'Submit' ),
            ht_submit( 'Cancel', 'Cancel' ),
        ht_uform;
}

sub do_contactus {
    my $self = shift;

    my $params = $self->get_param_hash();

    sendmail(
        To      => 'support@example.com',
        From    => 'acustomer@example.com',
        Subject => "Contact Us Message from $params->{ email }",
        Message => $params->{ message },
        smtp    => 'smtp.example.com'
    ) or warn "couldn't send $params->{ message } to support\@example.com";

    return ht_h( 2, 'Thank you for contacting us.' );
}

1;
