package GENJobAd;

use strict;

use Gantry qw{ -TemplateEngine=TT };

our @ISA = qw( Gantry );

use JobAd::Job;
use JobAd::Skill;
use JobAd::Position;

#-----------------------------------------------------------------
# $self->init( $r )
#-----------------------------------------------------------------
sub init {
    my ( $self, $r ) = @_;

    # process SUPER's init code
    $self->SUPER::init( $r );

    $self->set_dbuser( $self->fish_config( 'dbuser' ) || '' );
    $self->set_auth_dbuser( $self->fish_config( 'auth_dbuser' ) || '' );
} # END init


#-----------------------------------------------------------------
# $self->set_dbuser( $new_value )
#-----------------------------------------------------------------
sub set_dbuser {
    my ( $self, $value ) = @_;

    $self->{ __dbuser__ } = $value;
}

#-----------------------------------------------------------------
# $self->dbuser(  )
#-----------------------------------------------------------------
sub dbuser {
    my $self = shift;

    return $self->{ __dbuser__ };
}

#-----------------------------------------------------------------
# $self->set_auth_dbuser( $new_value )
#-----------------------------------------------------------------
sub set_auth_dbuser {
    my ( $self, $value ) = @_;

    $self->{ __auth_dbuser__ } = $value;
}

#-----------------------------------------------------------------
# $self->auth_dbuser(  )
#-----------------------------------------------------------------
sub auth_dbuser {
    my $self = shift;

    return $self->{ __auth_dbuser__ };
}

#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = shift;

    $self->stash->view->template( 'main.tt' );
    $self->stash->view->title( 'JobAd' );

    $self->stash->view->data( {
        pages => [
            { link => 'job', label => 'Job' },
            { link => 'skill', label => 'Skill' },
            { link => 'position', label => 'Position' },
        ],
    } );
}

#-----------------------------------------------------------------
# $self->site_links( )
#-----------------------------------------------------------------
sub site_links {
    my $self = shift;

    return [
        { link => $self->app_rootp() . 'job', label => 'Job' },
        { link => $self->app_rootp() . 'skill', label => 'Skill' },
        { link => $self->app_rootp() . 'position', label => 'Position' },
    ];
}

1;

=head1 NAME

GENJobAd - generated support module for JobAd

=head1 SYNOPSIS

In JobAd:

    use base 'GENJobAd';

=head1 DESCRIPTION

This module was generated by Bigtop (and IS subject to regeneration) to
provide methods in support of the whole JobAd
application.

JobAd should inherit from this module.

=head1 METHODS

=over 4

=item init

=item do_main

=item site_links

=item dbuser

=item set_dbuser

=item auth_dbuser

=item set_auth_dbuser


=back

=head1 AUTHOR

Phil Crow, E<lt>pcrow@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
