use strict;
use vars qw($loaded);
$^W = 1;

BEGIN { $| = 1; print "1..58\n"; }
END {print "not ok 1\n" unless $loaded;}
use ShiftJIS::Collate;
$loaded = 1;
print "ok 1\n";

####

my $mod = "ShiftJIS::Collate";

my $Collator = $mod->new();

my $s;

my @data = (
 [qw/  Lcl  ʂ lR ˂ p_ Ђ傤 CI /],
 [qw/ f[^ fF^ fG^ f[^[ f[^@ f[^A
   fF^[ fF^@ fF^A fG^[ fG^@ fG^A /],
 [qw/   Ƃ ǂ Ƃ Tg[ Ƃ /],
 [qw/ t@[ Ԃ t@D t@E t@ ӂ tA Ԃ /],
 [qw/ 傤 悤 傤 悤 傤 傤 悤
      傤 傤 V[ VI W[ 储 W[W /],
 [qw/  T  U   /],
);

$s = 0;
for(@data){
  my %h;
  @h{ @$_ } =();
  $s ++ unless join(":", @$_) eq join(":", $Collator->sort(keys %h));
}
print ! $s ? "ok" : "not ok", " 2\n";

print $Collator->cmp("Perl", "o") == 0
   && $mod->new( level => 4 )->cmp("Perl", "o") == 0
   && $mod->new( level => 5 )->cmp("Perl", "o") == -1
    ? "ok" : "not ok", " 3\n";

print $Collator->cmp("PERL", "o") == 1
   && $mod->new( level => 3 )->cmp("PERL", "o") == 1
   && $mod->new( level => 2 )->cmp("PERL", "o") == 0
    ? "ok" : "not ok", " 4\n";

print $Collator->cmp("Perl", "odqk") == -1
   && $mod->new( level => 3 )->cmp("Perl", "odqk") == -1
   && $mod->new( level => 2 )->cmp("Perl", "odqk") == 0
    ? "ok" : "not ok", " 5\n";

print $Collator->cmp("", "ACEGI") == -1
    ? "ok" : "not ok", " 6\n";

print $mod->new( level => 3 )->cmp("", "ACEGI") == 0
   && $mod->new( katakana_before_hiragana => 1 )
          ->cmp("", "ACEGI") == 1
   && $mod->new( katakana_before_hiragana => 1,
            level => 3 )->cmp("", "ACEGI") == 0
    ? "ok" : "not ok", " 7\n";

print $Collator->cmp("perl", "PERL") == -1
   && $mod->new( level => 2 )->cmp("perl", "PERL") == 0
    ? "ok" : "not ok", " 8\n";

print $mod->new(upper_before_lower => 1)->cmp("perl", "PERL") == 1
    ? "ok" : "not ok", " 9\n";

print $mod->new(upper_before_lower => 1, level => 2)->cmp("perl", "PERL") == 0
    ? "ok" : "not ok", " 10\n";

print $Collator->cmp("", "ACEGI") == 0
    ? "ok" : "not ok", " 11\n";

print $mod->new( level => 5 )->cmp("", "ACEGI") == 1
    ? "ok" : "not ok", " 12\n";

print $Collator->cmp("XYZ", "abc") == 1
    ? "ok" : "not ok", " 13\n";

print $mod->new( level => 1 )->cmp("XYZ", "abc") == 1
    ? "ok" : "not ok", " 14\n";

print $Collator->cmp("XYZ", "ABC") == 1
   && $Collator->cmp("xyz", "ABC") == 1
    ? "ok" : "not ok", " 15\n";

print $Collator->gt("", "T")
   && $Collator->ge("", "T")
   && $Collator->ne("", "T")
    ? "ok" : "not ok", " 16\n";

print $mod->new( level => 3 )->gt("", "T")
   && $mod->new( level => 3 )->ge("", "T")
   && $mod->new( level => 3 )->ne("", "T")
   && $mod->new( level => 3 )->lt("", "T")
   && $mod->new( level => 3 )->le("", "T")
   && $mod->new( level => 3 )->ne("", "T")
    ? "ok" : "not ok", " 17\n";

print $mod->new( level => 2 )->eq("", "T")
   && $mod->new( level => 2 )->ge("", "T")
   && $mod->new( level => 2 )->le("", "T")
   && $mod->new( level => 1 )->lt("", "U")
   && $mod->new( level => 1 )->le("", "U")
   && $mod->new( level => 1 )->ne("", "U")
    ? "ok" : "not ok", " 18\n";

print $mod->new( level => 2 )->gt("", "T")
   && $mod->new( level => 2 )->ge("", "T")
   && $mod->new( level => 2 )->ne("", "T")
   && $mod->new( level => 2 )->eq("", "U")
   && $mod->new( level => 2 )->ge("", "U")
   && $mod->new( level => 2 )->le("", "U")
    ? "ok" : "not ok", " 19\n";

print $mod->new( level => 1 )->eq("", "T")
   && $mod->new( level => 1 )->ge("", "T")
   && $mod->new( level => 1 )->le("", "T")
    ? "ok" : "not ok", " 20\n";

print $Collator->cmp("pA", "p[") == 1
    ? "ok" : "not ok", " 21\n";

print $mod->new( level => 3 )->cmp("pA", "p[") == 1
   && $mod->new( level => 3 )->cmp("p@", "p[") == 1
   && $mod->new( level => 2 )->cmp("pA", "p[") == 0
    ? "ok" : "not ok", " 22\n";

print $Collator->cmp("", "") == 0
    ? "ok" : "not ok", " 23\n";

print $mod->new( level => 1 )->cmp("", "") == 0
   && $mod->new( level => 2 )->cmp("", "") == 0
   && $mod->new( level => 3 )->cmp("", "") == 0
   && $mod->new( level => 4 )->cmp("", "") == 0
   && $mod->new( level => 5 )->cmp("", "") == 0
    ? "ok" : "not ok", " 24\n";

print $Collator->cmp("", " ")  == -1
   && $Collator->cmp("", "\n") == 0
   && $Collator->cmp("\n ", "\n \r") == 0
   && $Collator->cmp(" ", "\n \r") == 0
    ? "ok" : "not ok", " 25\n";

print $Collator->cmp('`', '') == -1
    ? "ok" : "not ok", " 26\n";

print $mod->new( level => 1, kanji => 1 )->cmp('`', '') == 1
   && $mod->new( level => 1, kanji => 1 )->cmp('`', 'W') == -1
   && $mod->new( level => 1, kanji => 1 )->cmp('W', '') == 1
   && $mod->new( level => 1, kanji => 2 )->cmp('`', '') == -1
   && $mod->new( level => 1, kanji => 2 )->cmp('`', 'W') == -1
   && $mod->new( level => 1, kanji => 2 )->cmp('W', '') == -1
   && $mod->new( level => 1, kanji => 0 )->cmp('', '') == -1
   && $mod->new( level => 1, kanji => 1 )->cmp('', '') == 0
   && $mod->new( level => 1, kanji => 2 )->cmp('', '') == -1
    ? "ok" : "not ok", " 27\n";

print $Collator->cmp('', '') == 1
    ? "ok" : "not ok", " 28\n";

{
  my(@subject, $sorted);

  my $delProlong = sub {
      my $str = shift;
      $str =~ s/\G(
	(?:[\x00-\x7F\xA1-\xDF]|[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC])*?
	)\x81\x5B/$1/gox;
      $str;
    };

  my $delete_prolong = $mod->new(preprocess => $delProlong);

  my $ignore_prolong = $mod->new(ignoreChar => '^(?:\x81\x5B|\xB0)');

  my $jis    = new ShiftJIS::Collate;
  my $level2 = new ShiftJIS::Collate level => 2;
  my $level3 = new ShiftJIS::Collate level => 3;
  my $level4 = new ShiftJIS::Collate level => 4;
  my $level5 = new ShiftJIS::Collate level => 5;

  $sorted  = 'pCibv nbg ͂ o[i[ oii p[ pfB';
  @subject = qw(pfB pCibv oii nbg ͂ p[ o[i[);

  print
      $sorted eq join(' ', $ignore_prolong->sort(@subject))
   && $sorted eq join(' ', $delete_prolong->sort(@subject))
   && $level2->cmp("pA", "p[") == 0
   && $level3->cmp("pA", "p[") == 1
   && $level3->cmp("p@", "p[") == 1
   && $level4->cmp("߰",   "p[") == 0
   && $level5->cmp("p[", "߰",4) == -1
   && $level2->cmp("pp", "ς") == 0
   && $jis->cmp("pp", "ς") == 1
    ? "ok" : "not ok", " 29\n";
}


{
  my @hira = map "\x82".chr, 0x9F .. 0xF1;
  my @kata = map "\x83".chr, 0x40 .. 0x7E, 0x80 .. 0x96;
  my $i;

  my $jis = new ShiftJIS::Collate;
  my $kbh = new ShiftJIS::Collate katakana_before_hiragana => 1;
  my $lv3 = new ShiftJIS::Collate level => 3;

  for($i = 0; $i < @hira; $i++) {
    last unless $jis->le($hira[$i], $kata[$i]);
    last unless $kbh->ge($hira[$i], $kata[$i]);
    last unless $lv3->eq($hira[$i], $kata[$i]);
  }

  print $i == @hira ? "ok" : "not ok", " 30\n";
}

{
  my @lower = map "\x82".chr, 0x81 .. 0x9A;
  my @upper = map "\x82".chr, 0x60 .. 0x79;
  my $i;

  my $jis = new ShiftJIS::Collate;
  my $ubl = new ShiftJIS::Collate upper_before_lower => 1;
  my $lv2 = new ShiftJIS::Collate level => 2;
  my $lv3 = new ShiftJIS::Collate level => 3;
  my $ul3 = new ShiftJIS::Collate level => 3, upper_before_lower => 1;

  for($i = 0; $i < @lower; $i++) {
    last unless $jis->le($lower[$i], $upper[$i]);
    last unless $ubl->ge($lower[$i], $upper[$i]);
    last unless $lv2->eq($lower[$i], $upper[$i]);
    last unless $lv3->le($lower[$i], $upper[$i]);
    last unless $ul3->ge($lower[$i], $upper[$i]);
  }

  print $i == @lower ? "ok" : "not ok", " 31\n";
}

my $obs; # 'overrideCJK' is obsolete and to be croaked.
eval { $obs = new ShiftJIS::Collate overrideCJK => sub {}, level => 3; };

print $@ ? "ok" : "not ok", " 32\n";

print 1
   && $mod->new( level => 3 )->gt('nnnn', 'nRRR')
   && $mod->new( level => 2 )->eq('nnnn', 'nRRR')
   && $mod->new( level => 3 )->gt('LCCC', 'L[[[')
   && $mod->new( level => 2 )->eq('LCCC', 'L[[[')
    ? "ok" : "not ok", " 33\n";

##########

my (@source, $result);

@source = (
  ['ic', 'Ȃ'],
  ['R', ''],
  ['c', ''],
  ['c', 'Ȃ'],
  ['R', ''],
);

$result = join ';', map join(',', @$_), $Collator->sortYomi(@source);

print $result eq
  'c,;R,;R,;ic,Ȃ;c,Ȃ'
? "ok" : "not ok", " 34\n";

@source = (
  ['V',   '킵'],
  ['Sʑ', '߂񂽂'],
  ['͓c',   '킾'],
  ['y',   ''],
  ['', 'At@ق'],
  ['֐', 'K}񂷂'],
  ['Perl',   'p['],
  ['S', '悶'],
  ['',   'x[^'],
  ['pc',   ''],
  ['',   '킵'],
  ['͓',   '킿'],
  ['c',   '킾'],
  ['͓',   ''],
  ['QF', 'ɂ傭'],
  ['Vc',   '킾'],
  ['y',   'ǂ'],
  ['pl',   'L['],
  ['͐',   ''],
  ['V',   '킵'],
  ['ihr', ''],
  ['֓',   'Ƃ'],
  ['͕',   ''],
  ['',   '킵'],
  ['pc',   'ǂ'],
  ['y',   ''],
  ['Uʑ', '낭߂񂽂'],
  ['pc',   '̂'],
  ['y',   'ǂ'],
  ['͍',   '킢'],
);

$result = join ';', map join(',', @$_), $Collator->sortDaihyo(@source);

print $result eq
  'Sʑ,߂񂽂;QF,ɂ傭;S,悶;' .
  'Uʑ,낭߂񂽂;,At@ق;֐,K}񂷂;' .
  ',x[^;pl,L[;ihr,;Perl,p[;͐,;' .
  '͍,킢;͓c,킾;͓,킿;͕,;pc,;' .
  'pc,ǂ;֓,Ƃ;͓,;,킵;,킵;' .
  'c,킾;V,킵;V,킵;Vc,킾;pc,̂;' .
  'y,;y,;y,ǂ;y,ǂ'
? "ok" : "not ok", " 35\n";


sub toU {
    my $char = shift;
    return $char eq '' ? 0x4E00 :
	   $char eq '' ? 0x4E9C : 0x9999;
}

print $Collator->lt('`', '')
    ? "ok" : "not ok", " 36\n";

print $mod->new( level => 1, kanji => 1 )->gt('`', '')
   && $mod->new( level => 1, kanji => 1 )->lt('`', 'W')
   && $mod->new( level => 1, kanji => 1 )->gt('W', '')
   && $mod->new( level => 1, kanji => 1 )->eq('', '')
    ? "ok" : "not ok", " 37\n";

print $mod->new( level => 1, kanji => 0 )->lt('', '')
   && $mod->new( level => 1, kanji => 2 )->lt('`', '')
   && $mod->new( level => 1, kanji => 2 )->lt('`', 'W')
   && $mod->new( level => 1, kanji => 2 )->lt('W', '')
   && $mod->new( level => 1, kanji => 2 )->lt('', '')
    ? "ok" : "not ok", " 38\n";

print $mod->new( level => 1, kanji => 3, tounicode => \&toU )->lt('`', '')
   && $mod->new( level => 1, kanji => 3, tounicode => \&toU )->lt('`', 'W')
   && $mod->new( level => 1, kanji => 3, tounicode => \&toU )->lt('W', '')
   && $mod->new( level => 1, kanji => 3, tounicode => \&toU )->gt('', '')
    ? "ok" : "not ok", " 39\n";

print $Collator->lt('', '@') ? "ok" : "not ok", " 40\n";
print $Collator->lt('@', 'V') ? "ok" : "not ok", " 41\n";
print $Collator->lt('V', 'W') ? "ok" : "not ok", " 42\n";
print $Collator->lt('W', 'X') ? "ok" : "not ok", " 43\n";
print $Collator->lt('X', 'Y') ? "ok" : "not ok", " 44\n";
print $Collator->lt('Y', 'Z') ? "ok" : "not ok", " 45\n";
print $Collator->lt('Z', '') ? "ok" : "not ok", " 46\n";
print $Collator->lt('', '') ? "ok" : "not ok", " 47\n";
print $Collator->lt('', '') ? "ok" : "not ok", " 48\n";


print $Collator->eq('', 'J') ? "ok" : "not ok", " 49\n";
print $Collator->eq('', 'K') ? "ok" : "not ok", " 50\n";
print $Collator->eq('', '') ? "ok" : "not ok", " 51\n";
print $Collator->eq('', '') ? "ok" : "not ok", " 52\n";
print $Collator->eq('', '') ? "ok" : "not ok", " 53\n";

my $box = join('', pack 'n*', 0x849f..0x84be);
print $Collator->eq('',  $box) ? "ok" : "not ok", " 54\n";
print $Collator->gt('a', $box) ? "ok" : "not ok", " 55\n";
print $Collator->lt('a'.$box, $box.'b') ? "ok" : "not ok", " 56\n";
print $Collator->eq('a'.$box, $box.'a') ? "ok" : "not ok", " 57\n";
print $Collator->gt('b'.$box, $box.'a') ? "ok" : "not ok", " 58\n";

