
package ZooZ::Fonts;
$ZooZ::Fonts::VERSION = '1.9.0';
use strict;

sub new {
  my $class = shift;

  my $self  = bless {
		     FONTS => {},
		     I     => 0,
		     } => $class;

  return $self;
}

sub add {
  my ($self, $name, $obj) = @_;

  $self->{FONTS}{$name} = $obj;
}

sub remove     { delete $_[0]{FONTS}{$_[1]} }
sub listAll    { keys %{$_[0]{FONTS}}       }
sub obj        { $_[0]{FONTS}{$_[1]}        }
sub FontExists { exists $_[0]{FONTS}{$_[1]} }
sub index      { $_[0]->{I}++ }

sub newName {
  my $self = shift;

  my $i = $self->index;
  return "_Font_$i";
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

ZooZ::Fonts

=head1 VERSION

version 1.9.0

=head1 AUTHOR

Ala Qumsieh, faraco <skelic3@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2004-2005, 2018 by Ala Qumsieh, faraco.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
