#!/usr/bin/perl

package eBay::API::XML::DataType::SellerFavoriteItemPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellerFavoriteItemPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SellerFavoriteItemPreferencesType

=head1 DESCRIPTION

Contains the data for the seller favorite item preferences, i.e.  the manual or automatic selection criteria to display items for buyer's favourite seller opt in email marketing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SellerFavoriteItemPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::ListingTypeCodeType;
use eBay::API::XML::DataType::Enum::StoreItemListSortOrderCodeType;


my @gaProperties = ( [ 'FavoriteItemID', 'ns:ItemIDType', '1'
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ListingType', 'ns:ListingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingTypeCodeType', '' ]
	, [ 'MaxPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'MinPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'SearchKeywords', 'xs:string', '', '', '' ]
	, [ 'SearchSortOrder', 'ns:StoreItemListSortOrderCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreItemListSortOrderCodeType', '' ]
	, [ 'StoreCategoryID', 'xs:long', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFavoriteItemID()

Specifies the list of favorite items.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:ItemIDType'

=cut

sub setFavoriteItemID {
  my $self = shift;
  $self->{'FavoriteItemID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getFavoriteItemID()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ItemIDType'

=cut

sub getFavoriteItemID {
  my $self = shift;
  return $self->_getDataTypeArray('FavoriteItemID');
}


=head2 setListingType()

The listing format (fixed price, auction, etc) for the automatic item search criteria.

  Calls: SetUserPreferences
  RequiredInput: No
  OnlyTheseValues: Auction, StoresFixedPrice, LeadGeneration,
							FixedPriceItem

#    Argument: 'ns:ListingTypeCodeType'

=cut

sub setListingType {
  my $self = shift;
  $self->{'ListingType'} = shift
}

=head2 getListingType()

  Calls: GetUserPreferences
  Returned: Conditionally
  OnlyTheseValues: Auction, StoresFixedPrice, LeadGeneration,
							FixedPriceItem

#    Returns: 'ns:ListingTypeCodeType'

=cut

sub getListingType {
  my $self = shift;
  return $self->{'ListingType'};
}


=head2 setMaxPrice()

Specifies the upper limit of price range for the automatic search criteria.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setMaxPrice {
  my $self = shift;
  $self->{'MaxPrice'} = shift
}

=head2 getMaxPrice()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getMaxPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaxPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setMinPrice()

Specifies the lower limit of price range for the automatic search criteria.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setMinPrice {
  my $self = shift;
  $self->{'MinPrice'} = shift
}

=head2 getMinPrice()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getMinPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MinPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setSearchKeywords()

The keywords in the item title for the automatic item search criteria.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setSearchKeywords {
  my $self = shift;
  $self->{'SearchKeywords'} = shift
}

=head2 getSearchKeywords()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getSearchKeywords {
  my $self = shift;
  return $self->{'SearchKeywords'};
}


=head2 setSearchSortOrder()

The sort order chosen from the standard ebay sorts for the automatic search criteria.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:StoreItemListSortOrderCodeType'

=cut

sub setSearchSortOrder {
  my $self = shift;
  $self->{'SearchSortOrder'} = shift
}

=head2 getSearchSortOrder()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:StoreItemListSortOrderCodeType'

=cut

sub getSearchSortOrder {
  my $self = shift;
  return $self->{'SearchSortOrder'};
}


=head2 setStoreCategoryID()

(For eBay Store owners only) The store custom category for the  automatic item search criteria.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:long'

=cut

sub setStoreCategoryID {
  my $self = shift;
  $self->{'StoreCategoryID'} = shift
}

=head2 getStoreCategoryID()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getStoreCategoryID {
  my $self = shift;
  return $self->{'StoreCategoryID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
