; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instsimplify < %s | FileCheck %s

define i8 @definitely_in_bounds() {
; CHECK-LABEL: define i8 @definitely_in_bounds() {
; CHECK-NEXT:    ret i8 0
;
  ret i8 extractelement (<vscale x 16 x i8> zeroinitializer, i64 15)
}

define i8 @maybe_in_bounds() {
; CHECK-LABEL: define i8 @maybe_in_bounds() {
; CHECK-NEXT:    ret i8 extractelement (<vscale x 16 x i8> zeroinitializer, i64 16)
;
  ret i8 extractelement (<vscale x 16 x i8> zeroinitializer, i64 16)
}

; Examples of extracting a lane from a splat constant

define i32 @extractconstant_shuffle_in_range(i32 %v) {
; CHECK-LABEL: define i32 @extractconstant_shuffle_in_range(
; CHECK-SAME: i32 [[V:%.*]]) {
; CHECK-NEXT:    ret i32 1024
;
  %r = extractelement <vscale x 4 x i32> splat (i32 1024), i32 1
  ret i32 %r
}

define i32 @extractconstant_shuffle_maybe_out_of_range(i32 %v) {
; CHECK-LABEL: define i32 @extractconstant_shuffle_maybe_out_of_range(
; CHECK-SAME: i32 [[V:%.*]]) {
; CHECK-NEXT:    ret i32 extractelement (<vscale x 4 x i32> splat (i32 1024), i32 4)
;
  %r = extractelement <vscale x 4 x i32> splat (i32 1024), i32 4
  ret i32 %r
}

define i32 @extractconstant_shuffle_invalid_index(i32 %v) {
; CHECK-LABEL: define i32 @extractconstant_shuffle_invalid_index(
; CHECK-SAME: i32 [[V:%.*]]) {
; CHECK-NEXT:    ret i32 extractelement (<vscale x 4 x i32> splat (i32 1024), i32 -1)
;
  %r = extractelement <vscale x 4 x i32> splat (i32 1024), i32 -1
  ret i32 %r
}
