; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX7LESS,GFX7LESS_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX8,GFX8_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064,GFX1064_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032,GFX1032_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164,GFX1164_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132,GFX1132_ITERATIVE %s
; RUN: llc -mtriple=amdgcn - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX7LESS,GFX7LESS_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX8,GFX8_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064,GFX1064_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032,GFX1032_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164,GFX1164_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -mattr=-flat-for-global - -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132,GFX1132_DPP %s

declare i32 @llvm.amdgcn.workitem.id.x()

@local_var32 = addrspace(3) global i32 poison, align 4
@local_var64 = addrspace(3) global i64 poison, align 8

; Show what the atomic optimization pass will do for local pointers.

define amdgpu_kernel void @add_i32_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: add_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB0_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_mul_i32 s2, s2, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB0_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB0_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB0_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB0_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB0_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s2, s2, 5
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB0_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s1, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB0_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s1, s1, 5
; GFX1032-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB0_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s2, s2, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB0_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s1, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_mul_i32 s1, s1, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s1
; GFX1132-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB0_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(3) @local_var32, i32 5 acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_uniform(ptr addrspace(1) %out, i32 %additive) {
; GFX7LESS-LABEL: add_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xb
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB1_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s2, s6, s2
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB1_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB1_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s2, s6, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB1_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB1_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s2, s6, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB1_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB1_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s2, s6, s2
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB1_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s6, v0, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dword s0, s[4:5], 0x2c
; GFX1032-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB1_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s2, s0, s2
; GFX1032-NEXT:    v_mov_b32_e32 v2, s2
; GFX1032-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB1_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s0, s0, v0, s[2:3]
; GFX1032-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b32 s6, s[4:5], 0x2c
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB1_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s2, s6, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB1_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[1:2], null, s6, v0, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v1, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b32 s0, s[4:5], 0x2c
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB1_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s2, s0, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s2
; GFX1132-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB1_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mad_u64_u32 v[1:2], null, s0, v0, s[2:3]
; GFX1132-NEXT:    buffer_store_b32 v1, off, s[4:7], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(3) @local_var32, i32 %additive acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: add_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB2_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_add_rtn_u32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB2_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_add_i32_e32 v0, vcc, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: add_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_add_rtn_u32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB2_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_add_u32_e32 v0, vcc, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: add_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_add_rtn_u32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB2_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_add_u32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: add_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_add_rtn_u32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB2_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: add_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_add_rtn_u32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB2_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: add_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB2_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: add_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_add_rtn_u32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB2_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: add_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_add_rtn_u32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: add_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_add_rtn_u32 v0, v3, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB2_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_add_u32_e32 v0, vcc, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: add_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX9_DPP-NEXT:    ds_add_rtn_u32 v0, v3, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB2_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_add_u32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: add_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_DPP-NEXT:    ds_add_rtn_u32 v0, v4, v0
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB2_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: add_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032_DPP-NEXT:    ds_add_rtn_u32 v0, v4, v0
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB2_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: add_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164_DPP-NEXT:    ds_add_rtn_u32 v0, v4, v0
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB2_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: add_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1132_DPP-NEXT:    ds_add_rtn_u32 v0, v4, v0
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB2_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_varying_nouse() {
; GFX7LESS_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB3_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB3_4:
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX8_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB3_4:
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX9_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX9_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB3_4:
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB3_4:
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s2, 1, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s2
; GFX1032_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s0
; GFX1032_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB3_4:
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_ITERATIVE-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB3_4:
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: add_i32_varying_nouse:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s2, 1, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s2
; GFX1132_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB3_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX1132_ITERATIVE-NEXT:    ds_add_u32 v0, v1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB3_4:
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: add_i32_varying_nouse:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    ds_add_u32 v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: add_i32_varying_nouse:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    s_mov_b32 s0, s2
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_add_u32 v2, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB3_2:
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: add_i32_varying_nouse:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    s_mov_b32 s0, s2
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX9_DPP-NEXT:    ds_add_u32 v2, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB3_2:
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: add_i32_varying_nouse:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1064_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_add_i32 s0, s2, s3
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_DPP-NEXT:    ds_add_u32 v0, v3
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB3_2:
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: add_i32_varying_nouse:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1032_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v4
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    ds_add_u32 v0, v3
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB3_2:
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: add_i32_varying_nouse:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    ds_add_u32 v0, v3
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB3_2:
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: add_i32_varying_nouse:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v3, v1
; GFX1132_DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    ds_add_u32 v0, v3
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB3_2:
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add ptr addrspace(3) @local_var32, i32 %lane acq_rel
  ret void
}

define amdgpu_kernel void @add_i64_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: add_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB4_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_mul_i32 s2, s2, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB4_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v0
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s5, v0
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB4_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB4_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    v_readfirstlane_b32 s3, v0
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB4_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_readfirstlane_b32 s2, v1
; GFX9-NEXT:    v_readfirstlane_b32 s3, v0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s2, s2, 5
; GFX1064-NEXT:    v_mov_b32_e32 v0, s2
; GFX1064-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB4_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s1, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s1, s1, 5
; GFX1032-NEXT:    v_mov_b32_e32 v0, s1
; GFX1032-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB4_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, v2, 5, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s2, s2, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v0, s2
; GFX1164-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB4_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s1, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_mul_i32 s1, s1, 5
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_e32 v0, s1
; GFX1132-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB4_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(3) @local_var64, i64 5 acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_uniform(ptr addrspace(1) %out, i64 %additive) {
; GFX7LESS-LABEL: add_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB5_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s7, s3, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s2, v0
; GFX7LESS-NEXT:    s_mul_i32 s6, s2, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s7, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB5_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s1, v0
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s3, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s2, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s2, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s1, v2
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB5_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s8, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[6:7], s2, v0, 0
; GFX8-NEXT:    s_mul_i32 s6, s3, s8
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB5_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_readfirstlane_b32 s5, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v3, s3, v2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s2, v2, v[0:1]
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB5_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB5_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_readfirstlane_b32 s5, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], s2, v2, v[0:1]
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], s3, v2, v[1:2]
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB5_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s7, s3, s6
; GFX1064-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1064-NEXT:    s_mul_i32 s6, s2, s6
; GFX1064-NEXT:    s_add_i32 s8, s8, s7
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    v_mov_b32_e32 v1, s8
; GFX1064-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB5_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], s2, v2, s[4:5]
; GFX1064-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], s3, v2, v[1:2]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB5_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s6, s3, s5
; GFX1032-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1032-NEXT:    s_mul_i32 s5, s2, s5
; GFX1032-NEXT:    s_add_i32 s7, s7, s6
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB5_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, s2, v2, s[4:5]
; GFX1032-NEXT:    v_mad_u64_u32 v[1:2], s2, s3, v2, v[1:2]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB5_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s7, s3, s6
; GFX1164-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1164-NEXT:    s_mul_i32 s6, s2, s6
; GFX1164-NEXT:    s_add_i32 s8, s8, s7
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    v_mov_b32_e32 v1, s8
; GFX1164-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB5_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, s2, v2, s[4:5]
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s3, v2, v[1:2]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB5_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s6, s3, s5
; GFX1132-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1132-NEXT:    s_mul_i32 s5, s2, s5
; GFX1132-NEXT:    s_add_i32 s7, s7, s6
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s7
; GFX1132-NEXT:    ds_add_rtn_u64 v[0:1], v3, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB5_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    v_readfirstlane_b32 s5, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s4, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, s2, v2, s[4:5]
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s3, v2, v[1:2]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    v_mov_b32_e32 v1, v3
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(3) @local_var64, i64 %additive acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: add_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s6
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s6
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s6
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    s_add_u32 s0, s0, s8
; GFX7LESS_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB6_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_add_rtn_u64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB6_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX7LESS_ITERATIVE-NEXT:    v_add_i32_e32 v0, vcc, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    v_addc_u32_e32 v1, vcc, v3, v2, vcc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: add_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s6
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s6
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s6
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_add_u32 s0, s0, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_add_rtn_u64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB6_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX8_ITERATIVE-NEXT:    v_add_u32_e32 v0, vcc, s5, v1
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_addc_u32_e32 v1, vcc, v3, v2, vcc
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: add_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s6
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s6
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s6
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_add_u32 s0, s0, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_add_rtn_u64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB6_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX9_ITERATIVE-NEXT:    v_add_co_u32_e32 v0, vcc, s5, v1
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_addc_co_u32_e32 v1, vcc, v3, v2, vcc
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: add_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s6
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s6
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s6
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s6
; GFX1064_ITERATIVE-NEXT:    s_add_u32 s0, s0, s7
; GFX1064_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s8
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_add_rtn_u64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB6_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc, s2, v1
; GFX1064_ITERATIVE-NEXT:    v_add_co_ci_u32_e32 v1, vcc, s3, v2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: add_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX1032_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_add_rtn_u64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB6_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc_lo, s2, v1
; GFX1032_ITERATIVE-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, s3, v2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: add_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s6, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v2, s6
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s6
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s6
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s6
; GFX1164_ITERATIVE-NEXT:    s_add_u32 s0, s0, s7
; GFX1164_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s8
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_add_rtn_u64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB6_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc, s2, v0
; GFX1164_ITERATIVE-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: add_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX1132_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB6_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_add_rtn_u64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB6_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc_lo, s2, v0
; GFX1132_ITERATIVE-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: add_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_add_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: add_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_add_rtn_u64 v[5:6], v7, v[5:6]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB6_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    v_add_u32_e32 v5, vcc, s5, v5
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_addc_u32_e32 v6, vcc, v0, v6, vcc
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: add_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX9_DPP-NEXT:    ds_add_rtn_u64 v[5:6], v7, v[5:6]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB6_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v5, vcc, s5, v5
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v6, vcc, v0, v6, vcc
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: add_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v2, v1
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v3, v4, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v4
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v3, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v8, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v8, s2, 16
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v8, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v9, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v8, s9, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s8, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v9
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v10, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, s0
; GFX1064_DPP-NEXT:    ds_add_rtn_u64 v[9:10], v0, v[9:10]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB6_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v12, v8
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v10
; GFX1064_DPP-NEXT:    v_add_co_u32 v9, vcc, s3, v11
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v10, vcc, s4, v12, vcc
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[9:10], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: add_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s2
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v2, v1
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v3, v4, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v4
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v3, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v3
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v8, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v9, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v8, s6, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v7, s3, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v9
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v10, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, s0
; GFX1032_DPP-NEXT:    ds_add_rtn_u64 v[9:10], v0, v[9:10]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB6_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v12, v8
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v10
; GFX1032_DPP-NEXT:    v_add_co_u32 v9, vcc_lo, s3, v11
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v10, vcc_lo, s4, v12, vcc_lo
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[9:10], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: add_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v2, s2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_add_rtn_u64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB6_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v8
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32 v7, vcc, s3, v9
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v8, null, s4, v10, vcc
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: add_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s2
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v7, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v8, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v7, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v8
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v9, s1 :: v_dual_mov_b32 v8, s0
; GFX1132_DPP-NEXT:    ds_add_rtn_u64 v[8:9], v0, v[8:9]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB6_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v9
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32 v8, vcc_lo, s3, v10
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v9, null, s4, v11, vcc_lo
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw add ptr addrspace(3) @local_var64, i64 %zext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_varying_nouse() {
; GFX7LESS_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_nop 0
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s5, v1, s4
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s4
; GFX7LESS_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX7LESS_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s5
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB7_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB7_4:
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s4
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s5, v1, s4
; GFX8_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX8_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s5
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s1
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB7_4:
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s4
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s5, v1, s4
; GFX9_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX9_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s5
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s1
; GFX9_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB7_4:
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s5, v0, s4
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v1, s4
; GFX1064_ITERATIVE-NEXT:    s_add_u32 s0, s0, s5
; GFX1064_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s6
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s1
; GFX1064_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB7_4:
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1032_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s4, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s5, v1, s3
; GFX1032_ITERATIVE-NEXT:    s_add_u32 s0, s0, s4
; GFX1032_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s5
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB7_4:
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s4, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s5, v0, s4
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v1, s4
; GFX1164_ITERATIVE-NEXT:    s_add_u32 s0, s0, s5
; GFX1164_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s6
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_ITERATIVE-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s1
; GFX1164_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB7_4:
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: add_i64_varying_nouse:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1132_ITERATIVE-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s4, v0, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s5, v1, s3
; GFX1132_ITERATIVE-NEXT:    s_add_u32 s0, s0, s4
; GFX1132_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s5
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB7_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s0
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s1
; GFX1132_ITERATIVE-NEXT:    ds_add_u64 v2, v[0:1]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB7_4:
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: add_i64_varying_nouse:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    ds_add_u64 v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: add_i64_varying_nouse:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, s1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s0
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_add_u64 v5, v[6:7]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB7_2:
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: add_i64_varying_nouse:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, s1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s0
; GFX9_DPP-NEXT:    ds_add_u64 v5, v[6:7]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB7_2:
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: add_i64_varying_nouse:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v2, v1
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v3, v4, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v4
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v3, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v3, v1, 0, 0
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v4, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s4, v1, 32
; GFX1064_DPP-NEXT:    v_readlane_b32 s5, v2, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_add_u32 s0, s3, s4
; GFX1064_DPP-NEXT:    s_addc_u32 s1, s2, s5
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_add_u64 v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB7_2:
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: add_i64_varying_nouse:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v2, v1
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v3, v4, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v4
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v3, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v3, v1, 0, 0
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v3
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v4, vcc_lo
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v9, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v9
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    ds_add_u64 v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB7_2:
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: add_i64_varying_nouse:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v3, v2, 0, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32 v2, vcc, v2, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v1, 0, 0
; GFX1164_DPP-NEXT:    v_permlane64_b32 v3, v2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    v_permlane64_b32 v4, v1
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_add_co_u32 v2, vcc, v2, v3
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v3, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, v2
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, v3
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v7
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    ds_add_u64 v0, v[5:6]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB7_2:
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: add_i64_varying_nouse:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v3, v2, 0, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v1, 0, 0
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v3, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v5, v2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v6, v3
; GFX1132_DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v7
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    ds_add_u64 v0, v[5:6]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB7_2:
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw add ptr addrspace(3) @local_var64, i64 %zext acq_rel
  ret void
}

define amdgpu_kernel void @sub_i32_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: sub_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB8_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_mul_i32 s2, s2, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB8_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB8_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB8_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB8_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB8_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB8_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s2, s2, 5
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB8_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s1, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB8_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s1, s1, 5
; GFX1032-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB8_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB8_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s2, s2, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB8_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s1, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB8_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_mul_i32 s1, s1, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s1
; GFX1132-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB8_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(3) @local_var32, i32 5 acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_uniform(ptr addrspace(1) %out, i32 %subitive) {
; GFX7LESS-LABEL: sub_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xb
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB9_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s2, s6, s2
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB9_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB9_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s2, s6, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB9_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB9_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s2, s6, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB9_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB9_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s2, s6, s2
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB9_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dword s0, s[4:5], 0x2c
; GFX1032-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB9_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s2, s0, s2
; GFX1032-NEXT:    v_mov_b32_e32 v2, s2
; GFX1032-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB9_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x24
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1032-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b32 s6, s[4:5], 0x2c
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB9_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s2, s6, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB9_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b32 s0, s[4:5], 0x2c
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB9_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s2, s0, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s2
; GFX1132-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB9_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(3) @local_var32, i32 %subitive acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: sub_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB10_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_sub_rtn_u32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB10_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_sub_i32_e32 v0, vcc, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: sub_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_sub_rtn_u32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB10_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_sub_u32_e32 v0, vcc, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: sub_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_sub_rtn_u32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB10_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_sub_u32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: sub_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_sub_rtn_u32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB10_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: sub_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_sub_rtn_u32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB10_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: sub_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_add_i32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB10_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: sub_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB10_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_sub_rtn_u32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB10_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: sub_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_sub_rtn_u32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: sub_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_sub_rtn_u32 v0, v3, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB10_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: sub_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX9_DPP-NEXT:    ds_sub_rtn_u32 v0, v3, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB10_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: sub_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_DPP-NEXT:    ds_sub_rtn_u32 v0, v4, v0
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB10_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: sub_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032_DPP-NEXT:    ds_sub_rtn_u32 v0, v4, v0
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB10_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: sub_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164_DPP-NEXT:    ds_sub_rtn_u32 v0, v4, v0
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB10_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: sub_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1132_DPP-NEXT:    ds_sub_rtn_u32 v0, v4, v0
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB10_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_sub_nc_u32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying_nouse() {
; GFX7LESS_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB11_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB11_4:
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX8_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB11_4:
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX9_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX9_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB11_4:
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB11_4:
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s2, 1, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s2
; GFX1032_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s0
; GFX1032_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB11_4:
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[4:5], 1, s3
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_add_i32 s2, s2, s6
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_ITERATIVE-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB11_4:
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: sub_i32_varying_nouse:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s2, 1, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s2
; GFX1132_ITERATIVE-NEXT:    s_add_i32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX1132_ITERATIVE-NEXT:    ds_sub_u32 v0, v1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB11_4:
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: sub_i32_varying_nouse:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    ds_sub_u32 v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: sub_i32_varying_nouse:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v1, vcc, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    s_mov_b32 s0, s2
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_sub_u32 v2, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB11_2:
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: sub_i32_varying_nouse:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    s_mov_b32 s0, s2
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX9_DPP-NEXT:    ds_sub_u32 v2, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB11_2:
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: sub_i32_varying_nouse:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1064_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_add_i32 s0, s2, s3
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_DPP-NEXT:    ds_sub_u32 v0, v3
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB11_2:
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: sub_i32_varying_nouse:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1032_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v4
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    ds_sub_u32 v0, v3
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB11_2:
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: sub_i32_varying_nouse:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    ds_sub_u32 v0, v3
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB11_2:
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: sub_i32_varying_nouse:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_xmask:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132_DPP-NEXT:    v_add_nc_u32_e32 v1, v1, v2
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v3, v1
; GFX1132_DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    ds_sub_u32 v0, v3
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB11_2:
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub ptr addrspace(3) @local_var32, i32 %lane acq_rel
  ret void
}

define amdgpu_kernel void @sub_i64_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: sub_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB12_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_mul_i32 s2, s2, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s2
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB12_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v0
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s5, v0
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB12_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB12_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_readfirstlane_b32 s5, v0
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX8-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s5, v0
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB12_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_readfirstlane_b32 s5, v0
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX9-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s5, v0
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB12_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s2, s2, 5
; GFX1064-NEXT:    v_mov_b32_e32 v0, s2
; GFX1064-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB12_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s1, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB12_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s1, s1, 5
; GFX1032-NEXT:    v_mov_b32_e32 v0, s1
; GFX1032-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB12_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s3, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB12_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s2, s2, 5
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    v_mov_b32_e32 v0, s2
; GFX1164-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB12_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1164-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s1, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB12_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s1, s1
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    s_mul_i32 s1, s1, 5
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_mov_b32_e32 v0, s1
; GFX1132-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB12_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1132-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(3) @local_var64, i64 5 acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_uniform(ptr addrspace(1) %out, i64 %subitive) {
; GFX7LESS-LABEL: sub_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB13_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s7, s3, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s2, v0
; GFX7LESS-NEXT:    s_mul_i32 s6, s2, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s7, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB13_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s1, v0
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s3, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s2, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s2, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s1, v2
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB13_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s8, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[6:7], s2, v0, 0
; GFX8-NEXT:    s_mul_i32 s6, s3, s8
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB13_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    v_mul_lo_u32 v4, s3, v2
; GFX8-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], s2, v2, 0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    v_readfirstlane_b32 s1, v0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s1, v2
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB13_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB13_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u64_u32 v[3:4], s[8:9], s2, v2, 0
; GFX9-NEXT:    v_readfirstlane_b32 s8, v0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v1
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s3, v2, v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_sub_co_u32_e32 v1, vcc, s8, v3
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v0, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[1:2], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB13_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s7, s3, s6
; GFX1064-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1064-NEXT:    s_mul_i32 s6, s2, s6
; GFX1064-NEXT:    s_add_i32 s8, s8, s7
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    v_mov_b32_e32 v1, s8
; GFX1064-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB13_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], s2, v2, 0
; GFX1064-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1064-NEXT:    v_mad_u64_u32 v[4:5], s[2:3], s3, v2, v[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s4, v4, vcc
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB13_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s6, s3, s5
; GFX1032-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1032-NEXT:    s_mul_i32 s5, s2, s5
; GFX1032-NEXT:    s_add_i32 s7, s7, s6
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB13_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[3:4], s2, s2, v2, 0
; GFX1032-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1032-NEXT:    v_mad_u64_u32 v[4:5], s2, s3, v2, v[4:5]
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s4, v4, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB13_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s7, s3, s6
; GFX1164-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX1164-NEXT:    s_mul_i32 s6, s2, s6
; GFX1164-NEXT:    s_add_i32 s8, s8, s7
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    v_mov_b32_e32 v1, s8
; GFX1164-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB13_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s2, v2, 0
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1164-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-NEXT:    v_mad_u64_u32 v[5:6], null, s3, v2, v[4:5]
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    v_sub_co_ci_u32_e64 v1, null, s4, v5, vcc
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB13_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s6, s3, s5
; GFX1132-NEXT:    s_mul_hi_u32 s7, s2, s5
; GFX1132-NEXT:    s_mul_i32 s5, s2, s5
; GFX1132-NEXT:    s_add_i32 s7, s7, s6
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s7
; GFX1132-NEXT:    ds_sub_rtn_u64 v[0:1], v3, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB13_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s2, v2, 0
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132-NEXT:    v_mad_u64_u32 v[5:6], null, s3, v2, v[4:5]
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    v_sub_co_ci_u32_e64 v1, null, s4, v5, vcc_lo
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(3) @local_var64, i64 %subitive acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: sub_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s6
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s6
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s6
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    s_add_u32 s0, s0, s8
; GFX7LESS_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB14_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB14_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX7LESS_ITERATIVE-NEXT:    v_sub_i32_e32 v0, vcc, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    v_subb_u32_e32 v1, vcc, v3, v2, vcc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: sub_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s6
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s6
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s6
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_add_u32 s0, s0, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB14_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX8_ITERATIVE-NEXT:    v_sub_u32_e32 v0, vcc, s5, v1
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_subb_u32_e32 v1, vcc, v3, v2, vcc
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: sub_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s6
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s6
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s6
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_add_u32 s0, s0, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB14_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX9_ITERATIVE-NEXT:    v_sub_co_u32_e32 v0, vcc, s5, v1
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_subb_co_u32_e32 v1, vcc, v3, v2, vcc
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: sub_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s6, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s6
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s6
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s6
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s6
; GFX1064_ITERATIVE-NEXT:    s_add_u32 s0, s0, s7
; GFX1064_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s8
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB14_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc, s2, v1
; GFX1064_ITERATIVE-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: sub_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX1032_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB14_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v1
; GFX1032_ITERATIVE-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: sub_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s6, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v2, s6
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s6
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s6
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s6
; GFX1164_ITERATIVE-NEXT:    s_add_u32 s0, s0, s7
; GFX1164_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s8
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s6
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB14_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1164_ITERATIVE-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: sub_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    s_add_u32 s0, s0, s6
; GFX1132_ITERATIVE-NEXT:    s_addc_u32 s1, s1, s7
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB14_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_sub_rtn_u64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB14_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1132_ITERATIVE-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: sub_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_sub_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: sub_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB14_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_sub_rtn_u64 v[5:6], v7, v[5:6]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB14_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    v_sub_u32_e32 v5, vcc, s5, v5
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_subb_u32_e32 v6, vcc, v0, v6, vcc
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: sub_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v4
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB14_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX9_DPP-NEXT:    ds_sub_rtn_u64 v[5:6], v7, v[5:6]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB14_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    v_sub_co_u32_e32 v5, vcc, s5, v5
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_subb_co_u32_e32 v6, vcc, v0, v6, vcc
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: sub_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v2, v1
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v3, v4, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v4
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v3, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v8, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v8, s2, 16
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v8, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v9, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v8, s9, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s8, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v9
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB14_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v10, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, s0
; GFX1064_DPP-NEXT:    ds_sub_rtn_u64 v[9:10], v0, v[9:10]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB14_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v12, v8
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v10
; GFX1064_DPP-NEXT:    v_sub_co_u32 v9, vcc, s3, v11
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_sub_co_ci_u32_e32 v10, vcc, s4, v12, vcc
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[9:10], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: sub_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s2
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v2, v1
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v3, v4, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v4
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v3, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v3
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v8, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v9, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v8, s6, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v7, s3, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v9
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB14_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v10, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, s0
; GFX1032_DPP-NEXT:    ds_sub_rtn_u64 v[9:10], v0, v[9:10]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB14_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v12, v8
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v10
; GFX1032_DPP-NEXT:    v_sub_co_u32 v9, vcc_lo, s3, v11
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_sub_co_ci_u32_e32 v10, vcc_lo, s4, v12, vcc_lo
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[9:10], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: sub_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v2, s2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB14_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_sub_rtn_u64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB14_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v8
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_sub_co_u32 v7, vcc, s3, v9
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    v_sub_co_ci_u32_e64 v8, null, s4, v10, vcc
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: sub_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s2
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v7, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v8, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v7, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v8
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB14_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v9, s1 :: v_dual_mov_b32 v8, s0
; GFX1132_DPP-NEXT:    ds_sub_rtn_u64 v[8:9], v0, v[8:9]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB14_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v9
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_sub_co_u32 v8, vcc_lo, s3, v10
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    v_sub_co_ci_u32_e64 v9, null, s4, v11, vcc_lo
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw sub ptr addrspace(3) @local_var64, i64 %zext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @and_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: and_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_and_b32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB15_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_and_rtn_b32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB15_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_and_b32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: and_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_and_b32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_and_rtn_b32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB15_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_and_b32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: and_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_and_b32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_and_rtn_b32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB15_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_and_b32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: and_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_and_b32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_and_rtn_b32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB15_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_and_b32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: and_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_and_b32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_and_rtn_b32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB15_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_and_b32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: and_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_and_b32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_and_rtn_b32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB15_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: and_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_and_b32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB15_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_and_rtn_b32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB15_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: and_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_and_rtn_b32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: and_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB15_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_and_rtn_b32 v0, v0, v3
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB15_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: and_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB15_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX9_DPP-NEXT:    ds_and_rtn_b32 v0, v0, v3
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB15_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: and_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB15_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1064_DPP-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB15_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: and_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB15_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1032_DPP-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB15_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: and_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB15_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1164_DPP-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB15_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: and_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB15_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1132_DPP-NEXT:    ds_and_rtn_b32 v0, v0, v4
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB15_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw and ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @and_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: and_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[8:9], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[8:9]
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB16_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_and_rtn_b64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB16_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7LESS_ITERATIVE-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: and_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_and_rtn_b64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB16_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX8_ITERATIVE-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: and_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_and_rtn_b64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB16_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX9_ITERATIVE-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: and_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX1064_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_and_rtn_b64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB16_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1064_ITERATIVE-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX1064_ITERATIVE-NEXT:    v_and_b32_e32 v1, s3, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: and_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s8
; GFX1032_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_and_rtn_b64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB16_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1032_ITERATIVE-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX1032_ITERATIVE-NEXT:    v_and_b32_e32 v1, s3, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: and_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[8:9]
; GFX1164_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_and_rtn_b64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB16_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, s2, v1
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: and_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB16_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s8
; GFX1132_ITERATIVE-NEXT:    s_and_b64 s[0:1], s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB16_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_and_rtn_b64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB16_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, s2, v1
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: and_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_and_rtn_b64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: and_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v3, -1, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v4, -1, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX8_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, -1
; GFX8_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v3, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v4, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB16_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_and_rtn_b64 v[5:6], v7, v[5:6]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB16_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, v1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_and_b32_e32 v6, s4, v6
; GFX8_DPP-NEXT:    v_and_b32_e32 v5, s5, v5
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: and_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v3, -1, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v4, -1, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX9_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, -1
; GFX9_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_and_b32_dpp v3, v3, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_and_b32_dpp v4, v4, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v3, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v4, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB16_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX9_DPP-NEXT:    ds_and_rtn_b64 v[5:6], v7, v[5:6]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB16_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, v1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_and_b32_e32 v6, s4, v6
; GFX9_DPP-NEXT:    v_and_b32_e32 v5, s5, v5
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: and_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s3
; GFX1064_DPP-NEXT:    v_and_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_and_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v2, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB16_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_and_rtn_b64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB16_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_and_b32_e32 v9, s3, v9
; GFX1064_DPP-NEXT:    v_and_b32_e32 v8, s4, v8
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: and_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, 0, s2
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1032_DPP-NEXT:    v_and_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_and_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB16_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_and_rtn_b64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB16_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_and_b32_e32 v9, s3, v9
; GFX1032_DPP-NEXT:    v_and_b32_e32 v8, s4, v8
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: and_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_and_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_and_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s6, 32
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB16_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_and_rtn_b64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB16_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_and_b32_e32 v9, s3, v9
; GFX1164_DPP-NEXT:    v_and_b32_e32 v8, s4, v8
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: and_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, 0, s2
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, -1 :: v_dual_mov_b32 v5, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_and_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_and_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB16_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_and_rtn_b64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB16_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_and_b32_e32 v9, s3, v9
; GFX1132_DPP-NEXT:    v_and_b32_e32 v8, s4, v8
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw and ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @or_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: or_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_or_b32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB17_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_or_rtn_b32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB17_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_or_b32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: or_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_or_b32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_or_rtn_b32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB17_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_or_b32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: or_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_or_b32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_or_rtn_b32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB17_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_or_b32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: or_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_or_b32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_or_rtn_b32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB17_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_or_b32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: or_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_or_b32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_or_rtn_b32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB17_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_or_b32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: or_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_or_b32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_or_rtn_b32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB17_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: or_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_or_b32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB17_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_or_rtn_b32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB17_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: or_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_or_rtn_b32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: or_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB17_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_or_rtn_b32 v0, v3, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB17_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: or_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB17_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX9_DPP-NEXT:    ds_or_rtn_b32 v0, v3, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB17_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: or_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB17_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_DPP-NEXT:    ds_or_rtn_b32 v0, v4, v0
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB17_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: or_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB17_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032_DPP-NEXT:    ds_or_rtn_b32 v0, v4, v0
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB17_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: or_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB17_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164_DPP-NEXT:    ds_or_rtn_b32 v0, v4, v0
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB17_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: or_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB17_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1132_DPP-NEXT:    ds_or_rtn_b32 v0, v4, v0
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB17_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw or ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @or_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: or_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[8:9], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[8:9]
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB18_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_or_rtn_b64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB18_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    v_or_b32_e32 v2, s4, v2
; GFX7LESS_ITERATIVE-NEXT:    v_or_b32_e32 v1, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: or_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB18_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_or_rtn_b64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB18_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_or_b32_e32 v2, s4, v2
; GFX8_ITERATIVE-NEXT:    v_or_b32_e32 v1, s5, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: or_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB18_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_or_rtn_b64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB18_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_or_b32_e32 v2, s4, v2
; GFX9_ITERATIVE-NEXT:    v_or_b32_e32 v1, s5, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: or_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX1064_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB18_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_or_rtn_b64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB18_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1064_ITERATIVE-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX1064_ITERATIVE-NEXT:    v_or_b32_e32 v1, s3, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: or_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s8
; GFX1032_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB18_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_or_rtn_b64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB18_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1032_ITERATIVE-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX1032_ITERATIVE-NEXT:    v_or_b32_e32 v1, s3, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: or_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[8:9]
; GFX1164_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB18_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_or_rtn_b64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB18_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_ITERATIVE-NEXT:    v_or_b32_e32 v1, s2, v1
; GFX1164_ITERATIVE-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: or_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB18_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s8
; GFX1132_ITERATIVE-NEXT:    s_or_b64 s[0:1], s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB18_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB18_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_or_rtn_b64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB18_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_ITERATIVE-NEXT:    v_or_b32_e32 v1, s2, v1
; GFX1132_ITERATIVE-NEXT:    v_or_b32_e32 v0, s3, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: or_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_or_rtn_b64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: or_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_or_rtn_b64 v[5:6], v7, v[5:6]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB18_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_or_b32_e32 v6, s4, v6
; GFX8_DPP-NEXT:    v_or_b32_e32 v5, s5, v5
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: or_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX9_DPP-NEXT:    ds_or_rtn_b64 v[5:6], v7, v[5:6]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB18_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_or_b32_e32 v6, s4, v6
; GFX9_DPP-NEXT:    v_or_b32_e32 v5, s5, v5
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: or_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_or_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s3
; GFX1064_DPP-NEXT:    v_or_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_or_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v2, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_or_rtn_b64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB18_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_or_b32_e32 v9, s3, v9
; GFX1064_DPP-NEXT:    v_or_b32_e32 v8, s4, v8
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: or_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s2
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1032_DPP-NEXT:    v_or_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_or_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_or_rtn_b64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB18_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_or_b32_e32 v9, s3, v9
; GFX1032_DPP-NEXT:    v_or_b32_e32 v8, s4, v8
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: or_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_or_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_or_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_or_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s6, 32
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_or_rtn_b64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB18_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_or_b32_e32 v9, s3, v9
; GFX1164_DPP-NEXT:    v_or_b32_e32 v8, s4, v8
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: or_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s2
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mov_b32 v5, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_or_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_or_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_or_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_or_rtn_b64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB18_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_or_b32_e32 v9, s3, v9
; GFX1132_DPP-NEXT:    v_or_b32_e32 v8, s4, v8
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw or ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @xor_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: xor_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB19_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_xor_rtn_b32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB19_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: xor_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_xor_b32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB19_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_xor_rtn_b32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB19_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: xor_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_xor_b32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB19_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_xor_rtn_b32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB19_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: xor_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_xor_b32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB19_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_xor_rtn_b32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB19_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: xor_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB19_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_xor_rtn_b32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB19_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: xor_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_xor_b32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB19_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_xor_rtn_b32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB19_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: xor_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB19_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB19_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB19_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_xor_rtn_b32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB19_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: xor_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_xor_rtn_b32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: xor_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_xor_rtn_b32 v0, v3, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB19_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_xor_b32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: xor_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX9_DPP-NEXT:    ds_xor_rtn_b32 v0, v3, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB19_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_xor_b32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: xor_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_DPP-NEXT:    ds_xor_rtn_b32 v0, v4, v0
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB19_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: xor_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032_DPP-NEXT:    ds_xor_rtn_b32 v0, v4, v0
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB19_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: xor_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164_DPP-NEXT:    ds_xor_rtn_b32 v0, v4, v0
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB19_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: xor_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1132_DPP-NEXT:    ds_xor_rtn_b32 v0, v4, v0
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB19_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw xor ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @xor_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: xor_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[8:9], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[8:9]
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB20_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB20_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    v_xor_b32_e32 v2, s4, v2
; GFX7LESS_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: xor_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB20_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB20_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_xor_b32_e32 v2, s4, v2
; GFX8_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s5, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: xor_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s8
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB20_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB20_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_xor_b32_e32 v2, s4, v2
; GFX9_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s5, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: xor_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[8:9]
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB20_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB20_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1064_ITERATIVE-NEXT:    v_xor_b32_e32 v2, s2, v2
; GFX1064_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s3, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: xor_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s8
; GFX1032_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB20_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB20_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1032_ITERATIVE-NEXT:    v_xor_b32_e32 v2, s2, v2
; GFX1032_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s3, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: xor_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[8:9]
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB20_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB20_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s2, v1
; GFX1164_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: xor_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB20_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s8
; GFX1132_ITERATIVE-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB20_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB20_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_xor_rtn_b64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB20_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_ITERATIVE-NEXT:    v_xor_b32_e32 v1, s2, v1
; GFX1132_ITERATIVE-NEXT:    v_xor_b32_e32 v0, s3, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: xor_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_xor_rtn_b64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: xor_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB20_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_xor_rtn_b64 v[5:6], v7, v[5:6]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB20_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_xor_b32_e32 v6, s4, v6
; GFX8_DPP-NEXT:    v_xor_b32_e32 v5, s5, v5
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: xor_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB20_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX9_DPP-NEXT:    ds_xor_rtn_b64 v[5:6], v7, v[5:6]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB20_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_xor_b32_e32 v6, s4, v6
; GFX9_DPP-NEXT:    v_xor_b32_e32 v5, s5, v5
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: xor_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s3
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_xor_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v2, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB20_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_xor_rtn_b64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB20_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_xor_b32_e32 v9, s3, v9
; GFX1064_DPP-NEXT:    v_xor_b32_e32 v8, s4, v8
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: xor_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s2
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_xor_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB20_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_xor_rtn_b64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB20_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_xor_b32_e32 v9, s3, v9
; GFX1032_DPP-NEXT:    v_xor_b32_e32 v8, s4, v8
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: xor_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_xor_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s6, 32
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v2, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v6, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB20_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_xor_rtn_b64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB20_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_xor_b32_e32 v9, s3, v9
; GFX1164_DPP-NEXT:    v_xor_b32_e32 v8, s4, v8
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: xor_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s2
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mov_b32 v5, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v3, v1, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v1, v3, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_xor_b32_dpp v2, v4, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 31
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB20_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_xor_rtn_b64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB20_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v9, v6
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_xor_b32_e32 v9, s3, v9
; GFX1132_DPP-NEXT:    v_xor_b32_e32 v8, s4, v8
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw xor ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @max_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: max_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_brev_b32 s2, 1
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_max_i32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB21_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_max_rtn_i32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB21_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: max_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_brev_b32 s2, 1
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_max_i32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB21_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_max_rtn_i32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB21_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: max_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_brev_b32 s2, 1
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_max_i32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB21_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_max_rtn_i32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB21_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: max_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_brev_b32 s2, 1
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_max_i32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB21_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_max_rtn_i32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB21_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_max_i32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: max_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_brev_b32 s0, 1
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_max_i32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB21_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_max_rtn_i32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB21_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_max_i32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: max_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_brev_b32 s2, 1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_max_i32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB21_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_max_rtn_i32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB21_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: max_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_brev_b32 s0, 1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB21_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_max_i32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB21_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB21_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_max_rtn_i32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB21_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: max_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_max_rtn_i32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: max_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, v1, v0, s[0:1]
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB21_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_max_rtn_i32 v0, v0, v3
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB21_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_max_i32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: max_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, v1, v0, s[0:1]
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB21_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX9_DPP-NEXT:    ds_max_rtn_i32 v0, v0, v3
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB21_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_max_i32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: max_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x80000000, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB21_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1064_DPP-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB21_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: max_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x80000000, v0, s0
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB21_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1032_DPP-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB21_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: max_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x80000000, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB21_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1164_DPP-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB21_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: max_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x80000000, v0, s0
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_max_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_max_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB21_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1132_DPP-NEXT:    ds_max_rtn_i32 v0, v0, v4
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB21_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_max_i32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw max ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @max_i64_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: max_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB22_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB22_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: max_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB22_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB22_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_bfrev_b32_e32 v0, 1
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: max_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB22_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v0, 1
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: max_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB22_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB22_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1064-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: max_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB22_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB22_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1032-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: max_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB22_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB22_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: max_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB22_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    ds_max_rtn_i64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB22_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, 0x80000000, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw max ptr addrspace(3) @local_var64, i64 5 acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @max_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: max_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[0:1], v[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB23_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_max_rtn_i64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB23_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[1:2]
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: max_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX8_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[0:1], v[4:5]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB23_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_max_rtn_i64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB23_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX8_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[1:2]
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: max_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX9_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[0:1], v[4:5]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB23_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_max_rtn_i64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB23_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX9_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[1:2]
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: max_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    v_cmp_gt_i64_e64 s[8:9], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB23_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_max_rtn_i64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB23_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[1:2]
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: max_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    v_cmp_gt_i64_e64 s8, s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB23_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_max_rtn_i64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB23_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[1:2]
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc_lo
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: max_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:    .p2align 6
; GFX1164_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    v_cmp_gt_i64_e64 s[8:9], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB23_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_max_rtn_i64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB23_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: max_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_brev_b32 s1, 1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:    .p2align 6
; GFX1132_ITERATIVE-NEXT:  .LBB23_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    v_cmp_gt_i64_e64 s8, s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB23_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB23_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_max_rtn_i64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB23_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: max_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_max_rtn_i64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: max_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v9, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v7
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v4, v2, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB23_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v8, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_max_rtn_i64 v[7:8], v9, v[7:8]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB23_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX8_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[7:8]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v7, v7, v0, vcc
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: max_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v9, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v7
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v4, v2, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB23_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v8, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, s2
; GFX9_DPP-NEXT:    ds_max_rtn_i64 v[7:8], v9, v[7:8]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB23_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX9_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[7:8]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v7, v7, v0, vcc
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: max_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB23_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_max_rtn_i64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB23_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[7:8]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: max_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, 0, s2
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s2
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB23_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_max_rtn_i64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB23_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: max_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB23_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_max_rtn_i64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB23_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_cmp_gt_i64_e32 vcc, s[4:5], v[7:8]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: max_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, 0, s2
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s2
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB23_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_max_rtn_i64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB23_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw max ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @min_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: min_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_brev_b32 s2, -2
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_min_i32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB24_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_min_rtn_i32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB24_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: min_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_brev_b32 s2, -2
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_min_i32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB24_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_min_rtn_i32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB24_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: min_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_brev_b32 s2, -2
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_min_i32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB24_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_min_rtn_i32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB24_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: min_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_brev_b32 s2, -2
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_min_i32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB24_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_min_rtn_i32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB24_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_min_i32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: min_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_brev_b32 s0, -2
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_min_i32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB24_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_min_rtn_i32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB24_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_min_i32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: min_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_brev_b32 s2, -2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_min_i32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB24_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_min_rtn_i32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB24_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_min_i32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: min_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_brev_b32 s0, -2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB24_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_min_i32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB24_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB24_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_min_rtn_i32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB24_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_min_i32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: min_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_min_rtn_i32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: min_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, v1, v0, s[0:1]
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB24_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_min_rtn_i32 v0, v0, v3
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB24_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_min_i32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: min_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, v1, v0, s[0:1]
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_i32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB24_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX9_DPP-NEXT:    ds_min_rtn_i32 v0, v0, v3
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB24_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_min_i32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: min_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x7fffffff, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1064_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB24_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1064_DPP-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB24_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: min_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x7fffffff, v0, s0
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1032_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB24_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1032_DPP-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB24_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: min_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x7fffffff, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB24_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1164_DPP-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB24_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: min_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0x7fffffff, v0, s0
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v3, -2
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_min_i32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_min_i32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB24_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1132_DPP-NEXT:    ds_min_rtn_i32 v0, v0, v4
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB24_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_min_i32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw min ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @min_i64_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: min_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB25_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB25_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: min_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB25_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB25_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_bfrev_b32_e32 v0, -2
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: min_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB25_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB25_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v0, -2
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: min_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB25_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB25_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1064-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: min_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB25_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB25_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1032-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: min_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB25_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB25_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: min_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB25_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    ds_min_rtn_i64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB25_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, 0x7fffffff, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw min ptr addrspace(3) @local_var64, i64 5 acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @min_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: min_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[0:1], v[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB26_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_min_rtn_i64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB26_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[1:2]
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: min_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX8_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[0:1], v[4:5]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB26_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_min_rtn_i64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB26_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX8_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[1:2]
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: min_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX9_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[0:1], v[4:5]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB26_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_min_rtn_i64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB26_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX9_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[1:2]
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: min_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    v_cmp_lt_i64_e64 s[8:9], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB26_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_min_rtn_i64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB26_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[1:2]
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: min_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    v_cmp_lt_i64_e64 s8, s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB26_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_min_rtn_i64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB26_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[2:3], v[1:2]
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc_lo
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: min_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:    .p2align 6
; GFX1164_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    v_cmp_lt_i64_e64 s[8:9], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB26_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_min_rtn_i64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB26_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: min_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_brev_b32 s1, -2
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:    .p2align 6
; GFX1132_ITERATIVE-NEXT:  .LBB26_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    v_cmp_lt_i64_e64 s8, s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB26_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB26_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_min_rtn_i64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB26_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: min_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_min_rtn_i64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: min_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v9, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v7
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v2, -2
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v4, v2, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v3, -1, v0, s[0:1]
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB26_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v8, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_min_rtn_i64 v[7:8], v9, v[7:8]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB26_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX8_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[7:8]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v7, v7, v0, vcc
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: min_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v9, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v7
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v2, -2
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v4, v2, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v3, -1, v0, s[0:1]
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v6, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[3:4], v[5:6]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB26_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v8, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, s2
; GFX9_DPP-NEXT:    ds_min_rtn_i64 v[7:8], v9, v[7:8]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB26_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX9_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[7:8]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v7, v7, v0, vcc
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: min_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fffffff, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_bfrev_b32_e32 v5, -2
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB26_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_min_rtn_i64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB26_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[7:8]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: min_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fffffff, 0, s2
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s2
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_bfrev_b32_e32 v5, -2
; GFX1032_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB26_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_min_rtn_i64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB26_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: min_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fffffff, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_bfrev_b32_e32 v5, -2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB26_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_min_rtn_i64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB26_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[7:8]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: min_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fffffff, 0, s2
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s2
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v6, -2
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v4, -2
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_bfrev_b32_e32 v5, -2
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB26_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_min_rtn_i64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB26_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_cmp_lt_i64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw min ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @umax_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: umax_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_max_u32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB27_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_max_rtn_u32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB27_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: umax_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_max_u32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB27_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_max_rtn_u32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB27_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: umax_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_max_u32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB27_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_max_rtn_u32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB27_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: umax_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_max_u32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB27_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_max_rtn_u32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB27_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_max_u32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: umax_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_max_u32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB27_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_max_rtn_u32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB27_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_max_u32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: umax_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_max_u32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB27_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_max_rtn_u32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB27_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_max_u32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: umax_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB27_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_max_u32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB27_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB27_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_max_rtn_u32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB27_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_max_u32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: umax_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_max_rtn_u32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: umax_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB27_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_max_rtn_u32 v0, v3, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB27_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_max_u32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: umax_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v4
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB27_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s2
; GFX9_DPP-NEXT:    ds_max_rtn_u32 v0, v3, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB27_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_max_u32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: umax_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB27_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_DPP-NEXT:    ds_max_rtn_u32 v0, v4, v0
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB27_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: umax_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB27_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032_DPP-NEXT:    ds_max_rtn_u32 v0, v4, v0
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB27_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: umax_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB27_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164_DPP-NEXT:    ds_max_rtn_u32 v0, v4, v0
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB27_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: umax_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_max_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_max_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB27_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX1132_DPP-NEXT:    ds_max_rtn_u32 v0, v4, v0
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB27_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_max_u32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw umax ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @umax_i64_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: umax_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB28_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB28_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s5
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: umax_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB28_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB28_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: umax_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB28_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB28_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: umax_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB28_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB28_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1064-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: umax_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB28_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB28_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1032-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: umax_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB28_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB28_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: umax_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB28_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    ds_max_rtn_u64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB28_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, 0, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, s3, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw umax ptr addrspace(3) @local_var64, i64 5 acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @umax_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: umax_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB29_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_max_rtn_u64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB29_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[1:2]
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: umax_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX8_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB29_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_max_rtn_u64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB29_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX8_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[1:2]
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: umax_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX9_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB29_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_max_rtn_u64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB29_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX9_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[1:2]
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: umax_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    v_cmp_gt_u64_e64 s[8:9], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB29_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_max_rtn_u64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB29_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[1:2]
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: umax_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    v_cmp_gt_u64_e64 s8, s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB29_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_max_rtn_u64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB29_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[1:2]
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc_lo
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: umax_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:    .p2align 6
; GFX1164_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_cmp_gt_u64_e64 s[8:9], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB29_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_max_rtn_u64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB29_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: umax_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:    .p2align 6
; GFX1132_ITERATIVE-NEXT:  .LBB29_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_gt_u64_e64 s8, s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB29_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB29_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_max_rtn_u64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB29_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: umax_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_max_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: umax_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v3, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB29_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_max_rtn_u64 v[5:6], v7, v[5:6]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB29_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v6
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v5
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX8_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[5:6]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v6, v6, v0, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v5, v5, v0, vcc
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: umax_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v5, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v5, exec_hi, v5
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v3, v1 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr5_vgpr6
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB29_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX9_DPP-NEXT:    ds_max_rtn_u64 v[5:6], v7, v[5:6]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB29_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v6
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v5
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, v3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v4
; GFX9_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[5:6]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v6, v6, v0, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v5, v5, v0, vcc
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[5:6], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: umax_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB29_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_max_rtn_u64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB29_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[7:8]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: umax_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB29_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_max_rtn_u64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB29_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: umax_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB29_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_max_rtn_u64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB29_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[7:8]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: umax_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, 0
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mov_b32 v5, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mov_b32 v5, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v5, 0 :: v_dual_cndmask_b32 v2, v4, v2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB29_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_max_rtn_u64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB29_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw umax ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @umin_i32_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: umin_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_min_u32 s2, s2, s8
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB30_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_min_rtn_u32 v0, v0, v2
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB30_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: umin_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX8_ITERATIVE-NEXT:    s_min_u32 s2, s2, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB30_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_min_rtn_u32 v0, v0, v2
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB30_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: umin_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s3
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, m0
; GFX9_ITERATIVE-NEXT:    s_min_u32 s2, s2, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB30_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX9_ITERATIVE-NEXT:    ds_min_rtn_u32 v0, v0, v2
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB30_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: umin_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s3, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s3
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_min_u32 s2, s2, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB30_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_ITERATIVE-NEXT:    ds_min_rtn_u32 v0, v0, v2
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB30_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_min_u32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: umin_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s2, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s2
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s1, s1, s6
; GFX1032_ITERATIVE-NEXT:    s_min_u32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB30_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1032_ITERATIVE-NEXT:    ds_min_rtn_u32 v0, v0, v2
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB30_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_min_u32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: umin_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s3, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s3
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s3
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_min_u32 s2, s2, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB30_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_ITERATIVE-NEXT:    ds_min_rtn_u32 v1, v1, v2
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB30_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_min_u32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: umin_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, -1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB30_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s2, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v1, s2
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s6, 1, s2
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s2
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s1, s1, s6
; GFX1132_ITERATIVE-NEXT:    s_min_u32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB30_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB30_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_min_rtn_u32 v1, v1, v2
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB30_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_min_u32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: umin_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_min_rtn_u32 v0, v1, v0
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: umin_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB30_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_min_rtn_u32 v0, v0, v3
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB30_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_min_u32_e32 v0, s4, v0
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: umin_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_min_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v2, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB30_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v3, s2
; GFX9_DPP-NEXT:    ds_min_rtn_u32 v0, v0, v3
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB30_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_min_u32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: umin_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB30_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1064_DPP-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB30_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: umin_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB30_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1032_DPP-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB30_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: umin_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s3, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s2, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB30_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s6
; GFX1164_DPP-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB30_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: umin_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_min_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    v_min_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s1, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s0, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB30_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, s0
; GFX1132_DPP-NEXT:    ds_min_rtn_u32 v0, v0, v4
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB30_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_min_u32_e32 v0, s3, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw umin ptr addrspace(3) @local_var32, i32 %lane acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @umin_i64_constant(ptr addrspace(1) %out) {
; GFX7LESS-LABEL: umin_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB31_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 5
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    s_mov_b32 m0, -1
; GFX7LESS-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:  .LBB31_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[0:1]
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: umin_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB31_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB31_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: umin_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB31_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 5
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:  .LBB31_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: umin_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB31_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, 5
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB31_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1064-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1064-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: umin_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB31_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, 5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB31_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1032-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1032-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: umin_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1164-NEXT:    s_cbranch_execz .LBB31_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    v_mov_b32_e32 v0, 5
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB31_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1164-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: umin_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1132-NEXT:    s_cbranch_execz .LBB31_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    v_mov_b32_e32 v0, 5
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, 0
; GFX1132-NEXT:    ds_min_rtn_u64 v[0:1], v2, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB31_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, 5, -1, vcc_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
entry:
  %old = atomicrmw umin ptr addrspace(3) @local_var64, i64 5 acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @umin_i64_varying(ptr addrspace(1) %out) {
; GFX7LESS_ITERATIVE-LABEL: umin_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX7LESS_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[2:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB32_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_ITERATIVE-NEXT:    ds_min_rtn_u64 v[3:4], v0, v[3:4]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:  .LBB32_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[1:2]
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: umin_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX8_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[4:5]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX8_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX8_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB32_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, -1
; GFX8_ITERATIVE-NEXT:    ds_min_rtn_u64 v[3:4], v0, v[3:4]
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:  .LBB32_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX8_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[1:2]
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: umin_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s8, s[2:3]
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s9, v3, s8
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s10, v0, s8
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s10
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v5, s9
; GFX9_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[4:5]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s8
; GFX9_ITERATIVE-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, m0
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, m0
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s9
; GFX9_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s10
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s8
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB32_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX9_ITERATIVE-NEXT:    ds_min_rtn_u64 v[3:4], v0, v[3:4]
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:  .LBB32_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v3
; GFX9_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[1:2]
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: umin_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s10, s[2:3]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s10
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s10
; GFX1064_ITERATIVE-NEXT:    v_cmp_lt_u64_e64 s[8:9], s[0:1], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1064_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[6:7]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB32_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1064_ITERATIVE-NEXT:    ds_min_rtn_u64 v[3:4], v0, v[3:4]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB32_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[1:2]
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc
; GFX1064_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: umin_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s1, s3
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s0, s3
; GFX1032_ITERATIVE-NEXT:    v_cmp_lt_u64_e64 s8, s[0:1], s[6:7]
; GFX1032_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1032_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s2, s2, s3
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB32_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s1
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s0
; GFX1032_ITERATIVE-NEXT:    ds_min_rtn_u64 v[3:4], v0, v[3:4]
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB32_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[2:3], v[1:2]
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v2, v2, s3, vcc_lo
; GFX1032_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: umin_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:    .p2align 6
; GFX1164_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s10
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s10
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s10
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_cmp_lt_u64_e64 s[8:9], s[0:1], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_and_b64 s[8:9], s[8:9], exec
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1164_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[6:7], 1, s10
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[6:7]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB32_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[2:3], exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s1
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1164_ITERATIVE-NEXT:    ds_min_rtn_u64 v[2:3], v4, v[2:3]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB32_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc
; GFX1164_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: umin_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[0:1], -1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:    .p2align 6
; GFX1132_ITERATIVE-NEXT:  .LBB32_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s7, v3, s3
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s6, v2, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s1, s3
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_lt_u64_e64 s8, s[0:1], s[6:7]
; GFX1132_ITERATIVE-NEXT:    s_and_b32 s8, s8, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s1, s1, s7
; GFX1132_ITERATIVE-NEXT:    s_cselect_b32 s0, s0, s6
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s3
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB32_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s2, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB32_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s1
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s0
; GFX1132_ITERATIVE-NEXT:    ds_min_rtn_u64 v[2:3], v4, v[2:3]
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB32_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132_ITERATIVE-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[2:3], v[0:1]
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v1, v1, s3, vcc_lo
; GFX1132_ITERATIVE-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: umin_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 m0, -1
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    ds_min_rtn_u64 v[0:1], v1, v[0:1]
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: umin_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v3, -1, 0, s[0:1]
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, -1
; GFX8_DPP-NEXT:    v_readlane_b32 s3, v3, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s2, v4, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB32_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s2
; GFX8_DPP-NEXT:    s_mov_b32 m0, -1
; GFX8_DPP-NEXT:    ds_min_rtn_u64 v[6:7], v8, v[6:7]
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:  .LBB32_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v7
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, v2
; GFX8_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[6:7]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v7, v7, v0, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e32 v6, v6, v0, vcc
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[6:7], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: umin_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v3, -1, 0, s[0:1]
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, v0, s[0:1]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, -1
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[4:5]
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, -1
; GFX9_DPP-NEXT:    v_readlane_b32 s3, v3, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s2, v4, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB32_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s2
; GFX9_DPP-NEXT:    ds_min_rtn_u64 v[6:7], v8, v[6:7]
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:  .LBB32_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v7
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v6
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, v2
; GFX9_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[6:7]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s5
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v7, v7, v0, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e32 v6, v6, v0, vcc
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[6:7], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: umin_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1064_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB32_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1064_DPP-NEXT:    ds_min_rtn_u64 v[7:8], v0, v[7:8]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB32_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1064_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064_DPP-NEXT:    s_mov_b32 null, 0
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[7:8]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: umin_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, 0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s2
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1032_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1032_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1032_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB32_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1032_DPP-NEXT:    ds_min_rtn_u64 v[7:8], v0, v[7:8]
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB32_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032_DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_mov_b32 null, 0
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[7:8], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: umin_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[5:6]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, s2
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, v[1:2], v[3:4]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, -1
; GFX1164_DPP-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s2, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s3, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s3, v2, 63
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 47
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s6, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s8, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s9, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1164_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB32_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, s1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s0
; GFX1164_DPP-NEXT:    ds_min_rtn_u64 v[7:8], v0, v[7:8]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB32_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[7:8]
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: umin_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v2, -1, 0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, -1 :: v_dual_mov_b32 v3, -1
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, -1, v0, s2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, -1 :: v_dual_mov_b32 v5, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, -1 :: v_dual_mov_b32 v3, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v6, -1 :: v_dual_mov_b32 v5, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, -1 :: v_dual_mov_b32 v3, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[5:6]
; GFX1132_DPP-NEXT:    v_dual_cndmask_b32 v2, v6, v2 :: v_dual_cndmask_b32 v1, v5, v1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v6, v1, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v5 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[1:2], v[3:4]
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v5, -1 :: v_dual_cndmask_b32 v2, v4, v2
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, -1 :: v_dual_cndmask_b32 v1, v3, v1
; GFX1132_DPP-NEXT:    v_readlane_b32 s3, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s1, v2, 31
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_readlane_b32 s0, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v5, s3, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s2
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1132_DPP-NEXT:    s_mov_b32 s2, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr7_vgpr8
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB32_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v8, s1 :: v_dual_mov_b32 v7, s0
; GFX1132_DPP-NEXT:    ds_min_rtn_u64 v[7:8], v0, v[7:8]
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB32_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132_DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v7, v4
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v8, v5
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[4:5], v[7:8]
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v8, v8, s5, vcc_lo
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v7, v7, s4, vcc_lo
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    buffer_store_b64 v[7:8], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %lane_ext = zext i32 %lane to i64
  %old = atomicrmw umin ptr addrspace(3) @local_var32, i64 %lane_ext acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}
