; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=sparcv9 | FileCheck %s -check-prefix=V9
; RUN: llc < %s -mtriple=sparcv9 -mattr=vis3 | FileCheck %s -check-prefix=VIS3

define i32 @stow(float %float) nounwind {
; V9-LABEL: stow:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    st %f1, [%sp+2187]
; V9-NEXT:    ld [%sp+2187], %o0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: stow:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movstouw %f1, %o0
  %w = bitcast float %float to i32
  ret i32 %w
}

define zeroext i32 @stouw(float %float) nounwind {
; V9-LABEL: stouw:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    st %f1, [%sp+2187]
; V9-NEXT:    ld [%sp+2187], %o0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: stouw:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movstouw %f1, %o0
  %uw = bitcast float %float to i32
  ret i32 %uw
}

define signext i32 @stosw(float %float) nounwind {
; V9-LABEL: stosw:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    st %f1, [%sp+2187]
; V9-NEXT:    ldsw [%sp+2187], %o0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: stosw:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movstosw %f1, %o0
  %sw = bitcast float %float to i32
  ret i32 %sw
}

define float @wtos(i32 %w) nounwind {
; V9-LABEL: wtos:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    st %o0, [%sp+2187]
; V9-NEXT:    ld [%sp+2187], %f0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: wtos:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movwtos %o0, %f0
  %float = bitcast i32 %w to float
  ret float %float
}

define float @uwtos(i32 zeroext %uw) nounwind {
; V9-LABEL: uwtos:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    st %o0, [%sp+2187]
; V9-NEXT:    ld [%sp+2187], %f0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: uwtos:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movwtos %o0, %f0
  %float = bitcast i32 %uw to float
  ret float %float
}

define float @swtos(i32 signext %sw) nounwind {
; V9-LABEL: swtos:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    st %o0, [%sp+2187]
; V9-NEXT:    ld [%sp+2187], %f0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: swtos:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movwtos %o0, %f0
  %float = bitcast i32 %sw to float
  ret float %float
}

define i64 @dtox(double %double) nounwind {
; V9-LABEL: dtox:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    std %f0, [%sp+2183]
; V9-NEXT:    ldx [%sp+2183], %o0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: dtox:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movdtox %f0, %o0
  %x = bitcast double %double to i64
  ret i64 %x
}

define double @xtod(i64 %x) nounwind {
; V9-LABEL: xtod:
; V9:       ! %bb.0:
; V9-NEXT:    add %sp, -144, %sp
; V9-NEXT:    stx %o0, [%sp+2183]
; V9-NEXT:    ldd [%sp+2183], %f0
; V9-NEXT:    retl
; V9-NEXT:    add %sp, 144, %sp
;
; VIS3-LABEL: xtod:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    retl
; VIS3-NEXT:    movxtod %o0, %f0
  %double = bitcast i64 %x to double
  ret double %double
}
