/*
 * OpenFEC.org AL-FEC Library.
 * (c) Copyright 2009 - 2012 INRIA - All rights reserved
 * (c) Copyright 2024 Roc Streaming authors
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */

#ifndef OF_BUILD_CONFIG_H
#define OF_BUILD_CONFIG_H

/*
 * Here we enable or disable encoder and decoder support.
 */
#define OF_USE_ENCODER
#define OF_USE_DECODER

/*
 * Here we enable or disable certain codecs (a.k.a. FEC schemes).
 *
 * By default most codecs are enabled.
 *
 * Disabling codecs prevents the compiler to read associated code
 * during compilation.
 *
 * Removing codecs known to be useless can be important for highly
 * specialized usage of OpenFEC, like embedded systems.
 *
 * Removing codecs may be also needed due to licensing issues.
 */
#define OF_USE_REED_SOLOMON_CODEC
#define OF_USE_REED_SOLOMON_2_M_CODEC
#define OF_USE_LDPC_STAIRCASE_CODEC
#define OF_USE_2D_PARITY_MATRIX_CODEC
/* #undef OF_USE_LDPC_FROM_FILE_CODEC */

/*
 * Here we enable or disable certain solving systems.
 *
 * By default all systems are considered.
 *
 * Note that the above codecs require certain solving systems.
 * For instance, LDPC-staircase requires IT decoding, and ML
 * decoding is highly recommended for improved performances.
 *
 * Removing solving systems known to be useless can be important
 * for highly specialized usage of OpenFEC, like embedded systems.
 */
#define OF_USE_LINEAR_BINARY_CODES_UTILS
#define OF_USE_GALOIS_FIELD_CODES_UTILS

/*
 * Define if you want to enable the use of the ML (Maximum Likelyhood) decoding.
 * If enabled, in practice decoding will start with IT decoding and end with ML
 * decoding (in this case a Gaussian Elimination) if needed.
 *
 * Warning: ML decoding enables to reach the best erasure recovery capabilities,
 * at the expense of potentially significant computation loads, depending on
 * the size and complexity of the simplified system at the end of IT decoding.
 *
 * See the MAX_NB_SOURCE_SYMBOLS_DEFAULT/MAX_NB_ENCODING_SYMBOLS_DEFAULT
 * constants that enable to limit the computation overheads.
 */
#define ML_DECODING

/*
 * Define if you need SSE optimizations for XOR operations.
 * This is useful for PC usage, with processors that support this
 * extension (i.e. all the processors except the very old ones).
 *
 * NB: if SSE is not defined, then we'll use regular XOR operations,
 * either on 32 bit or 64 bit integers depending on the operating
 * system.
 */
/* #undef ASSEMBLY_SSE_OPT */

#endif // OF_BUILD_CONFIG_H
