/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.sql;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.columnar.ColumnarDataSource;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.RowProcessor;
import org.tribuo.data.sql.ResultSetIterator;
import org.tribuo.data.sql.SQLDBConfig;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;

public class SQLDataSource<T extends Output<T>>
extends ColumnarDataSource<T>
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(SQLDataSource.class.getName());
    @Config(mandatory=true, description="Database configuration.")
    private SQLDBConfig sqlConfig;
    @Config(mandatory=true, description="SQL query to run.")
    private String sqlString;
    private final Set<Statement> statements = new HashSet<Statement>();

    private SQLDataSource() {
    }

    public SQLDataSource(String sqlString, SQLDBConfig sqlConfig, OutputFactory<T> outputFactory, RowProcessor<T> rowProcessor, boolean outputRequired) throws SQLException {
        super(outputFactory, rowProcessor, outputRequired);
        this.sqlConfig = sqlConfig;
        this.sqlString = sqlString;
    }

    public String toString() {
        return "SQLDataSource(sqlString=\"" + this.sqlString + "\", sqlConfig=\"" + this.sqlConfig.toString() + "\", rowProcessor=" + this.rowProcessor.getDescription() + ")";
    }

    @Override
    public ColumnarIterator rowIterator() {
        try {
            Statement stmt = this.sqlConfig.getStatement();
            this.statements.add(stmt);
            return new ResultSetIterator(stmt.executeQuery(this.sqlString), stmt.getFetchSize());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Error Processing SQL", e);
        }
    }

    @Override
    public void close() {
        for (Statement statement : this.statements) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Error closing statement", e);
            }
        }
        this.statements.clear();
    }

    public ConfiguredDataSourceProvenance getProvenance() {
        return new SQLDataSourceProvenance(this);
    }

    public static class SQLDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance dataSourceCreationTime;

        <T extends Output<T>> SQLDataSourceProvenance(SQLDataSource<T> host) {
            super(host, "DataSource");
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
        }

        public SQLDataSourceProvenance(Map<String, Provenance> map) {
            this(SQLDataSourceProvenance.extractProvenanceInfo(map));
        }

        private SQLDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)SQLDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)SQLDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, Provenance> instanceParameters = new HashMap<String, Provenance>();
            instanceParameters.put("datasource-creation-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)SQLDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SQLDataSourceProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SQLDataSourceProvenance pairs = (SQLDataSourceProvenance)((Object)o);
            return this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dataSourceCreationTime);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            Map map = super.getInstanceValues();
            map.put("datasource-creation-time", this.dataSourceCreationTime);
            return map;
        }
    }
}

