/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.impl.SimpleClusterAbstractionsImpl;

public class PlacementRequestImpl
implements PlacementRequest {
    private final SolrCollection solrCollection;
    private final Set<String> shardNames;
    private final Set<Node> targetNodes;
    private final EnumMap<Replica.ReplicaType, Integer> countReplicas = new EnumMap(Replica.ReplicaType.class);

    public PlacementRequestImpl(SolrCollection solrCollection, Set<String> shardNames, Set<Node> targetNodes, int countNrtReplicas, int countTlogReplicas, int countPullReplicas) {
        this.solrCollection = solrCollection;
        this.shardNames = shardNames;
        this.targetNodes = targetNodes;
        this.countReplicas.put(Replica.ReplicaType.NRT, countNrtReplicas);
        this.countReplicas.put(Replica.ReplicaType.TLOG, countTlogReplicas);
        this.countReplicas.put(Replica.ReplicaType.PULL, countPullReplicas);
    }

    @Override
    public SolrCollection getCollection() {
        return this.solrCollection;
    }

    @Override
    public Set<String> getShardNames() {
        return this.shardNames;
    }

    @Override
    public Set<Node> getTargetNodes() {
        return this.targetNodes;
    }

    @Override
    public int getCountReplicasToCreate(Replica.ReplicaType replicaType) {
        return this.countReplicas.get((Object)replicaType);
    }

    static PlacementRequestImpl toPlacementRequest(Cluster cluster, SolrCollection solrCollection, Assign.AssignRequest assignRequest) throws Assign.AssignmentException {
        Set<Node> nodes;
        HashSet<String> shardNames = new HashSet<String>(assignRequest.shardNames);
        if (shardNames.size() < 1) {
            throw new Assign.AssignmentException("Bad assign request: no shards specified for collection " + solrCollection.getName());
        }
        if (assignRequest.nodes != null) {
            nodes = SimpleClusterAbstractionsImpl.NodeImpl.getNodes(assignRequest.nodes);
            for (Node n : nodes) {
                if (cluster.getLiveDataNodes().contains(n)) continue;
                throw new Assign.AssignmentException("Bad assign request: specified node is a non-data hosting node (" + n.getName() + ") for collection " + solrCollection.getName());
            }
            if (nodes.isEmpty()) {
                throw new Assign.AssignmentException("Bad assign request: empty list of nodes for collection " + solrCollection.getName());
            }
        } else {
            nodes = cluster.getLiveDataNodes();
            if (nodes.isEmpty()) {
                throw new Assign.AssignmentException("Impossible assign request: no live nodes for collection " + solrCollection.getName());
            }
        }
        return new PlacementRequestImpl(solrCollection, shardNames, nodes, assignRequest.numNrtReplicas, assignRequest.numTlogReplicas, assignRequest.numPullReplicas);
    }
}

