/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.stats.HttpClientMetricNameStrategy;
import org.apache.solr.util.stats.InstrumentedHttpListenerFactory;
import org.apache.solr.util.stats.InstrumentedHttpRequestExecutor;
import org.apache.solr.util.stats.InstrumentedPoolingHttpClientConnectionManager;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler
implements SolrInfoBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExecutorService updateExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("updateExecutor"), false);
    private ExecutorService recoveryExecutor;
    private final Http2SolrClient updateOnlyClient;
    private final Http2SolrClient recoveryOnlyClient;
    private final CloseableHttpClient defaultClient;
    private final InstrumentedPoolingHttpClientConnectionManager defaultConnectionManager = new InstrumentedPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)HttpClientUtil.getSocketFactoryRegistryProvider().getSocketFactoryRegistry());
    private final InstrumentedHttpRequestExecutor httpRequestExecutor;
    private final InstrumentedHttpListenerFactory trackHttpSolrMetrics;
    private SolrMetricsContext solrMetricsContext;
    private int socketTimeout = 600000;
    private int connectionTimeout = 60000;

    public UpdateShardHandler(UpdateShardHandlerConfig cfg) {
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        if (cfg != null) {
            this.defaultConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.defaultConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
            clientParams.set("socketTimeout", cfg.getDistributedSocketTimeout());
            clientParams.set("connTimeout", cfg.getDistributedConnectionTimeout());
            clientParams.set("maxConnections", cfg.getMaxUpdateConnections());
            clientParams.set("maxConnectionsPerHost", cfg.getMaxUpdateConnectionsPerHost());
            this.socketTimeout = cfg.getDistributedSocketTimeout();
            this.connectionTimeout = cfg.getDistributedConnectionTimeout();
        }
        log.debug("Created default UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        this.httpRequestExecutor = new InstrumentedHttpRequestExecutor(this.getMetricNameStrategy(cfg));
        this.trackHttpSolrMetrics = new InstrumentedHttpListenerFactory(this.getNameStrategy(cfg));
        this.defaultClient = HttpClientUtil.createClient((SolrParams)clientParams, (PoolingHttpClientConnectionManager)this.defaultConnectionManager, (boolean)false, (HttpRequestExecutor)this.httpRequestExecutor);
        Set<String> urlParamNames = Set.of("distrib.from", "update.distrib");
        Http2SolrClient.Builder updateOnlyClientBuilder = new Http2SolrClient.Builder();
        Http2SolrClient.Builder recoveryOnlyClientBuilder = new Http2SolrClient.Builder();
        if (cfg != null) {
            ((Http2SolrClient.Builder)((Http2SolrClient.Builder)updateOnlyClientBuilder.withConnectionTimeout((long)cfg.getDistributedConnectionTimeout(), TimeUnit.MILLISECONDS)).withIdleTimeout((long)cfg.getDistributedSocketTimeout(), TimeUnit.MILLISECONDS)).withMaxConnectionsPerHost(cfg.getMaxUpdateConnectionsPerHost());
            ((Http2SolrClient.Builder)((Http2SolrClient.Builder)recoveryOnlyClientBuilder.withConnectionTimeout((long)cfg.getDistributedConnectionTimeout(), TimeUnit.MILLISECONDS)).withIdleTimeout((long)cfg.getDistributedSocketTimeout(), TimeUnit.MILLISECONDS)).withMaxConnectionsPerHost(cfg.getMaxUpdateConnectionsPerHost());
        }
        updateOnlyClientBuilder.withTheseParamNamesInTheUrl(urlParamNames);
        this.updateOnlyClient = updateOnlyClientBuilder.build();
        this.updateOnlyClient.addListenerFactory((HttpListenerFactory)this.trackHttpSolrMetrics);
        this.recoveryOnlyClient = recoveryOnlyClientBuilder.build();
        this.recoveryOnlyClient.addListenerFactory((HttpListenerFactory)this.trackHttpSolrMetrics);
        SolrNamedThreadFactory recoveryThreadFactory = new SolrNamedThreadFactory("recoveryExecutor");
        if (cfg != null && cfg.getMaxRecoveryThreads() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Creating recoveryExecutor with pool size {}", (Object)cfg.getMaxRecoveryThreads());
            }
            this.recoveryExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)cfg.getMaxRecoveryThreads(), (ThreadFactory)recoveryThreadFactory);
        } else {
            log.debug("Creating recoveryExecutor with unbounded pool");
            this.recoveryExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)recoveryThreadFactory);
        }
    }

    private HttpClientMetricNameStrategy getMetricNameStrategy(UpdateShardHandlerConfig cfg) {
        HttpClientMetricNameStrategy metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get("queryLessURLAndMethod");
        if (cfg != null && (metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get(cfg.getMetricNameStrategy())) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + cfg.getMetricNameStrategy() + " found. Must be one of: " + InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        return metricNameStrategy;
    }

    private InstrumentedHttpListenerFactory.NameStrategy getNameStrategy(UpdateShardHandlerConfig cfg) {
        InstrumentedHttpListenerFactory.NameStrategy nameStrategy = InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.get("queryLessURLAndMethod");
        if (cfg != null && (nameStrategy = InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.get(cfg.getMetricNameStrategy())) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + cfg.getMetricNameStrategy() + " found. Must be one of: " + InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        return nameStrategy;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        String expandedScope = SolrMetricManager.mkName(scope, this.getCategory().name());
        this.trackHttpSolrMetrics.initializeMetrics(this.solrMetricsContext, expandedScope);
        this.defaultConnectionManager.initializeMetrics(this.solrMetricsContext, expandedScope);
        this.updateExecutor = MetricUtils.instrumentedExecutorService(this.updateExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("updateOnlyExecutor", expandedScope, "threadPool"));
        this.recoveryExecutor = MetricUtils.instrumentedExecutorService(this.recoveryExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("recoveryExecutor", expandedScope, "threadPool"));
    }

    @Override
    public String getDescription() {
        return "Metrics tracked by UpdateShardHandler related to distributed updates and recovery";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.UPDATE;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Deprecated
    public HttpClient getDefaultHttpClient() {
        return this.defaultClient;
    }

    public Http2SolrClient getUpdateOnlyHttpClient() {
        return this.updateOnlyClient;
    }

    public Http2SolrClient getRecoveryOnlyHttpClient() {
        return this.recoveryOnlyClient;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    public PoolingHttpClientConnectionManager getDefaultConnectionManager() {
        return this.defaultConnectionManager;
    }

    public ExecutorService getRecoveryExecutor() {
        return this.recoveryExecutor;
    }

    @Override
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.updateExecutor);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.recoveryExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                SolrInfoBean.super.close();
            }
            catch (Exception exception) {}
            IOUtils.closeQuietly((Closeable)this.updateOnlyClient);
            IOUtils.closeQuietly((Closeable)this.recoveryOnlyClient);
            HttpClientUtil.close((HttpClient)this.defaultClient);
            this.defaultConnectionManager.close();
        }
    }

    @VisibleForTesting
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @VisibleForTesting
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setSecurityBuilder(HttpClientBuilderPlugin builder) {
        builder.setup(this.updateOnlyClient);
        builder.setup(this.recoveryOnlyClient);
    }
}

