/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;

@Deprecated
public class PutFilter
implements Filter {
    public static final String __PUT = "PUT";
    public static final String __DELETE = "DELETE";
    public static final String __MOVE = "MOVE";
    public static final String __OPTIONS = "OPTIONS";
    Set<String> _operations = new HashSet<String>();
    private ConcurrentMap<String, String> _hidden = new ConcurrentHashMap<String, String>();
    private ServletContext _context;
    private String _baseURI;
    private boolean _delAllowed;
    private boolean _putAtomic;
    private File _tmpdir;

    public void init(FilterConfig config) throws ServletException {
        this._context = config.getServletContext();
        this._tmpdir = (File)this._context.getAttribute("javax.servlet.context.tempdir");
        String realPath = this._context.getRealPath("/");
        if (realPath == null) {
            throw new UnavailableException("Packed war");
        }
        String b = config.getInitParameter("baseURI");
        if (b != null) {
            this._baseURI = b;
        } else {
            File base = new File(realPath);
            this._baseURI = base.toURI().toString();
        }
        this._delAllowed = this.getInitBoolean(config, "delAllowed");
        this._putAtomic = this.getInitBoolean(config, "putAtomic");
        this._operations.add(__OPTIONS);
        this._operations.add(__PUT);
        if (this._delAllowed) {
            this._operations.add(__DELETE);
            this._operations.add(__MOVE);
        }
    }

    private boolean getInitBoolean(FilterConfig config, String name) {
        String value = config.getInitParameter(name);
        return value != null && value.length() > 0 && (value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1"));
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block11: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String servletPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            String pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo);
            String resource = URIUtil.addPaths((String)this._baseURI, (String)pathInContext);
            String method = request.getMethod();
            boolean op = this._operations.contains(method);
            if (op) {
                File file = null;
                try {
                    if (method.equals(__OPTIONS)) {
                        this.handleOptions(chain, request, response);
                        break block11;
                    }
                    file = new File(new URI(resource));
                    boolean exists = file.exists();
                    if (exists && !this.passConditionalHeaders(request, response, file)) {
                        return;
                    }
                    if (method.equals(__PUT)) {
                        this.handlePut(request, response, pathInContext, file);
                        break block11;
                    }
                    if (method.equals(__DELETE)) {
                        this.handleDelete(request, response, pathInContext, file);
                        break block11;
                    }
                    if (method.equals(__MOVE)) {
                        this.handleMove(request, response, pathInContext, file);
                        break block11;
                    }
                    throw new IllegalStateException();
                }
                catch (Exception e) {
                    this._context.log(e.toString(), (Throwable)e);
                    response.sendError(500);
                }
            } else {
                if (this.isHidden(pathInContext)) {
                    response.sendError(404);
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
        }
    }

    private boolean isHidden(String pathInContext) {
        return this._hidden.containsKey(pathInContext);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePut(HttpServletRequest request, HttpServletResponse response, String pathInContext, File file) throws ServletException, IOException {
        boolean exists = file.exists();
        if (pathInContext.endsWith("/")) {
            if (!exists) {
                if (!file.mkdirs()) {
                    response.sendError(403);
                } else {
                    response.setStatus(201);
                    response.flushBuffer();
                }
            } else {
                response.setStatus(200);
                response.flushBuffer();
            }
        } else {
            boolean ok = false;
            try {
                this._hidden.put(pathInContext, pathInContext);
                File parent = file.getParentFile();
                parent.mkdirs();
                int toRead = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                if (this._putAtomic) {
                    Path tmp = Files.createTempFile(this._tmpdir.toPath(), file.getName(), null, new FileAttribute[0]);
                    try (OutputStream out = Files.newOutputStream(tmp, StandardOpenOption.WRITE);){
                        if (toRead >= 0) {
                            IO.copy((InputStream)in, (OutputStream)out, (long)toRead);
                        } else {
                            IO.copy((InputStream)in, (OutputStream)out);
                        }
                    }
                    Files.move(tmp, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    try (FileOutputStream out = new FileOutputStream(file, false);){
                        if (toRead >= 0) {
                            IO.copy((InputStream)in, (OutputStream)out, (long)toRead);
                        } else {
                            IO.copy((InputStream)in, (OutputStream)out);
                        }
                    }
                }
                response.setStatus(exists ? 200 : 201);
                response.flushBuffer();
                ok = true;
            }
            catch (Exception ex) {
                this._context.log(ex.toString(), (Throwable)ex);
                response.sendError(403);
            }
            finally {
                if (!ok) {
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception e) {
                        this._context.log(e.toString(), (Throwable)e);
                    }
                }
                this._hidden.remove(pathInContext);
            }
        }
    }

    public void handleDelete(HttpServletRequest request, HttpServletResponse response, String pathInContext, File file) throws ServletException, IOException {
        try {
            if (file.delete()) {
                response.setStatus(204);
                response.flushBuffer();
            } else {
                response.sendError(403);
            }
        }
        catch (SecurityException sex) {
            this._context.log(sex.toString(), (Throwable)sex);
            response.sendError(403);
        }
    }

    public void handleMove(HttpServletRequest request, HttpServletResponse response, String pathInContext, File file) throws ServletException, IOException, URISyntaxException {
        String newPath = URIUtil.canonicalURI((String)request.getHeader("new-uri"));
        if (newPath == null) {
            response.sendError(400);
            return;
        }
        String contextPath = request.getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(405);
            return;
        }
        String newInfo = newPath;
        if (contextPath != null) {
            newInfo = newInfo.substring(contextPath.length());
        }
        String newResource = URIUtil.addEncodedPaths((String)this._baseURI, (String)newInfo);
        File newFile = new File(new URI(newResource));
        file.renameTo(newFile);
        response.setStatus(204);
        response.flushBuffer();
    }

    public void handleOptions(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, (ServletResponse)new HttpServletResponseWrapper(response){

            public void setHeader(String name, String value) {
                if ("Allow".equalsIgnoreCase(name)) {
                    HashSet<String> options = new HashSet<String>();
                    options.addAll(Arrays.asList(StringUtil.csvSplit((String)value)));
                    options.addAll(PutFilter.this._operations);
                    value = null;
                    for (String o : options) {
                        value = value == null ? o : value + ", " + o;
                    }
                }
                super.setHeader(name, value);
            }
        });
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        long date = 0L;
        date = request.getDateHeader("if-unmodified-since");
        if (date > 0L && file.lastModified() / 1000L > date / 1000L) {
            response.sendError(412);
            return false;
        }
        date = request.getDateHeader("if-modified-since");
        if (date > 0L && file.lastModified() / 1000L <= date / 1000L) {
            response.reset();
            response.setStatus(304);
            response.flushBuffer();
            return false;
        }
        return true;
    }
}

