/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.jna;

import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.internal.jna.PosixLibC;
import com.oracle.svm.core.annotate.Delete;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Delete
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/ajalt/mordant/internal/jna/JnaLinuxMppImpls;", "Lcom/github/ajalt/mordant/internal/MppImpls;", "()V", "libC", "Lcom/github/ajalt/mordant/internal/jna/PosixLibC;", "getTerminalSize", "Lcom/github/ajalt/mordant/internal/Size;", "stderrInteractive", "", "stdinInteractive", "stdoutInteractive", "Companion", "mordant"})
public final class JnaLinuxMppImpls
implements MppImpls {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PosixLibC libC;
    @Deprecated
    public static final int STDIN_FILENO = 0;
    @Deprecated
    public static final int STDOUT_FILENO = 1;
    @Deprecated
    public static final int STDERR_FILENO = 2;
    @Deprecated
    public static final int TIOCGWINSZ = 21523;

    public JnaLinuxMppImpls() {
        PosixLibC posixLibC = Native.load(Platform.C_LIBRARY_NAME, PosixLibC.class);
        Intrinsics.checkNotNullExpressionValue(posixLibC, "load(...)");
        this.libC = posixLibC;
    }

    @Override
    public boolean stdoutInteractive() {
        return this.libC.isatty(1) == 1;
    }

    @Override
    public boolean stdinInteractive() {
        return this.libC.isatty(0) == 1;
    }

    @Override
    public boolean stderrInteractive() {
        return this.libC.isatty(2) == 1;
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        PosixLibC.winsize size2 = new PosixLibC.winsize();
        return this.libC.ioctl(0, 21523, size2) < 0 ? null : new Size(size2.ws_col, size2.ws_row);
    }

    @Override
    public boolean fastIsTty() {
        return MppImpls.DefaultImpls.fastIsTty(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/ajalt/mordant/internal/jna/JnaLinuxMppImpls$Companion;", "", "()V", "STDERR_FILENO", "", "STDIN_FILENO", "STDOUT_FILENO", "TIOCGWINSZ", "mordant"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

