// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GDKMM_TEXTUREDOWNLOADER_H
#define _GDKMM_TEXTUREDOWNLOADER_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <gdkmm/texture.h>
#include <gdkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdkTextureDownloader GdkTextureDownloader; }
#endif

namespace Gdk
{
class GDKMM_API ColorState;

/** The %Gdk::TextureDownloader is used to download the contents of a Gdk::Texture.
 *
 * It is intended to be created as a short-term object for a single download,
 * but can be used for multipe downloads of different textures or with different
 * settings.
 *
 * %Gdk::TextureDownloader can be used to convert data between different formats.
 * Create a Gdk::Texture for the existing format and then download it in a
 * different format.
 *
 * @newin{4,10}
 */

class GDKMM_API TextureDownloader
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = TextureDownloader;
  using BaseObjectType = GdkTextureDownloader;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  TextureDownloader();

  explicit TextureDownloader(GdkTextureDownloader* gobject, bool make_a_copy = true);

  TextureDownloader(const TextureDownloader& other);
  TextureDownloader& operator=(const TextureDownloader& other);

  TextureDownloader(TextureDownloader&& other) noexcept;
  TextureDownloader& operator=(TextureDownloader&& other) noexcept;

  ~TextureDownloader() noexcept;

  void swap(TextureDownloader& other) noexcept;

  ///Provides access to the underlying C instance.
  GdkTextureDownloader*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdkTextureDownloader* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdkTextureDownloader* gobj_copy() const;

protected:
  GdkTextureDownloader* gobject_;

private:

  
public:

  /** Creates a new texture downloader for @a texture.
   *
   * @newin{4,10}
   */
  explicit TextureDownloader(const Glib::RefPtr<Texture>& texture);

  
  /** Changes the texture the downloader will download.
   * 
   * @newin{4,10}
   * 
   * @param texture The new texture to download.
   */
  void set_texture(const Glib::RefPtr<Texture>& texture);
  
  /** Gets the texture that the downloader will download.
   * 
   * @newin{4,10}
   * 
   * @return The texture to download.
   */
  Glib::RefPtr<Texture> get_texture();
  
  /** Gets the texture that the downloader will download.
   * 
   * @newin{4,10}
   * 
   * @return The texture to download.
   */
  Glib::RefPtr<const Texture> get_texture() const;

  
  /** Sets the format the downloader will download.
   * 
   * By default, GDK_MEMORY_DEFAULT is set.
   * 
   * @newin{4,10}
   * 
   * @param format The format to use.
   */
  void set_format(MemoryFormat format);
  
  /** Gets the format that the data will be downloaded in.
   * 
   * @newin{4,10}
   * 
   * @return The format of the download.
   */
  MemoryFormat get_format() const;

  // ColorState is immutable. No need for a non-const get-method.
  
  /** Gets the color state that the data will be downloaded in.
   * 
   * @newin{4,16}
   * 
   * @return The color state of the download.
   */
  Glib::RefPtr<ColorState> get_color_state() const;
  
  /** Sets the color state the downloader will convert the data to.
   * 
   * By default, the sRGB colorstate returned by color_state_get_srgb()
   * is used.
   * 
   * @newin{4,16}
   * 
   * @param color_state The color state to use.
   */
  void set_color_state(const Glib::RefPtr<const ColorState>& color_state);

  
  /** Downloads the @a texture into local memory.
   * 
   * @newin{4,10}
   * 
   * @param data Pointer to enough memory to be filled with the
   * downloaded data of the texture.
   * @param stride Rowstride in bytes.
   */
  void download_into(guchar* data, gsize stride) const;
  
  /** Downloads the given texture pixels into a `Glib::Bytes`. The rowstride will
   * be stored in the stride value.
   * 
   * This function will abort if it tries to download a large texture and
   * fails to allocate memory. If you think that may happen, you should handle
   * memory allocation yourself and use download_into()
   * once allocation succeeded.
   * 
   * @newin{4,10}
   * 
   * @param out_stride The stride of the resulting data in bytes.
   * @return The downloaded pixels.
   */
  Glib::RefPtr<Glib::Bytes> download_bytes(gsize& out_stride) const;


};

} // namespace Gdk


namespace Gdk
{

/** @relates Gdk::TextureDownloader
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(TextureDownloader& lhs, TextureDownloader& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::TextureDownloader
 */
GDKMM_API
Gdk::TextureDownloader wrap(GdkTextureDownloader* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class GDKMM_API Value<Gdk::TextureDownloader> : public Glib::Value_Boxed<Gdk::TextureDownloader>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_TEXTUREDOWNLOADER_H */

