/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.common.util.concurrent.RefCounted;

public abstract class AbstractRefCounted
implements RefCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final String name;

    public AbstractRefCounted(String name) {
        this.name = name;
    }

    @Override
    public final void incRef() {
        if (!this.tryIncRef()) {
            this.alreadyClosed();
        }
    }

    @Override
    public final boolean tryIncRef() {
        int i;
        while ((i = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(i, i + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean decRef() {
        int i = this.refCount.decrementAndGet();
        assert (i >= 0);
        if (i == 0) {
            this.closeInternal();
            return true;
        }
        return false;
    }

    protected void alreadyClosed() {
        throw new IllegalStateException(this.name + " is already closed can't increment refCount current count [" + this.refCount.get() + "]");
    }

    public int refCount() {
        return this.refCount.get();
    }

    public String getName() {
        return this.name;
    }

    protected abstract void closeInternal();
}

