/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.index.store.remote.filecache.AggregateFileCacheStats;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCacheStats;
import org.opensearch.index.store.remote.utils.cache.RefCountedCache;
import org.opensearch.index.store.remote.utils.cache.SegmentedCache;
import org.opensearch.index.store.remote.utils.cache.stats.AggregateRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.IRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.RefCountedCacheStats;

@PublicApi(since="2.7.0")
public class FileCache
implements RefCountedCache<Path, CachedIndexInput> {
    private static final Logger logger = LogManager.getLogger(FileCache.class);
    private final SegmentedCache<Path, CachedIndexInput> theCache;
    private final CircuitBreaker circuitBreaker;

    public FileCache(SegmentedCache<Path, CachedIndexInput> cache, CircuitBreaker circuitBreaker) {
        this.theCache = cache;
        this.circuitBreaker = circuitBreaker;
    }

    public long capacity() {
        return this.theCache.capacity();
    }

    @Override
    public CachedIndexInput put(Path filePath, CachedIndexInput indexInput) {
        CachedIndexInput cachedIndexInput = this.theCache.put(filePath, indexInput);
        this.checkParentBreaker(filePath);
        return cachedIndexInput;
    }

    @Override
    public CachedIndexInput compute(Path key, BiFunction<? super Path, ? super CachedIndexInput, ? extends CachedIndexInput> remappingFunction) {
        CachedIndexInput cachedIndexInput = this.theCache.compute(key, remappingFunction);
        this.checkParentBreaker(key);
        return cachedIndexInput;
    }

    @Override
    public CachedIndexInput get(Path filePath) {
        return this.theCache.get(filePath);
    }

    @Override
    public void remove(Path filePath) {
        this.theCache.remove(filePath);
    }

    @Override
    public void clear() {
        this.theCache.clear();
    }

    @Override
    public long size() {
        return this.theCache.size();
    }

    @Override
    public void incRef(Path key) {
        this.theCache.incRef(key);
    }

    @Override
    public void decRef(Path key) {
        this.theCache.decRef(key);
    }

    @Override
    public void pin(Path key) {
        this.theCache.pin(key);
    }

    @Override
    public void unpin(Path key) {
        this.theCache.unpin(key);
    }

    @Override
    public Integer getRef(Path key) {
        return this.theCache.getRef(key);
    }

    @Override
    public long prune() {
        return this.theCache.prune();
    }

    @Override
    public long prune(Predicate<Path> keyPredicate) {
        return this.theCache.prune(keyPredicate);
    }

    @Override
    public long usage() {
        return this.theCache.usage();
    }

    @Override
    public long activeUsage() {
        return this.theCache.activeUsage();
    }

    @Override
    public long pinnedUsage() {
        return this.theCache.pinnedUsage();
    }

    @Override
    public IRefCountedCacheStats stats() {
        return this.theCache.stats();
    }

    public void logCurrentState() {
        logger.trace("CURRENT STATE OF FILE CACHE \n");
        long cacheUsage = this.theCache.usage();
        logger.trace("Total Usage: " + cacheUsage + " , Active Usage: " + this.theCache.activeUsage());
        this.theCache.logCurrentState();
    }

    private void checkParentBreaker(Path filePath) {
        try {
            this.circuitBreaker.addEstimateBytesAndMaybeBreak(0L, "filecache_entry");
        }
        catch (CircuitBreakingException ex) {
            this.theCache.remove(filePath);
            throw new CircuitBreakingException("Unable to create file cache entries", ex.getBytesWanted(), ex.getByteLimit(), ex.getDurability());
        }
    }

    public void restoreFromDirectory(List<Path> fileCacheDataPaths) {
        fileCacheDataPaths.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.resolve("RemoteLocalStore")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(dir -> {
            try {
                return Files.list(dir);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to process file cache directory. Please clear the file cache for node startup.", e);
            }
        }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            try {
                this.put(path.toAbsolutePath(), new RestoredCachedIndexInput(Files.size(path)));
                this.decRef(path.toAbsolutePath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to retrieve cache file details. Please clear the file cache for node startup.", e);
            }
        });
    }

    public AggregateFileCacheStats fileCacheStats() {
        AggregateRefCountedCacheStats stats = (AggregateRefCountedCacheStats)this.stats();
        RefCountedCacheStats overallCacheStats = stats.getOverallCacheStats();
        RefCountedCacheStats fullFileCacheStats = stats.getFullFileCacheStats();
        RefCountedCacheStats blockFileCacheStats = stats.getBlockFileCacheStats();
        RefCountedCacheStats pinnedFileCacheStats = stats.getPinnedFileCacheStats();
        return new AggregateFileCacheStats(System.currentTimeMillis(), new FileCacheStats(overallCacheStats.activeUsage(), this.capacity(), overallCacheStats.usage(), overallCacheStats.pinnedUsage(), overallCacheStats.evictionWeight(), overallCacheStats.hitCount(), overallCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.OVER_ALL_STATS), new FileCacheStats(fullFileCacheStats.activeUsage(), this.capacity(), fullFileCacheStats.usage(), fullFileCacheStats.pinnedUsage(), fullFileCacheStats.evictionWeight(), fullFileCacheStats.hitCount(), fullFileCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.FULL_FILE_STATS), new FileCacheStats(blockFileCacheStats.activeUsage(), this.capacity(), blockFileCacheStats.usage(), blockFileCacheStats.pinnedUsage(), blockFileCacheStats.evictionWeight(), blockFileCacheStats.hitCount(), blockFileCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.BLOCK_FILE_STATS), new FileCacheStats(pinnedFileCacheStats.activeUsage(), this.capacity(), pinnedFileCacheStats.usage(), pinnedFileCacheStats.pinnedUsage(), pinnedFileCacheStats.evictionWeight(), pinnedFileCacheStats.hitCount(), pinnedFileCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.PINNED_FILE_STATS));
    }

    private static class RestoredCachedIndexInput
    implements CachedIndexInput {
        private final long length;

        private RestoredCachedIndexInput(long length) {
            this.length = length;
        }

        @Override
        public IndexInput getIndexInput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

