/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.Line;
import net.sourceforge.plantuml.klimt.shape.SingleLine;
import net.sourceforge.plantuml.klimt.shape.TextBlock;

public class TextBlockRaw
extends AbstractTextBlock
implements TextBlock {
    private List<Line> lines2;
    private final List<String> strings;
    private final FontConfiguration fontConfiguration;

    public TextBlockRaw(List<String> strings, FontConfiguration fontConfiguration) {
        this.strings = strings;
        this.fontConfiguration = fontConfiguration;
    }

    private List<Line> getLines(StringBounder stringBounder) {
        if (this.lines2 == null) {
            if (stringBounder == null) {
                throw new IllegalStateException();
            }
            this.lines2 = new ArrayList<Line>();
            for (String s2 : this.strings) {
                this.lines2.add(SingleLine.rawText(s2, this.fontConfiguration));
            }
        }
        return this.lines2;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getTextDimension(stringBounder);
    }

    protected final XDimension2D getTextDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Line line : this.getLines(stringBounder)) {
            XDimension2D size2D = line.calculateDimension(stringBounder);
            height += size2D.getHeight();
            width = Math.max(width, size2D.getWidth());
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        for (Line line : this.getLines(ug.getStringBounder())) {
            line.drawU(ug.apply(UTranslate.dy(y)));
            y += line.calculateDimension(ug.getStringBounder()).getHeight();
        }
    }
}

