/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.NumericRange$;
import scala.math.Integral;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public class NumericRange<T>
extends AbstractSeq<T>
implements Serializable,
scala.collection.immutable.IndexedSeq<T>,
scala.collection.immutable.StrictOptimizedSeqOps<T, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<T>> {
    private int length;
    private boolean isEmpty;
    private int hashCode;
    private final T start;
    private final T end;
    private final T step;
    private final boolean isInclusive;
    public final Integral<T> scala$collection$immutable$NumericRange$$num;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ Object scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering ord) {
        void var1_1;
        return SeqOps.sorted$(this, (Ordering)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object distinctBy(Function1 f) {
        void var1_1;
        return scala.collection.immutable.StrictOptimizedSeqOps.distinctBy$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object updated(int index, Object elem) {
        void var2_2;
        void var1_1;
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, (int)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object sorted(Ordering ord) {
        void var1_1;
        return scala.collection.immutable.StrictOptimizedSeqOps.sorted$(this, (Ordering)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object prepended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.prepended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.appended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appendedAll(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedSeqOps.appendedAll$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> partition(Function1<T, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> unzip(Function1<T, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        void var1_1;
        return Seq.canEqual$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        void var1_1;
        return SeqOps.sameElements$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canEqual(Object that) {
        void var1_1;
        return scala.collection.immutable.IndexedSeq.canEqual$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> boolean sameElements(IterableOnce<B> o) {
        void var1_1;
        return scala.collection.immutable.IndexedSeq.sameElements$(this, (IterableOnce)var1_1);
    }

    @Override
    public SeqFactory<scala.collection.immutable.IndexedSeq> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        void var2_2;
        void var1_1;
        return scala.collection.IndexedSeqOps.slice$(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object slice(int from, int until) {
        void var2_2;
        void var1_1;
        return IndexedSeqOps.slice$(this, (int)var1_1, (int)var2_2);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<T> reverseIterator() {
        return scala.collection.IndexedSeqOps.reverseIterator$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B$> B$ foldRight(B$ z, Function2<T, B$, B$> op) {
        void var2_2;
        void var1_1;
        return (B$)scala.collection.IndexedSeqOps.foldRight$(this, (Object)var1_1, (Function2)var2_2);
    }

    @Override
    public IndexedSeqView<T> view() {
        return scala.collection.IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<T> reversed() {
        return scala.collection.IndexedSeqOps.reversed$(this);
    }

    @Override
    public Option<T> headOption() {
        return scala.collection.IndexedSeqOps.headOption$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lengthCompare(int len) {
        void var1_1;
        return scala.collection.IndexedSeqOps.lengthCompare$(this, (int)var1_1);
    }

    @Override
    public int knownSize() {
        return scala.collection.IndexedSeqOps.knownSize$(this);
    }

    public T start() {
        return this.start;
    }

    public T end() {
        return this.end;
    }

    public T step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator<T> iterator() {
        NumericRange numericRange = this;
        return new NumericRangeIterator<T>(numericRange, numericRange.scala$collection$immutable$NumericRange$$num);
    }

    private int length$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.length = NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.length;
    }

    @Override
    public int length() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.length$lzycompute();
        }
        return this.length;
    }

    private boolean isEmpty$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isEmpty = this.scala$collection$immutable$NumericRange$$num.gt(this.start(), this.end()) && this.scala$collection$immutable$NumericRange$$num.gt(this.step(), this.scala$collection$immutable$NumericRange$$num.zero()) || this.scala$collection$immutable$NumericRange$$num.lt(this.start(), this.end()) && this.scala$collection$immutable$NumericRange$$num.lt(this.step(), this.scala$collection$immutable$NumericRange$$num.zero()) || this.scala$collection$immutable$NumericRange$$num.equiv(this.start(), this.end()) && !this.isInclusive();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isEmpty;
    }

    @Override
    public boolean isEmpty() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.isEmpty$lzycompute();
        }
        return this.isEmpty;
    }

    @Override
    public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty list");
        }
        NumericRange numericRange = this;
        return numericRange.locationAfterN(numericRange.length() - 1);
    }

    @Override
    public NumericRange<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty list");
        }
        return new NumericRange<T>(this.start(), this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.end()).$minus(this.step()), this.step(), this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.start();
    }

    @Override
    public NumericRange<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty list");
        }
        if (this.isInclusive()) {
            return new Inclusive(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.scala$collection$immutable$NumericRange$$num);
        }
        return new Exclusive(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.scala$collection$immutable$NumericRange$$num);
    }

    /*
     * WARNING - void declaration
     */
    public NumericRange<T> by(T newStep) {
        void var1_1;
        NumericRange numericRange = this;
        return numericRange.copy(numericRange.start(), this.end(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public NumericRange<T> copy(T start, T end, T step) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new NumericRange<void>(var1_1, var2_2, var3_3, this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T apply(int idx) throws IndexOutOfBoundsException {
        void var1_1;
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.length() - 1).append(")").toString());
        }
        return this.locationAfterN((int)var1_1);
    }

    @Override
    public <U> void foreach(Function1<T, U> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    /*
     * WARNING - void declaration
     */
    private int indexOfTyped(T elem, int from) {
        void var2_3;
        void var1_1;
        int n = this.posOf(var1_1);
        if (n >= var2_3) {
            return n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> int indexOf(B elem, int from) {
        try {
            return this.indexOfTyped(elem, from);
        }
        catch (ClassCastException classCastException) {
            void var2_2;
            void var1_1;
            return SeqOps.indexOf$(this, var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int posOf(T i) {
        if (this.contains(i)) {
            void var1_1;
            return NumericRange$.MODULE$.count(this.start(), var1_1, this.step(), false, this.scala$collection$immutable$NumericRange$$num);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isWithinBoundaries(T elem) {
        void var1_1;
        return !this.isEmpty() && (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$greater(this.scala$collection$immutable$NumericRange$$num.zero()) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.start()).$less$eq(elem) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.last()) || this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$less(this.scala$collection$immutable$NumericRange$$num.zero()) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.last()).$less$eq(elem) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(var1_1).$less$eq(this.start()));
    }

    /*
     * WARNING - void declaration
     */
    private T locationAfterN(int n) {
        void var1_1;
        return this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).$times(this.scala$collection$immutable$NumericRange$$num.fromInt((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private boolean crossesTheEndAfterN(int n) {
        void var3_6;
        void var2_4;
        void var1_1;
        void var5_9;
        void var4_10;
        Integral<T> inclusive_num;
        T inclusive_step;
        Object inclusive_start;
        void apply_start3;
        Integral<T> apply_num;
        T apply_step;
        Tuple3<Exclusive<void>, NumericRange<void>, Integer> tuple3;
        void closestToZero;
        boolean stepIsInTheSameDirectionAsStartToEndVector;
        boolean bl = stepIsInTheSameDirectionAsStartToEndVector = this.scala$collection$immutable$NumericRange$$num.gt(this.end(), this.start()) && this.scala$collection$immutable$NumericRange$$num.gt(this.step(), this.scala$collection$immutable$NumericRange$$num.zero()) || this.scala$collection$immutable$NumericRange$$num.lt(this.end(), this.start()) && BoxesRunTime.equals(this.scala$collection$immutable$NumericRange$$num.sign(this.step()), this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.scala$collection$immutable$NumericRange$$num.one()).unary_$minus());
        if (this.scala$collection$immutable$NumericRange$$num.equiv(this.start(), this.end()) || n <= 0 || !stepIsInTheSameDirectionAsStartToEndVector) {
            return n > 0;
        }
        if (this.scala$collection$immutable$NumericRange$$num.equiv(this.scala$collection$immutable$NumericRange$$num.sign(this.start()), this.scala$collection$immutable$NumericRange$$num.sign(this.end()))) {
            NumericRange numericRange = this;
            Object len = numericRange.unsafeRangeLength$1(numericRange);
            if (this.fitsInInteger$1(len)) {
                return n >= this.scala$collection$immutable$NumericRange$$num.toInt(len);
            }
            return this.scala$collection$immutable$NumericRange$$num.gteq(this.scala$collection$immutable$NumericRange$$num.fromInt(n), len);
        }
        T stepsRemainderToZero = this.scala$collection$immutable$NumericRange$$num.rem(this.start(), this.step());
        boolean walksOnZero = this.scala$collection$immutable$NumericRange$$num.equiv(stepsRemainderToZero, this.scala$collection$immutable$NumericRange$$num.zero());
        Object object = closestToZero = walksOnZero ? this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus() : closestToZero;
        if (this.scala$collection$immutable$NumericRange$$num.lt(this.start(), this.scala$collection$immutable$NumericRange$$num.zero())) {
            Integral<T> apply_step2;
            T apply_start2;
            if (walksOnZero) {
                void apply_num2;
                void twoStepsAfterLargestNegativeNumber = this.scala$collection$immutable$NumericRange$$num.plus(closestToZero, (void)this.scala$collection$immutable$NumericRange$$num.times(this.step(), this.scala$collection$immutable$NumericRange$$num.fromInt(2)));
                Integral<T> integral = this.scala$collection$immutable$NumericRange$$num;
                T t = this.step();
                apply_start2 = this.start();
                Tuple3<Exclusive<Integral<T>>, NumericRange<void>, Integer> tuple32 = new Tuple3<Exclusive<Integral<T>>, NumericRange<void>, Integer>(new Exclusive<Integral<T>>(apply_start2, closestToZero, apply_step2, apply_num2), this.copy(twoStepsAfterLargestNegativeNumber, this.end(), this.step()), 2);
                tuple3 = tuple32;
            } else {
                apply_step2 = this.scala$collection$immutable$NumericRange$$num;
                apply_start2 = this.step();
                T apply_start3 = this.start();
                NumericRange numericRange = this;
                Tuple3<Exclusive<void>, NumericRange<void>, Integer> tuple33 = new Tuple3<Exclusive<void>, NumericRange<void>, Integer>(new Exclusive<void>((void)apply_start3, closestToZero, (void)apply_step, (Integral<void>)apply_num), numericRange.copy(numericRange.scala$collection$immutable$NumericRange$$num.plus(closestToZero, (void)this.step()), this.end(), this.step()), 1);
                tuple3 = tuple33;
            }
        } else if (apply_start3 != false) {
            T twoStepsAfterZero = this.scala$collection$immutable$NumericRange$$num.times(this.step(), this.scala$collection$immutable$NumericRange$$num.fromInt(2));
            apply_num = this.scala$collection$immutable$NumericRange$$num;
            apply_step = this.step();
            Object inclusive_end = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus();
            inclusive_start = this.start();
            Tuple3<NumericRange<T>, Inclusive<Object>, Integer> tuple34 = new Tuple3<NumericRange<T>, Inclusive<Object>, Integer>(this.copy(twoStepsAfterZero, this.end(), this.step()), new Inclusive<Object>(inclusive_start, inclusive_end, inclusive_step, inclusive_num), 2);
            tuple3 = tuple34;
        } else {
            void twoStepsAfterSmallestPositiveNumber = this.scala$collection$immutable$NumericRange$$num.plus((void)inclusive_start, (void)this.scala$collection$immutable$NumericRange$$num.times(this.step(), this.scala$collection$immutable$NumericRange$$num.fromInt(2)));
            inclusive_num = this.scala$collection$immutable$NumericRange$$num;
            inclusive_step = this.step();
            T inclusive_start2 = this.start();
            Tuple3<NumericRange<void>, Inclusive<T>, Integer> tuple35 = new Tuple3<NumericRange<void>, Inclusive<T>, Integer>(this.copy(twoStepsAfterSmallestPositiveNumber, this.end(), this.step()), new Inclusive<T>(inclusive_start2, inclusive_start, inclusive_step, inclusive_num), 2);
            tuple3 = tuple35;
        }
        inclusive_start = tuple3;
        NumericRange l = tuple3._1();
        NumericRange r = (NumericRange)((Tuple3)inclusive_start)._2();
        int carry = BoxesRunTime.unboxToInt(((Tuple3)inclusive_start)._3());
        if (l == null || r == null) {
            throw new MatchError(inclusive_start);
        }
        Object leftLength = this.unsafeRangeLength$1(l);
        Object rightLength = this.unsafeRangeLength$1((NumericRange)var4_10);
        if (this.fitsInInteger$1(leftLength) && this.fitsInInteger$1(rightLength)) {
            return n - this.scala$collection$immutable$NumericRange$$num.toInt(leftLength) - var5_9 >= this.scala$collection$immutable$NumericRange$$num.toInt(rightLength);
        }
        return this.scala$collection$immutable$NumericRange$$num.gteq(this.scala$collection$immutable$NumericRange$$num.minus(this.scala$collection$immutable$NumericRange$$num.minus((void)this.scala$collection$immutable$NumericRange$$num.fromInt((int)var1_1), var2_4), (void)this.scala$collection$immutable$NumericRange$$num.fromInt((int)var5_9)), var3_6);
    }

    /*
     * WARNING - void declaration
     */
    private Exclusive<T> newEmptyRange(T value) {
        void var3_2;
        void var2_3;
        void var1_1;
        Integral<T> apply_num = this.scala$collection$immutable$NumericRange$$num;
        T apply_step = this.step();
        void v0 = var1_1;
        return new Exclusive<void>(v0, v0, var2_3, (Integral<void>)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NumericRange<T> take(int n) {
        void var1_1;
        if (n <= 0 || this.isEmpty()) {
            NumericRange numericRange = this;
            return numericRange.newEmptyRange(numericRange.start());
        }
        if (this.crossesTheEndAfterN(n)) {
            return this;
        }
        return new Inclusive<T>(this.start(), this.locationAfterN((int)(var1_1 - true)), this.step(), this.scala$collection$immutable$NumericRange$$num);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NumericRange<T> drop(int n) {
        void var1_1;
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (this.crossesTheEndAfterN(n)) {
            NumericRange numericRange = this;
            return numericRange.newEmptyRange(numericRange.end());
        }
        NumericRange numericRange = this;
        return numericRange.copy(numericRange.locationAfterN((int)var1_1), this.end(), this.step());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<NumericRange<T>, NumericRange<T>> splitAt(int n) {
        void var1_1;
        return new Tuple2<Object, Object>(this.take(n), this.drop((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NumericRange<T> reverse() {
        void var1_1;
        if (this.isEmpty()) {
            return this;
        }
        Object newStep = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus();
        if (BoxesRunTime.equals(this.scala$collection$immutable$NumericRange$$num.sign(newStep), this.scala$collection$immutable$NumericRange$$num.sign(this.step()))) {
            throw new ArithmeticException("number type is unsigned, and .reverse requires a negative step");
        }
        return new Inclusive<void>((void)this.last(), (void)this.start(), var1_1, (Integral<void>)this.scala$collection$immutable$NumericRange$$num);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T1> T min(Ordering<T1> ord) {
        void var1_1;
        block6: {
            block5: {
                Ordering ordering;
                if (ord == this.scala$collection$immutable$NumericRange$$num) break block5;
                Option option = NumericRange$.MODULE$.defaultOrdering().get(this.scala$collection$immutable$NumericRange$$num);
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                if (!(!option.isEmpty() && NumericRange.$anonfun$min$1(ord, ordering = (Ordering)((Option)((Object)ordering)).get()))) break block6;
            }
            if (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.scala$collection$immutable$NumericRange$$num.sign(this.step())).$greater(this.scala$collection$immutable$NumericRange$$num.zero())) {
                return this.head();
            }
            return this.last();
        }
        return (T)IterableOnceOps.min$(this, (Ordering)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T1> T max(Ordering<T1> ord) {
        void var1_1;
        block6: {
            block5: {
                Ordering ordering;
                if (ord == this.scala$collection$immutable$NumericRange$$num) break block5;
                Option option = NumericRange$.MODULE$.defaultOrdering().get(this.scala$collection$immutable$NumericRange$$num);
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                if (!(!option.isEmpty() && NumericRange.$anonfun$max$1(ord, ordering = (Ordering)((Option)((Object)ordering)).get()))) break block6;
            }
            if (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.scala$collection$immutable$NumericRange$$num.sign(this.step())).$greater(this.scala$collection$immutable$NumericRange$$num.zero())) {
                return this.last();
            }
            return this.head();
        }
        return (T)IterableOnceOps.max$(this, (Ordering)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsTyped(T x) {
        void var1_1;
        return this.isWithinBoundaries(x) && BoxesRunTime.equals(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(var1_1).$minus(this.start())).$percent(this.step()), this.scala$collection$immutable$NumericRange$$num.zero());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1> boolean contains(A1 x) {
        try {
            void var1_1;
            return this.containsTyped(var1_1);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private int hashCode$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hashCode = MurmurHash3$.MODULE$.seqHash(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hashCode;
    }

    @Override
    public int hashCode() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.hashCode$lzycompute();
        }
        return this.hashCode;
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void var1_1;
        if (other instanceof NumericRange) {
            return ((NumericRange)(other = (NumericRange)other)).canEqual(this) && this.length() == ((NumericRange)other).length() && (this.isEmpty() || BoxesRunTime.equals(this.start(), ((NumericRange)other).start()) && BoxesRunTime.equals(this.last(), ((NumericRange)other).last()));
        }
        return Seq.equals$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var3_3;
        void var2_2;
        void var1_1;
        String empty = this.isEmpty() ? "empty " : "";
        String preposition = this.isInclusive() ? "to" : "until";
        String stepped = BoxesRunTime.equals(this.step(), 1) ? "" : new StringBuilder(4).append(" by ").append(this.step()).toString();
        return new StringBuilder(15).append((String)var1_1).append("NumericRange ").append(this.start()).append(" ").append((String)var2_2).append(" ").append(this.end()).append((String)var3_3).toString();
    }

    @Override
    public String className() {
        return "NumericRange";
    }

    public void foreach$mVc$sp(Function1<T, BoxedUnit> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object unsafeRangeLength$1(NumericRange r) {
        void var3_3;
        void var2_2;
        void var1_1;
        T diff = this.scala$collection$immutable$NumericRange$$num.minus(r.end(), r.start());
        T quotient = this.scala$collection$immutable$NumericRange$$num.quot(diff, r.step());
        T remainder = this.scala$collection$immutable$NumericRange$$num.rem(diff, r.step());
        if (!var1_1.isInclusive() && this.scala$collection$immutable$NumericRange$$num.equiv(var2_2, (void)this.scala$collection$immutable$NumericRange$$num.zero())) {
            return this.scala$collection$immutable$NumericRange$$num.max(quotient, this.scala$collection$immutable$NumericRange$$num.zero());
        }
        return this.scala$collection$immutable$NumericRange$$num.max(this.scala$collection$immutable$NumericRange$$num.plus(var3_3, (void)this.scala$collection$immutable$NumericRange$$num.one()), this.scala$collection$immutable$NumericRange$$num.zero());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean fitsInInteger$1(Object value) {
        void var1_1;
        return this.scala$collection$immutable$NumericRange$$num.equiv((void)this.scala$collection$immutable$NumericRange$$num.fromInt(this.scala$collection$immutable$NumericRange$$num.toInt(value)), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$min$1(Ordering ord$1, Ordering x$2) {
        void var1_1;
        return ord$1 == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$max$1(Ordering ord$2, Ordering x$3) {
        void var1_1;
        return ord$2 == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NumericRange(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.start = var1_1;
        this.end = var2_2;
        this.step = var3_3;
        this.isInclusive = isInclusive;
        this.scala$collection$immutable$NumericRange$$num = num;
    }

    public static class Exclusive<T>
    extends NumericRange<T> {
        private final Integral<T> num;

        /*
         * WARNING - void declaration
         */
        @Override
        public Exclusive<T> copy(T start, T end, T step) {
            void var3_3;
            void var2_2;
            void var1_1;
            Integral<T> apply_num = this.num;
            return new Exclusive<void>(var1_1, var2_2, var3_3, apply_num);
        }

        /*
         * WARNING - void declaration
         */
        public Exclusive(T start, T end, T step, Integral<T> num) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.num = num;
            super(var1_1, var2_2, var3_3, false, num);
        }
    }

    public static class Inclusive<T>
    extends NumericRange<T> {
        private final Integral<T> num;

        /*
         * WARNING - void declaration
         */
        @Override
        public Inclusive<T> copy(T start, T end, T step) {
            void var3_3;
            void var2_2;
            void var1_1;
            Integral<T> inclusive_num = this.num;
            return new Inclusive<void>(var1_1, var2_2, var3_3, inclusive_num);
        }

        /*
         * WARNING - void declaration
         */
        public Inclusive(T start, T end, T step, Integral<T> num) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.num = num;
            super(var1_1, var2_2, var3_3, true, num);
        }
    }

    private static final class NumericRangeIterator<T>
    extends AbstractIterator<T>
    implements Serializable {
        private final NumericRange<T> self;
        private final Integral<T> num;
        private boolean _hasNext;
        private T _next;
        private final T lastElement;

        @Override
        public final int knownSize() {
            if (this._hasNext) {
                return this.num.toInt(this.num.mkNumericOps(this.num.mkNumericOps(this.lastElement).$minus(this._next)).$div(this.self.step())) + 1;
            }
            return 0;
        }

        @Override
        public final boolean hasNext() {
            return this._hasNext;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T next() {
            void var1_1;
            T value;
            if (!this._hasNext) {
                Iterator$.scala$collection$Iterator$$_empty.next();
            }
            this._hasNext = !BoxesRunTime.equals(value = this._next, this.lastElement);
            this._next = this.num.plus(value, this.self.step());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public NumericRangeIterator(NumericRange<T> self, Integral<T> num) {
            void var1_1;
            void var2_2;
            this.self = self;
            this.num = var2_2;
            this._hasNext = !self.isEmpty();
            this._next = self.start();
            this.lastElement = this._hasNext ? self.last() : var1_1.start();
        }
    }
}

