/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;

final class ImmutableColumnReference
implements ColumnReference {
    private static final long serialVersionUID = -4411771492159843382L;
    private final Column foreignKeyColumn;
    private final Column primaryKeyColumn;
    private final int keySequence;

    protected ImmutableColumnReference(int keySequence, Column foreignKeyColumn, Column primaryKeyColumn) {
        this.keySequence = keySequence;
        this.foreignKeyColumn = Objects.requireNonNull(foreignKeyColumn, "No foreign key column provided");
        this.primaryKeyColumn = Objects.requireNonNull(primaryKeyColumn, "No primary key column provided");
    }

    @Override
    public int compareTo(ColumnReference columnRef) {
        if (columnRef == null) {
            return -1;
        }
        int compare = 0;
        ColumnReference other = columnRef;
        if (compare == 0) {
            compare = this.getKeySequence() - other.getKeySequence();
        }
        if (compare == 0) {
            compare = this.foreignKeyColumn.getFullName().compareTo(columnRef.getForeignKeyColumn().getFullName());
        }
        if (compare == 0) {
            compare = this.primaryKeyColumn.getFullName().compareTo(columnRef.getPrimaryKeyColumn().getFullName());
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ImmutableColumnReference)) {
            return false;
        }
        ColumnReference other = (ColumnReference)obj;
        return Objects.equals(this.primaryKeyColumn, other.getPrimaryKeyColumn()) && Objects.equals(this.foreignKeyColumn, other.getForeignKeyColumn());
    }

    @Override
    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    @Override
    public int getKeySequence() {
        return this.keySequence;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public int hashCode() {
        return Objects.hash(this.foreignKeyColumn, this.primaryKeyColumn);
    }

    public String toString() {
        return this.foreignKeyColumn + " --> " + this.primaryKeyColumn;
    }
}

