/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.string.StringFormat;

final class TableConstraintRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableConstraintRetriever.class.getName());
    private final Map<List<String>, MutableTableConstraint> tableConstraintsMap = new HashMap<List<String>, MutableTableConstraint>();

    TableConstraintRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    public void matchTableConstraints(NamedObjectList<MutableTable> allTables) {
        Objects.requireNonNull(allTables, "No tables provided");
        for (MutableTable mutableTable : allTables) {
            if (mutableTable == null) continue;
            this.matchPrimaryKey(mutableTable);
            this.addImportedForeignKeys(mutableTable);
        }
    }

    void retrieveTableConstraintDefinitions() {
        if (this.tableConstraintsMap.isEmpty()) {
            LOGGER.log(Level.FINE, "No table constraints found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.CHECK_CONSTRAINTS)) {
            LOGGER.log(Level.FINE, "Extended table constraints SQL statement was not provided");
            return;
        }
        Query extTableConstraintInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.CHECK_CONSTRAINTS);
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraint definitions");
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extTableConstraintInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = results.getString("CONSTRAINT_NAME");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving definition for constraint <%s>", new Object[]{constraintName}));
                String definition = results.getString("CHECK_CLAUSE");
                MutableTableConstraint tableConstraint = this.tableConstraintsMap.get(Arrays.asList(catalogName, schemaName, constraintName));
                if (tableConstraint == null) {
                    LOGGER.log(Level.FINEST, (Supplier<String>)new StringFormat("Could not add table constraint <%s>", new Object[]{constraintName}));
                    continue;
                }
                tableConstraint.appendDefinition(definition);
                tableConstraint.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", e);
        }
        retrievalCounts.log();
    }

    void retrieveTableConstraintInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_TABLE_CONSTRAINTS)) {
            LOGGER.log(Level.INFO, "Not retrieving additional table constraint information, since this was not requested");
            LOGGER.log(Level.FINE, "Additional table constraints information SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional table constraint information");
        Query extTableConstraintsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_TABLE_CONSTRAINTS);
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraint information");
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extTableConstraintsInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String tableConstraintName = results.getString("CONSTRAINT_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableConstraintName}));
                    continue;
                }
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving additional table constraint information <%s>", new Object[]{tableConstraintName}));
                MutableTable table = tableOptional.get();
                Optional<TableConstraint> tableConstraintOptional = table.lookupTableConstraint(tableConstraintName);
                if (!tableConstraintOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table constraint <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, tableConstraintName}));
                    continue;
                }
                TableConstraint tableConstraint = tableConstraintOptional.get();
                String remarks = results.getString("REMARKS");
                tableConstraint.setRemarks(remarks);
                Map<String, Object> attributes = results.getAttributes();
                Set<Map.Entry<String, Object>> entrySet = attributes.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    tableConstraint.setAttribute(entry.getKey(), entry.getValue());
                }
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint information", e);
        }
        retrievalCounts.log();
    }

    void retrieveTableConstraints() {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        this.createTableConstraints(this.tableConstraintsMap, informationSchemaViews);
        if (!this.tableConstraintsMap.isEmpty()) {
            this.retrieveTableConstraintsColumns(this.tableConstraintsMap, informationSchemaViews);
        }
    }

    private void addImportedForeignKeys(MutableTable table) {
        Collection<ForeignKey> importedForeignKeys = table.getImportedForeignKeys();
        for (ForeignKey foreignKey : importedForeignKeys) {
            Optional<TableConstraint> lookupTableConstraint = table.lookupTableConstraint(foreignKey.getName());
            if (lookupTableConstraint.isPresent()) {
                TableConstraint tableConstraint = lookupTableConstraint.get();
                this.copyRemarksAndAttributes(tableConstraint, foreignKey);
                table.removeTableConstraint(tableConstraint);
            }
            table.addTableConstraint(foreignKey);
        }
    }

    private void copyRemarksAndAttributes(TableConstraint tableConstraint, DatabaseObject databaseObject) {
        if (!databaseObject.hasRemarks() && tableConstraint.hasRemarks()) {
            databaseObject.setRemarks(tableConstraint.getRemarks());
        }
        for (Map.Entry<String, Object> attribute : tableConstraint.getAttributes().entrySet()) {
            databaseObject.setAttribute(attribute.getKey(), attribute.getValue());
        }
    }

    private void createTableConstraints(Map<List<String>, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLE_CONSTRAINTS)) {
            LOGGER.log(Level.FINE, "Table constraints SQL statement was not provided");
            return;
        }
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraints");
        Query tableConstraintsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLE_CONSTRAINTS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableConstraintsInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = results.getString("CONSTRAINT_NAME");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving constraint <%s>", new Object[]{constraintName}));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                String constraintType = results.getString("CONSTRAINT_TYPE");
                boolean deferrable = results.getBoolean("IS_DEFERRABLE");
                boolean initiallyDeferred = results.getBoolean("INITIALLY_DEFERRED");
                MutableTableConstraint tableConstraint = new MutableTableConstraint(table, constraintName);
                tableConstraint.setTableConstraintType(TableConstraintType.valueOfFromValue(constraintType));
                tableConstraint.setDeferrable(deferrable);
                tableConstraint.setInitiallyDeferred(initiallyDeferred);
                tableConstraint.addAttributes(results.getAttributes());
                table.addTableConstraint(tableConstraint);
                retrievalCounts.countIncluded();
                Schema schema = table.getSchema();
                tableConstraintsMap.put(Arrays.asList(schema.getCatalogName(), schema.getName(), constraintName), tableConstraint);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint information", e);
            return;
        }
        retrievalCounts.log();
    }

    private void matchPrimaryKey(MutableTable table) {
        if (!table.hasPrimaryKey()) {
            return;
        }
        MutablePrimaryKey primaryKey = table.getPrimaryKey();
        for (TableConstraint tableConstraint : table.getTableConstraints()) {
            if (tableConstraint.getType() != TableConstraintType.primary_key || !primaryKey.getName().equals(tableConstraint.getName()) && !primaryKey.getConstrainedColumns().equals(tableConstraint.getConstrainedColumns())) continue;
            this.copyRemarksAndAttributes(tableConstraint, primaryKey);
            table.removeTableConstraint(tableConstraint);
        }
        table.addTableConstraint(primaryKey);
    }

    private void retrieveTableConstraintsColumns(Map<List<String>, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE)) {
            LOGGER.log(Level.FINE, "Table constraints columns usage SQL statement was not provided");
            return;
        }
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraints columns");
        Query tableConstraintsColumnsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableConstraintsColumnsInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                String columnName;
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = results.getString("CONSTRAINT_NAME");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving definition for constraint <%s>", new Object[]{constraintName}));
                MutableTableConstraint tableConstraint = tableConstraintsMap.get(Arrays.asList(catalogName, schemaName, constraintName));
                if (tableConstraint == null) {
                    LOGGER.log(Level.FINEST, (Supplier<String>)new StringFormat("Could not add column constraint <%s>", new Object[]{constraintName}));
                    continue;
                }
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName = results.getString("COLUMN_NAME"));
                if (!columnOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find column <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, columnName}));
                    continue;
                }
                MutableColumn column = columnOptional.get();
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                MutableTableConstraintColumn constraintColumn = new MutableTableConstraintColumn(tableConstraint, column);
                constraintColumn.setKeyOrdinalPosition(ordinalPosition);
                tableConstraint.addColumn(constraintColumn);
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", e);
        }
        retrievalCounts.log();
    }
}

