/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.string.StringFormat;

final class ViewExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ViewExtRetriever.class.getName());

    ViewExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveViewInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.VIEWS)) {
            LOGGER.log(Level.INFO, "Not retrieving additional view information, since this was not requested");
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional view information");
        RetrievalCounts retrievalCounts = new RetrievalCounts("views for definitions");
        Query viewInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.VIEWS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String definition = results.getString("VIEW_DEFINITION");
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String viewName = results.getString("TABLE_NAME");
                Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName, viewName);
                if (!viewOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, viewName}));
                    continue;
                }
                MutableView view = (MutableView)viewOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving view information <%s>", new Object[]{viewName}));
                CheckOptionType checkOption = results.getEnum("CHECK_OPTION", CheckOptionType.unknown);
                boolean updatable = results.getBoolean("IS_UPDATABLE");
                view.appendDefinition(definition);
                view.setCheckOption(checkOption);
                view.setUpdatable(updatable);
                view.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional view information", e);
        }
        retrievalCounts.log();
    }

    void retrieveViewTableUsage() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.VIEW_TABLE_USAGE)) {
            LOGGER.log(Level.INFO, "Not retrieving additional view table usage, since this was not requested");
            LOGGER.log(Level.FINE, "View table usage SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving view table usage");
        RetrievalCounts retrievalCounts = new RetrievalCounts("views for table usage");
        Query viewTableUsageSql = informationSchemaViews.getQuery(InformationSchemaKey.VIEW_TABLE_USAGE);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewTableUsageSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("VIEW_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("VIEW_SCHEMA"));
                String viewName = results.getString("VIEW_NAME");
                Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName, viewName);
                if (!viewOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find view <%s.%s.%s>", new Object[]{catalogName, schemaName, viewName}));
                    continue;
                }
                MutableView view = (MutableView)viewOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving view information <%s>", new Object[]{viewName}));
                String tableCatalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String tableSchemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(tableCatalogName, tableSchemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{tableCatalogName, tableSchemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table information <%s>", new Object[]{tableName}));
                view.addTableUsage(table);
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table usage for views", e);
        }
        retrievalCounts.log();
    }
}

