# Arabic (Lunar Mansions)

## Introduction

The Arabic lunar stations describes the 28 sky areas chosen in ancient Arabia to define the daily location of the moon during its monthly trip around the sky.

## Description

#### Historical Overview

Originally, *Manāzil al-Qamar*, the Arabic for the lunar mansions, or stations of the moon, were a system of 28 stars, group of stars, or spots in the sky near which the moon can be found in each of the 28 nights of its monthly revolution. Early mentions of the complete list of the lunar stations are reported by ʿAbd al-Malik ibn Ḥabīb (d. 852) on the authority of Mālik ibn Anas (d. 795) [#1]. However, this system had been adopted already in the pre-Islamic period, prior to the 7th century of the common era.

 Using heliacal observations, the asterisms of the lunar mansions served to divide the sidereal and solar year of 365 days into 28 periods of 13 days each except for one period that is given 14 days. These 28 periods are called *Anwāʾ*, plural of *nawʾ*. Each *Nawʾ* is determined by a characteristical star: when this star rises in the morning during dawn (in the east, so, shortly before the Sun), this is the beginning of the next *nawʾ*. The name of the *nawʾ* (period of time, half month), gives the lunar mansion its name. One complete cycle of setting and rising for each of the 28 lunar mansions, one after the other, makes a solar year. This system was used to determine the seasons and predict weather, especially rain [#2]. The Arabs said: each *nawʾ* (period of 13/14 days) is characterized by a distinctive weather pattern of rain, wind, and temperature [#3].

A detailed description of the stars of each lunar mansion, the times of their heliacal rising and a compilation of astronomical and meteorological knowledge of the ancient Arabs can be found in the *Book of meteorology* (Arabic: Kitāb al-anwāʾ), authored by Ibn Qutaybah (b. 828 - d. 884 or 889). Copies of this book manuscripts survived, and it was printed in India in 1956 [#4].

 The usage of the lunar mansions continued to schedule the times of agricultural, travel and medicine practices. Due to the importance of observing the times of their heliacal risings, short treatises have been written, and poems have been composed describing the asterisms of the 28 mansions. A poem dedicated to description of the stars of the lunar mansions was published by Gustave-Adolphe de Calassanti-Motylinski in 1899 in his book *Les mansions lunaires chez les Arabes*, attributed to Muḥammad al-Maqri (1578-1638) [#5][#6]. A sample treatise is the one written by Shaikh Ṣāliḥ al-Shethrī (d. ~1891), titled *A time-table for farmers* [#7].

#### Current Usage of Lunar Stations

 Agricultural almanacs based on the heliacal rising of lunar stations are still in active use today. The official calendar of Saudi Arabia includes these times [#8]. The following is an example of the use of a calendar based on the lunar stations for the 13 days period starting with the rise of the 3rd lunar station *al-Thurayya* (Pleiades) on June 7th [#9]:

> Weather gets hotter and wind gets stronger. Wild grasses dry. Water in wells gets shallower. Rain is rare during this time. Spring insects start to disappear. Palm tree dates starts to get its colors. It is recommended to irrigate trees with the right amounts and stop irrigation of vines when grapes start to get its color.

#### Identification of the Lunar Stations

Ibn Qutaybah (b. 828 - d. 884 or 889) in his book *Kitāb al-anwāʾ* gives detailed description of the stars of each lunar station while an accurate identification can be extracted from the *Book of Stars* by al-Sufi (d. 986). In his book, al-Sufi maps the stars known to ancient Arabs to those of the Ptolemaic Constellations. An example of al-Sufi definitions of the stars of the lunar mansions, here is the definition of *al-Ġafr* [#10][#11]:

> And the 22nd [star of Virgo] and the 23rd which is on the tail [hem of the garment] with the 25th on the left foot [of Virgo] are named [by the Arabs] *al-Ghafr* which is the 15th lunar mansion.

 Because the stars of the Ptolemaic constellations have known coordinates, it is relatively easy to identify the Arab star names.

#### The 28 lunar stations

 1. (Arabic: الشرطان) *Al-Sharaṭān* (The two signs) or (Arabic: الأشراط) *"al-Ashrāṭ"* (The signs) composed of the 3 stars: α Ari (Hamal), β Ari (Sheratan) and γ Ari (Mesarthim)
 1. (Arabic: البطين) *Al-Buṭayn* (The small belly [of the little ram]) composed of the 3 stars: ε Ari, δ Ari (Botein), and ρ<sup>3</sup> Ari
 1. (Arabic: الثريا) *Al-Thurayyā* (Pleiades) composed of the star cluster of the Pleiades
 1. (Arabic: الدبران) *Al-Dabarān* (The Follower [of the Pleiades]) composed of the single star α Tau (Aldebaran)
 1. (Arabic: الهقعة) *Al-Haqʿah* (The mark on the horse side) composed of the three stars on the head of Orion: λ Ori (Meissa), φ<sup>1</sup> Ori and φ<sup>2</sup> Ori
 1. (Arabic: الهنعة*Al-Hanʿah* (The bend in the neck of a camel) composed of the 2 stars: γ Gem (Alhena) and ξ Gem
 1. (Arabic: الذراع) *Al-Dhirāʾ* (Retracted arm [of the lion]) composed of the 2 stars: α CMi (Procyon) and β CMi (Gomeisa)
 1. (Arabic: النثرة) *Al-Nathrah* (The tip of the nose of the lion) composed of the Praesepe cluster and the 2 stars: γ Cnc (Asellus Borealis) and δ Cnc (Asellus Australis)
 1. (Arabic: الطرف) *Al-Ṭarf* (The eyes of the lion) composed of the 2 stars: ε Leo and ο Leo (Subra)
 1. (Arabic: الجبهة) *Al-Ǧabhah* (The forehead of the lion) composed of 4 stars: ζ Leo (Adhafera), γ<sup>1</sup> Leo - γ<sup>2</sup> Leo (Algieba), η Leo and α Leo (Regulus)
 1. (Arabic: الزبرة) *Al-Zubrah* (The mane of the lion) composed of the 2 stars: δ Leo (Zosma) and θ Leo (Chertan)
 1. (Arabic: الصرفة) *Al-Ṣarfah* (The change to colder weather) composed of one star: β Leo (Denebola)
 1. (Arabic: العوا) *Al-ʿAwwā* (The bend) composed of 5 stars: β Vir (Zavijava), η Vir (Zaniah), γ Vir (Porrima), δ Vir and ε Vir (Vindemiatrix)
 1. (Arabic: السماك) *Al-Simāk* (The unarmed high one) composed of the star α Vir (Spica)
 1. (Arabic: الغفر) *Al-Ġafr* (The cover) composed of 3 stars: ι Vir (Syrma), κ Vir and λ Vir
 1. (Arabic: الزبانى) *Al-Zubānā* (The claws of the scorpion) composed of the 2 stars: α<sup>2</sup> Lib (Zubenelgenubi) and β Lib (Zubeneschamali)
 1. (Arabic: الإكليل) *Al-Iklīl* (The ornamented headband, The diadem) composed of the 3 stars: β<sup>1</sup> Sco (Acrab), δ Sco (Dschubba) and π Sco.
 1. (Arabic: القلب) *Al-Qalb* (The heart of the scorpion) composed of the star α Sco (Antares)
 1. (Arabic: الشولة) *Al-Shawlah* (The sting of the scorpion) composed of the 2 stars: λ Sco (Shaula) and υ Sco (Lesath)
 1. (Arabic: النعائم) *Al-Naʿaʾim* (The Ostriches) 8 stars: γ2 Sgr, δ Sgr, ε Sgr, η Sgr, σ Sgr, φ Sgr, τ Sgr, and ζ Sgr
 1. (Arabic: البلدة*Al-Baldah* (The empty area) is the area where there are no stars (between *al-Naayem* and *Saad al-Thabih*)
 1. (Arabic: سعد الذابح) *Saʿd al-Dhābiḥ* (The lucky star of the Slaughterer) composed of the 3 stars: α<sup>2</sup> Cap (Algedi), β Cap (Dabih), and ν Cap
 1. (Arabic: سعد بلع) *Saʿd Bulaʿ* (The lucky star of the swallower) composed of the 3 stars: ν Aqr, μ Aqr and ε Aqr (Albali)
 1. (Arabic: سعد السعود) *Saʿd al-Suʿūd* (The luckiest of the lucky stars) composed of the 3 stars: β Aqr (Sadalsuud), ξ Aqr and λ Cap
 1. (Arabic: سعد الأخبية) *Saʿd al-Aḫbiyah* (The lucky stars of the tent dwellers) composed of the 4 stars: γ Aqr (Sadachbia), π Aqr, ζ<sup>1</sup> - ζ<sup>2</sup> Aqr and η Aqr
 1. (Arabic: المقدم) *Al-Muqaddam* (The front bucket mouth) composed of the 2 stars: α And (Alpheratz) and γ Peg (Algenib)
 1. (Arabic: المؤخر) *Al-Muʾaḫar* (The rear bucket mouth) composed of the 2 stars: β Peg (Scheat) and α Peg (Markab)
 1. (Arabic: الرشاء أو الحوت) *Al-Rishāʾ* or *al-Ḥūt* (The rope of the well bucket or The Fish) composed of the star β And (Mirach) and two arcs of stars making a figure of a fish

##### The Super lion and al-Ǧawzāʾ figures of the ancient Arab star lore

 One may notice from the names of the 7th to the 15th lunar stations that they are part of a lion figure. This Arab lion figure covers around 100 degrees, a little bit more than half of the sky dome. From the names of these stars a lion figure can be constructed.

 Two of the lunar stations, *al-Haqʿah* and *al-Hanʿah*, are part of al-Ǧawzāʾ stars. al-Ǧawzāʾ is the figure covering Orion plus some stars around it. The ancient Arabs imagined these stars as a figure of a woman with a bow and arrow aimed at the lion (an image, probably influenced from Roman Egypt: see depiction on Denderah zodiac which shows Babylonian as well as Greek traces of constellations). Mr. Roland Laffitte discussed these two figures and offered a depiction of each in his article: [Our Arab Heritage in the CelestialVault](http://www.muslimheritage.com/article/our-arab-heritage-celestial-vault). A more detailed discussion of ancient Arab star lore is found in his book: &quot;Le Ciel des Arabes&quot; [#12].

## Constellations

In addition to the lunar stations, the prominent indigenous Arab asterisms have been added.

## References

 - [#1]: <notr>Kunitzsch P. The Arabs and the Stars, Variorum reprints Northampton 1989, Al-Manazil, Item XX pp 1-7.</notr>
 - [#2]: <notr>Helaine Selin, Encyclopaedia of the History of Science, Technology, and Medicine in Non-Western Cultures, Lunar Mansions in Islamic History, Kunitzsch P. p 520</notr>
 - [#3]: <notr>Ibn Qutaybah (b. 828 d. 884 or 889), Kitab al-Anwā’, pp 6,7 (Arabic print of the original book in 1956 in India Hydarabad/Deccan)</notr>
 - [#4]: <notr>Helaine Selin, Encyclopaedia of the History of Science, Technology, and Medicine in Non-Western Cultures, Ibn Qutayba, Kunitzsch P. p 429</notr>
 - [#5]: <notr>Ta̕rīf manāzil alkamar, Les mansions lunaires des Arabes; Muhammad al-Mukrī.; A de Calassanti-Motylinski published in Alger, Imprimerie orientale, 1899.</notr>
 - [#6]: <notr>[<notr>Muhammad al-Muqrī poem</notr>](http://www.uranos.fr/DOCU_03_T03.htm)</notr>
 - [#7]: <notr>Salih al-Shethri, Timetable for farmers *<notr>Jadwal fi ilm al-harth ala hisaab al-shuthoor</notr>* (جدول في علم الحرث على حساب الشثور) ISBN 9960-49-971-5</notr>
 - [#8]: <notr>[<notr>Official Calendar of the Kingdom of Saudi Arabia</notr>](http://www.ummulqura.org.sa/)</notr>
 - [#9]: <notr>Moon stations and Agriculture seasons. A bulletin by the Agriculture Administration of the Chamber of Commerce in Riyadh, Saudi Arabia. 2002</notr>
 - [#10]: <notr>Book of the Stars by al-Sufi (died 986): Critical edition with commentary by Khalid AlAjaji, digital edition, 2021 AD, كتاب الكواكب لأبي الحسين عبد الرحمن بن عمر الرازي المعروف بالصوفي (291-376)، تحقيق خالد بن عبد الله .</notr>
 - [#11]: <notr>Schjellerup, Description des etoiles fixes, 1874, p. 163. (Translation into French)</notr>
 - [#12]: <notr>Laffitte, Roland, Le Ciel des Arabes, Geuthner, Paris 2012</notr>
 - [#13]: Ibn Qutaybah, Al-Dinawarī, Abū Muḥammad ʿAbd Allah b. Muslim (died ~ 889), Kitab al-Anwāʾ (Book of meteorolgy), (Arabic print of the original book, Daʾirat al-Maʿarif al-Osmania, Hydarabad, India, 1956), أبو محمد عبد الله بن مسلم ابن قتيبة الدينوري (توفي 276 هـ)، كتاب الأنواء في مواسم العرب، دائرة المعارف العثمانية، حيدر أباد، الهند، 1375 هـ
 - [#14]: Al-Marzūqī, Abū ʿAli Aḥmad b. Muḥammad b. al-Ḥassan (died 1030), Al-Azminah wa al-amkinah (Times and Places), (Arabic print of the original book in 2002, World of Books, Beirut, Lebanon)., الإمام أبو علي أحمد بن محمد بن الحسن المرزوقي (توفي سنة 421 هـ)، الأزمنة والأمكنة، تحقيق د. محمد نايف الدليمي، عالم الكتب، بيروت، لبنان، 1422 هـ.
 - [#15]: Al-Ṯaqafī, ʿAbd Allah b. Ḥussayn b. ʿĀṣim (died ~ 1012), Al-Anwāʾ wa al-azminah (Meteorology and times), (Arabic print of the original book in 1996, Dar al-jeel, Beirut, Lebanon), عبد الله بن حسين بن عاصم الثقفي (توفي 403 هـ)، الأنواء والأزمنة، تحقيق: د. نوري حمودي القيسي، د. محمد نايف الدليمي، دار الجيل، بيروت، لبنان، 1416 هـ.
 - [#16]:  [Book of the stars by al-Ṣūfī (died 986): Critical edition with commentary by Khalid al-Ajaji, digital edition, 2021, كتاب الكواكب لأبي الحسين عبد الرحمن بن عمر الرازي المعروف بالصوفي (291-376)، تحقيق خالد بن عبد الله العجاجي](https://drive.google.com/drive/folders/1s6JXzftwjMQ5rgZoGE3718EtBLBZtjzr?usp=sharing)

## Authors

 Khalid al-Ajaji with additional documentation of this file by Susanne M Hoffmann.

## License

CC BY-NC-ND 4.0
