/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class ProxyErrorReportValve
extends ErrorReportValve {
    private static final Log log = LogFactory.getLog(ProxyErrorReportValve.class);
    protected boolean useRedirect = true;
    protected boolean usePropertiesFile = false;

    public boolean getUseRedirect() {
        return this.useRedirect;
    }

    public void setUseRedirect(boolean bl) {
        this.useRedirect = bl;
    }

    public boolean getUsePropertiesFile() {
        return this.usePropertiesFile;
    }

    public void setUsePropertiesFile(boolean bl) {
        this.usePropertiesFile = bl;
    }

    private String getRedirectUrl(Response response) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getSimpleName(), response.getLocale());
        String string = null;
        try {
            string = resourceBundle.getString(Integer.toString(response.getStatus()));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string == null) {
            try {
                string = resourceBundle.getString(Integer.toString(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void report(Request request, Response response, Throwable throwable) {
        Object object;
        Object object2;
        int n = response.getStatus();
        if (n < 400 || response.getContentWritten() > 0L) {
            return;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
        if (!atomicBoolean.get()) {
            return;
        }
        String string = null;
        if (this.usePropertiesFile) {
            string = this.getRedirectUrl(response);
        } else {
            object2 = this.findErrorPage(n, throwable);
            if (object2 != null) {
                string = object2.getLocation();
            }
        }
        if (string == null) {
            super.report(request, response, throwable);
            return;
        }
        if (!response.setErrorReported()) {
            return;
        }
        object2 = new StringBuilder(string);
        if (string.contains("?")) {
            ((StringBuilder)object2).append('&');
        } else {
            ((StringBuilder)object2).append('?');
        }
        try {
            ((StringBuilder)object2).append("requestUri=");
            ((StringBuilder)object2).append(URLEncoder.encode(request.getDecodedRequestURI(), request.getConnector().getURIEncoding()));
            ((StringBuilder)object2).append("&statusCode=");
            ((StringBuilder)object2).append(URLEncoder.encode(String.valueOf(n), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string2 = null;
        String string3 = null;
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.valves", request.getLocales());
        response.setLocale(stringManager.getLocale());
        try {
            string2 = stringManager.getString("http." + n + ".reason");
            string3 = stringManager.getString("http." + n + ".desc");
        }
        catch (Throwable throwable2) {
            ExceptionUtils.handleThrowable((Throwable)throwable2);
        }
        if (string2 == null || string3 == null) {
            string2 = stringManager.getString("errorReportValve.unknownReason");
            string3 = stringManager.getString("errorReportValve.noDescription");
        }
        try {
            ((StringBuilder)object2).append("&statusDescription=");
            ((StringBuilder)object2).append(URLEncoder.encode(string3, "UTF-8"));
            ((StringBuilder)object2).append("&statusReason=");
            ((StringBuilder)object2).append(URLEncoder.encode(string2, "UTF-8"));
            object = response.getMessage();
            if (object != null) {
                ((StringBuilder)object2).append("&message=");
                ((StringBuilder)object2).append(URLEncoder.encode((String)object, "UTF-8"));
            }
            if (throwable != null) {
                ((StringBuilder)object2).append("&throwable=");
                ((StringBuilder)object2).append(URLEncoder.encode(throwable.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        string = ((StringBuilder)object2).toString();
        if (this.useRedirect) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Redirecting error reporting to " + string));
            }
            try {
                response.sendRedirect(string);
            }
            catch (IOException iOException) {}
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Proxying error reporting to " + string));
            }
            object = null;
            try {
                URL uRL = new URI(string).toURL();
                object = (HttpURLConnection)uRL.openConnection();
                ((URLConnection)object).connect();
                response.setContentType(((URLConnection)object).getContentType());
                response.setContentLength(((URLConnection)object).getContentLength());
                ServletOutputStream servletOutputStream = response.getOutputStream();
                InputStream inputStream = uRL.openStream();
                IOTools.flow(inputStream, (OutputStream)servletOutputStream);
            }
            catch (IOException | IllegalArgumentException | URISyntaxException exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("proxyErrorReportValve.error", new Object[]{string}), (Throwable)exception);
                }
            }
            finally {
                if (object != null) {
                    ((HttpURLConnection)object).disconnect();
                }
            }
        }
    }
}

