/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptableObject {
    private static final long serialVersionUID = -7471457301304454454L;
    private static final Object CALL_TAG = "Call";
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeFunction function;
    Object[] originalArgs;
    boolean isStrict;
    private Arguments arguments;
    transient NativeCall parentActivationCall;

    static void init(Scriptable scriptable, boolean bl) {
        NativeCall nativeCall = new NativeCall();
        nativeCall.exportAsJSClass(1, scriptable, bl);
    }

    NativeCall() {
    }

    NativeCall(NativeFunction nativeFunction, Context context, Scriptable scriptable, Object[] objectArray, boolean bl, boolean bl2, boolean bl3) {
        this.function = nativeFunction;
        this.setParentScope(scriptable);
        this.originalArgs = objectArray == null ? ScriptRuntime.emptyArgs : objectArray;
        this.isStrict = bl2;
        int n = nativeFunction.getParamAndVarCount();
        int n2 = nativeFunction.getParamCount();
        if (n != 0) {
            Object object;
            if (bl3) {
                Object[] objectArray2;
                if (objectArray.length >= n2) {
                    objectArray2 = new Object[objectArray.length - n2];
                    System.arraycopy(objectArray, n2, objectArray2, 0, objectArray.length - n2);
                } else {
                    objectArray2 = ScriptRuntime.emptyArgs;
                }
                for (int i = 0; i < n2; ++i) {
                    object = nativeFunction.getParamOrVarName(i);
                    Object object2 = i < objectArray.length ? objectArray[i] : Undefined.instance;
                    this.defineProperty((String)object, object2, 4);
                }
                this.defineProperty(nativeFunction.getParamOrVarName(n2), (Object)context.newArray(scriptable, objectArray2), 4);
            } else {
                for (int i = 0; i < n2; ++i) {
                    String string = nativeFunction.getParamOrVarName(i);
                    object = i < objectArray.length ? objectArray[i] : Undefined.instance;
                    this.defineProperty(string, object, 4);
                }
            }
        }
        if (!super.has("arguments", (Scriptable)this) && !bl) {
            this.arguments = new Arguments(this);
            this.defineProperty("arguments", (Object)this.arguments, 4);
        }
        if (n != 0) {
            for (int i = n2; i < n; ++i) {
                String string = nativeFunction.getParamOrVarName(i);
                if (super.has(string, (Scriptable)this)) continue;
                if (nativeFunction.getParamOrVarConst(i)) {
                    this.defineProperty(string, Undefined.instance, 13);
                    continue;
                }
                if (nativeFunction instanceof InterpretedFunction && !((InterpretedFunction)nativeFunction).hasFunctionNamed(string)) continue;
                this.defineProperty(string, Undefined.instance, 4);
            }
        }
    }

    @Override
    public String getClassName() {
        return "Call";
    }

    @Override
    protected int findPrototypeId(String string) {
        return string.equals("constructor") ? 1 : 0;
    }

    @Override
    protected void initPrototypeId(int n) {
        if (n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = 1;
        String string = "constructor";
        this.initPrototypeMethod(CALL_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CALL_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            if (scriptable2 != null) {
                throw Context.reportRuntimeErrorById("msg.only.from.new", "Call");
            }
            ScriptRuntime.checkDeprecated(context, "Call");
            NativeCall nativeCall = new NativeCall();
            nativeCall.setPrototype(NativeCall.getObjectPrototype(scriptable));
            return nativeCall;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public void defineAttributesForArguments() {
        if (this.arguments != null) {
            this.arguments.defineAttributesForStrictMode();
        }
    }
}

