/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.stat.GaugeMetricInfo;
import org.infinispan.commons.stat.MetricInfo;
import org.jgroups.protocols.BATCH;
import org.jgroups.protocols.BATCH2;
import org.jgroups.protocols.CENTRAL_LOCK;
import org.jgroups.protocols.CENTRAL_LOCK2;
import org.jgroups.protocols.COMPRESS;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FD_SOCK2;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.FRAG;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.FRAG3;
import org.jgroups.protocols.FRAG4;
import org.jgroups.protocols.FlowControl;
import org.jgroups.protocols.Fragmentation;
import org.jgroups.protocols.Locking;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.MFC_NB;
import org.jgroups.protocols.PERF;
import org.jgroups.protocols.RED;
import org.jgroups.protocols.RSVP;
import org.jgroups.protocols.SEQUENCER;
import org.jgroups.protocols.SEQUENCER2;
import org.jgroups.protocols.SHARED_LOOPBACK;
import org.jgroups.protocols.STOMP;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCP_NIO2;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UFC_NB;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.pbcast.STATE;
import org.jgroups.protocols.pbcast.STATE_SOCK;
import org.jgroups.protocols.pbcast.STATE_TRANSFER;
import org.jgroups.protocols.pbcast.StreamingStateTransfer;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RELAY3;
import org.jgroups.stack.Protocol;

public class JGroupsMetricsMetadata {
    public static final Map<Class<? extends Protocol>, Collection<MetricInfo>> PROTOCOL_METADATA = new HashMap<Class<? extends Protocol>, Collection<MetricInfo>>();

    private JGroupsMetricsMetadata() {
    }

    static {
        ArrayList<GaugeMetricInfo> attributes = new ArrayList<GaugeMetricInfo>();
        attributes.add(new GaugeMetricInfo("getClientBindPortActual", "The actual client_bind_port", null, FD_SOCK::getClientBindPortActual));
        attributes.add(new GaugeMetricInfo("getNumSuspectEventsGenerated", "Number of suspect event generated", null, FD_SOCK::getNumSuspectEventsGenerated));
        attributes.add(new GaugeMetricInfo("getNumSuspectedMembers", "The number of currently suspected members", null, FD_SOCK::getNumSuspectedMembers));
        PROTOCOL_METADATA.put(FD_SOCK.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumberOfReceivedFragments", "Number of received fragments", null, Fragmentation::getNumberOfReceivedFragments));
        attributes.add(new GaugeMetricInfo("getNumberOfSentFragments", "Number of sent fragments", null, Fragmentation::getNumberOfSentFragments));
        PROTOCOL_METADATA.put(FRAG.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumberOfReceivedFragments", "Number of received fragments", null, Fragmentation::getNumberOfReceivedFragments));
        attributes.add(new GaugeMetricInfo("getNumberOfSentFragments", "Number of sent fragments", null, Fragmentation::getNumberOfSentFragments));
        PROTOCOL_METADATA.put(FRAG2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getViewHandlerSize", "", null, GMS::getViewHandlerSize));
        PROTOCOL_METADATA.put(GMS.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumVotes", "The number of votes for the current digest", null, STABLE::getNumVotes));
        attributes.add(new GaugeMetricInfo("getStabilityReceived", "", null, STABLE::getStabilityReceived));
        attributes.add(new GaugeMetricInfo("getStabilitySent", "", null, STABLE::getStabilitySent));
        attributes.add(new GaugeMetricInfo("getStableReceived", "", null, STABLE::getStableReceived));
        attributes.add(new GaugeMetricInfo("getStableSent", "", null, STABLE::getStableSent));
        PROTOCOL_METADATA.put(STABLE.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageStateSize", "", null, STATE_TRANSFER::getAverageStateSize));
        attributes.add(new GaugeMetricInfo("getNumberOfStateBytesSent", "", null, STATE_TRANSFER::getNumberOfStateBytesSent));
        attributes.add(new GaugeMetricInfo("getNumberOfStateRequests", "", null, STATE_TRANSFER::getNumberOfStateRequests));
        PROTOCOL_METADATA.put(STATE_TRANSFER.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumCompressions", "Number of compressions", null, COMPRESS::getNumCompressions));
        attributes.add(new GaugeMetricInfo("getNumUncompressions", "Number of un-compressions", null, COMPRESS::getNumUncompressions));
        PROTOCOL_METADATA.put(COMPRESS.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, TP::getDifferentClusterMessages));
        attributes.add(new GaugeMetricInfo("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, TP::getDifferentVersionMessages));
        attributes.add(new GaugeMetricInfo("getDroppedMessages", "Number of messages dropped when sending because of insufficient buffer space", null, UDP::getDroppedMessages));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsReceived", "", null, TP::getNumMcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsSent", "", null, TP::getNumMcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumRejectedMsgs", "", null, TP::getNumRejectedMsgs));
        attributes.add(new GaugeMetricInfo("getNumTimerTasks", "Number of timer tasks queued up for execution", null, TP::getNumTimerTasks));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsReceived", "", null, TP::getNumUcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsSent", "", null, TP::getNumUcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfThreadDumps", "", null, TP::getNumberOfThreadDumps));
        attributes.add(new GaugeMetricInfo("getTimerThreads", "Number of threads currently in the pool", null, TP::getTimerThreads));
        attributes.add(new GaugeMetricInfo("getLargestSize", "Largest number of threads in the thread pool", null, p -> p.getThreadPool().getLargestSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "Current number of threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSizeActive()));
        attributes.add(new GaugeMetricInfo("getNumBatchesReceived", "Number of batches received (by the transport)", null, p -> p.getMessageStats().getNumBatchesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBatchesSent", "Number of batches sent (by the bundler)", null, p -> p.getMessageStats().getNumBatchesSent()));
        attributes.add(new GaugeMetricInfo("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, p -> p.getMessageStats().getNumBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, p -> p.getMessageStats().getNumBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesReceived", "Number of multicast bytes received", null, p -> p.getMessageStats().getNumMcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesSent", "Number of multicast bytes sent", null, p -> p.getMessageStats().getNumMcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastsReceived", "Total number of multicast messages received", null, p -> p.getMessageStats().getNumMcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastsSent", "Number of multicast messages sent", null, p -> p.getMessageStats().getNumMcastsSent()));
        attributes.add(new GaugeMetricInfo("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, p -> p.getMessageStats().getNumMsgsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, p -> p.getMessageStats().getNumMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, p -> p.getMessageStats().getNumSingleMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesReceived", "Number of unicast bytes received", null, p -> p.getMessageStats().getNumUcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesSent", "Number of unicast bytes sent", null, p -> p.getMessageStats().getNumUcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastsReceived", "Number of unicast messages received", null, p -> p.getMessageStats().getNumUcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastsSent", "Number of unicast messages sent", null, p -> p.getMessageStats().getNumUcastsSent()));
        PROTOCOL_METADATA.put(UDP.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, TP::getDifferentClusterMessages));
        attributes.add(new GaugeMetricInfo("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, TP::getDifferentVersionMessages));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsReceived", "", null, TP::getNumMcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsSent", "", null, TP::getNumMcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumRejectedMsgs", "", null, TP::getNumRejectedMsgs));
        attributes.add(new GaugeMetricInfo("getNumTimerTasks", "Number of timer tasks queued up for execution", null, TP::getNumTimerTasks));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsReceived", "", null, TP::getNumUcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsSent", "", null, TP::getNumUcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfThreadDumps", "", null, TP::getNumberOfThreadDumps));
        attributes.add(new GaugeMetricInfo("getOpenConnections", "", null, TCP::getOpenConnections));
        attributes.add(new GaugeMetricInfo("getTimerThreads", "Number of threads currently in the pool", null, TP::getTimerThreads));
        attributes.add(new GaugeMetricInfo("getLargestSize", "Largest number of threads in the thread pool", null, p -> p.getThreadPool().getLargestSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "Current number of threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSizeActive()));
        attributes.add(new GaugeMetricInfo("getNumBatchesReceived", "Number of batches received (by the transport)", null, p -> p.getMessageStats().getNumBatchesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBatchesSent", "Number of batches sent (by the bundler)", null, p -> p.getMessageStats().getNumBatchesSent()));
        attributes.add(new GaugeMetricInfo("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, p -> p.getMessageStats().getNumBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, p -> p.getMessageStats().getNumBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesReceived", "Number of multicast bytes received", null, p -> p.getMessageStats().getNumMcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesSent", "Number of multicast bytes sent", null, p -> p.getMessageStats().getNumMcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastsReceived", "Total number of multicast messages received", null, p -> p.getMessageStats().getNumMcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastsSent", "Number of multicast messages sent", null, p -> p.getMessageStats().getNumMcastsSent()));
        attributes.add(new GaugeMetricInfo("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, p -> p.getMessageStats().getNumMsgsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, p -> p.getMessageStats().getNumMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, p -> p.getMessageStats().getNumSingleMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesReceived", "Number of unicast bytes received", null, p -> p.getMessageStats().getNumUcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesSent", "Number of unicast bytes sent", null, p -> p.getMessageStats().getNumUcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastsReceived", "Number of unicast messages received", null, p -> p.getMessageStats().getNumUcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastsSent", "Number of unicast messages sent", null, p -> p.getMessageStats().getNumUcastsSent()));
        PROTOCOL_METADATA.put(TCP.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, TP::getDifferentClusterMessages));
        attributes.add(new GaugeMetricInfo("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, TP::getDifferentVersionMessages));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsReceived", "", null, TP::getNumMcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsSent", "", null, TP::getNumMcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumRejectedMsgs", "", null, TP::getNumRejectedMsgs));
        attributes.add(new GaugeMetricInfo("getNumTimerTasks", "Number of timer tasks queued up for execution", null, TP::getNumTimerTasks));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsReceived", "", null, TP::getNumUcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsSent", "", null, TP::getNumUcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfThreadDumps", "", null, TP::getNumberOfThreadDumps));
        attributes.add(new GaugeMetricInfo("getTimerThreads", "Number of threads currently in the pool", null, TP::getTimerThreads));
        attributes.add(new GaugeMetricInfo("getLargestSize", "Largest number of threads in the thread pool", null, p -> p.getThreadPool().getLargestSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "Current number of threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSizeActive()));
        attributes.add(new GaugeMetricInfo("getNumBatchesReceived", "Number of batches received (by the transport)", null, p -> p.getMessageStats().getNumBatchesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBatchesSent", "Number of batches sent (by the bundler)", null, p -> p.getMessageStats().getNumBatchesSent()));
        attributes.add(new GaugeMetricInfo("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, p -> p.getMessageStats().getNumBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, p -> p.getMessageStats().getNumBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesReceived", "Number of multicast bytes received", null, p -> p.getMessageStats().getNumMcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesSent", "Number of multicast bytes sent", null, p -> p.getMessageStats().getNumMcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastsReceived", "Total number of multicast messages received", null, p -> p.getMessageStats().getNumMcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastsSent", "Number of multicast messages sent", null, p -> p.getMessageStats().getNumMcastsSent()));
        attributes.add(new GaugeMetricInfo("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, p -> p.getMessageStats().getNumMsgsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, p -> p.getMessageStats().getNumMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, p -> p.getMessageStats().getNumSingleMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesReceived", "Number of unicast bytes received", null, p -> p.getMessageStats().getNumUcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesSent", "Number of unicast bytes sent", null, p -> p.getMessageStats().getNumUcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastsReceived", "Number of unicast messages received", null, p -> p.getMessageStats().getNumUcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastsSent", "Number of unicast messages sent", null, p -> p.getMessageStats().getNumUcastsSent()));
        PROTOCOL_METADATA.put(TUNNEL.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getForwardTableSize", "Number of messages in the forward-table", null, SEQUENCER::getForwardTableSize));
        PROTOCOL_METADATA.put(SEQUENCER.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageFlushDuration", "", null, FLUSH::getAverageFlushDuration));
        attributes.add(new GaugeMetricInfo("getNumberOfFlushes", "", null, FLUSH::getNumberOfFlushes));
        attributes.add(new GaugeMetricInfo("getTotalTimeInFlush", "", null, FLUSH::getTotalTimeInFlush));
        PROTOCOL_METADATA.put(FLUSH.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageStateSize", "", null, StreamingStateTransfer::getAverageStateSize));
        attributes.add(new GaugeMetricInfo("getNumberOfStateBytesSent", "", null, StreamingStateTransfer::getNumberOfStateBytesSent));
        attributes.add(new GaugeMetricInfo("getNumberOfStateRequests", "", null, StreamingStateTransfer::getNumberOfStateRequests));
        attributes.add(new GaugeMetricInfo("getThreadPoolCompletedTasks", "", null, StreamingStateTransfer::getThreadPoolCompletedTasks));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "", null, StreamingStateTransfer::getThreadPoolSize));
        PROTOCOL_METADATA.put(STATE.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageStateSize", "", null, StreamingStateTransfer::getAverageStateSize));
        attributes.add(new GaugeMetricInfo("getNumberOfStateBytesSent", "", null, StreamingStateTransfer::getNumberOfStateBytesSent));
        attributes.add(new GaugeMetricInfo("getNumberOfStateRequests", "", null, StreamingStateTransfer::getNumberOfStateRequests));
        attributes.add(new GaugeMetricInfo("getThreadPoolCompletedTasks", "", null, StreamingStateTransfer::getThreadPoolCompletedTasks));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "", null, StreamingStateTransfer::getThreadPoolSize));
        PROTOCOL_METADATA.put(STATE_SOCK.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, TP::getDifferentClusterMessages));
        attributes.add(new GaugeMetricInfo("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, TP::getDifferentVersionMessages));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsReceived", "", null, TP::getNumMcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsSent", "", null, TP::getNumMcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumRejectedMsgs", "", null, TP::getNumRejectedMsgs));
        attributes.add(new GaugeMetricInfo("getNumTimerTasks", "Number of timer tasks queued up for execution", null, TP::getNumTimerTasks));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsReceived", "", null, TP::getNumUcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsSent", "", null, TP::getNumUcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfThreadDumps", "", null, TP::getNumberOfThreadDumps));
        attributes.add(new GaugeMetricInfo("getTimerThreads", "Number of threads currently in the pool", null, TP::getTimerThreads));
        attributes.add(new GaugeMetricInfo("getLargestSize", "Largest number of threads in the thread pool", null, p -> p.getThreadPool().getLargestSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "Current number of threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSizeActive()));
        attributes.add(new GaugeMetricInfo("getNumBatchesReceived", "Number of batches received (by the transport)", null, p -> p.getMessageStats().getNumBatchesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBatchesSent", "Number of batches sent (by the bundler)", null, p -> p.getMessageStats().getNumBatchesSent()));
        attributes.add(new GaugeMetricInfo("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, p -> p.getMessageStats().getNumBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, p -> p.getMessageStats().getNumBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesReceived", "Number of multicast bytes received", null, p -> p.getMessageStats().getNumMcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesSent", "Number of multicast bytes sent", null, p -> p.getMessageStats().getNumMcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastsReceived", "Total number of multicast messages received", null, p -> p.getMessageStats().getNumMcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastsSent", "Number of multicast messages sent", null, p -> p.getMessageStats().getNumMcastsSent()));
        attributes.add(new GaugeMetricInfo("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, p -> p.getMessageStats().getNumMsgsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, p -> p.getMessageStats().getNumMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, p -> p.getMessageStats().getNumSingleMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesReceived", "Number of unicast bytes received", null, p -> p.getMessageStats().getNumUcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesSent", "Number of unicast bytes sent", null, p -> p.getMessageStats().getNumUcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastsReceived", "Number of unicast messages received", null, p -> p.getMessageStats().getNumUcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastsSent", "Number of unicast messages sent", null, p -> p.getMessageStats().getNumUcastsSent()));
        PROTOCOL_METADATA.put(SHARED_LOOPBACK.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, MFC::getAverageTimeBlocked));
        attributes.add(new GaugeMetricInfo("getNumberOfBlockings", "Number of times flow control blocks sender", null, MFC::getNumberOfBlockings));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsReceived", "", null, FlowControl::getNumberOfCreditRequestsReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsSent", "", null, FlowControl::getNumberOfCreditRequestsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesReceived", "", null, FlowControl::getNumberOfCreditResponsesReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesSent", "", null, FlowControl::getNumberOfCreditResponsesSent));
        PROTOCOL_METADATA.put(MFC.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, UFC::getAverageTimeBlocked));
        attributes.add(new GaugeMetricInfo("getNumberOfBlockings", "Number of times flow control blocks sender", null, UFC::getNumberOfBlockings));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsReceived", "", null, FlowControl::getNumberOfCreditRequestsReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsSent", "", null, FlowControl::getNumberOfCreditRequestsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesReceived", "", null, FlowControl::getNumberOfCreditResponsesReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesSent", "", null, FlowControl::getNumberOfCreditResponsesSent));
        PROTOCOL_METADATA.put(UFC.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumConnections", "Number of client connections", null, STOMP::getNumConnections));
        attributes.add(new GaugeMetricInfo("getNumSubscriptions", "Number of subscriptions", null, STOMP::getNumSubscriptions));
        PROTOCOL_METADATA.put(STOMP.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumClientLocks", "Number of client locks", null, Locking::getNumClientLocks));
        attributes.add(new GaugeMetricInfo("getNumServerLocks", "Number of server locks (only on coord)", null, Locking::getNumServerLocks));
        PROTOCOL_METADATA.put(CENTRAL_LOCK.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumMergeEvents", "Number of times a MERGE event was sent up the stack", null, MERGE3::getNumMergeEvents));
        attributes.add(new GaugeMetricInfo("getViews", "Number of cached ViewIds", null, MERGE3::getViews));
        PROTOCOL_METADATA.put(MERGE3.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getPendingRsvpRequests", "Number of pending RSVP requests", null, RSVP::getPendingRsvpRequests));
        PROTOCOL_METADATA.put(RSVP.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getBecomeServerQueueSizeActual", "Actual size of the become_server_queue", null, NAKACK2::getBecomeServerQueueSizeActual));
        attributes.add(new GaugeMetricInfo("getCurrentSeqno", "", null, NAKACK2::getCurrentSeqno));
        attributes.add(new GaugeMetricInfo("getNonMemberMessages", "Number of messages from non-members", null, NAKACK2::getNonMemberMessages));
        attributes.add(new GaugeMetricInfo("getNumMessagesReceived", "Number of messages received", null, NAKACK2::getNumMessagesReceived));
        attributes.add(new GaugeMetricInfo("getNumMessagesSent", "Number of messages sent", null, NAKACK2::getNumMessagesSent));
        attributes.add(new GaugeMetricInfo("getSizeOfAllMessages", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used", null, NAKACK2::getSizeOfAllMessages));
        attributes.add(new GaugeMetricInfo("getSizeOfAllMessagesInclHeaders", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used", null, NAKACK2::getSizeOfAllMessagesInclHeaders));
        attributes.add(new GaugeMetricInfo("getXmitTableCapacity", "Capacity of the retransmit buffer. Computed as xmit_table_num_rows * xmit_table_msgs_per_row", null, NAKACK2::getXmitTableCapacity));
        attributes.add(new GaugeMetricInfo("getXmitTableMissingMessages", "Total number of missing (= not received) messages in all retransmit buffers", null, NAKACK2::getXmitTableMissingMessages));
        attributes.add(new GaugeMetricInfo("getXmitTableNumCompactions", "Number of retransmit table compactions", null, NAKACK2::getXmitTableNumCompactions));
        attributes.add(new GaugeMetricInfo("getXmitTableNumCurrentRows", "Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows", null, NAKACK2::getXmitTableNumCurrentRows));
        attributes.add(new GaugeMetricInfo("getXmitTableNumMoves", "Number of retransmit table moves", null, NAKACK2::getXmitTableNumMoves));
        attributes.add(new GaugeMetricInfo("getXmitTableNumPurges", "Number of retransmit table purges", null, NAKACK2::getXmitTableNumPurges));
        attributes.add(new GaugeMetricInfo("getXmitTableNumResizes", "Number of retransmit table resizes", null, NAKACK2::getXmitTableNumResizes));
        attributes.add(new GaugeMetricInfo("getXmitTableUndeliveredMsgs", "Total number of undelivered messages in all retransmit buffers", null, NAKACK2::getXmitTableUndeliveredMsgs));
        PROTOCOL_METADATA.put(NAKACK2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", null, RELAY::getAvgMsgsForwardingToLocalMbr));
        attributes.add(new GaugeMetricInfo("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", null, RELAY::getAvgMsgsForwardingToSM));
        attributes.add(new GaugeMetricInfo("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", null, RELAY::getAvgMsgsRelaying));
        attributes.add(new GaugeMetricInfo("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", null, RELAY::getNumForwardedToLocalMbr));
        attributes.add(new GaugeMetricInfo("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", null, RELAY::getNumForwardedToSiteMaster));
        attributes.add(new GaugeMetricInfo("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", null, RELAY::getNumRelayed));
        attributes.add(new GaugeMetricInfo("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", null, RELAY::getNumberOfNoRouteErrors));
        attributes.add(new GaugeMetricInfo("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", null, RELAY::getTimeForwardingToLocalMbr));
        attributes.add(new GaugeMetricInfo("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", null, RELAY::getTimeForwardingToSM));
        attributes.add(new GaugeMetricInfo("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", null, RELAY::getTimeRelaying));
        PROTOCOL_METADATA.put(RELAY2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", null, RELAY::getAvgMsgsForwardingToLocalMbr));
        attributes.add(new GaugeMetricInfo("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", null, RELAY::getAvgMsgsForwardingToSM));
        attributes.add(new GaugeMetricInfo("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", null, RELAY::getAvgMsgsRelaying));
        attributes.add(new GaugeMetricInfo("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", null, RELAY::getNumForwardedToLocalMbr));
        attributes.add(new GaugeMetricInfo("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", null, RELAY::getNumForwardedToSiteMaster));
        attributes.add(new GaugeMetricInfo("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", null, RELAY::getNumRelayed));
        attributes.add(new GaugeMetricInfo("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", null, RELAY::getNumberOfNoRouteErrors));
        attributes.add(new GaugeMetricInfo("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", null, RELAY::getTimeForwardingToLocalMbr));
        attributes.add(new GaugeMetricInfo("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", null, RELAY::getTimeForwardingToSM));
        attributes.add(new GaugeMetricInfo("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", null, RELAY::getTimeRelaying));
        PROTOCOL_METADATA.put(RELAY3.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAgeOutCacheSize", "", null, UNICAST3::getAgeOutCacheSize));
        attributes.add(new GaugeMetricInfo("getNumAcksReceived", "Number of acks received", null, UNICAST3::getNumAcksReceived));
        attributes.add(new GaugeMetricInfo("getNumAcksSent", "Number of acks sent", null, UNICAST3::getNumAcksSent));
        attributes.add(new GaugeMetricInfo("getNumConnections", "Returns the total number of outgoing (send) and incoming (receive) connections", null, UNICAST3::getNumConnections));
        attributes.add(new GaugeMetricInfo("getNumLoopbacks", "Number of unicast messages to self looped back up", null, UNICAST3::getNumLoopbacks));
        attributes.add(new GaugeMetricInfo("getNumMessagesReceived", "", null, UNICAST3::getNumMessagesReceived));
        attributes.add(new GaugeMetricInfo("getNumMessagesSent", "", null, UNICAST3::getNumMessagesSent));
        attributes.add(new GaugeMetricInfo("getNumReceiveConnections", "Returns the number of incoming (receive) connections", null, UNICAST3::getNumReceiveConnections));
        attributes.add(new GaugeMetricInfo("getNumSendConnections", "Returns the number of outgoing (send) connections", null, UNICAST3::getNumSendConnections));
        attributes.add(new GaugeMetricInfo("getNumUnackedMessages", "", null, UNICAST3::getNumUnackedMessages));
        attributes.add(new GaugeMetricInfo("getNumXmits", "Number of retransmitted messages", null, UNICAST3::getNumXmits));
        attributes.add(new GaugeMetricInfo("getTimestamper", "Next seqno issued by the timestamper", null, UNICAST3::getTimestamper));
        attributes.add(new GaugeMetricInfo("getXmitTableDeliverableMessages", "Total number of deliverable messages in all receive windows", null, UNICAST3::getXmitTableDeliverableMessages));
        attributes.add(new GaugeMetricInfo("getXmitTableMissingMessages", "Total number of missing messages in all receive windows", null, UNICAST3::getXmitTableMissingMessages));
        attributes.add(new GaugeMetricInfo("getXmitTableNumCompactions", "Number of compactions in all (receive and send) windows", null, UNICAST3::getXmitTableNumCompactions));
        attributes.add(new GaugeMetricInfo("getXmitTableNumMoves", "Number of moves in all (receive and send) windows", null, UNICAST3::getXmitTableNumMoves));
        attributes.add(new GaugeMetricInfo("getXmitTableNumPurges", "Number of purges in all (receive and send) windows", null, UNICAST3::getXmitTableNumPurges));
        attributes.add(new GaugeMetricInfo("getXmitTableNumResizes", "Number of resizes in all (receive and send) windows", null, UNICAST3::getXmitTableNumResizes));
        attributes.add(new GaugeMetricInfo("getXmitTableUndeliveredMessages", "Total number of undelivered messages in all receive windows", null, UNICAST3::getXmitTableUndeliveredMessages));
        PROTOCOL_METADATA.put(UNICAST3.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("latencyInMs", "Average latency in ms", null, PERF::latencyInMs));
        attributes.add(new GaugeMetricInfo("latencyInNs", "Average latency in ns", null, PERF::latencyInNs));
        PROTOCOL_METADATA.put(PERF.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getFwdQueueSize", "Number of messages in the forward-queue", null, SEQUENCER2::getFwdQueueSize));
        PROTOCOL_METADATA.put(SEQUENCER2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, TP::getDifferentClusterMessages));
        attributes.add(new GaugeMetricInfo("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, TP::getDifferentVersionMessages));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsReceived", "", null, TP::getNumMcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumMcastMsgsSent", "", null, TP::getNumMcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumRejectedMsgs", "", null, TP::getNumRejectedMsgs));
        attributes.add(new GaugeMetricInfo("getNumTimerTasks", "Number of timer tasks queued up for execution", null, TP::getNumTimerTasks));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsReceived", "", null, TP::getNumUcastMsgsReceived));
        attributes.add(new GaugeMetricInfo("getNumUcastMsgsSent", "", null, TP::getNumUcastMsgsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfThreadDumps", "", null, TP::getNumberOfThreadDumps));
        attributes.add(new GaugeMetricInfo("getOpenConnections", "", null, TCP_NIO2::getOpenConnections));
        attributes.add(new GaugeMetricInfo("getTimerThreads", "Number of threads currently in the pool", null, TP::getTimerThreads));
        attributes.add(new GaugeMetricInfo("numPartialWrites", "Number of partial writes for all connections (not all bytes were written)", null, TCP_NIO2::numPartialWrites));
        attributes.add(new GaugeMetricInfo("numSelects", "Number of times select() was called", null, TCP_NIO2::numSelects));
        attributes.add(new GaugeMetricInfo("getLargestSize", "Largest number of threads in the thread pool", null, p -> p.getThreadPool().getLargestSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSize", "Current number of threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSize()));
        attributes.add(new GaugeMetricInfo("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, p -> p.getThreadPool().getThreadPoolSizeActive()));
        attributes.add(new GaugeMetricInfo("getNumBatchesReceived", "Number of batches received (by the transport)", null, p -> p.getMessageStats().getNumBatchesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBatchesSent", "Number of batches sent (by the bundler)", null, p -> p.getMessageStats().getNumBatchesSent()));
        attributes.add(new GaugeMetricInfo("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, p -> p.getMessageStats().getNumBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, p -> p.getMessageStats().getNumBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesReceived", "Number of multicast bytes received", null, p -> p.getMessageStats().getNumMcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastBytesSent", "Number of multicast bytes sent", null, p -> p.getMessageStats().getNumMcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumMcastsReceived", "Total number of multicast messages received", null, p -> p.getMessageStats().getNumMcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMcastsSent", "Number of multicast messages sent", null, p -> p.getMessageStats().getNumMcastsSent()));
        attributes.add(new GaugeMetricInfo("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, p -> p.getMessageStats().getNumMsgsReceived()));
        attributes.add(new GaugeMetricInfo("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, p -> p.getMessageStats().getNumMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, p -> p.getMessageStats().getNumSingleMsgsSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesReceived", "Number of unicast bytes received", null, p -> p.getMessageStats().getNumUcastBytesReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastBytesSent", "Number of unicast bytes sent", null, p -> p.getMessageStats().getNumUcastBytesSent()));
        attributes.add(new GaugeMetricInfo("getNumUcastsReceived", "Number of unicast messages received", null, p -> p.getMessageStats().getNumUcastsReceived()));
        attributes.add(new GaugeMetricInfo("getNumUcastsSent", "Number of unicast messages sent", null, p -> p.getMessageStats().getNumUcastsSent()));
        PROTOCOL_METADATA.put(TCP_NIO2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumberOfReceivedFragments", "Number of received fragments", null, Fragmentation::getNumberOfReceivedFragments));
        attributes.add(new GaugeMetricInfo("getNumberOfSentFragments", "Number of sent fragments", null, Fragmentation::getNumberOfSentFragments));
        PROTOCOL_METADATA.put(FRAG3.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, UFC::getAverageTimeBlocked));
        attributes.add(new GaugeMetricInfo("getNumberOfBlockings", "Number of times flow control blocks sender", null, UFC::getNumberOfBlockings));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsReceived", "", null, FlowControl::getNumberOfCreditRequestsReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsSent", "", null, FlowControl::getNumberOfCreditRequestsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesReceived", "", null, FlowControl::getNumberOfCreditResponsesReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesSent", "", null, FlowControl::getNumberOfCreditResponsesSent));
        attributes.add(new GaugeMetricInfo("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", null, UFC_NB::getNumberOfQueuedMessages));
        attributes.add(new GaugeMetricInfo("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", null, UFC_NB::getNumberOfQueuings));
        attributes.add(new GaugeMetricInfo("getQueuedSize", "The total size of all currently queued messages for all destinations", null, UFC_NB::getQueuedSize));
        PROTOCOL_METADATA.put(UFC_NB.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, MFC::getAverageTimeBlocked));
        attributes.add(new GaugeMetricInfo("getNumberOfBlockings", "Number of times flow control blocks sender", null, MFC::getNumberOfBlockings));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsReceived", "", null, FlowControl::getNumberOfCreditRequestsReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditRequestsSent", "", null, FlowControl::getNumberOfCreditRequestsSent));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesReceived", "", null, FlowControl::getNumberOfCreditResponsesReceived));
        attributes.add(new GaugeMetricInfo("getNumberOfCreditResponsesSent", "", null, FlowControl::getNumberOfCreditResponsesSent));
        attributes.add(new GaugeMetricInfo("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", null, MFC_NB::getNumberOfQueuedMessages));
        attributes.add(new GaugeMetricInfo("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", null, MFC_NB::getNumberOfQueuings));
        attributes.add(new GaugeMetricInfo("getQueuedSize", "The total size of all currently queued messages", null, MFC_NB::getQueuedSize));
        PROTOCOL_METADATA.put(MFC_NB.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumClientLocks", "Number of client locks", null, Locking::getNumClientLocks));
        attributes.add(new GaugeMetricInfo("getNumServerLocks", "Number of server locks (only on coord)", null, Locking::getNumServerLocks));
        attributes.add(new GaugeMetricInfo("requestQueueSize", "", null, CENTRAL_LOCK2::requestQueueSize));
        PROTOCOL_METADATA.put(CENTRAL_LOCK2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getNumberOfReceivedFragments", "Number of received fragments", null, Fragmentation::getNumberOfReceivedFragments));
        attributes.add(new GaugeMetricInfo("getNumberOfSentFragments", "Number of sent fragments", null, Fragmentation::getNumberOfSentFragments));
        PROTOCOL_METADATA.put(FRAG4.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getActualBindPort", "Actual port the server is listening on", null, FD_SOCK2::getActualBindPort));
        attributes.add(new GaugeMetricInfo("getNumSuspectedMembers", "The number of currently suspected members", null, FD_SOCK2::getNumSuspectedMembers));
        PROTOCOL_METADATA.put(FD_SOCK2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("avgBatchSize", "Average number of messages in an BatchMessage", null, BATCH::avgBatchSize));
        PROTOCOL_METADATA.put(BATCH.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("avgBatchSize", "Average number of messages in an BatchMessage", null, BATCH2::avgBatchSize));
        PROTOCOL_METADATA.put(BATCH2.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getForkStacks", "Number of fork-stacks", null, FORK::getForkStacks));
        PROTOCOL_METADATA.put(FORK.class, attributes);
        attributes = new ArrayList();
        attributes.add(new GaugeMetricInfo("getDropRate", "Percentage of all messages that were dropped", null, RED::getDropRate));
        attributes.add(new GaugeMetricInfo("getDroppedMessages", "", null, RED::getDroppedMessages));
        attributes.add(new GaugeMetricInfo("getTotalMessages", "", null, RED::getTotalMessages));
        PROTOCOL_METADATA.put(RED.class, attributes);
    }
}

