/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ResizableWindow
extends JWindow
implements ResizableSupport {
    private ResizablePanel _resizablePanel;
    private boolean _routingKeyStrokes;

    public ResizableWindow() {
        this.initComponents();
    }

    public ResizableWindow(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public ResizableWindow(GraphicsConfiguration gc) {
        super(gc);
        this.initComponents();
    }

    public ResizableWindow(Window owner) {
        super(owner);
        this.initComponents();
    }

    public ResizableWindow(Window owner, GraphicsConfiguration gc) {
        super(owner, gc);
        this.initComponents();
    }

    protected void initComponents() {
        this._resizablePanel = new ResizablePanel(){

            @Override
            protected Resizable createResizable() {
                return new Resizable(this){

                    @Override
                    public void resizing(int resizeDir, int newX, int newY, int newW, int newH) {
                        Container container = ResizableWindow.this.getContentPane();
                        PortingUtils.setPreferredSize(container, new Dimension(newW, newH));
                        ResizableWindow.this.setBounds(newX, newY, newW, newH);
                        ResizableWindow.this.resizing();
                    }

                    @Override
                    public void beginResizing(int resizeCorner) {
                        super.beginResizing(resizeCorner);
                        ResizableWindow.this.beginResizing();
                    }

                    @Override
                    public void endResizing(int resizeCorner) {
                        super.endResizing(resizeCorner);
                        ResizableWindow.this.endResizing();
                    }

                    @Override
                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean processed = super.processKeyBinding(ks, e, condition, pressed);
                if (processed || e.isConsumed() || !ResizableWindow.this.isRoutingKeyStrokes()) {
                    return processed;
                }
                if (e.getSource() instanceof JComponent) {
                    Class<?> componentClass;
                    JRootPane rootPane = ((JComponent)e.getSource()).getRootPane();
                    for (componentClass = rootPane.getClass(); componentClass != JComponent.class && componentClass != null; componentClass = componentClass.getSuperclass()) {
                    }
                    try {
                        if (componentClass != null) {
                            Method m3 = componentClass.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                            m3.setAccessible(true);
                            processed = (Boolean)m3.invoke((Object)rootPane, ks, e, 2, pressed);
                        }
                    }
                    catch (NoSuchMethodException e1) {
                        e1.printStackTrace();
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                }
                if (processed || e.isConsumed()) {
                    return processed;
                }
                Component routingParent = ResizableWindow.this.getRoutingComponent();
                if (routingParent == null) {
                    return false;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(routingParent, e);
                return e.isConsumed();
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ResizableWindow.this._resizablePanel.setSize(ResizableWindow.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    @Override
    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    @Override
    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    @Override
    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }

    public Component getRoutingComponent() {
        return this.getOwner();
    }

    public void setRoutingKeyStrokes(boolean routingKeyStrokes) {
        this._routingKeyStrokes = routingKeyStrokes;
    }

    public boolean isRoutingKeyStrokes() {
        return this._routingKeyStrokes;
    }
}

