/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.browser;

import java.util.List;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.browser.BrowserViewSupport;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.RequestProcessor;

class JFRSnapshotBrowserView
extends JFRViewTab {
    JFRSnapshotBrowserView(JFRSnapshot snapshot) {
        super(snapshot, "Browser", Icons.getImage((String)"GeneralIcons.Find"), 80);
    }

    @Override
    protected DataViewComponent createComponent() {
        final JFRModel model = this.getModel();
        if (model == null) {
            BrowserViewSupport.MasterViewSupport masterView = new BrowserViewSupport.MasterViewSupport(model){

                @Override
                void firstShown() {
                }

                @Override
                void eventsFilterChanged(BrowserViewSupport.EventsFilter newFilter) {
                }

                @Override
                void includeExperimentalChanged(boolean newExperimental) {
                }
            };
            return new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        }
        final BrowserViewSupport.StackTraceViewSupport stackTracePane = new BrowserViewSupport.StackTraceViewSupport(){

            @Override
            JFREvent getEvent(long id) {
                return model.getEvent(id);
            }
        };
        final BrowserViewSupport.EventsTableViewSupport eventsTable = new BrowserViewSupport.EventsTableViewSupport(){

            @Override
            void idSelected(long id) {
                stackTracePane.idSelected(id);
            }
        };
        eventsTable.setIncludeExperimental(false);
        eventsTable.setEventsFilter(BrowserViewSupport.EventsFilter.ALL);
        final BrowserViewSupport.EventsTreeViewSupport eventsTree = new BrowserViewSupport.EventsTreeViewSupport(model.getEventsCount()){

            @Override
            void eventsSelected(String eventType, long eventsCount, List<JFRDataDescriptor> dataDescriptors) {
                JFRSnapshotBrowserView.this.initialize(null, new JFREventVisitor[]{eventsTable.getVisitor(eventType, eventsCount, dataDescriptors)});
            }
        };
        eventsTree.setIncludeExperimental(false);
        BrowserViewSupport.MasterViewSupport masterView = new BrowserViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                JFRSnapshotBrowserView.this.initialize(eventsTree, new JFREventVisitor[]{this, eventsTree.getVisitor()});
            }

            @Override
            void eventsFilterChanged(BrowserViewSupport.EventsFilter newFilter) {
                eventsTable.setEventsFilter(newFilter);
                eventsTree.refreshSelection();
            }

            @Override
            void includeExperimentalChanged(boolean newExperimental) {
                eventsTree.setIncludeExperimental(newExperimental);
                eventsTable.setIncludeExperimental(newExperimental);
                eventsTree.pauseSelection();
                JFRSnapshotBrowserView.this.initialize(eventsTree, new JFREventVisitor[]{this, eventsTree.getVisitor()});
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(0.35, 0.0, -1.0, -1.0, 0.65, 1.0));
        dvc.addDetailsView(eventsTree.getDetailsView(), 1);
        dvc.addDetailsView(eventsTable.getDetailsView(), 2);
        dvc.addDetailsView(stackTracePane.getDetailsView(), 4);
        dvc.hideDetailsArea(4);
        return dvc;
    }

    private void initialize(final JFREventTypeVisitor typeVisitor, final JFREventVisitor ... visitors) {
        new RequestProcessor("JFR Events Browser Initializer").post(new Runnable(){

            @Override
            public void run() {
                if (typeVisitor != null) {
                    JFRSnapshotBrowserView.this.getModel().visitEventTypes(typeVisitor);
                }
                JFRSnapshotBrowserView.this.getModel().visitEvents(visitors);
            }
        });
    }
}

