/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceViewPluginProvider;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;

public abstract class DataSourceViewPlugin {
    private DataSource dataSource;
    private DataSourceViewPluginProvider controller;

    public DataSourceViewPlugin(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public abstract DataViewComponent.DetailsView createView(int var1);

    protected void willBeAdded() {
    }

    protected void added() {
    }

    protected void removed() {
    }

    void pluginWillBeAdded() {
        this.willBeAdded();
        this.controller.pluginWillBeAdded(this);
    }

    void pluginAdded() {
        this.added();
        this.controller.pluginAdded(this);
    }

    void pluginRemoved() {
        this.removed();
        this.controller.pluginRemoved(this);
    }

    void setController(DataSourceViewPluginProvider controller) {
        this.controller = controller;
    }
}

