/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;
import com.sparshui.server.TouchPoint;

public class TouchEvent
implements Event {
    private static final long serialVersionUID = 370824346017492361L;
    private int _id;
    private float _x;
    private float _y;
    private int _state;
    private long _time;

    public TouchEvent() {
        this._id = Integer.MAX_VALUE;
        this._x = 0.0f;
        this._y = 0.0f;
        this._state = 0;
    }

    public TouchEvent(int id, float x, float y, int state) {
        this._id = id;
        this._x = x;
        this._y = y;
        this._state = state;
        this._time = System.currentTimeMillis();
    }

    public TouchEvent(TouchPoint tp) {
        this._id = tp.getID();
        this._x = tp.getLocation().getX();
        this._y = tp.getLocation().getY();
        this._state = tp.getState();
        this._time = tp.getTime();
    }

    public int getTouchID() {
        return this._id;
    }

    public long getTime() {
        return this._time;
    }

    public float getX() {
        return this._x;
    }

    public float getY() {
        return this._y;
    }

    public void setX(float x) {
        this._x = x;
    }

    public void setY(float y) {
        this._y = y;
    }

    public int getState() {
        return this._state;
    }

    @Override
    public int getEventType() {
        return 3;
    }

    public TouchEvent(byte[] data) {
        if (data.length < 24) {
            System.err.println("An error occurred while deserializing a TouchEvent.");
        } else {
            this._id = Converter.byteArrayToInt(data, 0);
            this._x = Converter.byteArrayToFloat(data, 4);
            this._y = Converter.byteArrayToFloat(data, 8);
            this._state = Converter.byteArrayToInt(data, 12);
            this._time = Converter.byteArrayToLong(data, 16);
        }
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[28];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.intToByteArray(data, 4, this._id);
        Converter.floatToByteArray(data, 8, this._x);
        Converter.floatToByteArray(data, 12, this._y);
        Converter.intToByteArray(data, 16, this._state);
        Converter.longToByteArray(data, 20, this._time);
        return data;
    }

    public String toString() {
        return "Touch Event: ID: " + this._id + ", X: " + this._x + ", Y: " + this._y + "State: " + this._state;
    }
}

