/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Encoding;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.exception.JSVException;
import org.jmol.api.GenericFileInterface;
import org.jmol.util.Logger;

@J2SIgnoreImport(value={FileOutputStream.class})
public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static final boolean newInterface = true;
    private static Map<String, String> htCorrelationCache;
    private static String cacheDir;
    private static String nciResolver;
    private static String nmrdbServerH1Old;
    private static String nmrdbServerC13Old;
    private static String nmrdbServerH1New;
    private static String nmrdbServerC13New;
    private static int stringCount;

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String name) {
        if (name == null) {
            return null;
        }
        SB sb = new SB();
        try {
            String line;
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.appendC('\n');
            }
            br.close();
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream in) {
        try {
            return new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForStringOrBytes(Object stringOrBytes) {
        return stringOrBytes == null ? null : new BufferedReader(new StringReader(stringOrBytes instanceof String ? (String)stringOrBytes : new String((byte[])stringOrBytes)));
    }

    public static BufferedReader getBufferedReaderFromName(String name) throws Exception {
        if (name == null) {
            throw new JSVException("Cannot find " + name);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + name);
        String path = JSVFileManager.getFullPathName(name);
        if (!path.equals(name)) {
            Logger.info("JSVFileManager getBufferedReaderFromName " + path);
        }
        return JSVFileManager.getUnzippedBufferedReaderFromName(path);
    }

    public static String getFullPathName(String name) throws JSVException {
        try {
            if (appletDocumentBase == null) {
                if (JSVFileManager.isURL(name)) {
                    URL url = new URL((URL)null, name, null);
                    return url.toString();
                }
                return JSVFileManager.newFile(name).getFullPath();
            }
            if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
                name = "file:///" + name;
            } else if (name.startsWith("cache://")) {
                return name;
            }
            URL url = new URL(appletDocumentBase, name, null);
            return url.toString();
        }
        catch (Exception e) {
            throw new JSVException("Cannot create path for " + name);
        }
    }

    public static boolean isURL(String name) {
        int i = urlPrefixes.length;
        while (--i >= 0) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String name) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLocal(String fileName) {
        if (fileName == null) {
            return false;
        }
        int itype = JSVFileManager.urlTypeIndex(fileName);
        return itype < 0 || itype == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String name) throws Exception {
        BufferedInputStream bis;
        String[] subFileList = null;
        if (name.indexOf("|") >= 0 && (subFileList = PT.split(name, "|")) != null && subFileList.length > 0) {
            name = subFileList[0];
        }
        if (name.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getSimulationReader(name);
        }
        InputStream ret = JSVFileManager.getInputStream(name, true, null);
        if (ret instanceof SB || ret instanceof String) {
            return new BufferedReader(new StringReader(ret.toString()));
        }
        if (JSVFileManager.isAB(ret)) {
            return new BufferedReader(new StringReader(new String((byte[])ret)));
        }
        InputStream in = bis = new BufferedInputStream(ret);
        if (JSVFileManager.isGzip(bis)) {
            in = ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newGZIPInputStream(in);
        }
        return new BufferedReader(new InputStreamReader(in, "UTF-8"));
    }

    public static String getAbbrSimulationFileName(String name) {
        String type = JSVFileManager.getSimulationType(name);
        String filename = JSVFileManager.getAbbreviatedSimulationName(name, type, true);
        return filename;
    }

    static String getAbbreviatedSimulationName(String name, String type, boolean addProtocol) {
        return name.indexOf("MOL=") >= 0 ? (addProtocol ? SIMULATION_PROTOCOL : "") + "MOL=" + JSVFileManager.getSimulationHash(name, type) : name;
    }

    private static String getSimulationHash(String name, String type) {
        String code = type + Math.abs(name.substring(name.indexOf("V2000") + 1).hashCode());
        if (Logger.debugging) {
            System.out.println("JSVFileManager hash for " + name + " = " + code);
        }
        return code;
    }

    public static String getSimulationFileData(String name, String type) {
        return JSVFileManager.cacheGet(name.startsWith("MOL=") ? name.substring(4) : JSVFileManager.getAbbreviatedSimulationName(name, type, false));
    }

    public static void cachePut(String name, String data) {
        if (Logger.debugging) {
            Logger.debug("JSVFileManager cachePut " + data + " for " + name);
        }
        if (data != null) {
            name = "new-" + name;
            htCorrelationCache.put(name, data);
            if (cacheDir != null && name.indexOf(":") < 0) {
                try {
                    new File(cacheDir).mkdirs();
                    File f = new File(cacheDir, name);
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(data.getBytes());
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String cacheGet(String key) {
        key = "new-" + key;
        String data = htCorrelationCache.get(key);
        if (Logger.debugging) {
            Logger.info("JSVFileManager cacheGet " + data + " for " + key);
        }
        return data;
    }

    private static BufferedReader getSimulationReader(String name) {
        String data = JSVFileManager.cacheGet(name);
        if (data == null) {
            data = JSVFileManager.getNMRSimulationJCampDX(name.substring(SIMULATION_PROTOCOL.length()));
            JSVFileManager.cachePut(name, data);
        }
        return JSVFileManager.getBufferedReaderForStringOrBytes(data);
    }

    public static boolean isAB(Object x) {
        return AU.isAB(x);
    }

    public static boolean isZipFile(InputStream is) throws JSVException {
        try {
            byte[] abMagic = new byte[4];
            is.mark(5);
            int countRead = is.read(abMagic, 0, 4);
            is.reset();
            return countRead == 4 && abMagic[0] == 80 && abMagic[1] == 75 && abMagic[2] == 3 && abMagic[3] == 4;
        }
        catch (Exception e) {
            throw new JSVException(e.toString());
        }
    }

    private static boolean isGzip(InputStream is) throws JSVException {
        try {
            byte[] abMagic = new byte[4];
            is.mark(5);
            int countRead = is.read(abMagic, 0, 4);
            is.reset();
            return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
        }
        catch (Exception e) {
            throw new JSVException(e.toString());
        }
    }

    public static Object getStreamAsBytes(BufferedInputStream bis, OC out) throws JSVException {
        try {
            byte[] buf = new byte[1024];
            byte[] bytes = out == null ? new byte[4096] : null;
            int len = 0;
            int totalLen = 0;
            while ((len = bis.read(buf, 0, 1024)) > 0) {
                totalLen += len;
                if (out == null) {
                    if (totalLen >= bytes.length) {
                        bytes = AU.ensureLengthByte(bytes, totalLen * 2);
                    }
                    System.arraycopy(buf, 0, bytes, totalLen - len, len);
                    continue;
                }
                out.write(buf, 0, len);
            }
            bis.close();
            if (out == null) {
                return AU.arrayCopyByte(bytes, totalLen);
            }
            return totalLen + " bytes";
        }
        catch (Exception e) {
            throw new JSVException(e.toString());
        }
    }

    public static String postByteArray(String fileName, byte[] bytes) {
        Object ret = null;
        try {
            ret = JSVFileManager.getInputStream(fileName, false, bytes);
        }
        catch (Exception e) {
            ret = e.toString();
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        try {
            ret = JSVFileManager.getStreamAsBytes((BufferedInputStream)ret, null);
        }
        catch (JSVException e) {
            try {
                ((BufferedInputStream)ret).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret == null ? "" : JSVFileManager.fixUTF((byte[])ret);
    }

    private static Encoding getUTFEncoding(byte[] bytes) {
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return Encoding.UTF8;
        }
        if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (bytes.length >= 4 && bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] bytes) {
        Encoding encoding = JSVFileManager.getUTFEncoding(bytes);
        if (encoding != Encoding.NONE) {
            try {
                String s = new String(bytes, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        s = s.substring(1);
                        break;
                    }
                }
                return s;
            }
            catch (IOException e) {
                Logger.error("fixUTF error " + e);
            }
        }
        return new String(bytes);
    }

    public static InputStream getInputStream(String name, boolean showMsg, byte[] postBytes) throws JSVException {
        int iurl;
        boolean isURL = JSVFileManager.isURL(name);
        boolean isApplet = appletDocumentBase != null;
        Object in = null;
        String post = null;
        if (isURL && (iurl = name.indexOf("?POST?")) >= 0) {
            post = name.substring(iurl + 6);
            name = name.substring(0, iurl);
        }
        if (isApplet || isURL) {
            URL url;
            try {
                url = new URL(appletDocumentBase, name, null);
            }
            catch (Exception e) {
                throw new JSVException("Cannot read " + name);
            }
            Logger.info("JSVFileManager opening URL " + url + (post == null ? "" : " with POST of " + post.length() + " bytes"));
            in = JSVFileManager.viewer.apiPlatform.getURLContents(url, postBytes, post, false);
        } else {
            if (showMsg) {
                Logger.info("JSVFileManager opening file " + name);
            }
            in = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(name);
        }
        if (in instanceof String) {
            throw new JSVException("\n" + (String)in);
        }
        return (InputStream)in;
    }

    private static String getNMRSimulationJCampDX(String name) {
        String src;
        String jcamp;
        boolean isInline;
        int pt = 0;
        String molFile = null;
        String type = JSVFileManager.getSimulationType(name);
        if (name.startsWith(type)) {
            name = name.substring(type.length() + 1);
        }
        if (isInline = name.startsWith("MOL=")) {
            pt = (name = name.substring(4)).indexOf("/n__Jmol");
            if (pt > 0) {
                name = name.substring(0, pt) + PT.rep(name.substring(pt), "/n", "\n");
            }
            molFile = name = PT.rep(name, "\\n", "\n");
        }
        String key = "" + JSVFileManager.getSimulationHash(name, type);
        if (Logger.debugging) {
            Logger.info("JSVFileManager type=" + type + " key=" + key + " name=" + name);
        }
        if ((jcamp = JSVFileManager.cacheGet(key)) != null) {
            return jcamp;
        }
        String string = src = isInline ? null : PT.rep(nciResolver, "%FILE", PT.escapeUrl(name));
        if (!isInline && (molFile = JSVFileManager.getFileAsString(src)) == null || molFile.indexOf("<html") >= 0) {
            Logger.error("no MOL data returned by NCI");
            return null;
        }
        boolean is13C = type.equals("C13");
        String url = is13C ? nmrdbServerC13New : nmrdbServerH1New;
        url = url.replace("$MOLFILE", molFile);
        String json = JSVFileManager.getFileAsString(url);
        if ((json == null ? (json = "Error: Error fetching simulation") : json).indexOf("Error:") >= 0) {
            return json;
        }
        Map<String, Object> map = new JSJSONParser().parseMap(json, true);
        JSVFileManager.cachePut("json", json);
        return JSVFileManager.processJSON(key, src, url, name, type, molFile, map, is13C, isInline);
    }

    private static String processJSON(String key, String src, String url, String name, String type, String molFile, Map<String, Object> json, boolean is13C, boolean isInline) {
        Map map = (Map)json.get("data");
        String jsonMolFile = (String)map.get("molfile");
        if (jsonMolFile == null) {
            System.out.println("JSVFileManager: no MOL file returned from EPFL");
            jsonMolFile = molFile;
        }
        int[] atomMap = JSVFileManager.getAtomMap(jsonMolFile, molFile);
        JSVFileManager.cachePut("mol", molFile);
        byte[] bytes = isInline || !JSViewer.isJS ? null : molFile.getBytes();
        viewer.syncScript("JSVSTR:" + molFile);
        String xml = "<Signals src=" + PT.esc(url.substring(0, url.indexOf(63))) + ">\n";
        type = is13C ? "13C" : "1HNMR";
        String jcamp = (String)map.get("jcamp");
        jcamp = JSVFileManager.hackNewNmriumSimulationJCAMP(jcamp);
        Lst signals = (Lst)map.get("signals");
        String bf1 = JSVFileManager.getval(jcamp, "##$BF1");
        float freq = bf1 == null ? (float)(is13C ? 100 : 400) : Float.parseFloat(bf1);
        SB sb = new SB();
        int i = signals.size();
        while (--i >= 0) {
            Map signal = (Map)signals.get(i);
            sb.append("<Signal ");
            JSVFileManager.setAttr(sb, "type", type, null);
            Integer index = (Integer)((Lst)signal.get("atoms")).get(0);
            if (atomMap == null) {
                JSVFileManager.setAttr(sb, "atoms", index, null);
            } else {
                sb.append("atoms=\"").appendI(atomMap[index]).append("\" ");
            }
            JSVFileManager.setAttr(sb, "multiplicity", "multiplicity", signal);
            Number delta = (Number)signal.get("delta");
            float[] minmax = JSVFileManager.getSignalMinMax(signal, delta.floatValue(), freq, is13C);
            JSVFileManager.setAttr(sb, "xMin", "" + minmax[0], null);
            JSVFileManager.setAttr(sb, "xMax", "" + minmax[1], null);
            JSVFileManager.setAttr(sb, "integral", "nbAtoms", signal);
            sb.append("></Signal>\n");
        }
        sb.append("</Signals>");
        xml = xml + sb.toString();
        if (Logger.debugging) {
            Logger.info(xml);
        }
        JSVFileManager.cachePut("xml", xml);
        jcamp = "##TITLE=" + (isInline ? "JMOL SIMULATION/" + type : name) + "\n" + jcamp.substring(jcamp.indexOf("\n##") + 1);
        int pt = molFile.indexOf("\n");
        pt = molFile.indexOf("\n", pt + 1);
        if (pt > 0 && pt == molFile.indexOf("\n \n")) {
            molFile = molFile.substring(0, pt + 1) + "Created " + JSVFileManager.viewer.apiPlatform.getDateFormat("8824") + " by JSpecView " + JSVersion.VERSION + molFile.substring(pt + 1);
        }
        pt = 0;
        pt = jcamp.indexOf("##.");
        String id = JSVFileManager.getAbbreviatedSimulationName(name, type, false);
        int pt1 = id.indexOf("id='");
        if (isInline && pt1 > 0) {
            id = id.substring(pt1 + 4, (id + "'").indexOf("'", pt1 + 4));
        }
        JSVFileManager.cachePut(type + "-json.jcamp", jcamp);
        jcamp = jcamp.substring(0, pt) + "##$MODELS=\n<Models>\n<ModelData id=" + PT.esc(id) + " type=\"MOL\" src=" + PT.esc(src) + ">\n" + molFile + "</ModelData>\n</Models>\n##$SIGNALS=\n" + xml + "\n" + jcamp.substring(pt);
        JSVFileManager.cachePut("jcamp", jcamp);
        JSVFileManager.cachePut(key, jcamp);
        return jcamp;
    }

    private static float[] getSignalMinMax(Map<String, Object> signal, float delta, float freq, boolean is13C) {
        float[] minmax = new float[2];
        if (is13C) {
            minmax[0] = delta - 0.5f;
            minmax[1] = delta + 0.5f;
        } else {
            Lst js = (Lst)signal.get("js");
            float d = 1.0f;
            int i = js.size();
            block7: while (--i >= 0) {
                Map j = (Map)js.get(i);
                float c = ((Number)j.get("coupling")).floatValue();
                switch ((String)j.get("multiplicity")) {
                    case "d": {
                        d += c / 2.0f;
                        continue block7;
                    }
                }
                d += c;
            }
            minmax[0] = delta - d / freq;
            minmax[1] = delta + d / freq;
        }
        return minmax;
    }

    private static String hackNewNmriumSimulationJCAMP(String jcamp) {
        String shift = JSVFileManager.getline(jcamp, "##.SHIFT REFERENCE=INTERNAL");
        String offset = JSVFileManager.getval(jcamp, "##$OFFSET");
        if (shift != null && offset != null) {
            shift = shift.substring(0, shift.lastIndexOf(", ") + 2) + offset;
            jcamp = JSVFileManager.setline(jcamp, "##$OFFSET", null);
            jcamp = JSVFileManager.setline(jcamp, "##.SHIFT REFERENCE=INTERNAL", shift);
        }
        return jcamp;
    }

    private static String getline(String jcamp, String record) {
        int pt = jcamp.indexOf(record);
        if (pt < 0) {
            return null;
        }
        return jcamp.substring(pt, jcamp.indexOf("\n", pt));
    }

    private static String getval(String jcamp, String record) {
        int pt = jcamp.indexOf(record);
        if (pt < 0) {
            return null;
        }
        String val = jcamp.substring(jcamp.indexOf("=", pt) + 1, jcamp.indexOf("\n", pt));
        if ((pt = val.indexOf("$$")) >= 0) {
            val = val.substring(pt);
        }
        return val.trim();
    }

    private static String setline(String jcamp, String record, String replacement) {
        int pt = jcamp.indexOf(record);
        if (pt < 0) {
            return jcamp;
        }
        if (replacement == null) {
            return jcamp.substring(0, pt) + jcamp.substring(jcamp.indexOf("\n", pt) + 1);
        }
        return jcamp.substring(0, pt) + replacement + jcamp.substring(jcamp.indexOf("\n", pt));
    }

    private static int[] getAtomMap(String jsonMolFile, String jmolMolFile) {
        P3[] acJmol;
        P3[] acJson = JSVFileManager.getCoord(jsonMolFile);
        int n = acJson.length;
        if (n != (acJmol = JSVFileManager.getCoord(jmolMolFile)).length) {
            return null;
        }
        int[] map = new int[n];
        BS bs = new BS();
        bs.setBits(0, n);
        boolean haveMap = false;
        block0: for (int i = 0; i < n; ++i) {
            P3 a = acJson[i];
            int j = bs.nextSetBit(0);
            while (j >= 0) {
                if ((double)a.distanceSquared(acJmol[j]) < 0.1) {
                    bs.clear(j);
                    map[i] = j;
                    if (i == j) continue block0;
                    haveMap = true;
                    continue block0;
                }
                j = bs.nextSetBit(j + 1);
            }
        }
        return (int[])(haveMap ? map : null);
    }

    private static P3[] getCoord(String mol) {
        String[] lines = PT.split(mol, "\n");
        float[] data = new float[3];
        int n = Integer.parseInt(lines[3].substring(0, 3).trim());
        P3[] pts = new P3[n];
        for (int i = 0; i < n; ++i) {
            String line = lines[4 + i];
            PT.parseFloatArrayInfested(PT.getTokens(line.substring(0, 31)), data);
            pts[i] = P3.new3(data[0], data[1], data[2]);
        }
        return pts;
    }

    private static void setAttr(SB sb, String mykey, Object lucsKeyOrVal, Map<String, Object> map) {
        sb.append(mykey + "=\"").appendO(map == null ? lucsKeyOrVal : map.get(lucsKeyOrVal)).append("\" ");
    }

    private static URL getResource(Object object, String fileName, String[] error) {
        URL url = null;
        try {
            url = object.getClass().getResource(fileName);
            if (url == null) {
                error[0] = "Couldn't find file: " + fileName;
            }
        }
        catch (Exception e) {
            error[0] = "Exception " + e + " in getResource " + fileName;
        }
        return url;
    }

    public static String getResourceString(Object object, String name, String[] error) {
        URL url = JSVFileManager.getResource(object, name, error);
        if (url == null) {
            error[0] = "Error loading resource " + name;
            return null;
        }
        if (url instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)url));
        }
        SB sb = new SB();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent(), "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            error[0] = e.toString();
        }
        return sb.toString();
    }

    public static String getJmolFilePath(String filePath) {
        try {
            filePath = JSVFileManager.getFullPathName(filePath);
        }
        catch (JSVException e) {
            return null;
        }
        return appletDocumentBase == null ? filePath.replace('\\', '/') : filePath;
    }

    public static String getTagName(String fileName) {
        if (fileName == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(fileName)) {
            try {
                if (fileName.startsWith(SIMULATION_PROTOCOL)) {
                    return JSVFileManager.getAbbrSimulationFileName(fileName);
                }
                String name = new URL((URL)null, fileName, null).getFile();
                return name.substring(name.lastIndexOf(47) + 1);
            }
            catch (IOException e) {
                return null;
            }
        }
        return JSVFileManager.newFile(fileName).getName();
    }

    private static GenericFileInterface newFile(String fileName) {
        return JSVFileManager.viewer.apiPlatform.newFile(fileName);
    }

    public static void setDocumentBase(JSViewer v, URL documentBase) {
        viewer = v;
        appletDocumentBase = documentBase;
    }

    public static String getSimulationType(String filePath) {
        return filePath.indexOf("C13/") >= 0 ? "C13" : "H1";
    }

    static {
        jsDocumentBase = "";
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        htCorrelationCache = new Hashtable<String, String>();
        cacheDir = null;
        nciResolver = "https://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        nmrdbServerH1Old = "https://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=$MOLFILE";
        nmrdbServerC13Old = "https://www.nmrdb.org/service/jsmol13c?POST?molfile=$MOLFILE";
        nmrdbServerH1New = "https://nmr-prediction.service.zakodium.com/v1/predict/proton?POST?{\"molfile\":\"$MOLFILE\",\"includeJDX\":true}";
        nmrdbServerC13New = "https://nmr-prediction.service.zakodium.com/v1/predict/carbon?POST?{\"molfile\":\"$MOLFILE\",\"includeJDX\":true}";
    }
}

