function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../common';
import { OuiIcon } from '../icon';
import { deprecatedComponentWarning } from '../../utils';
var sizeToClassNameMap = {
  m: 'ouiLoadingElastic--medium',
  l: 'ouiLoadingElastic--large',
  xl: 'ouiLoadingElastic--xLarge',
  xxl: 'ouiLoadingElastic--xxLarge'
};
export var SIZES = keysOf(sizeToClassNameMap);
var OuiLoadingElasticComponent = function OuiLoadingElasticComponent(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, ["size", "className"]);
  var classes = classNames('ouiLoadingElastic', sizeToClassNameMap[size], className);
  return /*#__PURE__*/React.createElement("span", _extends({
    className: classes
  }, rest), /*#__PURE__*/React.createElement(OuiIcon, {
    type: "logoOpenSearch",
    size: size
  }));
};
OuiLoadingElasticComponent.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  size: PropTypes.oneOf(["m", "l", "xl", "xxl"])
};
OuiLoadingElasticComponent.displayName = 'OuiLoadingElastic';

/**
 * @deprecated OuiLoadingElastic is deprecated in favor of OuiLoadingDashboards and will be removed in v2.0.0.
 */
export var OuiLoadingElastic = deprecatedComponentWarning({
  newComponentName: 'OuiLoadingDashboards',
  version: '2.0.0'
})(OuiLoadingElasticComponent);

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */export { EuiLoadingElastic } from '../../eui_components/loading/loading_elastic';