/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.nio.charset.Charset;
import java.util.ArrayList;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.cli.HelpGroup;
import net.sourceforge.plantuml.cli.HelpTable;

public class HelpPrint {
    private static void printHeader() {
        System.out.println("plantuml - generate diagrams from plain text");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  java -jar plantuml.jar [options] [file|dir]...");
        System.out.println("  java -jar plantuml.jar [options] --gui");
        System.out.println();
        System.out.println("Description:");
        System.out.println("  Process PlantUML sources from files, directories (optionally recursive), or stdin (-pipe).");
        System.out.println();
        System.out.println("Wildcards (for files/dirs):");
        System.out.println("  *   any characters except '/' and '\\'");
        System.out.println("  ?   exactly one character except '/' and '\\'");
        System.out.println("  **  any characters across directories (recursive)");
        System.out.println("  Tip: quote patterns to avoid shell expansion (e.g., \"**/*.puml\").");
        System.out.println();
        System.out.println("General:");
    }

    public static void printHelp() {
        String charset = Charset.defaultCharset().displayName();
        HelpPrint.printHeader();
        HelpPrint.getHelpTable(0).printMe(System.out);
        HelpPrint.printFooter();
    }

    public static void printHelpMore() {
        String charset = Charset.defaultCharset().displayName();
        HelpPrint.printHeader();
        HelpPrint.getHelpTable(1).printMe(System.out);
        HelpPrint.printFooter();
    }

    private static void printFooter() {
        System.out.println();
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  # Process all .puml recursively");
        System.out.println("  java -jar plantuml.jar \"**/*.puml\"");
        System.out.println();
        System.out.println("  # Check syntax only (CI)");
        System.out.println("  java -jar plantuml.jar --check-syntax src/diagrams");
        System.out.println();
        System.out.println("  # Read from stdin and write to stdout (SVG)");
        System.out.println("  cat diagram.puml | java -jar plantuml.jar --svg -pipe > out.svg");
        System.out.println();
        System.out.println("  # Encode a sprite from an image");
        System.out.println("  java -jar plantuml.jar --sprite 16z myicon.png");
        System.out.println();
        System.out.println("  # Use a define");
        System.out.println("  java -jar plantuml.jar -DAUTHOR=John diagram.puml");
        System.out.println();
        System.out.println("  # Change output directory");
        System.out.println("  java -jar plantuml.jar --format svg --output-dir out diagrams/");
        System.out.println();
        System.out.println("Exit codes:");
        System.out.println("  0   Success");
        System.out.println("  >0  Error (syntax error or processing failure)");
        System.out.println();
        System.out.println("See also:");
        System.out.println("  java -jar plantuml.jar --help-more");
        System.out.println("  Documentation: https://plantuml.com");
    }

    private static HelpTable getHelpTable(int limit) {
        HelpTable table = new HelpTable();
        ArrayList<HelpGroup> groups = new ArrayList<HelpGroup>();
        groups.add(new HelpGroup("General"));
        for (CliFlag flag2 : CliFlag.values()) {
            String doc = flag2.getFlagDoc();
            int level = flag2.getFlagLevel();
            String newgroup = flag2.getNewgroup();
            if (doc == null || level > limit) continue;
            if (newgroup.length() > 0) {
                groups.add(new HelpGroup(newgroup));
            }
            ((HelpGroup)groups.get(groups.size() - 1)).append(flag2);
        }
        for (HelpGroup group : groups) {
            table.newLine("", group.getTitle());
            for (CliFlag flag2 : group) {
                table.newLine(flag2.getUsage(), flag2.getFlagDoc());
            }
        }
        return table;
    }
}

