/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

class FreezableHashMap<K, V>
extends HashMap<K, V> {
    private boolean isFrozen;

    FreezableHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    FreezableHashMap() {
    }

    FreezableHashMap(@NotNull Map<? extends K, ? extends V> c) {
        if (c == null) {
            FreezableHashMap.$$$reportNull$$$0(0);
        }
        super(c);
    }

    @NotNull
    @Unmodifiable Map<K, V> freeze() {
        this.isFrozen = true;
        FreezableHashMap freezableHashMap = this;
        if (freezableHashMap == null) {
            FreezableHashMap.$$$reportNull$$$0(1);
        }
        return freezableHashMap;
    }

    private void checkForFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("This map is unmodifiable");
        }
    }

    @Override
    public V put(K key, V value) {
        this.checkForFrozen();
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkForFrozen();
        super.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.checkForFrozen();
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.checkForFrozen();
        super.clear();
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkForFrozen();
        return super.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkForFrozen();
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.checkForFrozen();
        return super.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.checkForFrozen();
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkForFrozen();
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkForFrozen();
        return super.compute(key, remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.checkForFrozen();
        return super.merge(key, value, remappingFunction);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.checkForFrozen();
        super.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.checkForFrozen();
        return super.putIfAbsent(key, value);
    }

    private boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.isFrozen() ? Collections.unmodifiableSet(super.keySet()) : super.keySet();
        if (set == null) {
            FreezableHashMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Collection collection = this.isFrozen() ? Collections.unmodifiableCollection(super.values()) : super.values();
        if (collection == null) {
            FreezableHashMap.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.isFrozen() ? Collections.unmodifiableSet(super.entrySet()) : super.entrySet();
        if (set == null) {
            FreezableHashMap.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FreezableHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FreezableHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "freeze";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

