/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.history.ActivityId;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.Unmodifiable;

public final class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    public static final Comparator<VirtualFile> VIRTUAL_FILE_PRESENTATION_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
    };
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = Comparator.comparing(DvcsUtil::getShortRepositoryName, NaturalComparator.INSTANCE);

    @NotNull
    public static @Unmodifiable List<VirtualFile> sortVirtualFilesByPresentation(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            DvcsUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.sorted(virtualFiles, VIRTUAL_FILE_PRESENTATION_COMPARATOR);
        if (list == null) {
            DvcsUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static @Unmodifiable List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<? extends File> files) {
        if (files == null) {
            DvcsUtil.$$$reportNull$$$0(2);
        }
        List list = RefreshVFsSynchronously.INSTANCE.findVirtualFilesWithRefresh(files);
        if (list == null) {
            DvcsUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            DvcsUtil.$$$reportNull$$$0(4);
        }
        String string = VcsImplUtil.getShortVcsRootName((Project)repository.getProject(), (VirtualFile)repository.getRoot());
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.join(repositories, repository -> DvcsUtil.getShortRepositoryName(repository), (String)", ");
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static <T extends Repository> void disableActionIfAnyRepositoryIsFresh(@NotNull AnActionEvent e, @NotNull Collection<T> repositories, @Nls String operationName) {
        boolean isFresh;
        if (e == null) {
            DvcsUtil.$$$reportNull$$$0(8);
        }
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(9);
        }
        if (isFresh = ContainerUtil.exists(repositories, Repository::isFresh)) {
            Presentation p = e.getPresentation();
            p.setEnabled(false);
            p.setDescription(DvcsBundle.messagePointer((String)"action.not.possible.in.fresh.repo.description", (Object[])new Object[]{operationName}));
        }
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        String joined;
        if (messages == null) {
            DvcsUtil.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmptyOrSpaces((String)(joined = StringUtil.join(messages, (String)"\n"))) ? null : joined;
    }

    @RequiresEdt
    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project) {
        FileEditor fileEditor;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(11);
        }
        return (fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor()) == null ? null : fileEditor.getFile();
    }

    @ApiStatus.Internal
    @Nullable
    public static VirtualFile getSelectedFile(@NotNull DataContext dataProvider) {
        FileEditor fileEditor;
        if (dataProvider == null) {
            DvcsUtil.$$$reportNull$$$0(12);
        }
        return (fileEditor = (FileEditor)PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR.getData(dataProvider)) == null ? null : fileEditor.getFile();
    }

    @NlsSafe
    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            DvcsUtil.$$$reportNull$$$0(13);
        }
        if (hash.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash + "]");
        }
        if (hash.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash + "]");
        }
        String string = VcsLogUtil.getShortHash((String)hash);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            DvcsUtil.$$$reportNull$$$0(15);
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTimestamp()) + " ";
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(@NotNull Project project) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(17);
        }
        return DvcsUtil.workingTreeChangeStarted(project, null, null);
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(@NotNull Project project, @NlsContexts.Label @Nullable String activityName) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(18);
        }
        return DvcsUtil.workingTreeChangeStarted(project, activityName, null);
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(final @NotNull Project project, @NlsContexts.Label @Nullable String activityName, @Nullable ActivityId activityId) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(19);
        }
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, activityName);
        final LocalHistoryAction action = (LocalHistoryAction)ObjectUtils.doIfNotNull((Object)activityId, id -> LocalHistory.getInstance().startAction(activityName, id));
        return new AccessToken(){

            public void finish() {
                if (action != null) {
                    action.finish();
                }
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
            }
        };
    }

    public static void assertFileExists(File file, @NonNls @Nls String message) throws IllegalStateException {
        if (!file.exists()) {
            throw new IllegalStateException(message);
        }
    }

    @NlsSafe
    @NotNull
    public static String tryLoadFile(@NotNull File file) throws RepoStateException {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(20);
        }
        return DvcsUtil.tryLoadFile(file, null);
    }

    @NlsSafe
    @NotNull
    public static String tryLoadFile(@NotNull File file, @Nullable String encoding) throws RepoStateException {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(21);
        }
        String string = DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file, (String)encoding)).trim(), file);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Contract(value="_ , !null -> !null")
    @NlsSafe
    @Nullable
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable @NlsSafe String defaultValue) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(23);
        }
        return DvcsUtil.tryLoadFileOrReturn(file, defaultValue, null);
    }

    @Contract(value="_ , !null, _ -> !null")
    @NlsSafe
    @Nullable
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable @NlsSafe String defaultValue, @Nullable @NonNls String encoding) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(24);
        }
        try {
            return DvcsUtil.tryLoadFile(file, encoding);
        }
        catch (RepoStateException e) {
            LOG.warn((Throwable)e);
            return defaultValue;
        }
    }

    public static <T> T tryOrThrow(Callable<? extends T> actionToTry, Object details) throws RepoStateException {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + String.valueOf(details), (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + String.valueOf(details), e);
            }
        }
        throw new RepoStateException("Couldn't load file " + String.valueOf(details), cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            DvcsUtil.$$$reportNull$$$0(25);
        }
        if (subDirs == null) {
            DvcsUtil.$$$reportNull$$$0(26);
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)CommonProcessors.alwaysTrue());
        }
    }

    public static void addMappingIfSubRoot(@NotNull Project project, @NotNull @NonNls String newRepositoryPath, @NotNull @NonNls String vcsName) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(27);
        }
        if (newRepositoryPath == null) {
            DvcsUtil.$$$reportNull$$$0(28);
        }
        if (vcsName == null) {
            DvcsUtil.$$$reportNull$$$0(29);
        }
        if (!project.isDisposed() && project.getBasePath() != null && FileUtil.isAncestor((String)project.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)newRepositoryPath, (String)vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessWidgetRepository(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager, @Nullable @NonNls @SystemIndependent String recentRootPath, @Nullable VirtualFile selectedFile) {
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(30);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(31);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project, selectedFile))) != null) {
            return repository;
        }
        repository = manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), recentRootPath));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Nullable
    public static <T extends Repository> T guessWidgetRepository(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager, @Nullable @NonNls @SystemIndependent String recentRootPath, @NotNull DataContext dataContext) {
        VirtualFile file;
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(32);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(33);
        }
        if (dataContext == null) {
            DvcsUtil.$$$reportNull$$$0(34);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project, file = DvcsUtil.getSelectedFile(dataContext)))) != null) {
            return repository;
        }
        repository = manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), recentRootPath));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @RequiresEdt
    @Nullable
    public static <T extends Repository> T guessRepositoryForOperation(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(35);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(36);
        }
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR, (Object)FileEditorManager.getInstance((Project)project).getSelectedEditor()).build();
        return DvcsUtil.guessRepositoryForOperation(project, manager, dataContext);
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForOperation(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager, @NotNull DataContext dataContext) {
        VirtualFile file;
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(37);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(38);
        }
        if (dataContext == null) {
            DvcsUtil.$$$reportNull$$$0(39);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project, file = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE)))) != null) {
            return repository;
        }
        file = DvcsUtil.getSelectedFile(dataContext);
        repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project, file));
        if (repository != null) {
            return repository;
        }
        repository = manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), null));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Nullable
    public static Repository guessRepositoryForOperation(@NotNull Project project, @NotNull DataContext dataContext) {
        VirtualFile file;
        VcsRepositoryManager manager;
        Repository repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(40);
        }
        if (dataContext == null) {
            DvcsUtil.$$$reportNull$$$0(41);
        }
        if ((repository = (manager = VcsRepositoryManager.getInstance(project)).getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project, file = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE)))) != null) {
            return repository;
        }
        VirtualFile selectedFile = DvcsUtil.getSelectedFile(dataContext);
        repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project, selectedFile));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project, @NotNull RepositoryManager<T> manager, @Nullable VirtualFile file, @Nullable @NonNls String defaultRootPathValue) {
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(42);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(43);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, file))) != null) {
            return repository;
        }
        return manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), defaultRootPathValue));
    }

    @Deprecated
    @RequiresEdt
    @Nullable
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager, @Nullable @NonNls String defaultRootPathValue) {
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(44);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(45);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, DvcsUtil.getSelectedFile(project)))) != null) {
            return repository;
        }
        return manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project, @NotNull AbstractVcs vcs, @Nullable @NonNls String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(46);
        }
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(47);
        }
        if (project.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        String vcsName = vcs.getDisplayName();
        Object[] vcsRoots = vcsManager.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + String.valueOf(onlyRoot));
            return onlyRoot;
        }
        if (defaultRootPathValue != null && ArrayUtil.contains((Object)(recentRoot = VcsUtil.getVirtualFile((String)defaultRootPathValue)), (Object[])vcsRoots)) {
            LOG.debug("Returning the recent root: " + String.valueOf(recentRoot));
            return recentRoot;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir == null) {
            Object firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + String.valueOf(firstRoot));
            return firstRoot;
        }
        for (Object root : vcsRoots) {
            if (!root.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + String.valueOf(root));
            return root;
        }
        Object rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + String.valueOf(rootCandidate));
        return rootCandidate;
    }

    public static <T extends Repository> @Unmodifiable List<T> sortRepositories(@NotNull Collection<? extends T> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(48);
        }
        List validRepositories = ContainerUtil.filter(repositories, t -> t.getRoot().isValid());
        return ContainerUtil.sorted((Collection)validRepositories, REPOSITORY_COMPARATOR);
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectLevelVcsManager vcsManager;
        VirtualFile root;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(49);
        }
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(50);
        }
        if ((root = (vcsManager = ProjectLevelVcsManager.getInstance((Project)project)).getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file))) != null) {
            LOG.debug("Found root for zip/jar file: " + String.valueOf(root));
            return root;
        }
        Set modulesVcsRoots = (Set)ReadAction.compute(() -> DvcsUtil.findVcsRootForModuleLibrary(project, file));
        if (modulesVcsRoots.isEmpty()) {
            LOG.debug("No library roots");
            return null;
        }
        VirtualFile topRoot = null;
        for (VirtualFile vcsRoot : modulesVcsRoots) {
            if (topRoot != null && !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)topRoot, (boolean)true)) continue;
            topRoot = vcsRoot;
        }
        LOG.debug("Several library roots, returning " + String.valueOf(topRoot));
        return topRoot;
    }

    private static Set<VirtualFile> findVcsRootForModuleLibrary(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(51);
        }
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(52);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
        HashSet<VirtualFile> modulesVcsRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleVcsRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleVcsRoot = vcsManager.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            modulesVcsRoots.add(moduleVcsRoot);
        }
        return modulesVcsRoots;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static VirtualFile guessVcsRoot(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(53);
        }
        return DvcsUtil.findVcsRootFor(project, file);
    }

    @Nullable
    public static VirtualFile findVcsRootFor(@NotNull Project project, @Nullable VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(54);
        }
        if ((root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file)) != null) {
            return root;
        }
        if (file != null && (root = DvcsUtil.getVcsRootForLibraryFile(project, file)) != null) {
            return root;
        }
        return null;
    }

    @RequiresBackgroundThread
    @NotNull
    public static <R extends Repository> Map<R, List<VcsCommitMetadata>> groupCommitsByRoots(@NotNull RepositoryManager<R> repoManager, @NotNull List<? extends VcsCommitMetadata> commits) {
        if (repoManager == null) {
            DvcsUtil.$$$reportNull$$$0(55);
        }
        if (commits == null) {
            DvcsUtil.$$$reportNull$$$0(56);
        }
        HashMap<Repository, List> groupedCommits = new HashMap<Repository, List>();
        for (VcsCommitMetadata vcsCommitMetadata : commits) {
            R repository = repoManager.getRepositoryForRoot(vcsCommitMetadata.getRoot());
            if (repository == null) {
                LOG.info("No repository found for commit " + String.valueOf(vcsCommitMetadata));
                continue;
            }
            List commitsInRoot = groupedCommits.computeIfAbsent((Repository)repository, __ -> new ArrayList());
            commitsInRoot.add(vcsCommitMetadata);
        }
        HashMap<Repository, List> hashMap = groupedCommits;
        if (hashMap == null) {
            DvcsUtil.$$$reportNull$$$0(57);
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(58);
        }
        return (PushSupport)ContainerUtil.find((Object[])((PushSupport[])PushSupport.PUSH_SUPPORT_EP.getExtensions((AreaInstance)vcs.getProject())), support -> support.getVcs().equals((Object)vcs));
    }

    @NlsSafe
    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(59);
        }
        return DvcsUtil.joinShortNames(repositories, -1);
    }

    @NlsSafe
    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories, int limit) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(60);
        }
        return DvcsUtil.joinWithAnd(ContainerUtil.map(repositories, repository -> DvcsUtil.getShortRepositoryName(repository)), limit);
    }

    @Nls
    @NotNull
    public static String joinWithAnd(@NotNull List<@Nls String> strings, int limit) {
        if (strings == null) {
            DvcsUtil.$$$reportNull$$$0(61);
        }
        String string = VcsUtil.joinWithAnd(strings, (int)limit);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(62);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 14, 16, 22, 57, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 9: 
            case 48: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositoryPath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 34: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 47: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoManager";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sortVirtualFilesByPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFilesWithRefresh";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRepositoryName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadFile";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "groupCommitsByRoots";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithAnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortVirtualFilesByPresentation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 57: 
            case 62: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFilesWithRefresh";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortRepositoryName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShortNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disableActionIfAnyRepositoryIsFresh";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinMessagesOrNull";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDateString";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeStarted";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFileOrReturn";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitVcsDirVfs";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addMappingIfSubRoot";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "guessWidgetRepository";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForOperation";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepositoryQuick";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "guessRootForVcs";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sortRepositories";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootForLibraryFile";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findVcsRootForModuleLibrary";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "guessVcsRoot";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findVcsRootFor";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "groupCommitsByRoots";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupport";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "joinShortNames";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "joinWithAnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 14, 16, 22, 57, 62 -> new IllegalStateException(string);
        };
    }
}

